/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class DisplayMode {
    private static final String TAG = "DisplayMode";
    private int mVideoWidth;
    private int mVideoHeight;
    private int mDisplayMode = 0;
    private View mDisplayView;
    private boolean mEnable = true;
    private final Runnable applyDisplayMode = this::applyDisplayMode;

    public void setEnable(boolean enable) {
        this.mEnable = enable;
    }

    public void setVideoSize(int videoWidth, int videoHeight) {
        TTVideoEngineLog.d(TAG, "setVideoSize videoWidth:" + videoWidth + ", videoHeight:" + videoHeight);
        this.mVideoWidth = videoWidth;
        this.mVideoHeight = videoHeight;
        this.apply();
    }

    public void setDisplayMode(int displayMode) {
        this.mDisplayMode = displayMode;
        this.apply();
    }

    public void setDisplayView(View displayView) {
        TTVideoEngineLog.d(TAG, "setDisplayView " + displayView);
        this.mDisplayView = displayView;
        if (this.mDisplayView == null) {
            return;
        }
        this.apply();
    }

    public void apply() {
        if (this.mDisplayView == null || !this.mEnable) {
            return;
        }
        this.mDisplayView.removeCallbacks(this.applyDisplayMode);
        this.mDisplayView.postOnAnimation(this.applyDisplayMode);
    }

    private void applyDisplayMode() {
        int displayHeight;
        int displayWidth;
        if (!this.mEnable) {
            return;
        }
        View displayView = this.mDisplayView;
        if (displayView == null) {
            return;
        }
        ViewParent parent = displayView.getParent();
        if (!(parent instanceof View)) {
            TTVideoEngineLog.d(TAG, "containerView error " + parent);
            return;
        }
        View containerView = (View)parent;
        int containerWidth = containerView.getWidth();
        int containerHeight = containerView.getHeight();
        int displayMode = this.mDisplayMode;
        int videoWidth = this.mVideoWidth;
        int videoHeight = this.mVideoHeight;
        if (videoWidth <= 0 || videoHeight <= 0 || containerWidth <= 0 || containerHeight <= 0) {
            return;
        }
        float videoRatio = (float)videoWidth / (float)videoHeight;
        float containerRatio = (float)containerWidth / (float)containerHeight;
        int displayGravity = 17;
        switch (displayMode) {
            case 1: {
                displayWidth = containerWidth;
                displayHeight = containerHeight;
                break;
            }
            case 3: {
                displayWidth = containerWidth;
                displayHeight = (int)((float)containerWidth / videoRatio);
                break;
            }
            case 4: {
                displayWidth = (int)((float)containerHeight * videoRatio);
                displayHeight = containerHeight;
                break;
            }
            case 0: {
                if (videoRatio >= containerRatio) {
                    displayWidth = containerWidth;
                    displayHeight = (int)((float)containerWidth / videoRatio);
                    break;
                }
                displayWidth = (int)((float)containerHeight * videoRatio);
                displayHeight = containerHeight;
                break;
            }
            case 2: {
                if (videoRatio >= containerRatio) {
                    displayWidth = (int)((float)containerHeight * videoRatio);
                    displayHeight = containerHeight;
                    break;
                }
                displayWidth = containerWidth;
                displayHeight = (int)((float)containerWidth / videoRatio);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown displayMode = " + displayMode);
            }
        }
        FrameLayout.LayoutParams displayLP = (FrameLayout.LayoutParams)displayView.getLayoutParams();
        if (displayLP == null) {
            return;
        }
        if (displayLP.height != displayHeight || displayLP.width != displayWidth || displayLP.gravity != 17) {
            displayLP.gravity = 17;
            displayLP.width = displayWidth;
            displayLP.height = displayHeight;
            displayView.setLayoutParams((ViewGroup.LayoutParams)displayLP);
            TTVideoEngineLog.i(TAG, "applyDisplayMode width:" + displayLP.width + ", height:" + displayLP.height);
        }
    }
}

