/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.text.TextUtils;
import android.util.Log;
import com.ss.ttvideoengine.utils.TTVideoEngineLogListener;

public class TTVideoEngineInternalLog {
    private static final String TAG = "TTVideoEngineLog";
    public static final String FORMAT = "<%s>%s";
    public static final int LOG_VERBOSE = 0;
    public static final int LOG_DEBUG = 1;
    public static final int LOG_INFO = 2;
    public static final int LOG_TRACK = 3;
    public static final int LOG_KILL = 4;
    public static final int LOG_WARN = 5;
    public static final int LOG_ERROR = 6;
    public static int LogTurnOn = 112;
    public static TTVideoEngineLogListener mListener = null;
    public static int LogNotifyLevel = 116;

    public static void turnOn(int level, int isTurnOn) {
        int mask = ~(1 << level);
        LogTurnOn &= mask;
        LogTurnOn |= isTurnOn << level;
        if (level == 1 && isTurnOn == 1) {
            mask = -5;
            LogTurnOn &= mask;
            LogTurnOn |= isTurnOn << 2;
        }
    }

    public static void setLogNotifyLevel(int level, int isTurnOn) {
        int mask = ~(1 << level);
        LogNotifyLevel &= mask;
        LogNotifyLevel |= isTurnOn << level;
    }

    public static void setListener(TTVideoEngineLogListener listener) {
        mListener = listener;
    }

    public static void i(String tag, String msg) {
        if ((LogNotifyLevel >> 2 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 2 & 1) == 1) {
            Log.i((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void d(String tag, String msg) {
        if ((LogNotifyLevel >> 1 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 1 & 1) == 1) {
            Log.d((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void d(Throwable throwable) {
        if ((LogTurnOn >> 1 & 1) == 1) {
            throwable.printStackTrace();
        }
    }

    public static boolean d() {
        return (LogTurnOn >> 1 & 1) == 1 || (LogNotifyLevel >> 1 & 1) == 1;
    }

    public static void w(String tag, String msg) {
        if ((LogNotifyLevel >> 5 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 5 & 1) == 1) {
            Log.w((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void t(String tag, String msg) {
        if ((LogNotifyLevel >> 3 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 3 & 1) == 1) {
            Log.i((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void k(String tag, String msg) {
        if ((LogNotifyLevel >> 4 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 4 & 1) == 1) {
            Log.i((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static void e(String tag, String msg) {
        if ((LogNotifyLevel >> 6 & 1) == 1) {
            TTVideoEngineInternalLog._notifyListener(tag, msg);
        }
        if ((LogTurnOn >> 6 & 1) == 1) {
            Log.e((String)TAG, (String)String.format(FORMAT, tag, msg));
        }
    }

    public static boolean e() {
        return (LogTurnOn >> 6 & 1) == 1 || (LogNotifyLevel >> 6 & 1) == 1;
    }

    protected static void _notifyListener(String tag, String msg) {
        if (mListener != null && !TextUtils.isEmpty((CharSequence)msg)) {
            mListener.consoleLog(TextUtils.isEmpty((CharSequence)tag) ? msg : "TTVideoEngine: tag = " + tag + ";  " + msg);
        }
    }
}

