/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.SntpClient;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeService {
    private static final String TAG = "TimeService";
    private static final int TIMESERVICE_STATE_NOT_UPDATE = 0;
    private static final int TIMESERVICE_STATE_UPDATING = 1;
    private static final int TIMESERVICE_STATE_UPDATED = 2;
    private static final int ERROR_COUNT = 6;
    private static String mNtpServer = null;
    private static TimeInfo mTimeInfo = new TimeInfo();
    private static int mState = 0;
    private static boolean mForceUseLocalTime = true;
    private static int mErrorCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long currentTimeMillis() {
        if (mForceUseLocalTime) return System.currentTimeMillis();
        Class<TimeService> clazz = TimeService.class;
        synchronized (TimeService.class) {
            if (mTimeInfo == null || !mTimeInfo.isUpdated()) return System.currentTimeMillis();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mTimeInfo.mNtpTime + SystemClock.elapsedRealtime() - mTimeInfo.mLocalTime;
        }
    }

    public static void setForceUseLocalTime(boolean forceUseLocalTime, String ntpServer) {
        TTVideoEngineLog.d(TAG, "force use localtime:" + forceUseLocalTime);
        mForceUseLocalTime = forceUseLocalTime;
        mNtpServer = ntpServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTimeFromNTP(final Context context) {
        if (mForceUseLocalTime || TextUtils.isEmpty((CharSequence)mNtpServer)) {
            return;
        }
        Class<TimeService> clazz = TimeService.class;
        synchronized (TimeService.class) {
            if (mTimeInfo != null && mTimeInfo.isUpdated()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (context != null && !NetUtils.isNetAvailable(context)) {
                TTVideoEngineLog.d(TAG, "network unavailable");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (mState != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mState = 1;
            if (mErrorCount > 6) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            EngineThreadPool.addExecuteTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SntpClient sntpClient = new SntpClient();
                    boolean isSuccess = sntpClient.requestTime(mNtpServer, 10000);
                    Class<TimeService> clazz = TimeService.class;
                    synchronized (TimeService.class) {
                        if (isSuccess) {
                            if (mTimeInfo != null) {
                                mTimeInfo.mNtpTime = sntpClient.getNtpTime();
                                mTimeInfo.mLocalTime = sntpClient.getNtpTimeReference();
                                mState = 2;
                                TTVideoEngineLog.d(TimeService.TAG, "NTP updated time:" + TimeService.longToStringWithFormat(mTimeInfo.mNtpTime + SystemClock.elapsedRealtime() - mTimeInfo.mLocalTime, "yyyy-MM-dd HH:mm:ss.SSS"));
                            }
                        } else {
                            if (context != null && NetUtils.isNetAvailable(context)) {
                                mErrorCount++;
                            }
                            TTVideoEngineLog.d(TimeService.TAG, "NTP update fail,error count:" + mErrorCount);
                            mState = 0;
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdated() {
        Class<TimeService> clazz = TimeService.class;
        synchronized (TimeService.class) {
            if (mTimeInfo != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return mTimeInfo.isUpdated();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    public static String longToStringWithFormat(long time, String format) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.format(new Date(time));
        }
        catch (Exception e) {
            return "";
        }
    }

    static class TimeInfo {
        private long mNtpTime = -1L;
        private long mLocalTime = -1L;

        TimeInfo() {
        }

        public boolean isUpdated() {
            return this.mNtpTime > 0L;
        }
    }
}

