/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.abrmodule;

import android.text.TextUtils;
import com.bytedance.vcloud.abrmodule.ABRConfig;
import com.bytedance.vcloud.abrmodule.ABRJniLoader;
import com.bytedance.vcloud.abrmodule.ABRResult;
import com.bytedance.vcloud.abrmodule.IABRInfoListener;
import com.bytedance.vcloud.abrmodule.IABRModule;
import com.bytedance.vcloud.abrmodule.IAudioStream;
import com.bytedance.vcloud.abrmodule.IDeviceInfo;
import com.bytedance.vcloud.abrmodule.IPlayStateSupplier;
import com.bytedance.vcloud.abrmodule.IVideoStream;
import com.ss.ttm.player.ABRStrategy;
import com.ss.ttm.player.NativeABRStrategy;
import java.util.List;
import java.util.Map;

public class DefaultABRModule
implements IABRModule {
    private long mHandle = 0L;
    public static final int PREDICTBITRATE_ALGO_BABB = 0;
    public static final int PREDICTBITRATE_ALGO_BB = 1;
    public static final int PREDICTBITRATE_ALGO_MPC = 2;
    public static final int PREDICTBITRATE_ALGO_BW = 3;
    public static final int PREDICTBITRATE_ALGO_CS = 4;
    public static final int PREDICTBITRATE_ALGO_RL = 5;
    public static final int PREDICTBITRATE_ALGO_BOLA = 6;
    public static final int PREDICTBITRATE_ALGO_FESTIVE = 7;
    public static final int PREDICTBITRATE_ALGO_MPC2 = 8;
    public static final int PREDICTBITRATE_ALGO_BBA = 9;
    private int mAlgoType = -1;

    public DefaultABRModule() {
        String preloadJson;
        String flowJson;
        ABRJniLoader.loadLibrary();
        if (!ABRJniLoader.isLibraryLoaded) {
            return;
        }
        this.mHandle = this._create();
        this._setIntValue(this.mHandle, 0, ABRConfig.getLogLevel());
        this._setIntValue(this.mHandle, 1, ABRConfig.getSwitchSensitivity());
        this._setIntValue(this.mHandle, 3, ABRConfig.getSwitchModel());
        this._setIntValue(this.mHandle, 4, ABRConfig.getFixedLevel());
        this._setIntValue(this.mHandle, 5, ABRConfig.getStartupModel());
        this._setIntValue(this.mHandle, 37, ABRConfig.getStartupUseCache());
        this._setIntValue(this.mHandle, 45, ABRConfig.getNarrowScreenUseWidth());
        this._setFloatValue(this.mHandle, 8, ABRConfig.getStartupBandwidthParameter());
        this._setFloatValue(this.mHandle, 9, ABRConfig.getStallPenaltyParameter());
        this._setFloatValue(this.mHandle, 10, ABRConfig.getSwitchPenaltyParameter());
        this._setFloatValue(this.mHandle, 11, ABRConfig.getBandwidthParameter());
        this._setDoubleValue(this.mHandle, 29, ABRConfig.getStartupModelFirstParam());
        this._setDoubleValue(this.mHandle, 30, ABRConfig.getStartupModelSecondParam());
        this._setDoubleValue(this.mHandle, 31, ABRConfig.getStartupModelThirdParam());
        this._setDoubleValue(this.mHandle, 32, ABRConfig.getStartupModelFourthParam());
        String startJosn = ABRConfig.getAbrStartupJson();
        if (!TextUtils.isEmpty((CharSequence)startJosn)) {
            this._setStringValue(this.mHandle, 51, startJosn);
        }
        if (!TextUtils.isEmpty((CharSequence)(flowJson = ABRConfig.getAbrFlowJson()))) {
            this._setStringValue(this.mHandle, 52, flowJson);
        }
        if (!TextUtils.isEmpty((CharSequence)(preloadJson = ABRConfig.getAbrPreloadJson()))) {
            this._setStringValue(this.mHandle, 50, preloadJson);
        }
    }

    @Override
    public String getVersion() {
        if (this.mHandle == 0L) {
            return "j_2.120.0-tob";
        }
        return this._getVersion();
    }

    @Override
    public void init(IPlayStateSupplier playStateSupplier) {
        if (this.mHandle == 0L) {
            return;
        }
        try {
            this._setDataSource(this.mHandle, playStateSupplier);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void setMediaInfo(List<IVideoStream> videoStreamMap, List<IAudioStream> audioStreamMap) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setMediaInfo(this.mHandle, videoStreamMap, audioStreamMap);
    }

    @Override
    public void setDeviceInfo(IDeviceInfo deviceInfo) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setDeviceInfo(this.mHandle, deviceInfo);
    }

    @Override
    public void setSRBenchmark(Map<Integer, Integer> benchmark) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setSRBenchmark(this.mHandle, benchmark);
    }

    @Override
    public void setSRBenchmarkMap(Map<Integer, List<Integer>> benchmark) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setSRBenchmarkMap(this.mHandle, benchmark);
    }

    @Override
    public void setInfoListener(IABRInfoListener infoListener) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setInfoListener(this.mHandle, infoListener);
    }

    @Override
    public void setIntOptionForKey(int key, int value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setIntValue(this.mHandle, key, value);
    }

    @Override
    public void setFloatOptionForKey(int key, float value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setFloatValue(this.mHandle, key, value);
    }

    @Override
    public void setLongOptionForKey(int key, long value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setLongValue(this.mHandle, key, value);
    }

    @Override
    public void setDoubleOptionForKey(int key, double value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setDoubleValue(this.mHandle, key, value);
    }

    @Override
    public void setStringOptionForKey(int key, String value) {
        if (this.mHandle == 0L) {
            return;
        }
        this._setStringValue(this.mHandle, key, value);
    }

    @Override
    public long getLongOption(int key, long dValue) {
        if (this.mHandle == 0L) {
            return dValue;
        }
        if (key == 19) {
            return this.mAlgoType;
        }
        return this._getLongValue(this.mHandle, key, dValue);
    }

    @Override
    public float getFloatOption(int key, float dValue) {
        if (this.mHandle == 0L) {
            return dValue;
        }
        return this._getFloatValue(this.mHandle, key, dValue);
    }

    @Override
    public String getStringOption(int key, String dValue) {
        if (this.mHandle == 0L) {
            return dValue;
        }
        try {
            return this._getStringValue(this.mHandle, key, dValue);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return dValue;
        }
    }

    @Override
    public ABRResult onceSelect(int onceType, int scene) {
        if (this.mHandle == 0L) {
            return null;
        }
        return this._select(this.mHandle, onceType, scene);
    }

    @Override
    public ABRResult getPredict() {
        if (this.mHandle == 0L) {
            return null;
        }
        return this._getPredict(this.mHandle);
    }

    @Override
    public String getPredictByJsonParams(String params) {
        if (this.mHandle == 0L) {
            return null;
        }
        return this._getPredictByJsonParams(this.mHandle, params);
    }

    @Override
    public void start(int flowType, int intervalMs) {
        if (this.mHandle == 0L) {
            return;
        }
        this.mAlgoType = flowType;
        this._start(this.mHandle, flowType, intervalMs);
    }

    @Override
    public void stop() {
        if (this.mHandle == 0L) {
            return;
        }
        this._stop(this.mHandle);
    }

    @Override
    public void release() {
        if (this.mHandle == 0L) {
            return;
        }
        this._release(this.mHandle);
    }

    @Override
    public void addBufferInfo(int streamType, String streamKey, long bitrate, long availSize, long headSize) {
        if (this.mHandle == 0L) {
            return;
        }
        this._addBufferInfo(this.mHandle, streamType, streamKey, bitrate, availSize, headSize);
    }

    @Override
    public ABRStrategy toStratrgy() {
        if (this.mHandle == 0L) {
            return null;
        }
        return new NativeABRStrategy(this.mHandle);
    }

    private native long _create();

    private native String _getVersion();

    private native void _release(long var1);

    private native void _setDataSource(long var1, IPlayStateSupplier var3);

    private native void _setMediaInfo(long var1, List<IVideoStream> var3, List<IAudioStream> var4);

    private native void _setDeviceInfo(long var1, IDeviceInfo var3);

    private native void _setSRBenchmark(long var1, Map<Integer, Integer> var3);

    private native void _setSRBenchmarkMap(long var1, Map<Integer, List<Integer>> var3);

    private native void _setInfoListener(long var1, IABRInfoListener var3);

    private native ABRResult _select(long var1, int var3, int var4);

    private native ABRResult _getPredict(long var1);

    private native String _getPredictByJsonParams(long var1, String var3);

    private native void _start(long var1, int var3, int var4);

    private native void _stop(long var1);

    private native void _setIntValue(long var1, int var3, int var4);

    private native void _setFloatValue(long var1, int var3, float var4);

    private native void _setLongValue(long var1, int var3, long var4);

    private native void _setDoubleValue(long var1, int var3, double var4);

    private native void _setStringValue(long var1, int var3, String var4);

    private native long _getLongValue(long var1, int var3, long var4);

    private native float _getFloatValue(long var1, int var3, float var4);

    private native double _getDoubleValue(long var1, int var3, double var4);

    private native String _getStringValue(long var1, int var3, String var4);

    private native void _addBufferInfo(long var1, int var3, String var4, long var5, long var7, long var9);
}

