/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.CacheModule;
import com.bytedance.vcloud.cacheModule.CacheModuleLoader;
import com.bytedance.vcloud.cacheModule.CacheSettings;
import com.bytedance.vcloud.cacheModule.PlaylistLoaderItem;
import com.bytedance.vcloud.cacheModule.info.MasterPlaylist;
import com.bytedance.vcloud.cacheModule.utils.CmLog;
import com.bytedance.vcloud.cacheModule.utils.UriUtils;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PlaylistLoader {
    private static final String TAG;
    private String mMdlProxyUrl = null;
    private String mPlaylistFileKey = null;
    private int mTargetPreloadSize = 0;
    private String mCacheDir = null;
    private LoadStatus mLoadStatus = LoadStatus.Unknown;
    private PlaylistLoaderItem mM3u8FileLoader = null;
    private PlaylistLoaderItem.PlayListType mPlaylistType = PlaylistLoaderItem.PlayListType.Unknown;
    private List<PreloadUrlInfo> mSubPreloadUrls = null;
    private int mPreloadedSize = 0;
    private HandlerThread mPreloadThread = null;
    private Handler mPreloadHandler = null;
    private Handler mStatusListenerHandler = null;
    private volatile boolean mCanceled = false;
    private String mCurrentFileKey = null;
    private PlaylistLoader mParentLoader = null;
    private static final int WHAT_PRELOAD_CMD_START = 10000;
    private static final int WHAT_PRELOAD_CMD_NEXT = 10001;
    private static final int WHAT_PRELOAD_CMD_CANCEL = 10002;
    private static final int WHAT_PRELOAD_STATUS_START = 11000;
    private static final int WHAT_PRELOAD_STATUS_CANCEL = 11001;
    private static final int WHAT_PRELOAD_STATUS_COMPLETED = 11002;
    private static final int WHAT_PRELOAD_STATUS_ERROR = 11003;
    public static final int WHAT_PRELOAD_STATUS_CHANGED = 12000;
    private static final int ErrorCodeIsCreateTask = -1000;
    private static final int ErrorCodeIsTheSameKeyTask = -1001;
    private static final int ErrorCodeIsTooManyTask = -1002;
    private static final int ErrorCodeIsAllURLInvalid = -1003;
    private static final int ErrorCodeIsInvalidContentLenth = -2000;
    private static final int ErrorCodeIsStatusCodeMoreThan400 = -3000;
    private static final int ErrorCodeIsStatusCodeMoreThan500 = -3001;
    private static final int ErrorCodeIsInvalidRequestInfo = -4000;
    private static final int ErrorCodeIsInvalidFileWrite = -5000;
    private static final int HTTP_ERROR_HTTP_BAD_REQUEST;
    private static final int HTTP_ERROR_HTTP_UNAUTHORIZED;
    private static final int HTTP_ERROR_HTTP_FORBIDDEN;
    private static final int HTTP_ERROR_HTTP_NOT_FOUND;
    private static final int HTTP_ERROR_HTTP_TIMEOUT;
    private static final int HTTP_ERROR_HTTP_OTHER_4XX;
    private static final int HTTP_ERROR_HTTP_SERVER_ERROR;
    private static final int FILE_ERROR;
    private PlaylistLoader mMasterUrlLoader = null;
    private ILoaderListener mListener = null;
    private OnMasterPlaylistListener mOnMasterPlaylistListener = null;

    public PlaylistLoader(String mdlProxyUrl, int size) {
        this(mdlProxyUrl, size, null);
    }

    public PlaylistLoader(String mdlProxyUrl, int size, PlaylistLoader parent) {
        CmLog.d(TAG, "<" + this + ">PlaylistLoader() parent = " + parent + ". size = " + size + ", mdlproxyurl = " + mdlProxyUrl);
        this.getCacheDir();
        this.mParentLoader = parent;
        this.mMdlProxyUrl = mdlProxyUrl;
        this.mTargetPreloadSize = size;
        Map<String, String> params = UriUtils.parseURLParam(this.mMdlProxyUrl);
        if (params.containsKey("k")) {
            this.mPlaylistFileKey = params.get("k");
        }
        if (this.mParentLoader == null) {
            this.initStatusListenerHandler();
            this.initPreloadCmdHandler();
        }
    }

    private void initStatusListenerHandler() {
        this.mStatusListenerHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                CmLog.d(TAG, "msg.what = " + msg.what);
                if (PlaylistLoader.this.mListener != null) {
                    int what = msg.what;
                    switch (what) {
                        case 11000: {
                            PlaylistLoader.this.callStartListener(PlaylistLoader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11001: {
                            PlaylistLoader.this.callCancelListener(PlaylistLoader.this.mPlaylistFileKey, PlaylistLoader.this.mMdlProxyUrl);
                            break;
                        }
                        case 11002: {
                            PlaylistLoader.this.callCompleteListener(PlaylistLoader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                            break;
                        }
                        case 11003: {
                            PlaylistLoader.this.callErrorListener(PlaylistLoader.this.mMdlProxyUrl, (AVMDLDataLoaderNotifyInfo)msg.obj);
                        }
                    }
                }
                super.handleMessage(msg);
            }
        };
    }

    private void changeStatusToError(AVMDLDataLoaderNotifyInfo errorInfo) {
        this.mLoadStatus = LoadStatus.Error;
        errorInfo.parameter = 2L;
        String string = errorInfo.logInfo = TextUtils.isEmpty((CharSequence)this.mPlaylistFileKey) ? this.mMdlProxyUrl : this.mPlaylistFileKey;
        if (this.mM3u8FileLoader != null) {
            this.mM3u8FileLoader.release();
            this.mM3u8FileLoader = null;
        }
        if (this.mMasterUrlLoader != null) {
            this.mMasterUrlLoader.release();
            this.mMasterUrlLoader = null;
        }
        if (this.mStatusListenerHandler != null) {
            Message message = this.mStatusListenerHandler.obtainMessage(11003);
            message.obj = errorInfo;
            this.mStatusListenerHandler.sendMessage(message);
        } else {
            this.callErrorListener(this.mMdlProxyUrl, errorInfo);
        }
    }

    private void callErrorListener(String mdlProxyUrl, AVMDLDataLoaderNotifyInfo errorInfo) {
        this.mListener.onError(mdlProxyUrl, errorInfo);
    }

    @SuppressLint(value={"DefaultLocale"})
    private void changeStatusToCompleted() {
        this.mLoadStatus = LoadStatus.Completed;
        AVMDLDataLoaderNotifyInfo completedInfo = new AVMDLDataLoaderNotifyInfo();
        completedInfo.what = 4;
        completedInfo.parameter = 2L;
        completedInfo.logInfo = String.format("%d,%d,%s,%s", CacheFileManager.getCacheSize(this.mPlaylistFileKey, CacheFileManager.CacheFileType.Preload), -1, this.mPlaylistFileKey, this.getCacheDir() + "/" + this.mPlaylistFileKey + ".plc");
        if (this.mStatusListenerHandler != null) {
            Message message = this.mStatusListenerHandler.obtainMessage(11002);
            message.obj = completedInfo;
            this.mStatusListenerHandler.sendMessage(message);
        } else {
            this.callCompleteListener(this.mMdlProxyUrl, completedInfo);
        }
    }

    private void callCompleteListener(String mdlProxyUrl, AVMDLDataLoaderNotifyInfo completedInfo) {
        this.mListener.onCompleted(mdlProxyUrl, completedInfo);
    }

    private void changeStatusToCancel() {
        this.mLoadStatus = LoadStatus.Cancel;
        if (this.mStatusListenerHandler != null) {
            Message message = this.mStatusListenerHandler.obtainMessage(11001);
            this.mStatusListenerHandler.sendMessage(message);
        }
    }

    private void callCancelListener(String urlFileKey, String mdlProxyUrl) {
        this.mListener.onCancel(urlFileKey, mdlProxyUrl);
    }

    private void changeStatusToStart() {
        this.mLoadStatus = LoadStatus.Start;
        AVMDLDataLoaderNotifyInfo startInfo = null;
        if (this.mStatusListenerHandler != null) {
            Message message = this.mStatusListenerHandler.obtainMessage(11000);
            message.obj = startInfo;
            this.mStatusListenerHandler.sendMessage(message);
        } else {
            this.callStartListener(this.mMdlProxyUrl, startInfo);
        }
    }

    private void callStartListener(String proxyUrl, AVMDLDataLoaderNotifyInfo obj) {
        this.mListener.onStart(proxyUrl, obj);
    }

    private String getCacheDir() {
        if (TextUtils.isEmpty((CharSequence)this.mCacheDir)) {
            this.mCacheDir = CacheSettings.getInstance().getStringOption(CacheSettings.OptionKey.CACHE_DIR);
        }
        return this.mCacheDir;
    }

    private static int mkTag(int a, int b, int c, int d) {
        return -(a | b << 8 | c << 16 | d << 24);
    }

    public int preload() {
        if (this.mCanceled) {
            CmLog.w(TAG, "<" + this + ">preload has been canceled");
            return 0;
        }
        if (this.mPreloadHandler != null) {
            Message msg = this.mPreloadHandler.obtainMessage(10000);
            this.mPreloadHandler.sendMessage(msg);
        } else {
            this.preloadM3u8File(this.mMdlProxyUrl);
        }
        return 0;
    }

    private void initPreloadCmdHandler() {
        this.mPreloadThread = new HandlerThread("playlistPreloader");
        this.mPreloadThread.start();
        this.mPreloadHandler = new Handler(this.mPreloadThread.getLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 10000) {
                    PlaylistLoader.this.preloadM3u8File(PlaylistLoader.this.mMdlProxyUrl);
                } else if (msg.what == 10001) {
                    PlaylistLoader.this.preLoadNextUrl();
                } else if (msg.what == 10002) {
                    PlaylistLoader.this.cancelPreload();
                } else if (msg.what == 12000) {
                    Bundle data = msg.getData();
                    String fileKey = data.getString("fileKey", null);
                    int statusCode = data.getInt("status", 0);
                    LoadStatus status = LoadStatus.covertCode(statusCode);
                    AVMDLDataLoaderNotifyInfo info = (AVMDLDataLoaderNotifyInfo)msg.obj;
                    PlaylistLoader.this.processStatusChangeInner(fileKey, status, info);
                }
                super.handleMessage(msg);
            }
        };
    }

    private void cancelPreload() {
        if (this.mCurrentFileKey != null) {
            CmLog.d(TAG, "cancel ts.. mCurrentFileKey:" + this.mCurrentFileKey);
            AVMDLDataLoader.getInstance().cancel(this.mCurrentFileKey);
        }
        if (this.mM3u8FileLoader != null) {
            this.mM3u8FileLoader.release();
            this.mM3u8FileLoader = null;
        }
        if (this.mMasterUrlLoader != null) {
            this.mMasterUrlLoader.release();
            this.mMasterUrlLoader = null;
        }
        this.changeStatusToCancel();
    }

    private void preloadM3u8File(String url) {
        CmLog.d(TAG, "<" + this + "> preloadM3u8File : " + url);
        if (TextUtils.isEmpty((CharSequence)url)) {
            CmLog.e(TAG, "<" + this + "> main url is empty. ");
            AVMDLDataLoaderNotifyInfo errorInfo = new AVMDLDataLoaderNotifyInfo();
            errorInfo.what = 8;
            errorInfo.code = -4000L;
            this.changeStatusToError(errorInfo);
            return;
        }
        this.mM3u8FileLoader = new PlaylistLoaderItem(url);
        int preloadRet = this.mM3u8FileLoader.preload();
        if (preloadRet < 0 && !this.mCanceled) {
            CmLog.e(TAG, "<" + this + ">open main m3u8 url fail : " + preloadRet);
            AVMDLDataLoaderNotifyInfo errorInfo = new AVMDLDataLoaderNotifyInfo();
            errorInfo.what = 8;
            errorInfo.code = PlaylistLoader.getErrorCode(preloadRet);
            this.changeStatusToError(errorInfo);
            return;
        }
        int preloadedSize = (int)CacheFileManager.getHlsCacheSizeWithoutTs(this.mPlaylistFileKey, CacheFileManager.CacheFileType.Preload);
        this.mPreloadedSize += preloadedSize;
        CmLog.v(TAG, "<" + this + ">preload main m3u8 url cost size : " + preloadedSize);
        CacheFileManager.HlsCacheNodeInfo hlsCacheNodeInfo = new CacheFileManager.HlsCacheNodeInfo();
        hlsCacheNodeInfo.version = 1;
        hlsCacheNodeInfo.fileKey = this.mPlaylistFileKey;
        this.mM3u8FileLoader.writeHlsNodeInfo(hlsCacheNodeInfo);
        this.mPlaylistType = this.mM3u8FileLoader.getType();
        if (this.mPlaylistType == PlaylistLoaderItem.PlayListType.MasterPlaylist) {
            CmLog.i(TAG, "<" + this + "> main url is Master ");
            MasterPlaylist masterPlaylist = this.mM3u8FileLoader.getMasterPlaylist();
            this.mSubPreloadUrls = this.selectMasterPreloadUrls(masterPlaylist);
        } else {
            List<String> subUrls = this.mM3u8FileLoader.getSubUrls();
            this.mSubPreloadUrls = new LinkedList<PreloadUrlInfo>();
            if (subUrls != null) {
                for (String subUrl : subUrls) {
                    PreloadUrlInfo info = new PreloadUrlInfo();
                    info.mUrl = subUrl;
                    info.mPreloadSize = null;
                    this.mSubPreloadUrls.add(info);
                }
            }
        }
        this.preLoadNextUrl();
    }

    private List<PreloadUrlInfo> selectMasterPreloadUrls(MasterPlaylist masterPlaylist) {
        List<PreloadUrlInfo> selectUrls = null;
        if (masterPlaylist == null) {
            selectUrls = new LinkedList<PreloadUrlInfo>();
            return selectUrls;
        }
        if (this.mOnMasterPlaylistListener != null) {
            selectUrls = this.mOnMasterPlaylistListener.onSelectPreloadUrls(masterPlaylist);
        }
        if (selectUrls == null || selectUrls.size() == 0) {
            CmLog.w(TAG, "<" + this + "> select url is empty. try preload first VariantStream");
            selectUrls = new LinkedList();
            if (masterPlaylist.mVariantStreams == null) {
                return selectUrls;
            }
            PreloadUrlInfo info = new PreloadUrlInfo();
            info.mUrl = masterPlaylist.mVariantStreams[0].mUri;
            info.mPreloadSize = null;
            selectUrls.add(info);
        }
        CmLog.d(TAG, "<" + this + "> select urls are :" + selectUrls);
        for (PreloadUrlInfo urlInfo : selectUrls) {
            urlInfo.mUrl = CacheModule.generateProxyUrl(this.mPlaylistFileKey, urlInfo.mUrl);
        }
        return selectUrls;
    }

    private static int getErrorCode(int preloadRet) {
        if (preloadRet == HTTP_ERROR_HTTP_BAD_REQUEST || preloadRet == HTTP_ERROR_HTTP_UNAUTHORIZED || preloadRet == HTTP_ERROR_HTTP_FORBIDDEN || preloadRet == HTTP_ERROR_HTTP_NOT_FOUND || preloadRet == HTTP_ERROR_HTTP_TIMEOUT || preloadRet == HTTP_ERROR_HTTP_OTHER_4XX) {
            return -3000;
        }
        if (preloadRet == HTTP_ERROR_HTTP_SERVER_ERROR) {
            return -3001;
        }
        if (preloadRet == FILE_ERROR) {
            return -5000;
        }
        return preloadRet;
    }

    private void preLoadNextUrl() {
        boolean hasReachPreloadSize;
        CmLog.d(TAG, "<" + this + ">preLoadNextUrl...");
        if (this.mCanceled) {
            return;
        }
        boolean proxyUrlsEmpty = this.mSubPreloadUrls.isEmpty();
        boolean bl = hasReachPreloadSize = this.mPreloadedSize >= this.mTargetPreloadSize;
        if (proxyUrlsEmpty || hasReachPreloadSize) {
            CmLog.i(TAG, "<" + this + ">preLoadNextUrl() completed. proxyUrlsEmpty:" + proxyUrlsEmpty + ", hasReachPreloadSize :" + hasReachPreloadSize);
            this.mCurrentFileKey = null;
            this.changeStatusToCompleted();
            return;
        }
        PreloadUrlInfo preloadUrlInfo = this.mSubPreloadUrls.remove(0);
        String mdlProxyUrl = preloadUrlInfo.mUrl;
        if (TextUtils.isEmpty((CharSequence)mdlProxyUrl)) {
            AVMDLDataLoaderNotifyInfo errorInfo = new AVMDLDataLoaderNotifyInfo();
            errorInfo.what = 8;
            errorInfo.code = -4000L;
            this.changeStatusToError(errorInfo);
            return;
        }
        CmLog.d(TAG, "<" + this + "> preLoadNextUrl = " + mdlProxyUrl + " , size = " + preloadUrlInfo.mPreloadSize);
        Map<String, String> params = UriUtils.parseURLParam(mdlProxyUrl);
        if (params.containsKey("k")) {
            this.mCurrentFileKey = params.get("k");
        }
        CacheFileManager.TsCacheNodeInfo tsCacheNodeInfo = new CacheFileManager.TsCacheNodeInfo();
        tsCacheNodeInfo.version = 2;
        tsCacheNodeInfo.fileKey = this.mCurrentFileKey;
        tsCacheNodeInfo.keyType = this.mPlaylistType == PlaylistLoaderItem.PlayListType.MasterPlaylist ? 1 : 2;
        this.mM3u8FileLoader.writeTsNodeInfo(tsCacheNodeInfo);
        int preloadSize = this.mTargetPreloadSize - this.mPreloadedSize;
        if (preloadUrlInfo.mPreloadSize != null && preloadUrlInfo.mPreloadSize > 0) {
            preloadSize = preloadUrlInfo.mPreloadSize;
        }
        if (this.mPlaylistType == PlaylistLoaderItem.PlayListType.MasterPlaylist) {
            if (this.mMasterUrlLoader != null) {
                this.mMasterUrlLoader.release();
            }
            this.mMasterUrlLoader = new PlaylistLoader(mdlProxyUrl, preloadSize, this);
            this.mMasterUrlLoader.setLoaderListener(new ILoaderListener(){

                @Override
                public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                }

                @Override
                public void onCancel(String fileKey, String url) {
                    CmLog.d(TAG, "<" + this + ">sub m3u8 canceled fileKey:" + fileKey);
                }

                @Override
                public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                    CmLog.d(TAG, "<" + this + ">sub m3u8 completed info.logInfo:" + info.logInfo);
                    int preloadedSize = this.getPreloadedSizeFromInfo(info);
                    PlaylistLoader.this.mPreloadedSize = PlaylistLoader.this.mPreloadedSize + preloadedSize;
                    PlaylistLoader.this.preLoadNextUrl();
                }

                private int getPreloadedSizeFromInfo(AVMDLDataLoaderNotifyInfo info) {
                    try {
                        String[] longInfos = info.logInfo.split(",");
                        if (longInfos != null && longInfos.length > 1) {
                            String preloadedSize = longInfos[0];
                            return Integer.parseInt(preloadedSize);
                        }
                    }
                    catch (Exception e) {
                        return 0;
                    }
                    return 0;
                }

                @Override
                public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                    CmLog.d(TAG, "<" + this + ">sub m3u8 error code : " + info.code + " info.loginfo :" + info.logInfo);
                    PlaylistLoader.this.changeStatusToError(info);
                }
            });
            CmLog.i(TAG, "<" + this + ">sub m3u8 preloadSource filekey = " + this.mCurrentFileKey + " , preloadSize = " + preloadSize + " proxyUrl = " + mdlProxyUrl);
            this.mMasterUrlLoader.preload();
        } else {
            CmLog.i(TAG, "<" + this + ">MDL preloadSource filekey = " + this.mCurrentFileKey + " , preloadSize = " + preloadSize + " proxyUrl = " + mdlProxyUrl);
            AVMDLDataLoader.getInstance().preloadResource(mdlProxyUrl, preloadSize);
        }
    }

    public boolean isMyKey(String fileKey) {
        if (this.isPlaylistFileKey(fileKey) || this.isTsFileKey(fileKey)) {
            return true;
        }
        if (this.mMasterUrlLoader != null) {
            return this.mMasterUrlLoader.isMyKey(fileKey);
        }
        return false;
    }

    public boolean processStatusChange(String fileKey, LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        boolean willIntercept = this.checkIfIntercept(fileKey, status);
        if (this.mPreloadHandler != null) {
            Message message = this.mPreloadHandler.obtainMessage(12000);
            Bundle data = new Bundle();
            data.putInt("status", status.ordinal());
            data.putString("fileKey", fileKey);
            message.setData(data);
            message.obj = info;
            this.mPreloadHandler.sendMessage(message);
        }
        return willIntercept;
    }

    void processStatusChangeInner(String fileKey, LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        if (this.isPlaylistFileKey(fileKey)) {
            this.processM3u8PreloadStatus(fileKey, status, info);
        } else if (this.isTsFileKey(fileKey)) {
            this.processTsPreloadStatus(fileKey, status, info);
        } else if (this.mMasterUrlLoader != null) {
            this.mMasterUrlLoader.processStatusChangeInner(fileKey, status, info);
        }
    }

    private boolean isPlaylistFileKey(String fileKey) {
        return this.mPlaylistFileKey != null && this.mPlaylistFileKey.equals(fileKey);
    }

    private boolean isTsFileKey(String fileKey) {
        return this.mCurrentFileKey != null && this.mCurrentFileKey.equals(fileKey);
    }

    boolean checkIfIntercept(String fileKey, LoadStatus status) {
        if (this.isPlaylistFileKey(fileKey)) {
            if (status == this.mLoadStatus) {
                return true;
            }
            return status != LoadStatus.Error;
        }
        if (this.isTsFileKey(fileKey)) {
            return false;
        }
        if (this.mMasterUrlLoader != null) {
            return this.mMasterUrlLoader.checkIfIntercept(fileKey, status);
        }
        return false;
    }

    private void processM3u8PreloadStatus(String fileKey, LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.i(TAG, "processM3u8PreloadStatus = " + fileKey + ", mCurrentFileKey = " + this.mCurrentFileKey + ", mUrlFileKey = " + this.mPlaylistFileKey + ", status = " + status.name());
    }

    private void processTsPreloadStatus(String fileKey, LoadStatus status, AVMDLDataLoaderNotifyInfo info) {
        CmLog.i(TAG, "processSubPreloadStatus = " + fileKey + ", mCurrentFileKey = " + this.mCurrentFileKey + ", mUrlFileKey = " + this.mPlaylistFileKey + ", status = " + status.name());
        if (status == LoadStatus.Completed) {
            if (this.mCanceled) {
                return;
            }
            long cacheSize = AVMDLDataLoader.getInstance().getCacheSize(this.mCurrentFileKey);
            this.mPreloadedSize = (int)((long)this.mPreloadedSize + cacheSize);
            CmLog.d(TAG, "<" + this + ">sub preload completd size = " + cacheSize + " , key = " + this.mCurrentFileKey + ", cacheSize = " + cacheSize + " , mPreloadedSize = " + this.mPreloadedSize + " , mTargetPreloadSize = " + this.mTargetPreloadSize);
            this.mCurrentFileKey = null;
            this.preLoadNextUrl();
        } else if (status == LoadStatus.Cancel) {
            CmLog.d(TAG, "<" + this + ">mdl canceled... " + this.mCurrentFileKey);
        } else if (status == LoadStatus.Error) {
            CmLog.d(TAG, "<" + this + ">mdl Error ... code : " + info.code);
            AVMDLDataLoaderNotifyInfo errorInfo = new AVMDLDataLoaderNotifyInfo();
            errorInfo.what = 8;
            errorInfo.code = info.code;
            this.changeStatusToError(errorInfo);
        }
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        if (this.mM3u8FileLoader != null) {
            this.mM3u8FileLoader.cancel();
        }
        if (this.mMasterUrlLoader != null) {
            this.mMasterUrlLoader.cancel();
        }
        if (this.mPreloadHandler != null) {
            Message message = this.mPreloadHandler.obtainMessage(10002);
            this.mPreloadHandler.sendMessage(message);
        }
    }

    public void release() {
        if (this.mPreloadThread != null) {
            if (this.mM3u8FileLoader != null) {
                this.mM3u8FileLoader.release();
                this.mM3u8FileLoader = null;
            }
            this.mPreloadThread.quit();
        }
    }

    public void setLoaderListener(ILoaderListener listener) {
        this.mListener = listener;
    }

    public void setOnMasterPlaylistListener(OnMasterPlaylistListener l) {
        this.mOnMasterPlaylistListener = l;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    static {
        CacheModuleLoader.loadLibrary();
        TAG = PlaylistLoader.class.getSimpleName();
        HTTP_ERROR_HTTP_BAD_REQUEST = PlaylistLoader.mkTag(248, 52, 48, 48);
        HTTP_ERROR_HTTP_UNAUTHORIZED = PlaylistLoader.mkTag(248, 52, 48, 49);
        HTTP_ERROR_HTTP_FORBIDDEN = PlaylistLoader.mkTag(248, 52, 48, 51);
        HTTP_ERROR_HTTP_NOT_FOUND = PlaylistLoader.mkTag(248, 52, 48, 52);
        HTTP_ERROR_HTTP_TIMEOUT = PlaylistLoader.mkTag(248, 52, 48, 56);
        HTTP_ERROR_HTTP_OTHER_4XX = PlaylistLoader.mkTag(248, 52, 88, 88);
        HTTP_ERROR_HTTP_SERVER_ERROR = PlaylistLoader.mkTag(248, 53, 88, 88);
        FILE_ERROR = PlaylistLoader.mkTag(73, 78, 70, 87);
    }

    public static class OnMasterPlaylistListener {
        public List<PreloadUrlInfo> onSelectPreloadUrls(MasterPlaylist masterPlaylist) {
            return null;
        }
    }

    public static class PreloadUrlInfo {
        public String mUrl = null;
        public Integer mPreloadSize = null;
    }

    public static interface ILoaderListener {
        public void onStart(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onCancel(String var1, String var2);

        public void onCompleted(String var1, AVMDLDataLoaderNotifyInfo var2);

        public void onError(String var1, AVMDLDataLoaderNotifyInfo var2);
    }

    public static enum LoadStatus {
        Unknown,
        Start,
        Cancel,
        Completed,
        Error;


        public static LoadStatus covertCode(int statusCode) {
            if (statusCode == Start.ordinal()) {
                return Start;
            }
            if (statusCode == Cancel.ordinal()) {
                return Cancel;
            }
            if (statusCode == Completed.ordinal()) {
                return Completed;
            }
            if (statusCode == Error.ordinal()) {
                return Error;
            }
            return Unknown;
        }
    }
}

