/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vodsetting;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vodsetting.ConfigEnv;
import com.bytedance.vodsetting.FetcherListener;
import com.bytedance.vodsetting.Log;
import com.bytedance.vodsetting.NetInterface;
import com.bytedance.vodsetting.Utils;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONObject;

class Fetcher {
    private static final String TAG = "Fetcher";
    static final int OverRetryTimesCode = -999;
    static final int InvalidHostCode = -998;
    static final int InvalidJsonCode = -997;
    static final int InvalidNetClient = -996;
    static final int SuccessCode = 0;
    private final Context mContext;
    private final FetcherListener mListener;
    private int mMaxRetryTimes = 10;
    private boolean mOpenDebug = false;
    private int mFetchInterval = 86400;
    private long mConfigVersion = 0L;
    private final int mRetryDelay = 5;
    private int mFetchVideoRetryTimes = 0;
    private long mLastFetchTime = 0L;
    private long mFetchCount = 0L;
    private NetInterface mNetInterface;

    Fetcher(Context context, FetcherListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public Fetcher setDebug(boolean isEnabled) {
        this.mOpenDebug = isEnabled;
        return this;
    }

    public Fetcher setMaxRetryTimes(int times) {
        this.mMaxRetryTimes = times;
        return this;
    }

    public Fetcher setFetchInterval(int interval) {
        if (interval < 1) {
            Log.e(TAG, "set fetch interval fail. interval = " + interval);
            return this;
        }
        this.mFetchInterval = interval;
        return this;
    }

    public Fetcher setNet(NetInterface net) {
        this.mNetInterface = net;
        return this;
    }

    public int getFetchInterval() {
        return this.mFetchInterval;
    }

    public Fetcher setConfigVersion(long version) {
        if (version < 1L) {
            Log.e(TAG, "set config version fail. version = " + version);
            return this;
        }
        this.mConfigVersion = version;
        return this;
    }

    public void fetch(String module, String configKey, boolean isForced) {
        this.mFetchVideoRetryTimes = 0;
        if (isForced) {
            this.startFetch(module, configKey);
        } else {
            this.fetchIfNeeded(module, configKey);
        }
    }

    private void fetchIfNeeded(String module, String configKey) {
        Log.v(TAG, "try to fetch, module = " + module);
        long currentTime = System.currentTimeMillis();
        if (this.mLastFetchTime < 1L || currentTime - this.mLastFetchTime >= (long)this.mFetchInterval * 1000L) {
            this.startFetch(module, configKey);
        }
    }

    private void startFetch(final String module, final String configKey) {
        this.mFetchCount = this.mFetchCount >= Long.MAX_VALUE ? 1L : ++this.mFetchCount;
        Log.v(TAG, "start to fetch, module = " + module + ", fetch count = " + this.mFetchCount);
        if (this.mNetInterface == null) {
            if (this.mListener != null) {
                this.mListener.onResult(-996, "netClient is null", null);
            }
            return;
        }
        String host = ConfigEnv.getHost(ConfigEnv.getRegion());
        if (TextUtils.isEmpty((CharSequence)host)) {
            Log.e(TAG, "get host is null");
            if (this.mListener != null) {
                this.mListener.onResult(-998, "host is null", null);
            }
            return;
        }
        ++this.mFetchVideoRetryTimes;
        HashMap<String, String> getPara = new HashMap<String, String>();
        getPara.put("caller_name", Utils.getCallerName());
        getPara.put("device_platform", "android");
        getPara.put("os_version", Utils.getSystemVersion());
        getPara.put("os_api", String.valueOf(Utils.getSDKVersion()));
        getPara.put("config_version", "" + this.mConfigVersion);
        if (!getPara.containsKey("device_brand")) {
            getPara.put("device_brand", Utils.getDeviceBrand());
        }
        if (!getPara.containsKey("device_type")) {
            getPara.put("device_type", Utils.getDeviceModel().toLowerCase());
        }
        if (!TextUtils.isEmpty((CharSequence)module) && !module.equals("all")) {
            getPara.put("module", module);
        }
        if (this.mOpenDebug) {
            getPara.put("debug", "1");
        }
        if (!TextUtils.isEmpty((CharSequence)configKey)) {
            getPara.put("config_key", configKey);
        }
        if (ConfigEnv.getAPPInfo() != null) {
            getPara.putAll(ConfigEnv.getAPPInfo());
        }
        if (ConfigEnv.getSDKInfo() != null) {
            getPara.putAll(ConfigEnv.getSDKInfo());
        }
        String getUrl = "https://" + host + ConfigEnv.getPath();
        Log.v(TAG, "param = " + getPara.toString());
        this.mNetInterface.start(getUrl, getPara, new NetInterface.CompletionListener(){

            @Override
            public void onCompletion(@Nullable JSONObject jsonBody, @Nullable Error error) {
                if (error != null) {
                    Fetcher.this.delayFetch(module, configKey, 5L);
                    return;
                }
                if (jsonBody == null) {
                    Log.e(Fetcher.TAG, "response is null or empty");
                    Fetcher.this.delayFetch(module, configKey, 5L);
                    return;
                }
                Fetcher.this.mLastFetchTime = System.currentTimeMillis();
                if (Fetcher.this.mOpenDebug) {
                    Log.v(Fetcher.TAG, "fetch suc, fetch count = " + Fetcher.this.mFetchCount + ", response = " + jsonBody.toString());
                }
                JSONObject dataObject = jsonBody.optJSONObject("data");
                if (Fetcher.this.mListener != null) {
                    Fetcher.this.mListener.onResult(jsonBody.optInt("code"), jsonBody.optString("msg"), dataObject, module, configKey);
                }
            }
        });
    }

    private void delayFetch(final String module, final String configKey, long delaySecond) {
        Log.v(TAG, "retry fetch, count = " + this.mFetchCount);
        if (this.mFetchVideoRetryTimes > this.mMaxRetryTimes) {
            Log.v(TAG, "fetch fail, module = " + module + ", retry times = " + this.mFetchVideoRetryTimes);
            if (this.mListener != null) {
                this.mListener.onResult(-999, "fetch fail. try times = " + this.mFetchVideoRetryTimes + ", max = " + this.mMaxRetryTimes, null);
            }
            this.mFetchVideoRetryTimes = 0;
            return;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Fetcher.this.startFetch(module, configKey);
            }
        }, delaySecond * 1000L);
    }
}

