/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Looper;
import android.telephony.PhoneStateListener;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.ss.ttvideoengine.TTNetworkStateCallback;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TTNetWorkListener
extends BroadcastReceiver {
    private static final String TAG = "TTNetWorkListener";
    public static final int ACCESS_TYPE_DISCONNECT = -1;
    public static final int ACCESS_TYPE_WIFI = 0;
    public static final int ACCESS_TYPE_4G = 1;
    public static final int ACCESS_TYPE_2G = 2;
    public static final int ACCESS_TYPE_3G = 3;
    public static final int ACCESS_TYPE_5G = 4;
    public static final int ACCESS_TYPE_MOBILE = 6;
    public static final int ACCESS_TYPE_UNKNOWN = 1000;
    public static final int ACCESS_STRENGTH_WEAK = 1;
    public static final int ACCESS_STRENGTH_MEDIUM = 2;
    public static final int ACCESS_STRENGTH_GOOD = 3;
    public static final int ACCESS_STRENGTH_EXCELLENT = 4;
    public static final int ACCESS_STRENGTH_UNKNOWN = 10;
    public static final int CALLBACK_NETWORK_TYPE = 0;
    public static final int CALLBACK_SIGNAL_STRENGTH = 1;
    public static final int NETWORK_LISTENER_KEY_NET_LEVEL_MAX_COUNT = 1;
    public static final int NETWORK_LISTENER_KEY_TIMER_TASK_INTERVAL = 2;
    public static final int NETWORK_LISTENER_KEY_RTT_CODE_MAP = 3;
    public static final int NETWORK_LISTENER_KEY_SIG_CODE_MAP = 4;
    public static final int NETWORK_LISTENER_KEY_LEVEL_CODE_MAP = 5;
    private Thread mThread;
    private int mCurrentAccessType = 1000;
    private int mCurrentAccessStrength = 10;
    private Lock mLock = new ReentrantLock();
    private ArrayList<WeakReference<TTNetworkStateCallback>> mListeners = new ArrayList();
    private int mInited = 0;
    private TTPhoneStateListener mPhoneStateListener = null;
    private static TTNetWorkListener mInst = null;
    private boolean mIsWifiSensitiveMode = false;

    private TTNetWorkListener() {
    }

    public static synchronized TTNetWorkListener getInstance() {
        if (mInst == null) {
            mInst = new TTNetWorkListener();
        }
        return mInst;
    }

    public synchronized void init(Context ctx) {
        if (this.mInited != 0) {
            return;
        }
        this.mInited = 1;
        this.mThread = new MyThread(ctx, this);
        this.mThread.start();
    }

    public void registerListener(Context ctx) {
        try {
            TTVideoEngineLog.d(TAG, "enter start listen");
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction("android.net.wifi.RSSI_CHANGED");
            Intent intent = ctx.registerReceiver((BroadcastReceiver)this, intentFilter);
            int accessType = this.getNetworkType(ctx);
            this.updateAccessType(accessType);
            if (this.mCurrentAccessType == 0) {
                this.mCurrentAccessStrength = this.getWIFISignalStrength(ctx, null);
            }
            this.mPhoneStateListener = new TTPhoneStateListener(ctx, this);
            if (!this.mIsWifiSensitiveMode) {
                this.mPhoneStateListener.register(ctx);
            }
            this.mInited = 1;
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            TTVideoEngineLog.d(TAG, "start listen network state failed");
        }
    }

    public void unregisterListener(Context ctx) {
        if (ctx == null || this.mPhoneStateListener == null) {
            return;
        }
        try {
            ctx.unregisterReceiver((BroadcastReceiver)this);
            this.mPhoneStateListener.unregister(ctx);
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "Receiver has been unregistered!");
        }
    }

    public void startListen(WeakReference<TTNetworkStateCallback> cb) {
        if (cb == null) {
            return;
        }
        this.mLock.lock();
        this.mListeners.add(cb);
        this.mLock.unlock();
    }

    public void stopListen(WeakReference<TTNetworkStateCallback> cb) {
        if (cb == null) {
            return;
        }
        this.mLock.lock();
        this.mListeners.remove(cb);
        this.mLock.unlock();
    }

    public void onReceive(Context context, Intent intent) {
        if (this.isInitialStickyBroadcast() || intent == null) {
            return;
        }
        if ("android.net.wifi.RSSI_CHANGED".equals(intent.getAction()) && this.mCurrentAccessType == 0) {
            int level = this.getWIFISignalStrength(context, intent);
            this._handleSigStrengthChange(level);
            return;
        }
        if (!"android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            return;
        }
        TTVideoEngineLog.d(TAG, "network broadcast:" + intent.getAction());
        this._handleNetworkChange(context);
    }

    private void _handleNetworkChange(Context contex) {
        int accessType = this.getNetworkType(contex);
        this.updateAccessType(accessType);
    }

    private void _handleNetworkChange(int netWorkType) {
        int accessType = TTNetWorkListener.convertNetworkType(netWorkType);
        TTVideoEngineLog.d(TAG, "network change to: " + accessType);
        this.updateAccessType(accessType);
    }

    private void _handleSigStrengthChange(int strength) {
        if (strength != this.mCurrentAccessStrength) {
            this.mLock.lock();
            int from = this.mCurrentAccessStrength;
            this.mCurrentAccessStrength = strength;
            TTVideoEngineLog.i(TAG, "strength changed, from: " + from + " to: " + this.mCurrentAccessStrength + " callback list size: " + this.mListeners.size());
            Iterator<WeakReference<TTNetworkStateCallback>> it = this.mListeners.iterator();
            while (it.hasNext()) {
                WeakReference<TTNetworkStateCallback> cbr = it.next();
                TTNetworkStateCallback cb = (TTNetworkStateCallback)cbr.get();
                if (cb == null) {
                    it.remove();
                    continue;
                }
                cb.onAccessChanged(1, from, this.mCurrentAccessStrength);
            }
            this.mLock.unlock();
        }
    }

    private void updateAccessType(int accessType) {
        if (accessType != this.mCurrentAccessType) {
            this.mLock.lock();
            int from = this.mCurrentAccessType;
            this.mCurrentAccessType = accessType;
            TTVideoEngineLog.d(TAG, "access changed, from: " + from + " to: " + this.mCurrentAccessType + " callback list size: " + this.mListeners.size());
            Iterator<WeakReference<TTNetworkStateCallback>> it = this.mListeners.iterator();
            while (it.hasNext()) {
                WeakReference<TTNetworkStateCallback> cbr = it.next();
                TTNetworkStateCallback cb = (TTNetworkStateCallback)cbr.get();
                if (cb == null) {
                    it.remove();
                    continue;
                }
                cb.onAccessChanged(0, from, this.mCurrentAccessType);
            }
            this.mLock.unlock();
        }
    }

    private int getNetworkType(Context context) {
        if (context == null) {
            return 1000;
        }
        ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
        if (conMgr == null) {
            TTVideoEngineLog.d(TAG, "disconnect");
            return -1;
        }
        try {
            NetworkInfo.State state;
            NetworkInfo activeNetInfo = conMgr.getActiveNetworkInfo();
            if (activeNetInfo == null || !activeNetInfo.isAvailable()) {
                TTVideoEngineLog.d(TAG, "disconnect 1");
                return -1;
            }
            NetworkInfo wifiInfo = conMgr.getNetworkInfo(1);
            if (wifiInfo != null && (state = wifiInfo.getState()) != null && (state == NetworkInfo.State.CONNECTED || state == NetworkInfo.State.CONNECTING)) {
                TTVideoEngineLog.d(TAG, "wifi");
                return 0;
            }
            NetworkInfo networkInfo = conMgr.getNetworkInfo(0);
            if (networkInfo != null) {
                NetworkInfo.State state2 = networkInfo.getState();
                int subtype = activeNetInfo.getSubtype();
                TTVideoEngineLog.d(TAG, "state: " + state2 + ", subtype: " + subtype);
                if (state2 != null && (state2 == NetworkInfo.State.CONNECTED || state2 == NetworkInfo.State.CONNECTING)) {
                    return TTNetWorkListener.convertNetworkType(subtype);
                }
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, e.toString());
            return 1000;
        }
        return 1000;
    }

    public int getCurrentAccessType() {
        return this.mCurrentAccessType;
    }

    public int getCurrentAccessStrength() {
        return this.mCurrentAccessStrength;
    }

    private static int convertNetworkType(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 7: 
            case 11: 
            case 16: {
                return 2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 20: {
                return 4;
            }
        }
        return 6;
    }

    private int getWIFISignalStrength(Context context, Intent intent) {
        if (context == null) {
            return 10;
        }
        int sigLevel = 10;
        try {
            WifiManager wifiManager;
            WifiInfo wifiInfo;
            PackageManager pm;
            NetworkInfo networkInfo;
            ConnectivityManager conMgr = (ConnectivityManager)context.getSystemService("connectivity");
            if (conMgr == null) {
                return sigLevel;
            }
            int rssi = -1;
            if (intent != null) {
                rssi = intent.getIntExtra("newRssi", -70);
            } else if (!this.mIsWifiSensitiveMode && (networkInfo = conMgr.getNetworkInfo(1)) != null && networkInfo.isConnected() && (pm = context.getPackageManager()).checkPermission("android.permission.ACCESS_WIFI_STATE", context.getPackageName()) == 0 && (wifiInfo = (wifiManager = (WifiManager)context.getSystemService("wifi")).getConnectionInfo()) != null) {
                rssi = wifiInfo.getRssi();
            }
            int level = WifiManager.calculateSignalLevel((int)rssi, (int)4);
            TTVideoEngineLog.d(TAG, "wifi dbm:" + rssi + ", level:" + level);
            sigLevel = level + 1;
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, e.toString());
        }
        return sigLevel;
    }

    public void setIntValue(int key, int value) {
        switch (key) {
            case 1: {
                PortraitNetworkScore.getInstance().setIntOption(2, value);
                break;
            }
            case 2: {
                PortraitNetworkScore.getInstance().setIntOption(3, value);
            }
        }
    }

    public void setStringValue(int key, String value) {
        switch (key) {
            case 3: 
            case 4: 
            case 5: {
                PortraitNetworkScore.getInstance().setStringOption(key, value);
            }
        }
    }

    public String getSignalStrength() {
        if (this.mCurrentAccessType == 1000) {
            return "unknown";
        }
        switch (this.mCurrentAccessStrength) {
            case 1: {
                return "weak";
            }
            case 2: {
                return "medium";
            }
            case 3: {
                return "good";
            }
            case 4: {
                return "excellent";
            }
        }
        return "unknown";
    }

    private static class MyThread
    extends Thread {
        private WeakReference<Context> mContextRef;
        private WeakReference<TTNetWorkListener> mTTNetworkListener;

        public MyThread(Context ctx, TTNetWorkListener listener) {
            this.mContextRef = new WeakReference<Context>(ctx);
            this.mTTNetworkListener = new WeakReference<TTNetWorkListener>(listener);
        }

        @Override
        public void run() {
            if (Looper.myLooper() == null) {
                Looper.prepare();
            }
            int sensitiveMode = TTVideoEngineUtils.getSensitiveScene();
            switch (sensitiveMode) {
                case 1: 
                case 2: 
                case 3: {
                    TTNetWorkListener.getInstance().mIsWifiSensitiveMode = true;
                    TTVideoEngineLog.i(TTNetWorkListener.TAG, "is wifi sensitive mode:" + sensitiveMode);
                }
            }
            TTNetWorkListener.getInstance().registerListener((Context)this.mContextRef.get());
            Looper.loop();
            TTNetWorkListener listener = (TTNetWorkListener)((Object)this.mTTNetworkListener.get());
            if (listener != null) {
                listener.unregisterListener((Context)this.mContextRef.get());
            }
        }
    }

    private static class TTPhoneStateListener
    extends PhoneStateListener {
        private TelephonyManager mTelephonyManager = null;
        private WeakReference<TTNetWorkListener> mHandler = null;

        public TTPhoneStateListener(Context context, TTNetWorkListener handler) {
            if (handler != null) {
                this.mHandler = new WeakReference<TTNetWorkListener>(handler);
            }
            try {
                TelephonyManager defaultManager = (TelephonyManager)context.getSystemService("phone");
                if (defaultManager == null) {
                    return;
                }
                this.mTelephonyManager = defaultManager;
            }
            catch (Exception e) {
                TTVideoEngineLog.e(TTNetWorkListener.TAG, "create telephonyManager failed");
                this.mTelephonyManager = null;
            }
        }

        private void listenCompact(Context context, PhoneStateListener listener, int events) {
            if (this.mTelephonyManager == null || context == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 31) {
                if (context.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
                    this.mTelephonyManager.listen(listener, events);
                }
            } else {
                this.mTelephonyManager.listen(listener, events);
            }
        }

        public void register(Context context) {
            if (this.mTelephonyManager != null) {
                if (Build.VERSION.SDK_INT >= 23) {
                    try {
                        TTVideoEngineLog.d(TTNetWorkListener.TAG, "start listen signal strength");
                        this.listenCompact(context, this, 256);
                    }
                    catch (Exception e) {
                        TTVideoEngineLog.e(TTNetWorkListener.TAG, "listen signal strength failed");
                    }
                }
                this.listenCompact(context, this, 64);
            }
        }

        public void unregister(Context context) {
            if (this.mTelephonyManager != null) {
                this.listenCompact(context, this, 0);
            }
        }

        public void onDataConnectionStateChanged(int state, int networkType) {
            TTNetWorkListener ttNetWorkListener;
            super.onDataConnectionStateChanged(state, networkType);
            TTVideoEngineLog.d(TTNetWorkListener.TAG, "data connection state changed, state: " + state + ", networkType: " + networkType);
            if (state == 2 && this.mHandler != null && (ttNetWorkListener = (TTNetWorkListener)((Object)this.mHandler.get())) != null && ttNetWorkListener.mCurrentAccessType != 0) {
                ttNetWorkListener._handleNetworkChange(networkType);
            }
        }

        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            super.onSignalStrengthsChanged(signalStrength);
            if (signalStrength == null || Build.VERSION.SDK_INT < 23) {
                return;
            }
            TTNetWorkListener ttNetWorkListener = null;
            if (this.mHandler != null) {
                ttNetWorkListener = (TTNetWorkListener)((Object)this.mHandler.get());
            }
            if (ttNetWorkListener != null && ttNetWorkListener.mCurrentAccessType == 0) {
                return;
            }
            int level = -1;
            try {
                level = signalStrength.getLevel();
                if (level == 0) {
                    level = 1;
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.e(TTNetWorkListener.TAG, "failed to get signalStrength");
            }
            if (ttNetWorkListener != null) {
                ttNetWorkListener._handleSigStrengthChange(level);
            }
        }
    }
}

