/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class TTVideoEngineHelper {
    private static final String TAG = "TTVideoEngine";

    TTVideoEngineHelper() {
    }

    @Nullable
    static IVideoInfo infoFromBitrate(@NonNull IVideoModel videoModel, long videoBitrate) {
        List<VideoInfo> videoInfos = videoModel.getVideoInfoList();
        VideoInfo selectedInfo = null;
        if (videoBitrate > 0L && videoInfos != null) {
            for (VideoInfo videoInfo : videoInfos) {
                long resolutionBitRate;
                if (videoInfo == null || videoInfo.getMediatype() == VideoRef.TYPE_AUDIO || videoInfo.getResolution() == null || (resolutionBitRate = (long)videoInfo.getValueInt(3)) != videoBitrate) continue;
                selectedInfo = videoInfo;
                break;
            }
        }
        return selectedInfo;
    }

    @Nullable
    static Map<Integer, String> paramsFromVideoInfo(@Nullable IVideoInfo videoInfo) {
        if (videoInfo == null) {
            return null;
        }
        HashMap<Integer, String> params = null;
        if (!TextUtils.isEmpty((CharSequence)videoInfo.getValueStr(32))) {
            params = new HashMap<Integer, String>();
            params.put(32, videoInfo.getValueStr(32));
        }
        return params;
    }

    static boolean isMayUseP2P(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            TTVideoEngineLog.d(TAG, "url null, may not use p2p");
            return false;
        }
        if (!url.contains("http://127.0.0.1") && !url.contains("mdl://")) {
            TTVideoEngineLog.d(TAG, "url not 127 or mdl protocol, may not use p2p");
            return false;
        }
        TTVideoEngineLog.d(TAG, "url  may use p2p");
        return true;
    }
}

