/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Keep;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;

@Keep
public final class TTVideoEngineMonitor {
    private static final String TAG = "TTVideoEngineMonitor";
    private static final String ACTION_LIVE_PLAYER_PLAYING = "com.bytedance.android.livesdk.player.monitor.ACTION_LIVE_PLAYER_PLAYING";
    private static final String ACTION_LIVE_PLAYER_STOP_OR_RELEASE = "com.bytedance.android.livesdk.player.monitor.ACTION_LIVE_PLAYER_STOP_OR_RELEASE";
    private static final String ACTION_CROSSTALK_DIDHAPPEN = "com.bytedance.android.vodsdk.player.monitor.ACTION_CROSSTALK_DIDHAPPEN";
    private HashMap<String, TTVideoEngineStateWrapper> allEngineWrapper = new HashMap();
    private int playingCount = 0;
    private HashMap<String, TTVideoEngineLivePlayerInfo> playingLivePLayerInfos = new HashMap();
    private final Context mContext;
    private CrosstalkReceiver mCrosstalkReceiver;
    private Handler mainHandler;
    private static volatile boolean enableCheck = false;
    private static volatile TTVideoEngineMonitor instance;

    private TTVideoEngineMonitor(Context context) {
        this.mContext = context.getApplicationContext();
        this.start();
    }

    public void start() {
        if (enableCheck && this.mCrosstalkReceiver == null) {
            this.registerBroadcastReceiver(this.mContext);
        }
    }

    private void registerBroadcastReceiver(Context context) {
        IntentFilter filter = new IntentFilter(ACTION_LIVE_PLAYER_PLAYING);
        filter.addAction(ACTION_LIVE_PLAYER_STOP_OR_RELEASE);
        this.mCrosstalkReceiver = new CrosstalkReceiver();
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this.mCrosstalkReceiver, filter);
    }

    public void stop() {
        this.unregisterBroadcastReceiver(this.mContext);
    }

    private void unregisterBroadcastReceiver(Context context) {
        if (this.mCrosstalkReceiver != null) {
            try {
                LocalBroadcastManager.getInstance((Context)context).unregisterReceiver((BroadcastReceiver)this.mCrosstalkReceiver);
            }
            catch (Exception e) {
                TTVideoEngineLog.w(TAG, e.getMessage());
            }
            this.mCrosstalkReceiver = null;
        }
    }

    @Keep
    public static void enableCrosstalkCheck(Context context, boolean enable) {
        enableCheck = enable;
        TTVideoEngineMonitor.getInstance(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Keep
    public static TTVideoEngineMonitor getInstance(Context context) {
        if (instance != null) return instance;
        Class<TTVideoEngineMonitor> clazz = TTVideoEngineMonitor.class;
        synchronized (TTVideoEngineMonitor.class) {
            if (instance != null) return instance;
            instance = new TTVideoEngineMonitor(context);
            TTVideoEngineLog.i(TAG, "Construct TTVideoEngineMonitor");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startObserve(int engineHash, TTVideoEngine engine) {
        if (null == engine) {
            return;
        }
        TTVideoEngineStateWrapper wrap = new TTVideoEngineStateWrapper(engine);
        TTVideoEngineMonitor tTVideoEngineMonitor = this;
        synchronized (tTVideoEngineMonitor) {
            this.allEngineWrapper.put(engineHash + "", wrap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopObserve(int engineHash) {
        TTVideoEngineMonitor tTVideoEngineMonitor = this;
        synchronized (tTVideoEngineMonitor) {
            this.allEngineWrapper.remove(engineHash + "");
        }
    }

    private static HashMap<String, Object> generateCrosstalkMap(String tag, String subTag, int isLive, String engineHash) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)tag)) {
            map.put("tag", tag);
        }
        if (!TextUtils.isEmpty((CharSequence)subTag)) {
            map.put("subtag", subTag);
        }
        map.put("islive", isLive);
        if (!TextUtils.isEmpty((CharSequence)engineHash)) {
            map.put("enginehash", engineHash);
        }
        return map;
    }

    @Nullable
    private static String generateCrosstalkCallbackStr(ArrayList<HashMap<String, Object>> infoListForCallback) {
        if (infoListForCallback != null && infoListForCallback.size() > 0) {
            try {
                return new JSONArray(infoListForCallback).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private synchronized void postRunCrosstalkCheck() {
        if (this.mainHandler == null) {
            this.mainHandler = new Handler(Looper.getMainLooper());
        }
        this.mainHandler.postDelayed(this::crosstalkCheck, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crosstalkCheck() {
        ArrayList<TTVideoEngine> crosstalkEngines = null;
        HashMap<String, TTVideoEngineLivePlayerInfo> nPlayingLivePlayerInfos = null;
        boolean crosstalkHappend = false;
        boolean crosstalkContainVod = false;
        boolean crosstalkContainLive = false;
        TTVideoEngineMonitor tTVideoEngineMonitor = this;
        synchronized (tTVideoEngineMonitor) {
            int playingLiveCount = this.playingLivePLayerInfos.size();
            if (this.playingCount + playingLiveCount >= 2) {
                crosstalkHappend = true;
                if (this.playingCount > 0) {
                    crosstalkContainVod = true;
                    crosstalkEngines = new ArrayList<TTVideoEngine>();
                    ArrayList<String> willRemoveKeys = new ArrayList<String>();
                    for (String string : this.allEngineWrapper.keySet()) {
                        TTVideoEngineStateWrapper objWrapper = this.allEngineWrapper.get(string);
                        if (objWrapper == null) continue;
                        TTVideoEngine objEngine = (TTVideoEngine)objWrapper.weakVideoEngine.get();
                        if (objEngine != null) {
                            if (!objWrapper.hasSetPlaying) continue;
                            crosstalkEngines.add(objEngine);
                            continue;
                        }
                        willRemoveKeys.add(string);
                    }
                    if (willRemoveKeys.size() > 0) {
                        for (String string : willRemoveKeys) {
                            this.allEngineWrapper.remove(string);
                        }
                    }
                }
                if (playingLiveCount > 0) {
                    crosstalkContainLive = true;
                    nPlayingLivePlayerInfos = new HashMap<String, TTVideoEngineLivePlayerInfo>(this.playingLivePLayerInfos);
                }
            }
        }
        if (!crosstalkHappend) {
            return;
        }
        int nVodCount = 0;
        int nLiveCount = 0;
        if (crosstalkEngines != null) {
            nVodCount = crosstalkEngines.size();
        }
        if (nPlayingLivePlayerInfos != null) {
            nLiveCount = nPlayingLivePlayerInfos.size();
        }
        if (nVodCount + nLiveCount < 2) {
            return;
        }
        if (crosstalkEngines == null || crosstalkEngines.size() <= 0) {
            crosstalkContainVod = false;
        }
        if (nPlayingLivePlayerInfos == null || nPlayingLivePlayerInfos.size() <= 0) {
            crosstalkContainLive = false;
        }
        ArrayList<HashMap<String, Object>> infoListForCallback = new ArrayList<HashMap<String, Object>>();
        boolean hasRecordVodInfo = false;
        if (crosstalkContainVod && crosstalkEngines != null && crosstalkEngines.size() > 0) {
            for (TTVideoEngine engine : crosstalkEngines) {
                ArrayList<HashMap<String, Object>> crosstalkVodList = engine.crosstalkHappen(crosstalkEngines, nPlayingLivePlayerInfos);
                if (!crosstalkContainLive || hasRecordVodInfo || crosstalkVodList == null || crosstalkVodList.size() <= 0) continue;
                hasRecordVodInfo = true;
                infoListForCallback.addAll(crosstalkVodList);
            }
        }
        if (crosstalkContainLive && nPlayingLivePlayerInfos != null && nPlayingLivePlayerInfos.size() > 0) {
            for (String keyHashcodeStr : nPlayingLivePlayerInfos.keySet()) {
                TTVideoEngineLivePlayerInfo liveInfo = nPlayingLivePlayerInfos.get(keyHashcodeStr);
                if (liveInfo == null) continue;
                HashMap<String, Object> map = TTVideoEngineMonitor.generateCrosstalkMap(liveInfo.mTag, liveInfo.mSubTag, 1, keyHashcodeStr);
                infoListForCallback.add(map);
            }
            String string = TTVideoEngineMonitor.generateCrosstalkCallbackStr(infoListForCallback);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                Intent intent = new Intent(ACTION_CROSSTALK_DIDHAPPEN);
                intent.putExtra("crosstalk_info_list", string);
                try {
                    LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
                }
                catch (Exception e) {
                    TTVideoEngineLog.w(TAG, e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineStateChange(int engineHash, boolean becomePlaying) {
        if (!enableCheck) {
            return;
        }
        if (!becomePlaying) {
            TTVideoEngineMonitor tTVideoEngineMonitor = this;
            synchronized (tTVideoEngineMonitor) {
                TTVideoEngineStateWrapper changedWrapper = this.allEngineWrapper.get(engineHash + "");
                if (changedWrapper != null && changedWrapper.hasSetPlaying) {
                    changedWrapper.hasSetPlaying = false;
                    --this.playingCount;
                }
            }
        }
        boolean needCheck = false;
        TTVideoEngineMonitor tTVideoEngineMonitor = this;
        synchronized (tTVideoEngineMonitor) {
            TTVideoEngineStateWrapper changedWrapper = this.allEngineWrapper.get(engineHash + "");
            if (changedWrapper != null && !changedWrapper.hasSetPlaying) {
                changedWrapper.hasSetPlaying = true;
                ++this.playingCount;
                int playingLiveCount = this.playingLivePLayerInfos.size();
                if (this.playingCount + playingLiveCount >= 2) {
                    needCheck = true;
                }
            }
        }
        if (needCheck) {
            this.postRunCrosstalkCheck();
        }
    }

    public final class TTVideoEngineLivePlayerInfo {
        public String mTag = "";
        public String mSubTag = "";
    }

    private final class TTVideoEngineStateWrapper {
        private WeakReference<TTVideoEngine> weakVideoEngine = null;
        private boolean hasSetPlaying;

        public TTVideoEngineStateWrapper(TTVideoEngine eng) {
            this.weakVideoEngine = new WeakReference<TTVideoEngine>(eng);
            this.hasSetPlaying = false;
        }
    }

    private class CrosstalkReceiver
    extends BroadcastReceiver {
        private CrosstalkReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (!enableCheck) {
                return;
            }
            if (intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
                return;
            }
            String action = intent.getAction();
            String engineHash = intent.getStringExtra("enginehash");
            if (TextUtils.isEmpty((CharSequence)engineHash)) {
                return;
            }
            switch (intent.getAction()) {
                case "com.bytedance.android.livesdk.player.monitor.ACTION_LIVE_PLAYER_PLAYING": {
                    TTVideoEngineLivePlayerInfo detectLivePlayer = null;
                    CrosstalkReceiver crosstalkReceiver = this;
                    synchronized (crosstalkReceiver) {
                        detectLivePlayer = (TTVideoEngineLivePlayerInfo)TTVideoEngineMonitor.this.playingLivePLayerInfos.get(engineHash);
                    }
                    if (detectLivePlayer != null) {
                        return;
                    }
                    String tag = intent.getStringExtra("tag");
                    String subtag = intent.getStringExtra("subtag");
                    TTVideoEngineLivePlayerInfo livePlayerInfo = new TTVideoEngineLivePlayerInfo();
                    if (!TextUtils.isEmpty((CharSequence)tag)) {
                        livePlayerInfo.mTag = tag;
                    }
                    if (!TextUtils.isEmpty((CharSequence)subtag)) {
                        livePlayerInfo.mSubTag = subtag;
                    }
                    boolean needCheck = false;
                    CrosstalkReceiver crosstalkReceiver2 = this;
                    synchronized (crosstalkReceiver2) {
                        TTVideoEngineMonitor.this.playingLivePLayerInfos.put(engineHash, livePlayerInfo);
                        int playingLiveCount = TTVideoEngineMonitor.this.playingLivePLayerInfos.size();
                        if (TTVideoEngineMonitor.this.playingCount + playingLiveCount >= 2) {
                            needCheck = true;
                        }
                    }
                    if (!needCheck) break;
                    TTVideoEngineMonitor.this.postRunCrosstalkCheck();
                    break;
                }
                case "com.bytedance.android.livesdk.player.monitor.ACTION_LIVE_PLAYER_STOP_OR_RELEASE": {
                    CrosstalkReceiver crosstalkReceiver = this;
                    synchronized (crosstalkReceiver) {
                        TTVideoEngineMonitor.this.playingLivePLayerInfos.remove(engineHash);
                        break;
                    }
                }
            }
        }
    }
}

