/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.database;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.ss.ttvideoengine.database.KVDBHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class KVDBManager {
    private static final String TAG = "KVDBManager";
    private SQLiteDatabase mDB = null;
    private String mTableName = null;
    private KVDBHelper mHelper = null;
    private boolean createDBSuccess = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVDBManager(Context context, String name) {
        if (context == null || TextUtils.isEmpty((CharSequence)name)) {
            TTVideoEngineLog.e(TAG, "context or name is invalid");
            return;
        }
        this.mTableName = name;
        boolean sqlExcHappen = false;
        this.mHelper = new KVDBHelper(context, this.mTableName);
        if (this.mHelper != null) {
            block11: {
                try {
                    this.mDB = this.mHelper.getWritableDatabase();
                    if (this.mDB != null) {
                        String order = String.format("CREATE TABLE IF NOT EXISTS %s(key TEXT PRIMARY KEY,value TEXT,time INTEGER)", this.mTableName);
                        this.mDB.execSQL(order);
                    }
                    if (!sqlExcHappen) break block11;
                }
                catch (Throwable e) {
                    block12: {
                        try {
                            TTVideoEngineLog.d(e);
                            sqlExcHappen = true;
                            if (!sqlExcHappen) break block12;
                        }
                        catch (Throwable throwable) {
                            if (sqlExcHappen) {
                                TTVideoEngineLog.e(TAG, "create db fail, table name " + this.mTableName);
                            }
                            if (this.mHelper == null) {
                                TTVideoEngineLog.e(TAG, "create db fail, mHelper == null, table name " + this.mTableName);
                            }
                            this.createDBSuccess = this.mHelper != null && !sqlExcHappen;
                            throw throwable;
                        }
                        TTVideoEngineLog.e(TAG, "create db fail, table name " + this.mTableName);
                    }
                    if (this.mHelper == null) {
                        TTVideoEngineLog.e(TAG, "create db fail, mHelper == null, table name " + this.mTableName);
                    }
                    this.createDBSuccess = this.mHelper != null && !sqlExcHappen;
                }
                TTVideoEngineLog.e(TAG, "create db fail, table name " + this.mTableName);
            }
            if (this.mHelper == null) {
                TTVideoEngineLog.e(TAG, "create db fail, mHelper == null, table name " + this.mTableName);
            }
            this.createDBSuccess = this.mHelper != null && !sqlExcHappen;
        }
    }

    public boolean isCreateDBSuccess() {
        return this.createDBSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean save(String key, String value) {
        if (this.mDB == null || TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            TTVideoEngineLog.e(TAG, "open db fail");
            return false;
        }
        TTVideoEngineLog.i(TAG, "save key: " + key + " value: " + value);
        boolean sqlExcHappen = false;
        try {
            try {
                this.mDB.beginTransaction();
                try {
                    String order = String.format("REPLACE INTO %s VALUES ('%s','%s',%d)", this.mTableName, key, value, System.currentTimeMillis());
                    this.mDB.execSQL(order);
                    this.mDB.setTransactionSuccessful();
                }
                catch (SQLException e2222222) {
                    TTVideoEngineLog.d(e2222222);
                    sqlExcHappen = true;
                    {
                        catch (Throwable throwable) {
                            this.mDB.endTransaction();
                            boolean bl = !sqlExcHappen;
                            if (sqlExcHappen) return false;
                            return true;
                        }
                    }
                    this.mDB.endTransaction();
                    boolean e2222222 = !sqlExcHappen;
                    if (sqlExcHappen) return false;
                    return true;
                    catch (IllegalStateException e222222222) {
                        TTVideoEngineLog.d(e222222222);
                        this.mDB.endTransaction();
                        boolean e222222222 = !sqlExcHappen;
                        if (sqlExcHappen) return false;
                        return true;
                    }
                }
                this.mDB.endTransaction();
                boolean order = !sqlExcHappen;
                if (sqlExcHappen) return false;
                return true;
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
                if (sqlExcHappen) return false;
                return true;
            }
        }
        catch (Throwable throwable) {
            if (sqlExcHappen) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String key) {
        if (this.mDB == null || TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.d(TAG, "open db fail");
            return false;
        }
        boolean sqlExcHappen = false;
        this.mDB.beginTransaction();
        try {
            String order = String.format("DELETE FROM %s WHERE key='%s'", this.mTableName, key);
            this.mDB.execSQL(order);
            this.mDB.setTransactionSuccessful();
        }
        catch (Exception e3) {
            try {
                sqlExcHappen = true;
                TTVideoEngineLog.d(e3);
            }
            catch (Throwable throwable) {
                try {
                    this.mDB.endTransaction();
                    if (!sqlExcHappen) {
                        TTVideoEngineLog.d(TAG, "remove key " + key);
                    }
                    boolean bl = !sqlExcHappen;
                    return !sqlExcHappen;
                }
                catch (Throwable e2) {
                    try {
                        TTVideoEngineLog.d(e2);
                        return !sqlExcHappen;
                    }
                    catch (Throwable throwable2) {
                        return !sqlExcHappen;
                    }
                }
            }
            this.mDB.endTransaction();
            if (!sqlExcHappen) {
                TTVideoEngineLog.d(TAG, "remove key " + key);
            }
            boolean e3 = !sqlExcHappen;
            return !sqlExcHappen;
        }
        this.mDB.endTransaction();
        if (!sqlExcHappen) {
            TTVideoEngineLog.d(TAG, "remove key " + key);
        }
        boolean order = !sqlExcHappen;
        return !sqlExcHappen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || this.mDB == null) {
            TTVideoEngineLog.e(TAG, "open db fail");
            return null;
        }
        String info = null;
        try {
            String order = String.format("SELECT * FROM %s WHERE key='%s'", this.mTableName, key);
            Cursor c = this.mDB.rawQuery(order, null);
            if (c.moveToFirst()) {
                info = c.getString(c.getColumnIndex("value"));
            }
            c.close();
            TTVideoEngineLog.d(TAG, "get key: " + key + " value: " + info);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            info = null;
            return info;
        }
        finally {
            return info;
        }
    }

    public void clear() {
        if (this.mDB == null) {
            return;
        }
        try {
            this.mDB.beginTransaction();
            try {
                String order = String.format("DELETE FROM %s ", this.mTableName);
                this.mDB.execSQL(order);
                this.mDB.setTransactionSuccessful();
                TTVideoEngineLog.d(TAG, "all cleared");
            }
            catch (Exception e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                this.mDB.endTransaction();
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }
}

