/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher.mdlfethcer;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.mediakit.fetcher.AVMDLURLFetcherInterface;
import com.ss.mediakit.fetcher.AVMDLURLFetcherListener;
import com.ss.ttvideoengine.VideoModelCache;
import com.ss.ttvideoengine.fetcher.VideoInfoFetcher;
import com.ss.ttvideoengine.fetcher.mdlfethcer.MDLFetcherListener;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;

public class MDLFetcherNew
implements AVMDLURLFetcherInterface {
    private static final String TAG = "MDLFetcherNew";
    private static final int CALLBACK_URLS_TO_MDL = 0;
    private static final int MDL_GET_URLS = 1;
    private WeakReference<MDLFetcherListener> mMDLFetcherListener;
    private String mVideoID;
    private String mFileHash;
    private String[] mNewUrls = null;
    private VideoInfoFetcher mFetcher;
    private AVMDLURLFetcherListener mListener;
    private String mOldUrl;
    private VideoModel mVideoModel;

    public MDLFetcherNew(MDLFetcherListener mdlFetcherListener) {
        this.mMDLFetcherListener = new WeakReference<MDLFetcherListener>(mdlFetcherListener);
    }

    public int start(String rawKey, String fileKey, String oldUrl, AVMDLURLFetcherListener listener) {
        TTVideoEngineLog.i(TAG, "start rawKey " + rawKey + ", fileKey " + fileKey + ", olderUrl " + oldUrl + ", listener " + listener);
        this.mVideoID = rawKey;
        this.mFileHash = fileKey;
        this.mListener = listener;
        this.mOldUrl = oldUrl;
        MDLFetcherListener mdlFetcherListener = this.getMDLFetcherListener();
        if (mdlFetcherListener == null) {
            TTVideoEngineLog.i(TAG, "start MDLFetcherListener is null return MDL_GET_URLS");
            this.onError(new Error("kTTVideoErrorDomainMDLRetry", -10001, "MDLFetcherListener is empty"), false);
            return 1;
        }
        String fallbackApi = mdlFetcherListener.getFallbackApi();
        if (TextUtils.isEmpty((CharSequence)fallbackApi)) {
            TTVideoEngineLog.i(TAG, "start fallbackApi is empty return MDL_GET_URLS");
            this.onError(new Error("kTTVideoErrorDomainMDLRetry", -10002, "fallbackApi is empty"), false);
            return 1;
        }
        String[] urls = this.getURLsFromCache(fallbackApi, oldUrl);
        if (urls != null && urls.length > 0) {
            this.mNewUrls = urls;
            TTVideoEngineLog.i(TAG, "start return MDL_GET_URLS");
            this.onCompletion(this.mVideoModel, false);
            return 1;
        }
        Context context = mdlFetcherListener.getContext();
        this.mFetcher = new VideoInfoFetcher(context, null);
        this.mFetcher.setUseVideoModelCache(context != null);
        this.mFetcher.setVideoID(rawKey);
        this.mFetcher.setListener(new MyFetcherListener(this));
        this.mFetcher.setUseFallbakApi(true);
        this.mFetcher.fetchInfo(fallbackApi, null, 0, null);
        TTVideoEngineLog.i(TAG, "start return CALLBACK_URLS_TO_MDL");
        return 0;
    }

    public String[] getURLs() {
        TTVideoEngineLog.i(TAG, "mdl getURLs " + Arrays.toString(this.mNewUrls));
        return this.mNewUrls;
    }

    public void close() {
        if (this.mFetcher != null) {
            this.mFetcher.cancel();
            this.mFetcher = null;
        }
        this.mMDLFetcherListener = null;
    }

    private void onError(Error error, boolean callbackToMDL) {
        MDLFetcherListener mdlFetcherListener;
        if (callbackToMDL) {
            this.mListener.onCompletion(error.code, this.mVideoID, this.mFileHash, null);
        }
        if ((mdlFetcherListener = this.getMDLFetcherListener()) != null) {
            mdlFetcherListener.onError(error, this.mFileHash);
        }
        this.close();
    }

    private void onCompletion(VideoModel model, boolean newModel) {
        MDLFetcherListener mdlFetcherListener = this.getMDLFetcherListener();
        if (mdlFetcherListener != null) {
            mdlFetcherListener.onCompletion(model, newModel, this.mFileHash);
        }
        this.close();
    }

    @Nullable
    private String[] getURLsFromCache(String fallbackApi, String oldUrl) {
        VideoModelCache.VideoModelCacheInfo cacheInfo = VideoModelCache.getInstance().get(this.mVideoID, fallbackApi);
        if (cacheInfo == null || cacheInfo.isExpired) {
            TTVideoEngineLog.i(TAG, "getURLsFromCache cacheInfo is null or isExpired");
            return null;
        }
        this.mVideoModel = cacheInfo.model;
        Object[] temUrls = this.getUrlsFromVideoModelByFileHash(cacheInfo.model, this.mFileHash);
        if (temUrls == null || temUrls.length <= 0) {
            TTVideoEngineLog.i(TAG, "getURLsFromCache temUrls is null");
            return null;
        }
        if (!MDLFetcherNew.isNewUrlsValid((String[])temUrls, oldUrl)) {
            VideoModelCache.getInstance().remove(this.mVideoID, fallbackApi);
            TTVideoEngineLog.i(TAG, "getURLsFromCache urls is invalid");
            return null;
        }
        TTVideoEngineLog.i(TAG, "getURLsFromCache " + Arrays.toString(temUrls));
        return temUrls;
    }

    @Nullable
    private String[] getUrlsFromVideoModelByFileHash(VideoModel videoModel, String fileHash) {
        if (videoModel == null || TextUtils.isEmpty((CharSequence)fileHash)) {
            TTVideoEngineLog.i(TAG, "getUrlsFromVideoModelByFileHash videoModel is null or fileHash is empty " + fileHash);
            return null;
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(15, fileHash);
        VideoInfo info = videoModel.getVideoInfo(map);
        if (info == null) {
            TTVideoEngineLog.i(TAG, "getUrlsFromVideoModelByFileHash videoInfo is null");
            return null;
        }
        Object[] temUrls = info.getValueStrArr(16);
        TTVideoEngineLog.i(TAG, "getUrlsFromVideoModelByFileHash " + Arrays.toString(temUrls));
        return temUrls;
    }

    private static boolean isNewUrlsValid(String[] newUrls, String oldUrl) {
        if (newUrls == null || newUrls.length <= 0) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)oldUrl)) {
            return true;
        }
        for (String newUrl : newUrls) {
            if (!TextUtils.equals((CharSequence)newUrl, (CharSequence)oldUrl)) continue;
            TTVideoEngineLog.d(TAG, "new urls is invalid");
            return false;
        }
        return true;
    }

    private MDLFetcherListener getMDLFetcherListener() {
        if (this.mMDLFetcherListener == null) {
            TTVideoEngineLog.d(TAG, "getMDLFetcherListener is null");
            return null;
        }
        return (MDLFetcherListener)this.mMDLFetcherListener.get();
    }

    static /* synthetic */ String[] access$202(MDLFetcherNew x0, String[] x1) {
        x0.mNewUrls = x1;
        return x1;
    }

    private static class MyFetcherListener
    implements VideoInfoFetcher.FetcherListener {
        private final WeakReference<MDLFetcherNew> mFetcherRef;

        public MyFetcherListener(MDLFetcherNew fetcher) {
            this.mFetcherRef = new WeakReference<MDLFetcherNew>(fetcher);
        }

        @Override
        public void onRetry(Error error) {
            MDLFetcherNew fetcher = (MDLFetcherNew)this.mFetcherRef.get();
            if (fetcher == null || fetcher.getMDLFetcherListener() == null) {
                return;
            }
            fetcher.getMDLFetcherListener().onRetry(error);
        }

        @Override
        public void onCompletion(VideoModel model, Error error) {
            TTVideoEngineLog.i(MDLFetcherNew.TAG, "onCompletion model " + model + ", error " + error);
            MDLFetcherNew fetcher = (MDLFetcherNew)this.mFetcherRef.get();
            if (fetcher == null) {
                TTVideoEngineLog.i(MDLFetcherNew.TAG, "onCompletion but fetcher is null");
                return;
            }
            if (error != null) {
                fetcher.onError(error, true);
                return;
            }
            if (model == null) {
                fetcher.onError(new Error("kTTVideoErrorDomainMDLRetry", -9997, "fetch empty"), true);
                return;
            }
            MDLFetcherNew.access$202(fetcher, fetcher.getUrlsFromVideoModelByFileHash(model, fetcher.mFileHash));
            TTVideoEngineLog.i(MDLFetcherNew.TAG, "onCompletion newUrls " + Arrays.toString(fetcher.mNewUrls));
            if (fetcher.mNewUrls == null || fetcher.mNewUrls.length == 0) {
                fetcher.onError(new Error("kTTVideoErrorDomainMDLRetry", -10003, "file hash invalid"), true);
                return;
            }
            boolean valid = MDLFetcherNew.isNewUrlsValid(fetcher.mNewUrls, fetcher.mOldUrl);
            if (valid) {
                fetcher.mListener.onCompletion(0, fetcher.mVideoID, fetcher.mFileHash, fetcher.mNewUrls);
                fetcher.onCompletion(model, true);
            } else {
                fetcher.onError(new Error("kTTVideoErrorDomainMDLRetry", -10004, "fetch videoModel is expired"), true);
            }
        }

        @Override
        public void onStatusException(int status, String message) {
            MDLFetcherNew fetcher = (MDLFetcherNew)this.mFetcherRef.get();
            if (fetcher == null) {
                TTVideoEngineLog.i(MDLFetcherNew.TAG, "onStatusException but fetcher is null");
                return;
            }
            fetcher.onError(new Error("kTTVideoErrorDomainMDLRetry", -10005, status, message), true);
        }

        @Override
        public void onLog(String message) {
            MDLFetcherNew fetcher = (MDLFetcherNew)this.mFetcherRef.get();
            if (fetcher == null || fetcher.getMDLFetcherListener() == null) {
                return;
            }
            fetcher.getMDLFetcherListener().onLog(message);
        }
    }
}

