/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.TextUtils;
import com.ss.ttvideoengine.BaseAppInfo;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventOnePlay;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.io.InputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentDataReporter {
    private static final String TAG = "ContentDataReporter";
    private TTVNetClient mNetClient = new TTHTTPNetwork();
    private boolean mCanceled;
    private Context mContext;
    private static String mRequestUrl;
    private static volatile boolean mInit;
    private static volatile int mRetryCnt;
    private static final int MAX_RETRY_COUNT = 3;
    private static final String mAssertsFileName = "CN_content_data_transmit_url.json";
    private String mInitialUrl = null;

    public ContentDataReporter(Context context) {
        this.mContext = context;
        this.readRequestUrlFromAsserts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRequestUrlFromAsserts() {
        if (mInit) {
            return;
        }
        Class<ContentDataReporter> clazz = ContentDataReporter.class;
        synchronized (ContentDataReporter.class) {
            if (mRetryCnt >= 3) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            EngineThreadPool.addExecuteTask(() -> {
                if (this.mContext == null) return;
                try {
                    InputStream is = this.mContext.getAssets().open(mAssertsFileName);
                    int size = is.available();
                    byte[] buffer = new byte[size];
                    is.read(buffer);
                    is.close();
                    String fileContent = new String(buffer, "UTF-8");
                    JSONObject jsonObject = new JSONObject(fileContent);
                    if (!jsonObject.has("requestUrl+CN")) return;
                    mRequestUrl = jsonObject.getString("requestUrl+CN");
                    mInit = true;
                    return;
                }
                catch (Exception e) {
                    Class<ContentDataReporter> clazz = ContentDataReporter.class;
                    // MONITORENTER : com.ss.ttvideoengine.log.ContentDataReporter.class
                    ++mRetryCnt;
                    // MONITOREXIT : clazz
                    TTVideoEngineLog.e(TAG, e.toString());
                }
            });
            return;
        }
    }

    public void startTask(VideoEventOnePlay onePlay, VideoEventBase base) {
        if (this.mCanceled) {
            TTVideoEngineLog.i(TAG, "canceled, return");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)mRequestUrl)) {
            TTVideoEngineLog.i(TAG, "mRequestUrl is empty, return");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mInitialUrl) || onePlay == null || base == null) {
            TTVideoEngineLog.i(TAG, "null parameter, return");
            return;
        }
        int index = this.mInitialUrl.indexOf("?");
        if (index == -1) {
            TTVideoEngineLog.i(TAG, "cant find ?, return");
            return;
        }
        final String requestUrl = mRequestUrl + this.mInitialUrl.substring(index);
        JSONObject requestBody = new JSONObject();
        try {
            requestBody.put("start_event_time", onePlay.pt);
            requestBody.put("end_event_time", onePlay.et > 0L ? onePlay.et : onePlay.lt);
            requestBody.put("video_duration", base.vd);
            requestBody.put("end_position", onePlay.curPlayBackTime);
            requestBody.put("duration", onePlay.watchduration);
            requestBody.put("custom_id", BaseAppInfo.mAppID);
        }
        catch (JSONException e) {
            TTVideoEngineLog.e(TAG, "JSONObject put error:%s" + e.toString());
            return;
        }
        this.mNetClient.startTask(requestUrl, null, requestBody, 1, new TTVNetClient.CompletionListener(){

            @Override
            @SuppressLint(value={"DefaultLocale"})
            public void onCompletion(JSONObject jsonBody, Error error) {
                if (ContentDataReporter.this.mCanceled) {
                    TTVideoEngineLog.i(ContentDataReporter.TAG, "canceled, return");
                    return;
                }
                if (jsonBody != null) {
                    int ret = jsonBody.optInt("ret");
                    if (ret != 0) {
                        TTVideoEngineLog.i(ContentDataReporter.TAG, String.format("network error, code:%d, requestUrl:%s", ret, requestUrl));
                    } else {
                        String req_id = jsonBody.optString("req_id");
                        TTVideoEngineLog.i(ContentDataReporter.TAG, String.format("translate vdata to content success, req_id:%s", req_id));
                    }
                } else if (error != null) {
                    TTVideoEngineLog.i(ContentDataReporter.TAG, String.format("network error:%s, requestUrl:%s", error.toString(), requestUrl));
                }
            }
        });
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        this.mInitialUrl = null;
        this.mNetClient.cancel();
    }

    public void setInitialUrl(String url) {
        this.mInitialUrl = url;
    }

    static {
        mInit = false;
        mRetryCnt = 0;
    }
}

