/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.List;

public class HeadsetStateMonitor {
    private static final String TAG = "HeadsetStateMonitor";
    private static final int MASK_WIRED = 1;
    private static final int MASK_WIRELESS = 2;
    private static final int STATE_UNINITIALIZED = 65280;
    private static final int STATE_NOTHING_CONNECTED = 0;
    private final Context mContext;
    private final Handler mHandler;
    private final List<HeadsetStateChangedListener> mChangeListener = new ArrayList<HeadsetStateChangedListener>();
    private HeadsetReceiver mHeadsetReceiver;
    private volatile int mHeadsetState = 65280;
    private volatile boolean mIsStarted;
    private static HeadsetStateMonitor sInstance;

    private HeadsetStateMonitor(Context context) {
        this.mContext = context.getApplicationContext();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void start() {
        if (this.mIsStarted) {
            return;
        }
        this.mIsStarted = true;
        EngineThreadPool.addExecuteTask(() -> {
            this.mHeadsetState = this.getHeadsetState(this.mContext);
        });
        if (this.mHeadsetReceiver == null) {
            this.registerBroadcastReceiver(this.mContext);
        }
    }

    private void registerBroadcastReceiver(Context context) {
        IntentFilter filter = new IntentFilter("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        this.mHeadsetReceiver = new HeadsetReceiver();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetReceiver, filter);
    }

    public void stop() {
        if (!this.mIsStarted) {
            return;
        }
        this.mIsStarted = false;
        this.unregisterBroadcastReceiver(this.mContext);
    }

    private void unregisterBroadcastReceiver(Context context) {
        if (this.mHeadsetReceiver != null) {
            try {
                context.unregisterReceiver((BroadcastReceiver)this.mHeadsetReceiver);
            }
            catch (Exception e) {
                TTVideoEngineLog.w(TAG, e.getMessage());
            }
            this.mHeadsetReceiver = null;
        }
    }

    public boolean isWiredConnected() {
        if (this.mHeadsetState == 65280) {
            this.mHeadsetState = this.getHeadsetState(this.mContext);
        }
        return (this.mHeadsetState & 1) != 0;
    }

    public boolean isWirelessConnected() {
        if (this.mHeadsetState == 65280) {
            this.mHeadsetState = this.getHeadsetState(this.mContext);
        }
        return (this.mHeadsetState & 2) != 0;
    }

    private int getHeadsetState(Context context) {
        try {
            int state = 0;
            AudioManager am = (AudioManager)context.getSystemService("audio");
            if (am == null) {
                TTVideoEngineLog.e(TAG, "AudioManager is null");
                return 65280;
            }
            if (Build.VERSION.SDK_INT < 23 || Build.VERSION.SDK_INT == 25) {
                if (am.isWiredHeadsetOn()) {
                    state |= 1;
                }
                if (am.isBluetoothScoOn() || am.isBluetoothA2dpOn()) {
                    state |= 2;
                }
            } else {
                AudioDeviceInfo[] devices;
                for (AudioDeviceInfo device : devices = am.getDevices(2)) {
                    if (device.getType() == 3 || device.getType() == 4) {
                        state |= 1;
                        TTVideoEngineLog.d(TAG, "wired device: " + device.getProductName());
                    }
                    if (device.getType() != 8 && device.getType() != 7) continue;
                    state |= 2;
                    TTVideoEngineLog.d(TAG, "bluetooth device: " + device.getProductName());
                }
            }
            return state;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 65280;
        }
    }

    private void onConnected(int mask) {
        int state;
        TTVideoEngineLog.d(TAG, "onConnected, " + mask);
        if (this.mHeadsetState == 65280) {
            this.mHeadsetState = this.getHeadsetState(this.mContext);
        }
        if ((state = this.mHeadsetState | mask) == this.mHeadsetState) {
            return;
        }
        this.mHeadsetState = state;
        this.notifyStateChanged(mask == 2);
    }

    private void notifyStateChanged(boolean wireless) {
        if (this.mChangeListener.isEmpty()) {
            return;
        }
        try {
            for (int i = 0; i < this.mChangeListener.size(); ++i) {
                HeadsetStateChangedListener l = this.mChangeListener.get(i);
                if (l == null) continue;
                l.onHeadsetStateChanged(this.isWiredConnected() || this.isWirelessConnected(), wireless);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onDisconnected(int mask) {
        int state;
        TTVideoEngineLog.d(TAG, "onDisconnected");
        if (this.mHeadsetState == 65280) {
            this.mHeadsetState = this.getHeadsetState(this.mContext);
        }
        if ((state = this.mHeadsetState & ~mask) == this.mHeadsetState) {
            return;
        }
        this.mHeadsetState = state;
        this.notifyStateChanged(this.isWirelessConnected());
    }

    public void addStateChangedListener(HeadsetStateChangedListener listener) {
        HeadsetStateMonitor.runOnThread(this.mHandler, () -> this.addListenerInternal(listener));
    }

    private void addListenerInternal(HeadsetStateChangedListener listener) {
        if (listener != null && !this.mChangeListener.contains(listener)) {
            this.mChangeListener.add(listener);
        }
        TTVideoEngineLog.d(TAG, "listener: " + this.mChangeListener.size());
    }

    public void removeStateChangedListener(HeadsetStateChangedListener listener) {
        HeadsetStateMonitor.runOnThread(this.mHandler, () -> this.removeListenerInternal(listener));
    }

    private void removeListenerInternal(HeadsetStateChangedListener listener) {
        if (listener != null) {
            this.mChangeListener.remove(listener);
        }
        TTVideoEngineLog.d(TAG, "listener: " + this.mChangeListener.size());
    }

    private static void runOnThread(Handler handler, Runnable runnable) {
        if (Looper.myLooper() == handler.getLooper()) {
            runnable.run();
        } else {
            handler.post(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HeadsetStateMonitor getInstance(Context context) {
        if (sInstance != null) return sInstance;
        Class<HeadsetStateMonitor> clazz = HeadsetStateMonitor.class;
        synchronized (HeadsetStateMonitor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new HeadsetStateMonitor(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public static interface HeadsetStateChangedListener {
        public void onHeadsetStateChanged(boolean var1, boolean var2);
    }

    private class HeadsetReceiver
    extends BroadcastReceiver {
        private HeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
                return;
            }
            String action = intent.getAction();
            TTVideoEngineLog.d(HeadsetStateMonitor.TAG, "onReceive: " + action);
            switch (intent.getAction()) {
                case "android.intent.action.HEADSET_PLUG": {
                    int state = intent.getIntExtra("state", -1);
                    if (state == 1) {
                        HeadsetStateMonitor.runOnThread(HeadsetStateMonitor.this.mHandler, () -> HeadsetStateMonitor.this.onConnected(1));
                        break;
                    }
                    if (state != 0) break;
                    HeadsetStateMonitor.runOnThread(HeadsetStateMonitor.this.mHandler, () -> HeadsetStateMonitor.this.onDisconnected(1));
                    break;
                }
                case "android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED": {
                    int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                    if (state == 2) {
                        HeadsetStateMonitor.runOnThread(HeadsetStateMonitor.this.mHandler, () -> HeadsetStateMonitor.this.onConnected(2));
                        break;
                    }
                    if (state != 0) break;
                    HeadsetStateMonitor.runOnThread(HeadsetStateMonitor.this.mHandler, () -> HeadsetStateMonitor.this.onDisconnected(2));
                }
            }
        }
    }
}

