/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.playermetrcis;

import com.ss.ttvideoengine.playermetrcis.IMetricsInfo;
import java.util.HashMap;
import java.util.Map;

public class BatteryMetricsInfo
implements IMetricsInfo {
    public int mBatteryUsage = 0;
    public int mLastThermalState = 0;
    public int mLastBatteryLevel = 0;
    public boolean mLowPowerMode = false;
    public int mPowerState = 0;
    public long mStartPowerTime = 0L;
    public long mTotalPowerTime = 0L;
    public long mStartCriticalTime = 0L;
    public long mTotalCriticalTime = 0L;
    public long mStartEmergencyTime = 0L;
    public long mTotalEmergencyTime = 0L;

    public long getCurCriticalTime() {
        if (this.mStartCriticalTime > 0L) {
            long cur = System.currentTimeMillis();
            this.mTotalCriticalTime += cur - this.mStartCriticalTime;
            this.mStartCriticalTime = cur;
        }
        return this.mTotalCriticalTime;
    }

    public long getCurEmergencyTime() {
        if (this.mStartEmergencyTime > 0L) {
            long cur = System.currentTimeMillis();
            this.mTotalEmergencyTime += cur - this.mStartEmergencyTime;
            this.mStartEmergencyTime = cur;
        }
        return this.mTotalEmergencyTime;
    }

    @Override
    public Map<String, Object> getMetricsInfo(String key) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.mStartEmergencyTime > 0L) {
            result.put("cri_t", this.getCurEmergencyTime());
        }
        if (this.mStartCriticalTime > 0L) {
            result.put("ser_t", this.getCurCriticalTime());
        }
        if (this.mStartPowerTime > 0L) {
            result.put("bu_t", this.mTotalPowerTime);
            result.put("bu_l", this.mLastBatteryLevel);
        }
        return result;
    }
}

