/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector.strategy;

import com.bytedance.vcloud.abrmodule.ABRResult;
import com.bytedance.vcloud.abrmodule.ABRResultElement;
import com.ss.ttvideoengine.EngineGlobalConfig;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.selector.SelectedInfo;
import com.ss.ttvideoengine.selector.strategy.GearStrategyContext;
import com.ss.ttvideoengine.selector.strategy.IGearStrategyListener;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GearStrategy {
    private static final String TAG = "TTVideoEngine.GearStrategy";
    public static final int GEAR_STRATEGY_SELECT_TYPE_PRELOAD = 2;
    public static final int GEAR_STRATEGY_SELECT_TYPE_PLAY = 1;
    public static final int GEAR_STRATEGY_ERROR_OK = 0;
    public static final int GEAR_STRATEGY_ERROR_JSON_PARSE_FAIL = -1;
    public static final int GEAR_STRATEGY_ERROR_VIDEO_INFO_EMPTY = -2;
    public static final int GEAR_STRATEGY_ERROR_STRATEGY_CENTER_NOT_RUNNING = -3;
    public static final int GEAR_STRATEGY_ERROR_STRATEGY_RESULT_NULL = -4;
    public static final int GEAR_STRATEGY_DOWNGRADE_NONE = 0;
    public static final int GEAR_STRATEGY_DOWNGRADE_SR = 1;
    public static final int GEAR_STRATEGY_DOWNGRADE_NARROW_SCREEN = 2;
    public static final int GEAR_STRATEGY_REASON_DEFAULT_GEAR = 1;
    public static final int GEAR_STRATEGY_REASON_DEFAULT_BITRATE = 2;
    public static final int GEAR_STRATEGY_REASON_AUTO_BITRATE_SET = 3;
    public static final int GEAR_STRATEGY_REASON_BANDWIDTH_SET = 4;
    public static final int GEAR_STRATEGY_REASON_GEAR_SET = 5;
    public static final int GEAR_STRATEGY_REASON_FALLBACK = 6;
    public static final int GEAR_STRATEGY_REASON_Cache1 = 7;
    public static final int GEAR_STRATEGY_REASON_Cache2 = 8;
    public static final int GEAR_STRATEGY_REASON_USER_SELECTED = 9;
    public static final int GEAR_STRATEGY_REASON_PRELOAD_CACHE = 10;
    public static final int GEAR_STRATEGY_REASON_CONFIG_QUALITY_LOWEST = 11;
    public static final int GEAR_STRATEGY_REASON_BEST_RESOLUTION_MAX_CACHE = 12;
    public static final int GEAR_STRATEGY_REASON_CALLBACK = 13;
    public static final int GEAR_STRATEGY_SELECT_METHOD_NATIVE = 1;
    public static final int GEAR_STRATEGY_SELECT_METHOD_CALLBACK = 2;
    public static final String GEAR_STRATEGY_KEY_EXTRA_CONFIG = "extra_config";
    public static final String GEAR_STRATEGY_KEY_VIDEO_BITRATE = "video_bitrarte";
    public static final String GEAR_STRATEGY_KEY_VIDEO_CALC_BITRATE = "video_calc_bitrarte";
    public static final String GEAR_STRATEGY_KEY_AUDIO_BITRATE = "audio_bitrarte";
    public static final String GEAR_STRATEGY_KEY_AUDIO_CALC_BITRATE = "audio_calc_bitrarte";
    public static final String GEAR_STRATEGY_KEY_SELECT_REASON = "select_reason";
    public static final String GEAR_STRATEGY_KEY_ERROR_CODE = "error_code";
    public static final String GEAR_STRATEGY_KEY_ERROR_DESC = "error_desc";
    public static final String GEAR_STRATEGY_KEY_SPEED = "speed";
    public static final String GEAR_STRATEGY_KEY_SR_GEARS = "sr_gears";
    public static final String GEAR_STRATEGY_KEY_VIDEO_BITRATE_USER_SELECTED = "video_bitrarte_user_selected";
    public static final String GEAR_STRATEGY_KEY_CONFIG_QUALITY = "config_quality";
    public static final String GEAR_STRATEGY_KEY_EXTRA_INFO = "extra_info";
    public static final String GEAR_STRATEGY_KEY_USE_LAST_NETWORK_SPEED = "use_last_network_speed";
    public static final String GEAR_STRATEGY_KEY_VIDEO_BITRATE_ORIGIN = "video_bitrarte_origin";
    public static final String GEAR_STRATEGY_KEY_DOWNGRADE_TYPE = "downgrade_type";
    public static final String GEAR_STRATEGY_KEY_CURVE_ADJUST_MODE = "curve_adjust_mode";
    public static final String GEAR_STRATEGY_KEY_CURVE_ADJUST_FACTOR = "curve_adjust_factor";
    public static final String GEAR_STRATEGY_KEY_INITIAL_SPEED = "initial_speed";
    public static final String GEAR_STRATEGY_VALUE_CONFIG_QUALITY_DEFAULT = "1";
    public static final String GEAR_STRATEGY_VALUE_CONFIG_QUALITY_HIGH = "2";
    public static final String GEAR_STRATEGY_VALUE_CONFIG_QUALITY_LOW = "3";
    public static final String GEAR_STRATEGY_VALUE_CONFIG_QUALITY_LOW_LITE = "4";
    public static final String GEAR_STRATEGY_VALUE_CURVE_ADJUST_MODE_SPEED = "1";
    public static final String GEAR_STRATEGY_VALUE_CURVE_ADJUST_MODE_BITRATE = "2";

    public static SelectedInfo selectBitrate(IVideoModel videoModel, int selectType, Map<String, String> params) {
        TTVideoEngineLog.i(TAG, String.format("[GearStrategy]GearStrategy.selectBitrate selectType=%d", selectType));
        GearStrategyContext strategyContext = new GearStrategyContext(null);
        strategyContext.setVideoModel(videoModel);
        strategyContext.setGearStrategyListener(new IGearStrategyListener(){

            @Override
            public void onBeforeSelect(IVideoModel videoModel, Map<String, String> params, int selectType, Object userData) {
            }

            @Override
            public void onAfterSelect(IVideoModel videoModel, Map<String, String> result, int selectType, Object userData) {
                ((Map)userData).putAll(result);
            }
        });
        strategyContext.setUserData(params);
        Map<String, Integer> result = StrategyHelper.helper().selectResolution(videoModel, selectType, params, strategyContext);
        String errDesc = params.get(GEAR_STRATEGY_KEY_ERROR_DESC);
        if (errDesc != null && !errDesc.isEmpty()) {
            int errCode = 0;
            try {
                errCode = Integer.parseInt(params.get(GEAR_STRATEGY_KEY_ERROR_CODE));
            }
            catch (Exception e) {
                errCode = 0;
            }
            Error error = new Error("kTTVideoSelector", errCode, errDesc);
            return new SelectedInfo(error);
        }
        Error err = null;
        VideoInfo info = null;
        double calcBitrate = 0.0;
        if (result != null) {
            int videoBitrate = 0;
            Integer vBitrate = result.get("video");
            if (vBitrate != null) {
                videoBitrate = vBitrate;
            }
            try {
                calcBitrate = Double.parseDouble(params.get(GEAR_STRATEGY_KEY_VIDEO_CALC_BITRATE));
            }
            catch (Exception e) {
                calcBitrate = 0.0;
            }
            List<VideoInfo> videoInfos = videoModel.getVideoInfoList();
            if (videoBitrate > 0 && videoInfos != null) {
                for (VideoInfo videoInfo : videoInfos) {
                    if (videoInfo == null || videoInfo.getMediatype() == VideoRef.TYPE_AUDIO || videoInfo.getResolution() == null) continue;
                    long resolutionBitRate = 0L;
                    if (1 == EngineGlobalConfig.getInstance().getEnableUseRealBitrate()) {
                        resolutionBitRate = videoInfo.getValueInt(44);
                        if (resolutionBitRate <= 0L) {
                            resolutionBitRate = videoInfo.getValueInt(3);
                        }
                    } else {
                        resolutionBitRate = videoInfo.getValueInt(3);
                    }
                    if (resolutionBitRate != (long)videoBitrate) continue;
                    info = videoInfo;
                    break;
                }
            }
            if (info == null) {
                err = new Error("kTTVideoSelector", -7999, "null video info fit bitrate");
            }
        } else {
            err = new Error("kTTVideoSelector", -7997, "native select result null");
        }
        SelectedInfo selectedInfo = new SelectedInfo(info, err);
        if (calcBitrate > 0.0) {
            selectedInfo.setDoubleValue(0, calcBitrate);
        }
        return selectedInfo;
    }

    public static Map<String, Object> parseABRResult(ABRResult abrResult) {
        HashMap<String, Object> gearResult = new HashMap<String, Object>();
        long audioBitrate = 0L;
        long videoBitrateSelected = 0L;
        long videoBitrateBeforeSR = 0L;
        long videoBitrateFullScreen = 0L;
        if (abrResult != null) {
            for (int i = 0; i < abrResult.size(); ++i) {
                ABRResultElement element = abrResult.get(i);
                long bitrate = element.getBitrate();
                int selectType = element.getOnceSelectType();
                int mediaType = element.getMediaType();
                if (VideoRef.TYPE_VIDEO == mediaType) {
                    if (0 == selectType) {
                        videoBitrateSelected = bitrate;
                        continue;
                    }
                    if (1 == selectType) {
                        videoBitrateBeforeSR = bitrate;
                        continue;
                    }
                    if (2 != selectType) continue;
                    videoBitrateFullScreen = bitrate;
                    continue;
                }
                if (VideoRef.TYPE_AUDIO != mediaType) continue;
                audioBitrate = bitrate;
            }
        }
        gearResult.put(GEAR_STRATEGY_KEY_VIDEO_BITRATE, videoBitrateSelected);
        gearResult.put(GEAR_STRATEGY_KEY_AUDIO_BITRATE, audioBitrate);
        if (videoBitrateBeforeSR > videoBitrateSelected) {
            gearResult.put(GEAR_STRATEGY_KEY_VIDEO_BITRATE_ORIGIN, videoBitrateBeforeSR);
            gearResult.put(GEAR_STRATEGY_KEY_DOWNGRADE_TYPE, 1);
        } else if (videoBitrateFullScreen > videoBitrateSelected) {
            gearResult.put(GEAR_STRATEGY_KEY_VIDEO_BITRATE_ORIGIN, videoBitrateFullScreen);
            gearResult.put(GEAR_STRATEGY_KEY_DOWNGRADE_TYPE, 2);
        } else {
            gearResult.put(GEAR_STRATEGY_KEY_VIDEO_BITRATE_ORIGIN, videoBitrateSelected);
            gearResult.put(GEAR_STRATEGY_KEY_DOWNGRADE_TYPE, 0);
        }
        return gearResult;
    }
}

