/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheFileManager;
import com.bytedance.vcloud.cacheModule.CacheModuleLoader;
import com.bytedance.vcloud.cacheModule.info.MasterPlaylist;
import java.util.LinkedList;
import java.util.List;

public class PlaylistLoaderItem {
    private long nativeHandler = 0L;

    public PlaylistLoaderItem(String url) {
        if (CacheModuleLoader.inited) {
            this.nativeHandler = this._createLoader(url);
        }
    }

    public int preload() {
        if (this.nativeHandler != 0L) {
            return this._preload(this.nativeHandler);
        }
        return 0;
    }

    public void cancel() {
        if (this.nativeHandler != 0L) {
            this._cancel(this.nativeHandler);
        }
    }

    public void release() {
        if (this.nativeHandler != 0L) {
            this._releaseLoader(this.nativeHandler);
        }
        this.nativeHandler = 0L;
    }

    public void writeHlsNodeInfo(CacheFileManager.HlsCacheNodeInfo hlsCacheNodeInfo) {
        if (this.nativeHandler != 0L) {
            this._writeHlsNodeInfo(this.nativeHandler, hlsCacheNodeInfo);
        }
    }

    public void writeTsNodeInfo(CacheFileManager.TsCacheNodeInfo tsCacheNodeInfo) {
        if (this.nativeHandler != 0L) {
            this._writeTsNodeInfo(this.nativeHandler, tsCacheNodeInfo);
        }
    }

    public List<String> getSubUrls() {
        if (this.nativeHandler != 0L) {
            Object urls = this._getSubUrls(this.nativeHandler);
            if (urls == null) {
                return null;
            }
            return (LinkedList)urls;
        }
        return null;
    }

    public PlayListType getType() {
        if (this.nativeHandler != 0L) {
            int type = this._getPlaylistType(this.nativeHandler);
            switch (type) {
                case 0: {
                    return PlayListType.Unknown;
                }
                case 1: {
                    return PlayListType.MasterPlaylist;
                }
                case 2: {
                    return PlayListType.Live;
                }
                case 3: {
                    return PlayListType.Vod;
                }
                case 4: {
                    return PlayListType.Event;
                }
            }
            return PlayListType.Unknown;
        }
        return PlayListType.Unknown;
    }

    public MasterPlaylist getMasterPlaylist() {
        if (this.nativeHandler != 0L) {
            return (MasterPlaylist)this._getMasterPlaylistInfo(this.nativeHandler);
        }
        return null;
    }

    private native long _createLoader(String var1);

    private native int _preload(long var1);

    private native void _cancel(long var1);

    private native void _releaseLoader(long var1);

    private native Object _getSubUrls(long var1);

    private native Object _getMasterPlaylistInfo(long var1);

    private native int _getPlaylistType(long var1);

    private native void _writeHlsNodeInfo(long var1, Object var3);

    private native void _writeTsNodeInfo(long var1, Object var3);

    static {
        CacheModuleLoader.loadLibrary();
    }

    public static enum PlayListType {
        Unknown,
        MasterPlaylist,
        Live,
        Vod,
        Event;

    }
}

