/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import com.bytedance.vcloud.cacheModule.CacheModule;
import com.bytedance.vcloud.cacheModule.CacheSettings;
import com.bytedance.vcloud.cacheModule.PlayTaskKeyManager;
import com.bytedance.vcloud.cacheModule.PlaylistDownloader;
import com.bytedance.vcloud.cacheModule.PlaylistDownloaderManager;
import com.bytedance.vcloud.cacheModule.PlaylistLoader;
import com.bytedance.vcloud.cacheModule.PlaylistLoaderManager;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class DataLoaderHelperAdapter {
    private static final String TAG = "DataLoaderHelperAdapter";
    private PlaylistLoaderManager mPlaylistLoaderManager = null;
    private PlaylistDownloaderManager mPlaylistDownloaderManager = null;

    public void onMDLStartComplete() {
        long urlGeneratorMethod = AVMDLDataLoader.getInstance().getLongValue(7425);
        TTVideoEngineLog.i(TAG, "MediaDataLoader start complete , urlGeneratorMethod = " + urlGeneratorMethod);
        if (urlGeneratorMethod == -1L || urlGeneratorMethod == 0L) {
            return;
        }
        CacheModule.setProxyUrlGenerator(urlGeneratorMethod);
    }

    public void setHLSCacheDir(String cacheDir) {
        TTVideoEngineLog.i(TAG, "set CacheDir:" + cacheDir);
        CacheSettings.getInstance().setStringOption(CacheSettings.OptionKey.CACHE_DIR, cacheDir);
    }

    public void initHLSCacheModule() {
        this.initHlsPreloadManager();
        this.initHlsDownloadManager();
    }

    private void initHlsPreloadManager() {
        this.mPlaylistLoaderManager = PlaylistLoaderManager.getInstance();
        this.mPlaylistLoaderManager.addLoaderListener(new PlaylistLoader.ILoaderListener(){

            @Override
            public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }

            @Override
            public void onCancel(String fileKey, String url) {
            }

            @Override
            public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }

            @Override
            public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                DataLoaderHelper.getDataLoader().onNotify(info);
            }
        });
    }

    public void convertHLSProxyUrl(StringBuffer proxyUrlBuffer) {
        if (this.mPlaylistLoaderManager != null) {
            proxyUrlBuffer.append("hlsproxy://");
        }
    }

    public boolean preloadHLSSource(String url, int size) {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.preloadSource(url, size);
            return true;
        }
        return false;
    }

    public boolean cancelPreload(String key) {
        if (this.mPlaylistLoaderManager != null && this.mPlaylistLoaderManager.isCacheKey(key)) {
            this.mPlaylistLoaderManager.cancel(key);
            return true;
        }
        return false;
    }

    public boolean removeCacheFile(String key) {
        if (this.mPlaylistLoaderManager != null && this.mPlaylistLoaderManager.isCacheKey(key)) {
            this.mPlaylistLoaderManager.removeFileCache(key);
            return true;
        }
        return false;
    }

    public long getAllCacheSize() {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.getAllCacheSize();
        }
        return 0L;
    }

    public long getCacheSize(String key) {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.getCacheSize(key);
        }
        return 0L;
    }

    public void cancelAll() {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.cancelAll();
        }
    }

    public boolean onLoaderFail(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && this.mPlaylistLoaderManager != null) {
            String[] temArray = info.logInfo.split(",");
            String fileKey = temArray[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Error, info);
        }
        return false;
    }

    public boolean onLoaderOpen(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && this.mPlaylistLoaderManager != null) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Start, info);
        }
        if (info.parameter == 1L) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            PlayTaskKeyManager.getInstance().onPlayTaskOpen(fileKey);
        }
        return false;
    }

    public boolean onLoaderCancel(AVMDLDataLoaderNotifyInfo info) {
        if (this.mPlaylistLoaderManager != null) {
            String[] logInfos = info.logInfo.split(",");
            String fileKey = logInfos[0];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(fileKey, PlaylistLoader.LoadStatus.Cancel, info);
        }
        return false;
    }

    public boolean onLoaderEnd(AVMDLDataLoaderNotifyInfo info) {
        if (info.parameter == 2L && info.what == 4 && this.mPlaylistLoaderManager != null) {
            String[] temArray = info.logInfo.split(",");
            String key = temArray[2];
            return this.mPlaylistLoaderManager.onPreloadStatusChanged(key, PlaylistLoader.LoadStatus.Completed, info);
        }
        return false;
    }

    public boolean removeCache(String key) {
        if (this.mPlaylistLoaderManager != null) {
            return this.mPlaylistLoaderManager.removeFileCache(key);
        }
        return false;
    }

    public void removeAllHLSCache() {
        if (this.mPlaylistLoaderManager != null) {
            this.mPlaylistLoaderManager.clearAllPlaylistCache();
        }
    }

    public void setHLSDownloadDir(String downloadDir) {
        TTVideoEngineLog.i(TAG, "set DownloadDir:" + downloadDir);
        CacheSettings.getInstance().setStringOption(CacheSettings.OptionKey.DOWNLOAD_DIR, downloadDir);
    }

    private void initHlsDownloadManager() {
        this.mPlaylistDownloaderManager = PlaylistDownloaderManager.getInstance();
        this.mPlaylistDownloaderManager.addLoaderListener(new PlaylistDownloader.IDownloadListener(){

            @Override
            public void onStart(String url, AVMDLDataLoaderNotifyInfo info) {
                TTVideoEngineLog.d(DataLoaderHelperAdapter.TAG, "download onStart, info: what = " + info.what + ", param = " + info.parameter + ", loginfo = " + info.logInfo);
            }

            @Override
            public void onCancel(String fileKey, String url) {
                TTVideoEngineLog.i(DataLoaderHelperAdapter.TAG, "download onCancel, fileKey = " + fileKey);
            }

            @Override
            public void onCompleted(String url, AVMDLDataLoaderNotifyInfo info) {
                TTVideoEngineLog.d(DataLoaderHelperAdapter.TAG, "download onCompleted, info: what = " + info.what + ", param = " + info.parameter + ", loginfo = " + info.logInfo);
            }

            @Override
            public void onError(String url, AVMDLDataLoaderNotifyInfo info) {
                TTVideoEngineLog.d(DataLoaderHelperAdapter.TAG, "download onError, info: what = " + info.what + ", param = " + info.parameter + ", loginfo = " + info.logInfo);
                DataLoaderHelper.getDataLoader().onNotify(info);
            }

            @Override
            public void onProgress(String url, AVMDLDataLoaderNotifyInfo info) {
                TTVideoEngineLog.d(DataLoaderHelperAdapter.TAG, "download onProgress, info: what = " + info.what + ", param = " + info.parameter + ", loginfo = " + info.logInfo);
                DataLoaderHelper.getDataLoader().onNotify(info);
            }
        });
    }

    public boolean downloadHlsSource(String url) {
        if (this.mPlaylistDownloaderManager != null) {
            this.mPlaylistDownloaderManager.downloadSource(url);
            return true;
        }
        return false;
    }

    public boolean cancelDownload(String key) {
        if (this.mPlaylistDownloaderManager != null && this.mPlaylistDownloaderManager.isHlsDownloadKey(key)) {
            this.mPlaylistDownloaderManager.cancel(key);
            return true;
        }
        return false;
    }

    public boolean removeDownloadFile(String key) {
        if (this.mPlaylistDownloaderManager != null && this.mPlaylistDownloaderManager.isHlsDownloadKey(key)) {
            this.mPlaylistDownloaderManager.removeDownloadFile(key);
            return true;
        }
        return false;
    }

    public boolean onDownloadFail(AVMDLDataLoaderNotifyInfo info) {
        TTVideoEngineLog.d(TAG, "onDownloadFail, logInfo:" + info.logInfo);
        String key = info.logInfo;
        if (this.mPlaylistDownloaderManager == null) {
            return false;
        }
        return this.mPlaylistDownloaderManager.onDownloadStatusChanged(key, PlaylistDownloader.DownloadStatus.Error, info);
    }

    public boolean onDownloadCompleted(AVMDLDataLoaderNotifyInfo info) {
        TTVideoEngineLog.d(TAG, "onDownloadCompleted, logInfo:" + info.logInfo);
        if (this.mPlaylistDownloaderManager == null) {
            return false;
        }
        PlaylistDownloader.DownloadLogInfo downloadLogInfo = PlaylistDownloader.parseDownloadLogInfo(info.logInfo);
        if (downloadLogInfo == null) {
            return false;
        }
        return this.mPlaylistDownloaderManager.onDownloadStatusChanged(downloadLogInfo.key, PlaylistDownloader.DownloadStatus.Completed, info);
    }

    public boolean onDownloadProgress(AVMDLDataLoaderNotifyInfo info) {
        TTVideoEngineLog.d(TAG, "onDownloadProgress, logInfo:" + info.logInfo);
        if (this.mPlaylistDownloaderManager == null) {
            return false;
        }
        PlaylistDownloader.DownloadLogInfo downloadLogInfo = PlaylistDownloader.parseDownloadLogInfo(info.logInfo);
        if (downloadLogInfo == null) {
            return false;
        }
        return this.mPlaylistDownloaderManager.onDownloadStatusChanged(downloadLogInfo.key, PlaylistDownloader.DownloadStatus.Progress, info);
    }
}

