/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.content.Context;
import android.text.TextUtils;
import com.pandora.common.vod.EngineParams;
import com.pandora.ttlicense2.LicenseLogger;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.log.AppLogTOBVer2;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.setting.SettingsHelper;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class EngineAdapter {
    private static final String TAG = "TTVideoEngine";
    private static boolean mInitSyncLicenseIdOnce = false;

    static void initSettings(Context context) {
        String region = AppInfo.mRegion;
        if (TextUtils.equals((CharSequence)region, (CharSequence)"china")) {
            SettingsHelper.helper().setRegionHost(116, EngineParams.getSettingHost());
        } else if (TextUtils.equals((CharSequence)region, (CharSequence)"singapore")) {
            SettingsHelper.helper().setRegionHost(117, EngineParams.getSettingHost());
        } else {
            throw new IllegalArgumentException("Unsupported region! " + region);
        }
        SettingsHelper.helper().setContext(context.getApplicationContext());
        SettingsHelper.helper().addListener((module, what) -> {
            if (TextUtils.equals((CharSequence)"vod", (CharSequence)module)) {
                int timeOut = InfoWrapper.maxRetryTimeOut();
                TTVideoEngineLog.d(TAG, "set maxRetryTimeOut " + timeOut);
                TTHTTPNetwork.setMaxRetryTimeOut(timeOut);
                TTHTTPNetwork.isRetryWhenFail(timeOut > 0 ? 1 : 0);
                StrategyManager.instance().updateSettings();
                InfoWrapper.printSettings();
            }
        });
        SettingsHelper.helper().config().setEnable(1);
        if (!mInitSyncLicenseIdOnce) {
            mInitSyncLicenseIdOnce = true;
            LicenseLogger.init((Context)context);
            LicenseLogger.getInstance().addEventListener(new LicenseLogger.EventListener(){

                public void onLicenseAddSuccess(String licenseId) {
                    SettingsHelper.helper().config();
                }
            });
        }
    }

    static void initDefaultEventUploader() {
        boolean hasAppLogLib = AppLogTOBVer2.isAppLogVer2Exist();
        TTVideoEngineLog.d(TAG, "_setDefaultEventUploader hasAppLogLib = " + hasAppLogLib);
        if (hasAppLogLib) {
            TTVideoEngine.setVideoEventUploader(AppLogTOBVer2.instance());
            DataLoaderHelper.getDataLoader().setUploader(AppLogTOBVer2.instance());
        }
    }
}

