/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.text.TextUtils;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class DubbedInfo {
    public int mMediaType = 0;
    public String mMainUrl = null;
    public String mBackupUrl1 = null;
    public String mBackupUrl2 = null;
    public String mBackupUrl3 = null;
    public String mCheckInfo = null;
    public int mInfoId = -1;
    public int mBitrate = 0;
    public float mLoudness = 0.0f;
    public float mPeak = 0.0f;
    public String mFileKey = null;

    public JSONObject toBashJsonObject() {
        try {
            if (TextUtils.isEmpty((CharSequence)this.mMainUrl)) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("main_url", (Object)this.mMainUrl);
            jsonObject.put("backup_url_1", (Object)(this.mBackupUrl1 == null ? "" : this.mBackupUrl1));
            jsonObject.put("check_info", (Object)this.mCheckInfo);
            jsonObject.put("info_id", this.mInfoId);
            jsonObject.put("bitrate", this.mBitrate);
            jsonObject.put("loudness", (double)this.mLoudness);
            jsonObject.put("peak", (double)this.mPeak);
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JSONObject toStrategyPreloadJsonObject() {
        try {
            if (TextUtils.isEmpty((CharSequence)this.mMainUrl)) {
                return null;
            }
            JSONObject jsonObject = new JSONObject();
            JSONArray urls = new JSONArray();
            urls.put((Object)this.mMainUrl);
            if (this.mBackupUrl1 != null) {
                urls.put((Object)this.mBackupUrl1);
            }
            if (this.mBackupUrl2 != null) {
                urls.put((Object)this.mBackupUrl2);
            }
            if (this.mBackupUrl3 != null) {
                urls.put((Object)this.mBackupUrl3);
            }
            jsonObject.put("urls", (Object)urls);
            jsonObject.put("info_id", this.mInfoId);
            jsonObject.put("bitrate", this.mBitrate);
            jsonObject.put("file_hash", (Object)this.mFileKey);
            jsonObject.put("media_type", (Object)(this.mMediaType == 0 ? "video" : "audio"));
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getUrls() {
        ArrayList<String> urlList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)this.mMainUrl)) {
            urlList.add(this.mMainUrl);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl1)) {
            urlList.add(this.mBackupUrl1);
        } else if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl2)) {
            urlList.add(this.mBackupUrl2);
        } else if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl3)) {
            urlList.add(this.mBackupUrl3);
        }
        if (urlList.size() == 0) {
            return null;
        }
        String[] urls = new String[urlList.size()];
        urlList.toArray(urls);
        return urls;
    }

    public static class Builder {
        private int mMediaType = 0;
        private String mMainUrl = null;
        private String mBackupUrl1 = null;
        private String mBackupUrl2 = null;
        private String mBackupUrl3 = null;
        private String mCheckInfo = null;
        private int mInfoId = -1;
        private int mBitrate = 0;
        private float mLoudness = 0.0f;
        private float mPeak = 0.0f;
        private String mFileKey = null;

        public Builder mediaType(int mediaType) {
            this.mMediaType = mediaType;
            return this;
        }

        public Builder mainUrl(String mainUrl) {
            this.mMainUrl = mainUrl;
            return this;
        }

        public Builder backupUrl1(String backupUrl1) {
            this.mBackupUrl1 = backupUrl1;
            return this;
        }

        public Builder backupUrl2(String backupUrl2) {
            this.mBackupUrl2 = backupUrl2;
            return this;
        }

        public Builder backupUrl3(String backupUrl3) {
            this.mBackupUrl3 = backupUrl3;
            return this;
        }

        public Builder checkInfo(String checkInfo) {
            this.mCheckInfo = checkInfo;
            return this;
        }

        public Builder infoId(int infoId) {
            this.mInfoId = infoId;
            return this;
        }

        public Builder bitrate(int bitrate) {
            this.mBitrate = bitrate;
            return this;
        }

        public Builder loudness(float loudness) {
            this.mLoudness = loudness;
            return this;
        }

        public Builder peak(float peak) {
            this.mPeak = peak;
            return this;
        }

        public Builder fileKey(String fileKey) {
            this.mFileKey = fileKey;
            return this;
        }

        public DubbedInfo build() {
            DubbedInfo dubbedInfo = new DubbedInfo();
            dubbedInfo.mMediaType = this.mMediaType;
            dubbedInfo.mMainUrl = this.mMainUrl;
            dubbedInfo.mBackupUrl1 = this.mBackupUrl1;
            dubbedInfo.mBackupUrl2 = this.mBackupUrl2;
            dubbedInfo.mBackupUrl3 = this.mBackupUrl3;
            dubbedInfo.mCheckInfo = this.mCheckInfo;
            dubbedInfo.mInfoId = this.mInfoId;
            dubbedInfo.mBitrate = this.mBitrate;
            dubbedInfo.mLoudness = this.mLoudness;
            dubbedInfo.mPeak = this.mPeak;
            dubbedInfo.mFileKey = this.mFileKey;
            return dubbedInfo;
        }
    }
}

