/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.playermetrcis;

import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.playermetrcis.BatteryListener;
import com.ss.ttvideoengine.playermetrcis.BatteryMetricsInfo;
import com.ss.ttvideoengine.playermetrcis.DiagnoseInfo;
import com.ss.ttvideoengine.playermetrcis.DiagnoseResult;
import com.ss.ttvideoengine.playermetrcis.ThreadCPU;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlayerMetrics {
    private static final String TAG = "PlayerMetrics";
    private static final int diagnoseInterval = 5;
    private static final int cpuOverload = 100;
    private static final int powerOverload = 1;
    private static final int memoryOverload = 800;
    private static final String[] pcdnNames = new String[]{"KSThread", "XYThread", "vdp:vidtask:m"};
    private static final String[] mdlNames = new String[]{"MediaLoad", "com.video.mdl.network_manager", "com.video.mdl.network_session"};
    private Context mContext = null;
    private int mMetricsInterval = 60;
    private int mMetricsAbility = 0;
    private long mCurDuraiton = 0L;
    private long mLastMetricsTime = 0L;
    private DiagnoseResult powResult = null;
    private BatteryMetricsInfo mBatteryMetricsInfo = null;
    private PowerManager.OnThermalStatusChangedListener mThermalListener = null;
    private BatteryListener batteryListener = null;
    private ArrayList<DiagnoseInfo> mDiagnoseInfos = null;
    private ThreadCPU mThreadCPU = null;
    private static ArrayList<String> mTheadList = null;

    private PlayerMetrics() {
    }

    public static PlayerMetrics getInstance() {
        return InstanceHolder.sInstance;
    }

    public int getAbility() {
        return this.mMetricsAbility;
    }

    public void setMetricsIntervalOption(int interval) {
        this.mMetricsInterval = interval == 0 ? 60 : interval;
    }

    public void setMetricsAbilityOption(int ability) {
        this.mMetricsAbility = ability;
    }

    public void beginCpuRefresh(String tids) {
        if ((this.mMetricsAbility & 1) > 0 && (this.mMetricsAbility & 0x20) > 0) {
            if (this.mThreadCPU == null) {
                return;
            }
            this.mThreadCPU.refreshSingleThreads(tids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMetricsLog() {
        HashMap<String, Object> metricsLog = new HashMap<String, Object>();
        PlayerMetrics playerMetrics = this;
        synchronized (playerMetrics) {
            Map<String, Object> result;
            if (this.powResult != null && this.powResult.avgValue > 0) {
                metricsLog.putAll(this.powResult.getMetricsInfo("pow"));
            }
            if (this.mBatteryMetricsInfo != null) {
                result = this.mBatteryMetricsInfo.getMetricsInfo(null);
                TTVideoEngineLog.d(TAG, "getMetricsLog: " + result);
                if (result != null && result.size() > 0) {
                    metricsLog.putAll(result);
                }
            }
            if (this.mThreadCPU != null && (result = this.mThreadCPU.getPlayerThreads()) != null && result.size() > 0) {
                metricsLog.putAll(result);
            }
        }
        return metricsLog;
    }

    public void startMetric(Context context) {
        if (this.mMetricsAbility == 0) {
            return;
        }
        if (this.mContext == null) {
            this.mContext = context.getApplicationContext();
        }
        this.checkAbility();
        long curTime = System.currentTimeMillis();
        this.mCurDuraiton = this.mLastMetricsTime == 0L ? 0L : (this.mCurDuraiton += (curTime - this.mLastMetricsTime) / 1000L);
        this.mLastMetricsTime = curTime;
        if (this.mMetricsInterval > 0 && this.mCurDuraiton >= (long)this.mMetricsInterval) {
            this.mCurDuraiton = 0L;
            this.collectMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAbility() {
        if ((this.mMetricsAbility & 2) > 0) {
            if (this.mBatteryMetricsInfo == null) {
                this.mBatteryMetricsInfo = new BatteryMetricsInfo();
            }
            if (this.mContext != null && this.batteryListener == null) {
                this.batteryListener = new BatteryListener(this.mContext);
                this.batteryListener.register(new BatteryListener.BatteryStateListener(){

                    @Override
                    public void onStatePowerConnected() {
                        TTVideoEngineLog.i(PlayerMetrics.TAG, "onStatePowerConnected");
                        ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartPowerTime = 0L;
                        ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mPowerState = 0;
                    }

                    @Override
                    public void onStatePowerDisconnected() {
                        TTVideoEngineLog.i(PlayerMetrics.TAG, "onStatePowerDisconnected");
                        ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartPowerTime = System.currentTimeMillis();
                        ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mLastBatteryLevel = DeviceMonitorUtils.getPowerCapacity(PlayerMetrics.this.mContext);
                        ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mPowerState = 1;
                    }
                });
                if (!this.batteryListener.getInitialCharging()) {
                    TTVideoEngineLog.i(TAG, "getInitialCharging");
                    this.mBatteryMetricsInfo.mStartPowerTime = System.currentTimeMillis();
                    this.mBatteryMetricsInfo.mLastBatteryLevel = DeviceMonitorUtils.getPowerCapacity(this.mContext);
                    this.mBatteryMetricsInfo.mPowerState = 0;
                }
            }
        }
        if ((this.mMetricsAbility & 4) > 0) {
            this.startThermal();
        }
        if ((this.mMetricsAbility & 1) > 0) {
            if (mTheadList == null) {
                int i;
                mTheadList = new ArrayList();
                if ((this.mMetricsAbility & 0x40) > 0) {
                    for (i = 0; i < mdlNames.length; ++i) {
                        mTheadList.add(mdlNames[i]);
                    }
                }
                if ((this.mMetricsAbility & 0x80) > 0) {
                    for (i = 0; i < pcdnNames.length; ++i) {
                        mTheadList.add(pcdnNames[i]);
                    }
                }
            }
            if (this.mThreadCPU == null) {
                this.mThreadCPU = new ThreadCPU();
                this.mThreadCPU.initThreadMonitor(mTheadList);
                this.mThreadCPU.refreshStaticThreads();
            }
        }
        PlayerMetrics playerMetrics = this;
        synchronized (playerMetrics) {
            if (this.powResult == null) {
                this.powResult = new DiagnoseResult();
            }
            if (this.mDiagnoseInfos == null) {
                this.mDiagnoseInfos = new ArrayList();
            }
        }
    }

    private void startThermal() {
        if (this.mContext == null) {
            return;
        }
        if (this.mThermalListener != null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                final PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
                if (pm != null) {
                    TTVideoEngineLog.i(TAG, "start thermal");
                    this.mThermalListener = new PowerManager.OnThermalStatusChangedListener(){

                        public void onThermalStatusChanged(int status) {
                            TTVideoEngineLog.i(PlayerMetrics.TAG, "onThermalStatusChanged " + status);
                            if (PlayerMetrics.this.mBatteryMetricsInfo != null) {
                                if (status == 4) {
                                    ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartCriticalTime = System.currentTimeMillis();
                                } else if (((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartCriticalTime > 0L) {
                                    ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mTotalCriticalTime += System.currentTimeMillis() - ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartCriticalTime;
                                    ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartCriticalTime = 0L;
                                } else {
                                    ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartCriticalTime = 0L;
                                }
                            }
                            if (status == 5) {
                                ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartEmergencyTime = System.currentTimeMillis();
                            } else if (((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartEmergencyTime > 0L) {
                                ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mTotalEmergencyTime += System.currentTimeMillis() - ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartEmergencyTime;
                                ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartEmergencyTime = 0L;
                            } else {
                                ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mStartEmergencyTime = 0L;
                            }
                            ((PlayerMetrics)PlayerMetrics.this).mBatteryMetricsInfo.mLastThermalState = status;
                        }
                    };
                    pm.addThermalStatusListener(this.mThermalListener);
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.i(TAG, "thermalError: " + e);
            }
        }
    }

    private void removeThrmal() {
        if (this.mContext == null || this.mThermalListener == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            try {
                PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
                if (pm != null && this.mThermalListener != null) {
                    pm.removeThermalStatusListener(this.mThermalListener);
                    this.mThermalListener = null;
                }
            }
            catch (Exception e) {
                TTVideoEngineLog.i(TAG, "thermalError: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectMetrics() {
        long end;
        long start;
        TTVideoEngineLog.d(TAG, "start collectMetrics");
        DiagnoseInfo diagnoseInfo = new DiagnoseInfo();
        if ((this.mMetricsAbility & 1) > 0 && this.mThreadCPU != null) {
            this.mThreadCPU.refresh();
        }
        if ((this.mMetricsAbility & 2) > 0) {
            start = System.currentTimeMillis();
            int powerRate = DeviceMonitorUtils.getPowerCapacity(this.mContext);
            end = System.currentTimeMillis();
            if (this.mBatteryMetricsInfo != null) {
                this.mBatteryMetricsInfo.mLastBatteryLevel = powerRate;
                if (this.mBatteryMetricsInfo.mStartPowerTime > 0L) {
                    diagnoseInfo.mPowerUsage = this.mBatteryMetricsInfo.mLastBatteryLevel;
                    this.mBatteryMetricsInfo.mTotalPowerTime = diagnoseInfo.mPowerUsageTime = end - this.mBatteryMetricsInfo.mStartPowerTime;
                    this.mBatteryMetricsInfo.mStartPowerTime = end;
                    TTVideoEngineLog.i(TAG, "METRICS_ABILITY_POWER " + this.mBatteryMetricsInfo.mLastBatteryLevel + " costTime: " + (end - start) + " powertime: " + diagnoseInfo.mPowerUsageTime);
                }
            }
        }
        if ((this.mMetricsAbility & 0x10) > 0) {
            start = System.currentTimeMillis();
            int mem = DeviceMonitorUtils.getUsingMemory();
            end = System.currentTimeMillis();
            diagnoseInfo.mMemUsage = mem;
            TTVideoEngineLog.d(TAG, "METRICS_ABILITY_MEMORY " + mem + " costTime: " + (end - start));
        }
        if ((this.mMetricsAbility & 4) > 0 && this.mBatteryMetricsInfo != null) {
            diagnoseInfo.mCiticalTime = this.mBatteryMetricsInfo.getCurCriticalTime();
            diagnoseInfo.mEmergencyTime = this.mBatteryMetricsInfo.getCurEmergencyTime();
        }
        if ((this.mMetricsAbility & 0x100) > 0) {
            PlayerMetrics playerMetrics = this;
            synchronized (playerMetrics) {
                if (this.mDiagnoseInfos != null) {
                    this.mDiagnoseInfos.add(diagnoseInfo);
                }
                this.diagnose();
            }
        }
    }

    private void diagnose() {
        if (this.mDiagnoseInfos != null && !this.mDiagnoseInfos.isEmpty() && this.mDiagnoseInfos.size() > 5) {
            this.diagnoseInternal();
            TTVideoEngineLog.d(TAG, "startDiagnose");
            this.mDiagnoseInfos.remove(0);
        }
    }

    private void diagnoseInternal() {
        if (this.powResult == null || this.mDiagnoseInfos == null) {
            return;
        }
        this.powResult.reset();
        int powDiff = 0;
        int lastPow = 0;
        for (DiagnoseInfo diagnoseInfo : this.mDiagnoseInfos) {
            if (lastPow > 0) {
                powDiff = Math.abs(lastPow - diagnoseInfo.mPowerUsage);
            }
            if (powDiff > this.powResult.maxValue) {
                this.powResult.maxValue = powDiff;
            }
            if (powDiff > 1) {
                ++this.powResult.overCount;
            }
            lastPow = diagnoseInfo.mPowerUsage;
        }
        if (this.mDiagnoseInfos.size() > 1) {
            DiagnoseInfo infoFirst = this.mDiagnoseInfos.get(0);
            DiagnoseInfo infoLast = this.mDiagnoseInfos.get(this.mDiagnoseInfos.size() - 1);
            this.powResult.avgValue = infoFirst.mPowerUsage - infoLast.mPowerUsage;
        }
    }

    private static final class InstanceHolder {
        private static final PlayerMetrics sInstance = new PlayerMetrics();

        private InstanceHolder() {
        }
    }
}

