/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.playermetrcis;

import android.os.Process;
import android.text.TextUtils;
import com.ss.ttvideoengine.playermetrcis.ThreadInfo;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ThreadCPU {
    private static final String PROC_PATH = "/proc/self/stat";
    private static final String TASK_PATH_PREFIX = "/proc/self/task/";
    private static final String TASK_PATH_SUFFIX = "/stat";
    private static final int INDEX_U_TIME = 12;
    private static final int INDEX_S_TIME = 13;
    private static final int kClockTicksMs = 10;
    private static final String TAG = "ThreadCPU";
    private static final String MEDIA_LOAD_TAG = "MediaLoad";
    private final ConcurrentHashMap<String, Object> mCpuMap = new ConcurrentHashMap();
    private CopyOnWriteArrayList<ThreadInfo> mStaticThreads = null;
    private CopyOnWriteArrayList<ThreadInfo> mSingleThreads = null;
    private ThreadInfo total = null;
    private int mMdlCpuOverZero = 0;

    boolean initThreadMonitor(ArrayList<String> threadsArray) {
        if (threadsArray == null) {
            return false;
        }
        this.mStaticThreads = new CopyOnWriteArrayList();
        this.mSingleThreads = new CopyOnWriteArrayList();
        ThreadInfo proc = new ThreadInfo();
        proc.pidName = "proc";
        proc.type = 0;
        this.total = proc;
        ThreadInfo main = new ThreadInfo();
        main.pidName = "self";
        main.pid = Process.myPid() + "";
        main.type = 1;
        this.mStaticThreads.add(main);
        for (int i = 0; i < threadsArray.size(); ++i) {
            this.initProc(threadsArray.get(i), i + 1);
        }
        return true;
    }

    void transStaticThread(String[] stat) {
        for (int i = 1; i < this.mStaticThreads.size() + 1; ++i) {
            if (stat.length != 2 || !stat[1].startsWith(this.mStaticThreads.get((int)i).pidName)) continue;
            if (this.mStaticThreads.get((int)i).type == 2) {
                this.transMulti(stat, i);
                break;
            }
            ThreadInfo info = this.mStaticThreads.get(i);
            info.reset();
            info.pid = stat[0];
            info.currentTime = System.currentTimeMillis();
            break;
        }
    }

    public void refresh() {
        EngineThreadPool.addExecuteTask(() -> {
            ThreadInfo info;
            int i;
            for (i = 0; i < this.mStaticThreads.size(); ++i) {
                info = this.mStaticThreads.get(i);
                if (info.type == 2 && info.pids != null && info.pids.size() > 0) {
                    float mdl_cpu_rate = (float)((double)this.mMdlCpuOverZero / ((double)info.pids.size() * 1.0));
                    this.mCpuMap.put("mdl_cpu_rate", Float.valueOf(mdl_cpu_rate));
                }
                this.refreshInternal(info);
            }
            for (i = 0; i < this.mSingleThreads.size(); ++i) {
                info = this.mSingleThreads.get(i);
                this.refreshInternal(info);
            }
        });
    }

    private void refreshInternal(ThreadInfo info) {
        this.refreshCpu(info);
        if (info != null && info.pidName != null) {
            this.mCpuMap.put(info.pidName, Float.valueOf(info.cpuUsage));
        }
    }

    public ThreadInfo getTotalThreadInfo() {
        return this.total;
    }

    public Map<String, Object> getPlayerThreads() {
        HashMap<String, Object> threads = new HashMap<String, Object>(this.mCpuMap);
        return threads;
    }

    public void refreshStaticThreads() {
        EngineThreadPool.addExecuteTask(() -> {
            try {
                File[] taskFiles;
                File taskParent = new File("/proc/" + Process.myPid() + "/task/");
                if (taskParent.isDirectory() && (taskFiles = taskParent.listFiles()) != null) {
                    for (File taskFile : taskFiles) {
                        String stat = this.readFile(taskFile.getPath() + TASK_PATH_SUFFIX);
                        if (stat.isEmpty()) continue;
                        try {
                            String[] stats = this.parseStat(stat);
                            this.transStaticThread(stats);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    public void refreshSingleThreads(String tids) {
        if (TextUtils.isEmpty((CharSequence)tids)) {
            return;
        }
        String[] array = tids.split("=|;");
        this.mSingleThreads.clear();
        for (int i = 0; i < array.length - 1; i += 2) {
            ThreadInfo info = new ThreadInfo();
            info.type = 1;
            info.pidName = array[i];
            info.pid = array[i + 1];
            this.mSingleThreads.add(info);
        }
    }

    private ThreadInfo refreshCpu(ThreadInfo threadInfo) {
        if (threadInfo == null) {
            return null;
        }
        if (this.total != null) {
            this.getProcInfo(this.total);
        }
        if (threadInfo.type == 1) {
            this.getSingleThreadInfoByID(threadInfo.pid, threadInfo);
        } else if (threadInfo.type == 2) {
            if (threadInfo.pids == null) {
                return threadInfo;
            }
            threadInfo.cpuTime = 0L;
            if (threadInfo.currentTime == 0L) {
                threadInfo.currentTime = System.currentTimeMillis();
            }
            this.getMultiThreadInfoByID(threadInfo.pids, threadInfo);
            if (threadInfo.cpuTimeStart == 0L) {
                threadInfo.cpuTimeStart = threadInfo.cpuTime;
            } else {
                threadInfo.cpuUsage = (float)(threadInfo.cpuTime - threadInfo.cpuTimeStart) / (float)(System.currentTimeMillis() - threadInfo.currentTime);
            }
        }
        return threadInfo;
    }

    protected ThreadInfo getProcInfo(ThreadInfo threadInfo) {
        String stat = this.readFile(PROC_PATH);
        this.getSingleCpuTime(stat, threadInfo);
        return threadInfo;
    }

    protected ThreadInfo getSingleThreadInfoByID(String tid, ThreadInfo threadInfo) {
        if (threadInfo == null) {
            threadInfo = new ThreadInfo();
        }
        if (tid == null) {
            return threadInfo;
        }
        String stat = this.readFile(TASK_PATH_PREFIX + tid + TASK_PATH_SUFFIX);
        this.getSingleCpuTime(stat, threadInfo);
        return threadInfo;
    }

    protected ThreadInfo getMultiThreadInfoByID(HashSet<String> tids, ThreadInfo threadInfo) {
        if (threadInfo == null) {
            threadInfo = new ThreadInfo();
        }
        this.mMdlCpuOverZero = 0;
        Iterator<String> iterator = tids.iterator();
        while (iterator.hasNext()) {
            String tid = iterator.next();
            String stat = this.readFile(TASK_PATH_PREFIX + tid + TASK_PATH_SUFFIX);
            if (stat == null || stat.isEmpty()) {
                iterator.remove();
                continue;
            }
            this.getMultiCpuTime(stat, threadInfo, tid);
        }
        return threadInfo;
    }

    private ThreadInfo getSingleCpuTime(String stat, ThreadInfo threadInfo) {
        if (threadInfo == null) {
            threadInfo = new ThreadInfo();
        }
        long cpuTime = this.parseTime(stat);
        long now = System.currentTimeMillis();
        threadInfo.cpuUsage = threadInfo.currentTime != 0L ? (cpuTime == -1L ? -1.0f : (float)(cpuTime - threadInfo.cpuTime) / (float)(now - threadInfo.currentTime)) : -1.0f;
        threadInfo.cpuTime = cpuTime;
        threadInfo.currentTime = now;
        return threadInfo;
    }

    private ThreadInfo getMultiCpuTime(String stat, ThreadInfo threadInfo, String tid) {
        long cpuTime;
        if (threadInfo == null) {
            threadInfo = new ThreadInfo();
        }
        if ((cpuTime = this.parseTime(stat)) != -1L) {
            if (threadInfo.mMutiThreadUsage != null) {
                long time;
                Object obj;
                if (threadInfo.mMutiThreadUsage.containsKey(tid) && (obj = threadInfo.mMutiThreadUsage.get(tid)) != null && cpuTime - (time = ((Long)obj).longValue()) > 0L) {
                    ++this.mMdlCpuOverZero;
                }
                threadInfo.mMutiThreadUsage.put(tid, cpuTime);
            }
            threadInfo.cpuTime += cpuTime;
        }
        return threadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFile(String path) {
        BufferedInputStream bis = null;
        FileInputStream fis = null;
        try {
            int flag;
            fis = new FileInputStream(path);
            bis = new BufferedInputStream(fis);
            StringBuilder content = new StringBuilder();
            byte[] buffer = new byte[1024];
            while ((flag = bis.read(buffer)) != -1) {
                content.append(new String(buffer, 0, flag));
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String[] parseStat(String stat) {
        String[] res = new String[2];
        String tid = null;
        String tidName = null;
        char[] chars = stat.toCharArray();
        int offset = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ' && tid == null) {
                tid = new String(chars, 0, i);
            }
            if (c == '(') {
                offset = i + 1;
            }
            if (c != ')') continue;
            tidName = new String(chars, offset, i - offset);
            break;
        }
        res[0] = tid;
        res[1] = tidName;
        return res;
    }

    protected long parseTime(String stat) {
        if (stat == null || stat.isEmpty()) {
            return -1L;
        }
        boolean tidNameSet = false;
        String utime = null;
        String stime = null;
        char[] chars = stat.toCharArray();
        int spaceCount = 0;
        int offset = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ' ') {
                if (spaceCount == 12) {
                    utime = new String(chars, offset, i - offset);
                } else if (spaceCount == 13) {
                    stime = new String(chars, offset, i - offset);
                    break;
                }
                if (tidNameSet) {
                    ++spaceCount;
                    offset = i + 1;
                }
            }
            if (c != ')') continue;
            tidNameSet = true;
        }
        if (utime == null || stime == null) {
            return -1L;
        }
        long cpuTime = -1L;
        try {
            cpuTime = 10 * (Integer.parseInt(utime) + Integer.parseInt(stime));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return cpuTime;
    }

    protected void initProc(String name, int index) {
        ThreadInfo event = new ThreadInfo();
        event.pidName = name;
        event.type = name != null && name.equals(MEDIA_LOAD_TAG) ? 2 : 1;
        this.mStaticThreads.add(event);
    }

    protected boolean transMulti(String[] stats, int index) {
        HashSet<String> pids;
        if (this.mStaticThreads.get((int)index).pids == null) {
            this.mStaticThreads.get((int)index).pids = new HashSet();
        }
        if (this.mStaticThreads.get((int)index).mMutiThreadUsage == null) {
            this.mStaticThreads.get((int)index).mMutiThreadUsage = new HashMap();
        }
        if (this.mStaticThreads.get((int)index).pids != null && (pids = this.mStaticThreads.get((int)index).pids) != null && !pids.contains(stats[0])) {
            pids.add(stats[0]);
        }
        return true;
    }
}

