/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source;

import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.strategy.source.StrategySource;

public class VideoModelSource
implements StrategySource {
    private final String vid;
    private final IVideoModel videoModel;
    private final Resolution resolution;

    private VideoModelSource(Builder builder) {
        this.vid = builder.vid;
        this.videoModel = builder.videoModel;
        this.resolution = builder.resolution;
    }

    @Override
    public Source.Type type() {
        return Source.Type.VIDEO_MODEL_SOURCE;
    }

    @Override
    public String vid() {
        return this.vid;
    }

    public IVideoModel videoModel() {
        return this.videoModel;
    }

    public Resolution resolution() {
        return this.resolution;
    }

    @Override
    public int codecStrategy() {
        return 0;
    }

    public String toString() {
        return "VideoModelSource{vid='" + this.vid + '\'' + ", videoModel=" + this.videoModel + ", resolution=" + (Object)((Object)this.resolution) + '}';
    }

    public static class Builder {
        private String vid;
        private IVideoModel videoModel;
        private Resolution resolution;

        public Builder setVid(String vid) {
            this.vid = vid;
            return this;
        }

        public Builder setVideoModel(IVideoModel videoModel) {
            this.videoModel = videoModel;
            return this;
        }

        public Builder setResolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public VideoModelSource build() {
            return new VideoModelSource(this);
        }
    }
}

