/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher;

import android.os.Build;
import android.text.TextUtils;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.net.ChannelSelect;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FetcherApiHelper {
    private static final String TAG = "FetcherApiHelper";
    private final boolean mDashEnable;
    private final boolean mHlsEnable;
    private final boolean mEncryptEnable;
    private final String mCodecType;
    private int mApiVersion;
    private String mAuthorization;
    private HashMap<String, String> mParams;

    public FetcherApiHelper(String authToken, boolean dashEnable, boolean hlsEnable, boolean encryptEnable, String codecType) {
        this(authToken, null, 1, dashEnable, hlsEnable, encryptEnable, codecType);
    }

    public FetcherApiHelper(String authorization, int apiVersion, boolean dashEnable, boolean hlsEnable, boolean encryptEnable, String codecType) {
        this(null, authorization, apiVersion, dashEnable, hlsEnable, encryptEnable, codecType);
    }

    public FetcherApiHelper(String authToken, String codecType) {
        this(authToken, null, 1, false, false, false, codecType);
    }

    public FetcherApiHelper(String authToken, String authorization, int apiVersion, boolean dashEnable, boolean hlsEnable, boolean encryptEnable, String codecType) {
        this.mDashEnable = dashEnable;
        this.mHlsEnable = hlsEnable;
        this.mEncryptEnable = encryptEnable;
        this.mCodecType = codecType;
        this.mAuthorization = authorization;
        this.mApiVersion = apiVersion;
        if (TextUtils.isEmpty((CharSequence)authorization)) {
            this.mAuthorization = this.getAuthorization(authToken);
        }
        TTVideoEngineLog.d(TAG, "new FetcherApiHelper authorization " + this.mAuthorization + "\uff0c apiVersion " + this.mApiVersion + "\uff0c mCodecType " + this.mCodecType);
    }

    public void setParams(Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        this.mParams = new HashMap();
        this.mParams.putAll(params);
    }

    public int getApiVersion() {
        return this.mApiVersion;
    }

    public String getAuthorization() {
        return this.mAuthorization;
    }

    public String getAPIString() {
        if (TextUtils.isEmpty((CharSequence)this.mAuthorization)) {
            TTVideoEngineLog.d(TAG, "getAPIString null");
            return null;
        }
        String url = this.addHostToUrl();
        String result = this.addParam(url, this.mAuthorization);
        TTVideoEngineLog.d(TAG, "getAPIString " + result);
        return result;
    }

    private String addHostToUrl() {
        String host = this.getHost();
        TTVideoEngineLog.d(TAG, "getHost " + host);
        if (TextUtils.isEmpty((CharSequence)host)) {
            return this.mAuthorization;
        }
        if (this.mAuthorization.startsWith("http")) {
            String newUrl = TTHelper.replaceHostInURL(this.mAuthorization, host);
            if (!TextUtils.isEmpty((CharSequence)newUrl)) {
                return newUrl;
            }
            return this.mAuthorization;
        }
        StringBuilder builder = new StringBuilder();
        if (host.startsWith("http")) {
            return builder.append(host).append("?").append(this.mAuthorization).toString();
        }
        return builder.append("https://").append(host).append("?").append(this.mAuthorization).toString();
    }

    private String getHost() {
        Object host;
        JSONArray settingHostArray;
        if (!TextUtils.isEmpty((CharSequence)AppInfo.mOpenApiHostName)) {
            return AppInfo.mOpenApiHostName;
        }
        if (InfoWrapper.getUseHostSelect()) {
            ChannelSelect.getInstance().init(AppInfo.mContext);
            if (this.mApiVersion == 2) {
                ChannelSelect.getInstance().setHostList(2, InfoWrapper.getTopHostArray());
            } else {
                ChannelSelect.getInstance().setHostList(4, InfoWrapper.getTopHostArrayV2());
            }
            String host2 = ChannelSelect.getInstance().selectNext(this.mApiVersion, null);
            if (!TextUtils.isEmpty((CharSequence)host2)) {
                return host2;
            }
        }
        if (this.mApiVersion == 2) {
            Object host3;
            settingHostArray = InfoWrapper.getTopHostArray();
            if (!TTHelper.isEmpty(settingHostArray) && (host3 = settingHostArray.opt(0)) instanceof String) {
                return (String)host3;
            }
            return AppInfo.getDefaultVodTopHost();
        }
        settingHostArray = InfoWrapper.getTopHostArrayV2();
        if (!TTHelper.isEmpty(settingHostArray) && (host = settingHostArray.opt(0)) instanceof String) {
            return (String)host;
        }
        return AppInfo.getDefaultVodTopHostV2();
    }

    private String getAuthorization(String authToken) {
        TTVideoEngineLog.d(TAG, "getAuthorization " + authToken);
        String authStr = TTHelper.base64Decode(authToken);
        if (TextUtils.isEmpty((CharSequence)authStr)) {
            TTVideoEngineLog.d(TAG, "getAuthorization result null");
            return null;
        }
        String result = authStr;
        String tokenVersion = "";
        try {
            JSONObject authJSON = new JSONObject(authStr);
            String token = authJSON.optString("GetPlayInfoToken");
            if (!TextUtils.isEmpty((CharSequence)token)) {
                result = token;
            }
            this.mApiVersion = !TextUtils.isEmpty((CharSequence)(tokenVersion = authJSON.optString("TokenVersion"))) && tokenVersion.equals("V2") ? 4 : 2;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        TTVideoEngineLog.d(TAG, "getAuthorization result:" + result + ", version:" + tokenVersion);
        return result;
    }

    private String addParam(String url, String authorization) {
        HashMap<Object, Object> params = this.mParams != null && !this.mParams.isEmpty() ? this.mParams : new HashMap();
        if (this.mApiVersion == 2) {
            if (this.mHlsEnable) {
                params.put("format_type", "hls");
            }
            if (this.mDashEnable) {
                params.put("format_type", "dash");
            }
            if (TextUtils.equals((CharSequence)this.mCodecType, (CharSequence)"h265") && !authorization.contains("codec_type")) {
                params.put("codec_type", "1");
            }
            if (this.mEncryptEnable) {
                params.put("stream_type", "evideo");
            }
        } else if (this.mApiVersion == 4 && !authorization.contains("Codec")) {
            if (TextUtils.equals((CharSequence)this.mCodecType, (CharSequence)"h265")) {
                params.put("Codec", "h265");
            } else if (TextUtils.equals((CharSequence)this.mCodecType, (CharSequence)"h266")) {
                params.put("Codec", "h266");
            }
        }
        params.put("device_type", Build.MODEL);
        params.put("device_platform", "android");
        params.put("aid", InfoWrapper.getAppID());
        String did = InfoWrapper.getDeviceID();
        if (!TextUtils.isEmpty((CharSequence)did)) {
            params.put("device_id", did);
        }
        if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppVersion)) {
            params.put("version_code", AppInfo.mAppVersion);
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry entry : params.entrySet()) {
            builder.append(String.format("&%s=%s", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }
}

