/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LoggerUtils {
    public static final int PLAYER_BUFFER_STATE_SIZE = 6;
    public static final String KEY_FORMAT_VIDEO_LENGTH = "fvl";
    public static final String KEY_FORMAT_AUDIO_LENGTH = "fal";
    public static final String KEY_DECODER_VIDEO_LENGTH = "dvl";
    public static final String KEY_DECODER_AUDIO_LENGTH = "dal";
    public static final String KEY_BASE_VIDEO_LENGTH = "bvl";
    public static final String KEY_BASE_AUDIO_LENGTH = "bal";
    public static final String KEY_FORMAT_VIDEO_ONLY_LENGTH = "fvlim";
    public static final String KEY_FORMAT_AUDIO_ONLY_LENGTH = "falim";
    private static final int[] caesar_key = new int[]{1, 5, -1, 6, -3};

    static void putToMap(Map map, String key, String value) {
        if (map == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)value)) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, int value) {
        if (map == null) {
            return;
        }
        if (value != Integer.MIN_VALUE) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, long value) {
        if (map == null) {
            return;
        }
        if (value != Integer.MIN_VALUE) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, Map value) {
        if (map == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, ArrayList value) {
        if (map == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            map.put(key, value);
        }
    }

    static void putToMap(Map map, String key, float value) {
        if (map == null) {
            return;
        }
        if (value != Float.MIN_VALUE && value != Float.NaN) {
            map.put(key, Float.valueOf(value));
        }
    }

    static Map<String, Long> parsePlayerBufferString(String text) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (TextUtils.isEmpty((CharSequence)text)) {
            return result;
        }
        String[] strArray = text.split(";|:");
        if (strArray == null || strArray.length == 0) {
            return result;
        }
        for (int i = 0; i < strArray.length - 1; i += 2) {
            try {
                result.put(strArray[i], Long.parseLong(strArray[i + 1]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static long encryptIntergerV1(long i) {
        if (i == Integer.MIN_VALUE) {
            return i;
        }
        return i >>> 4 | i << 60;
    }

    public static String encryptStringV1(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return s;
        }
        String cipher = "";
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            int k = caesar_key[i % 5];
            if (c >= 'a' && c <= 'z') {
                if ((c = (char)(c + k)) < 'a') {
                    c = (char)(c + 26);
                }
                if (c > 'z') {
                    c = (char)(c - 26);
                }
            } else if (c >= 'A' && c <= 'Z') {
                if ((c = (char)(c + k)) < 'A') {
                    c = (char)(c + 26);
                }
                if (c > 'Z') {
                    c = (char)(c - 26);
                }
            } else if (c >= '0' && c <= '9') {
                if ((c = (char)(c + k)) < '0') {
                    c = (char)(c + 10);
                }
                if (c > '9') {
                    c = (char)(c - 10);
                }
            }
            cipher = cipher + c;
        }
        return cipher;
    }

    public static float encryptFloatV1(float f) {
        if (f == Float.MIN_VALUE || f == Float.NaN) {
            return f;
        }
        return -f;
    }
}

