/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import com.ss.ttvideoengine.log.IVideoEventUploader;
import com.ss.ttvideoengine.log.VideoEventEngineUploader;
import com.ss.ttvideoengine.log.VideoEventListener;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ConcurrentModificationException;
import org.json.JSONArray;
import org.json.JSONObject;

public enum VideoEventManager {
    instance;

    public static final int LOGGER_VERSION_OLD = 1;
    public static final int LOGGER_VERSION_NEW = 2;
    private static final String TAG = "VideoEventManager";
    private static final int MAX_LOG_LINE_LENGTH = 3900;
    private VideoEventListener mListener = null;
    private JSONArray mJsonArray = new JSONArray();
    private JSONArray mJsonArrayV2 = new JSONArray();
    private IVideoEventUploader mUploader;
    private VideoEventEngineUploader mEngineUploader;
    private Context mContext;
    private int mLoggerVersion = 2;

    public void setUploader(IVideoEventUploader uploader) {
        this.mUploader = uploader;
    }

    public synchronized void setEngineUploader(VideoEventEngineUploader uploader) {
        this.mEngineUploader = uploader;
    }

    public void setListener(VideoEventListener listener) {
        this.mListener = listener;
    }

    public void setLoggerVersion(int version) {
        TTVideoEngineLog.e(TAG, "setLoggerVersion: " + version);
        if (version == 1 || version == 2) {
            this.mLoggerVersion = version;
        }
    }

    public void setContext(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public int getLoggerVersion() {
        TTVideoEngineLog.e(TAG, "getLoggerVersion: " + this.mLoggerVersion);
        return this.mLoggerVersion;
    }

    public synchronized JSONArray popAllEvents() {
        JSONArray ret = this.mJsonArray;
        this.mJsonArray = new JSONArray();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(boolean isUpload, JSONObject jsonObject) {
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            if (jsonObject == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            TTVideoEngineLog.d(TAG, "addEvent  uploadLog = " + isUpload);
            if (this.mEngineUploader != null) {
                this.mEngineUploader.onEvent("video_playq", jsonObject);
            } else if (this.mUploader != null && isUpload) {
                this.mUploader.onUplaod("video_playq", jsonObject);
            } else {
                this.mJsonArray.put((Object)jsonObject);
                if (this.mListener != null) {
                    this.mListener.onEvent();
                }
            }
            EngineThreadPool.addExecuteTask(() -> VideoEventManager.showEvent(jsonObject));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray popAllEventsV2() {
        JSONArray ret = this.mJsonArrayV2;
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            this.mJsonArrayV2 = new JSONArray();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventV2(boolean isUpload, JSONObject jsonObject, String monitor_name) {
        Class<VideoEventManager> clazz = VideoEventManager.class;
        synchronized (VideoEventManager.class) {
            if (jsonObject == null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            TTVideoEngineLog.d(TAG, "addEventV2  uploadLog = " + isUpload + ", listener:" + this.mListener + ", uploader:" + this.mUploader);
            if (this.mEngineUploader != null) {
                this.mEngineUploader.onEventV2(monitor_name, jsonObject);
            } else if (this.mUploader != null && isUpload) {
                this.mUploader.onUplaod(monitor_name, jsonObject);
                EngineThreadPool.addExecuteTask(() -> VideoEventManager.showEvent(jsonObject));
            } else {
                this.mJsonArrayV2.put((Object)jsonObject);
                if (this.mListener != null) {
                    this.mListener.onEventV2(monitor_name);
                }
            }
            EngineThreadPool.addExecuteTask(() -> VideoEventManager.showEvent(jsonObject));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    static void showEvent(JSONObject eventJSON) {
        if ((TTVideoEngineLog.getLogNotifyLevel() >> 1 & 1) == 1 || (TTVideoEngineLog.getLogTurnOn() >> 1 & 1) == 1) {
            try {
                VideoEventManager.showLongLog(eventJSON.toString());
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    private static void showLongLog(String str) {
        if (str == null || str.length() <= 3900) {
            TTVideoEngineLog.d(TAG, str);
            return;
        }
        int length = str.length();
        int start = 0;
        int end = 3900;
        String part = null;
        while (end < length) {
            part = str.substring(start, end);
            TTVideoEngineLog.d(TAG, part);
            start += 3900;
            end += 3900;
            end = Math.min(end, length);
        }
        part = str.substring(start, end);
        TTVideoEngineLog.d(TAG, part);
    }
}

