/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class VideoEventOneOutSync {
    private static final String TAG = "VideoEventOneOutSync";
    public static final String EVENT_TYPE_OUTSYNC = "av_outsync";
    public static final String monitorName = "videoplayer_oneevent";
    public static final String END_TYPE_SEEK = "seek";
    public static final String END_TYPE_SWITCH = "switch";
    public static final String END_TYPE_EXIT = "exit";
    public static final String END_TYPE_WAIT = "wait";
    public static final String END_TYPE_ERROR = "error";
    public static final String END_TYPE_FINISH = "finish";
    public static final int VIDEO_OUTSYNC_KEY_PAUSE_TIME = 1;
    public VideoEventBase mEventBase;
    public EventContext mContext = null;
    public ArrayList<String> mList = new ArrayList();
    public int mAVOutSyncCount = 0;
    public int mIndex = 0;
    public long mFirstFrameTime = Integer.MIN_VALUE;
    public long mLastEventTime = Integer.MIN_VALUE;
    public long mVideoStreamDuration = Integer.MIN_VALUE;
    public long mAudioStreamDuration = Integer.MIN_VALUE;
    public int mIsAVBadInterlaced = 0;

    public VideoEventOneOutSync(VideoEventBase eventBase) {
        this.mEventBase = eventBase;
        this.mContext = new EventContext();
    }

    public void reset() {
        this.mList = new ArrayList();
        this.mAVOutSyncCount = 0;
        this.mIndex = 0;
        this.mFirstFrameTime = Integer.MIN_VALUE;
        this.mLastEventTime = Integer.MIN_VALUE;
        this.mIsAVBadInterlaced = 0;
    }

    public void showedFirstFrame() {
        this.mFirstFrameTime = System.currentTimeMillis();
    }

    public void onAVBadInterlaced() {
        this.mIsAVBadInterlaced = 1;
    }

    public void AVOutSyncStart(int clock, long lastRebufTime, long lastSeekTime, long lastHeadsetSwitchTime) {
        long curTime = System.currentTimeMillis();
        this.mContext.mStartT = curTime;
        this.mContext.mBeginPos = clock;
        if (lastRebufTime == 0L) {
            this.mContext.mLastRebufT = this.mContext.mStartT;
        } else {
            this.mContext.mLastRebufT = lastRebufTime;
        }
        if (lastSeekTime == 0L) {
            this.mContext.mLastSeekT = this.mContext.mStartT;
        } else {
            this.mContext.mLastSeekT = lastSeekTime;
        }
        if (lastHeadsetSwitchTime > 0L) {
            this.mContext.mLastHeadsetSwitchInterval = curTime - lastHeadsetSwitchTime;
        }
        if (this.mEventBase != null) {
            Object is_abr;
            this.mContext.mResolutionBefore = this.mEventBase.mCurrentResolution;
            this.mContext.mBitrateBefore = this.mEventBase.mCurrentConfigBitrate;
            this.mContext.mQualityDescBefore = this.mEventBase.mCurrentQualityDesc;
            if (this.mEventBase.abrInfo != null && (is_abr = this.mEventBase.abrInfo.get("abr_used")) != null) {
                this.mContext.mIsABR = (Integer)is_abr;
            }
            if (this.mEventBase.mDataSource != null) {
                HashMap<String, Object> batteryInfo;
                Map<String, Long> bufStates = LoggerUtils.parsePlayerBufferString(this.mEventBase.mDataSource.getLogValueStr(55));
                if (bufStates.get("fvl") != null) {
                    this.mContext.mVideoFormaterLenMS = bufStates.get("fvl");
                }
                if (bufStates.get("fal") != null) {
                    this.mContext.mAudioFormaterLenMs = bufStates.get("fal");
                }
                if (bufStates.get("dvl") != null) {
                    this.mContext.mVideoDecoderLenMs = bufStates.get("dvl");
                }
                if (bufStates.get("dal") != null) {
                    this.mContext.mAudioDecoderLenMs = bufStates.get("dal");
                }
                if (bufStates.get("bvl") != null) {
                    this.mContext.mVideoBaseLenMs = bufStates.get("bvl");
                }
                if (bufStates.get("bal") != null) {
                    this.mContext.mAudioBaseLenMs = bufStates.get("bal");
                }
                this.mContext.mIsRadioMode = this.mEventBase.mDataSource.getLogValueInt(88);
                this.mContext.mHeadset = this.mEventBase.mDataSource.getLogValueInt(89);
                this.mContext.mBt = this.mEventBase.mDataSource.getLogValueInt(90);
                this.mContext.mIsBackground = this.mEventBase.mDataSource.getLogValueInt(94);
                long t = this.mEventBase.mDataSource.getLogValueLong(91);
                if (t > 0L) {
                    this.mContext.mLastAVSwitchInterval = curTime - t;
                }
                if ((t = this.mEventBase.mDataSource.getLogValueLong(92)) > 0L) {
                    this.mContext.mLastResSwitchInterval = curTime - t;
                }
                if ((t = this.mEventBase.mDataSource.getLogValueLong(95)) > 0L) {
                    this.mContext.mLastForebackSwitchInterval = curTime - t;
                }
                if ((batteryInfo = this.mEventBase.getChargingState()) != null) {
                    this.mContext.mPower = (Integer)batteryInfo.get("power");
                    this.mContext.mIsCharging = (Integer)batteryInfo.get("isCharging");
                }
            }
            if (this.mEventBase.mEnablePowerReport) {
                double cpuRate = this.mEventBase.getCPURate();
                double cpuSpeed = this.mEventBase.getCPUSpeed();
                if (cpuRate > 0.0 && cpuSpeed > 0.0) {
                    this.mContext.mCpuRate = cpuRate;
                    this.mContext.mCpuSpeed = cpuSpeed;
                } else {
                    EngineThreadPool.addExecuteTask(new StatisticDataRunnable(this.mContext, this.mEventBase));
                }
                int isPowerSaveMod = DeviceMonitorUtils.isPowerSaveMode(this.mEventBase.mContext);
                if (isPowerSaveMod >= 0) {
                    this.mContext.mPowerSaveMode = isPowerSaveMod;
                }
                this.mContext.mCurrent = this.mEventBase.getBatteryCurrent();
            }
        }
        this._triggerOutSyncStartCb();
    }

    public void AVOutSyncEnd(int clock, String end_type) {
        if (this.mContext.mStartT <= 0L) {
            TTVideoEngineLog.w(TAG, "Invalid start time, return." + this.mContext.mStartT);
            return;
        }
        long curT = System.currentTimeMillis();
        long costT = curT - this.mContext.mStartT;
        if (costT <= 200L) {
            this._triggerOutSyncEndCb();
            this.mContext = new EventContext();
            return;
        }
        this.mContext.mEndType = end_type;
        this.mContext.mEndPos = clock;
        this.mContext.mEndT = curT;
        this.mContext.mCostTime = costT;
        ++this.mIndex;
        ++this.mAVOutSyncCount;
        if (this.mEventBase != null) {
            this.mContext.mResolultionAfter = this.mEventBase.mCurrentResolution;
            this.mContext.mBitrateAfter = this.mEventBase.mCurrentConfigBitrate;
            this.mContext.mQualityDescAfter = this.mEventBase.mCurrentQualityDesc;
            if (this.mEventBase.mDataSource != null) {
                this.mContext.mDropCount = this.mEventBase.mDataSource.getLogValueInt(79);
                this.mContext.mPtsList = this.mEventBase.mDataSource.getLogValueStr(78);
                this.mContext.mVideoDecFpsList = this.mEventBase.mDataSource.getLogValueStr(80);
                this.mContext.mMaxAVDiff = this.mEventBase.mDataSource.getLogValueLong(96);
            }
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("ps", this.mContext.mBeginPos);
        map.put("pe", this.mContext.mEndPos);
        map.put("st", this.mContext.mStartT);
        map.put("c", this.mContext.mCostTime);
        this.mList.add(new JSONObject(map).toString());
        this.mEventBase.degradeModeChangeSession();
        this.sendOutSyncEvent();
        this._triggerOutSyncEndCb();
        this.mContext = new EventContext();
    }

    public void setLongValue(int key, long value) {
        switch (key) {
            case 1: {
                this.mContext.mPauseTimeList.add(value);
                break;
            }
        }
    }

    private void _triggerOutSyncStartCb() {
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            HashMap infos = new HashMap();
            this.mEventBase.mDataSource.onInfo(3, infos);
        }
    }

    private void _triggerOutSyncEndCb() {
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            HashMap<String, Number> infos = new HashMap<String, Number>();
            infos.put("begin_pos", this.mContext.mBeginPos);
            infos.put("end_pos", this.mContext.mEndPos);
            infos.put("render_drop_cnt", this.mContext.mDropCount);
            infos.put("container_fps", Float.valueOf(this.mEventBase.mDataSource.getLogValueFloat(82)));
            infos.put("video_out_fps", Float.valueOf(this.mEventBase.mDataSource.getLogValueFloat(83)));
            infos.put("clock_diff", this.mEventBase.mDataSource.getLogValueLong(45));
            int decodeFps = this.mEventBase.mDataSource.getLogValueInt(84);
            long decodeTime = 0L;
            if (decodeFps > 0) {
                decodeTime = 1000 / decodeFps;
            }
            infos.put("decode_time", decodeTime);
            this.mEventBase.mDataSource.onInfo(4, infos);
        }
    }

    public void sendOutSyncEvent() {
        TTVideoEngineLog.i(TAG, "report oussync event");
        this.mEventBase.updateVideoInfo(null);
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase, this.mContext));
    }

    public JSONObject toJsonObject(EventContext context, VideoEventBase eventBase) {
        HashMap map = new HashMap();
        if (eventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", this.mEventBase.mSessionID);
            if (eventBase.mCurURL == null || eventBase.mCurURL.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mInitialURL);
            } else {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mCurURL);
            }
            if (eventBase.mCurIP == null || eventBase.mCurIP.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mInitialIP);
            } else {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mCurIP);
            }
            LoggerUtils.putToMap(map, "source_type", eventBase.mSourceTypeStr);
            LoggerUtils.putToMap(map, "v", eventBase.mVid);
            LoggerUtils.putToMap(map, "pv", eventBase.pv);
            LoggerUtils.putToMap(map, "pc", eventBase.pc);
            LoggerUtils.putToMap(map, "sv", eventBase.sv);
            LoggerUtils.putToMap(map, "sdk_version", eventBase.sdk_version);
            LoggerUtils.putToMap(map, "vtype", eventBase.vtype);
            LoggerUtils.putToMap(map, "tag", eventBase.mTag);
            LoggerUtils.putToMap(map, "subtag", eventBase.mSubTag);
            LoggerUtils.putToMap(map, "p2p_cdn_type", eventBase.mP2PCDNType);
            LoggerUtils.putToMap(map, "codec", eventBase.codec_type);
            LoggerUtils.putToMap(map, "video_codec_nameid", eventBase.videoCodecNameId);
            LoggerUtils.putToMap(map, "audio_codec_nameid", eventBase.audioCodecNameId);
            LoggerUtils.putToMap(map, "format_type", eventBase.formatType);
            LoggerUtils.putToMap(map, "drm_type", eventBase.mDrmType);
            LoggerUtils.putToMap(map, "play_speed", eventBase.mPlaySpeed);
            LoggerUtils.putToMap(map, "net_type", eventBase.mNetworkType);
            LoggerUtils.putToMap(map, "mdl_version", eventBase.mMdlVersion);
            LoggerUtils.putToMap(map, "enable_mdl", eventBase.mEnableMDL);
            LoggerUtils.putToMap(map, "video_hw", eventBase.mVideoHW);
            LoggerUtils.putToMap(map, "user_hw", eventBase.mVideoHWUser);
        }
        LoggerUtils.putToMap(map, "event_type", EVENT_TYPE_OUTSYNC);
        LoggerUtils.putToMap(map, "st", context.mStartT);
        LoggerUtils.putToMap(map, "et", context.mEndT);
        LoggerUtils.putToMap(map, "cost_time", context.mCostTime);
        LoggerUtils.putToMap(map, "end_type", context.mEndType);
        LoggerUtils.putToMap(map, "audio_len_before", context.mAudioFormaterLenMs);
        LoggerUtils.putToMap(map, "video_len_before", context.mVideoFormaterLenMS);
        LoggerUtils.putToMap(map, "alen_dec_before", context.mAudioDecoderLenMs);
        LoggerUtils.putToMap(map, "vlen_dec_before", context.mVideoDecoderLenMs);
        LoggerUtils.putToMap(map, "alen_base_before", context.mAudioBaseLenMs);
        LoggerUtils.putToMap(map, "vlen_base_before", context.mVideoBaseLenMs);
        LoggerUtils.putToMap(map, "resolution_before", context.mResolutionBefore);
        LoggerUtils.putToMap(map, "resolution_after", context.mResolultionAfter);
        LoggerUtils.putToMap(map, "bitrate_before", context.mBitrateBefore);
        LoggerUtils.putToMap(map, "bitrate_after", context.mBitrateAfter);
        LoggerUtils.putToMap(map, "index", this.mIndex);
        LoggerUtils.putToMap(map, "radio_mode", context.mIsRadioMode);
        LoggerUtils.putToMap(map, "last_av_switch_interval", context.mLastAVSwitchInterval);
        LoggerUtils.putToMap(map, "last_res_switch_interval", context.mLastResSwitchInterval);
        LoggerUtils.putToMap(map, "headset", context.mHeadset);
        LoggerUtils.putToMap(map, "bt", context.mBt);
        LoggerUtils.putToMap(map, "last_headset_switch_interval", context.mLastHeadsetSwitchInterval);
        LoggerUtils.putToMap(map, "power", context.mPower);
        LoggerUtils.putToMap(map, "is_charging", context.mIsCharging);
        LoggerUtils.putToMap(map, "max_av_diff", context.mMaxAVDiff);
        LoggerUtils.putToMap(map, "is_background", context.mIsBackground);
        LoggerUtils.putToMap(map, "last_foreback_switch_interval", context.mLastForebackSwitchInterval);
        long first_frame_interval = -1L;
        if (this.mFirstFrameTime > 0L) {
            first_frame_interval = context.mStartT - this.mFirstFrameTime;
        }
        LoggerUtils.putToMap(map, "first_frame_interval", first_frame_interval);
        long event_interval = -1L;
        if (this.mLastEventTime > 0L) {
            event_interval = context.mStartT - this.mLastEventTime;
        }
        LoggerUtils.putToMap(map, "last_event_interval", event_interval);
        LoggerUtils.putToMap(map, "pts_list", context.mPtsList);
        LoggerUtils.putToMap(map, "begin_pos", context.mBeginPos);
        LoggerUtils.putToMap(map, "end_pos", context.mEndPos);
        LoggerUtils.putToMap(map, "drop_cnt", context.mDropCount);
        LoggerUtils.putToMap(map, "v_dec_fps_list", context.mVideoDecFpsList);
        if (context.mLastRebufT > 0L) {
            LoggerUtils.putToMap(map, "last_rebuf_interval", context.mStartT - context.mLastRebufT);
        }
        if (context.mLastSeekT > 0L) {
            LoggerUtils.putToMap(map, "last_seek_interval", context.mStartT - context.mLastSeekT);
        }
        LoggerUtils.putToMap(map, "is_abr", context.mIsABR);
        LoggerUtils.putToMap(map, "quality_desc_before", context.mQualityDescBefore);
        LoggerUtils.putToMap(map, "quality_desc_after", context.mQualityDescAfter);
        LoggerUtils.putToMap(map, "pause_time_list", context.mPauseTimeList);
        LoggerUtils.putToMap(map, "bad_interlaced", this.mIsAVBadInterlaced);
        LoggerUtils.putToMap(map, "v_duration", this.mVideoStreamDuration);
        LoggerUtils.putToMap(map, "a_duration", this.mAudioStreamDuration);
        LoggerUtils.putToMap(map, "cpu_rate", (float)context.mCpuRate);
        LoggerUtils.putToMap(map, "cpu_speed", (float)context.mCpuSpeed);
        LoggerUtils.putToMap(map, "power_save_mode", context.mPowerSaveMode);
        LoggerUtils.putToMap(map, "battery_current", context.mCurrent);
        return new JSONObject(map);
    }

    private static class StatisticDataRunnable
    implements Runnable {
        private final WeakReference<EventContext> rEvent;
        private final WeakReference<VideoEventBase> rEventBase;

        public StatisticDataRunnable(EventContext event, VideoEventBase eventBase) {
            this.rEvent = new WeakReference<EventContext>(event);
            this.rEventBase = new WeakReference<VideoEventBase>(eventBase);
        }

        @Override
        public void run() {
            DeviceMonitorUtils.CPUInfo cpuInfo;
            EventContext event = (EventContext)this.rEvent.get();
            VideoEventBase eventBase = (VideoEventBase)this.rEventBase.get();
            if (event != null && eventBase != null && (cpuInfo = eventBase.getCurrentCPUInfo()) != null) {
                event.mCpuRate = cpuInfo.cpuAppRate > 0.0 ? cpuInfo.cpuAppRate : (double)1.4E-45f;
                event.mCpuSpeed = cpuInfo.cpuAppSpeed > 0.0 ? cpuInfo.cpuAppSpeed : (double)1.4E-45f;
            }
        }
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventOneOutSync rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;
        private EventContext rEventContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventOneOutSync event, VideoEventBase base, EventContext eventContext) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rEventContext = eventContext;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            final boolean isUpload = this.rEventBase != null && this.rEventBase.isUploadLogEnabled;
            final JSONObject jsonEvent = this.rEvent.toJsonObject(this.rEventContext, this.rEventBase);
            if (this.rHandler == null || this.rHandler.getLooper() == null) {
                VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneOutSync.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneOutSync.monitorName);
                }
            });
            this.rEvent.mLastEventTime = this.rEventContext.mEndT;
        }
    }

    private class EventContext {
        private long mStartT = Integer.MIN_VALUE;
        private long mEndT = Integer.MIN_VALUE;
        private String mPtsList = null;
        private int mDropCount = Integer.MIN_VALUE;
        private long mAudioFormaterLenMs = Integer.MIN_VALUE;
        private long mVideoFormaterLenMS = Integer.MIN_VALUE;
        private long mAudioDecoderLenMs = Integer.MIN_VALUE;
        private long mVideoDecoderLenMs = Integer.MIN_VALUE;
        private long mAudioBaseLenMs = Integer.MIN_VALUE;
        private long mVideoBaseLenMs = Integer.MIN_VALUE;
        private String mResolutionBefore = null;
        private String mResolultionAfter = null;
        private int mBitrateBefore = Integer.MIN_VALUE;
        private int mBitrateAfter = Integer.MIN_VALUE;
        private String mVideoDecFpsList = null;
        private long mLastRebufT = Integer.MIN_VALUE;
        private long mLastSeekT = Integer.MIN_VALUE;
        private int mBeginPos = Integer.MIN_VALUE;
        private int mEndPos = Integer.MIN_VALUE;
        private long mCostTime = Integer.MIN_VALUE;
        private String mEndType = null;
        public int mIsABR = Integer.MIN_VALUE;
        private String mQualityDescBefore = "";
        private String mQualityDescAfter = "";
        public int mIsRadioMode = Integer.MIN_VALUE;
        public long mLastAVSwitchInterval = Integer.MIN_VALUE;
        public long mLastResSwitchInterval = Integer.MIN_VALUE;
        public int mHeadset = Integer.MIN_VALUE;
        public int mBt = Integer.MIN_VALUE;
        public long mLastHeadsetSwitchInterval = Integer.MIN_VALUE;
        public int mPower = Integer.MIN_VALUE;
        public int mIsCharging = Integer.MIN_VALUE;
        public long mMaxAVDiff = Integer.MIN_VALUE;
        public int mIsBackground = Integer.MIN_VALUE;
        public long mLastForebackSwitchInterval = Integer.MIN_VALUE;
        private ArrayList<Long> mPauseTimeList = new ArrayList();
        public double mCpuRate = 1.4E-45f;
        public double mCpuSpeed = 1.4E-45f;
        public int mPowerSaveMode = Integer.MIN_VALUE;
        public float mCurrent = Float.MIN_VALUE;

        private EventContext() {
        }
    }
}

