/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.EngineGlobalConfig;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.MediaBitrateFitterInfo;
import com.ss.ttvideoengine.model.VideoModelPb;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.utils.TTHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoInfo
implements IVideoInfo {
    public static final int VALUE_VIDEO_INFO_MAIN_URL = 0;
    public static final int VALUE_VIDEO_INFO_VWIDTH = 1;
    public static final int VALUE_VIDEO_INFO_VHEIGHT = 2;
    public static final int VALUE_VIDEO_INFO_BITRATE = 3;
    public static final int VALUE_VIDEO_INFO_ENCRYPT = 4;
    public static final int VALUE_VIDEO_INFO_PLAY_AUTH = 5;
    public static final int VALUE_VIDEO_INFO_FORMAT_TYPE = 6;
    public static final int VALUE_VIDEO_INFO_DEFINITION = 7;
    public static final int VALUE_VIDEO_INFO_CODEC_TYPE = 8;
    public static final int VALUE_VIDEO_INFO_PRELOAD_SIZE = 9;
    public static final int VALUE_VIDEO_INFO_PRELOAD_MIN_STEP = 10;
    public static final int VALUE_VIDEO_INFO_PRELOAD_MAX_STEP = 11;
    public static final int VALUE_VIDEO_INFO_SIZE = 12;
    public static final int VALUE_VIDEO_INFO_PRELOAD_INTERVAL = 13;
    public static final int VALUE_VIDEO_INFO_FILE_HASH = 15;
    public static final int VALUE_VIDEO_INFO_URLS = 16;
    public static final int VALUE_VIDEO_INFO_BACKUP_URL_1 = 17;
    public static final int VALUE_VIDEO_INFO_QUALITY = 18;
    public static final int VALUE_VIDEO_INFO_LOGO_TYPE = 19;
    public static final int VALUE_VIDEO_INFO_GBR = 20;
    public static final int VALUE_VIDEO_INFO_USE_VIDEO_PROXY = 21;
    public static final int VALUE_VIDEO_INFO_SOCKET_BUFFER = 22;
    public static final int VALUE_VIDEO_INFO_BACKUP_URL_2 = 23;
    public static final int VALUE_VIDEO_INFO_BACKUP_URL_3 = 24;
    public static final int VALUE_VIDEO_INFO_STORE_PATH = 25;
    public static final int VALUE_VIDEO_INFO_RESOLUTION_STR = 26;
    public static final int VALUE_VIDEO_INFO_DURATION = 27;
    public static final int VALUE_VIDEO_INFO_FILEID = 28;
    public static final int VALUE_VIDEO_INFO_P2PVERIFYURL = 29;
    public static final int VALUE_VIDEO_INFO_URLEXPIRED = 30;
    public static final int VALUE_VIDEO_INFO_CHECK_INFO = 31;
    public static final int VALUE_VIDEO_INFO_QUALITY_DESC = 32;
    public static final int VALUE_VIDEO_INFO_BARRAGE_OFFSET = 33;
    public static final int VALUE_VIDEO_INFO_INIT_RANGE = 34;
    public static final int VALUE_VIDEO_INFO_INDEX_RANGE = 35;
    public static final int VALUE_VIDEO_INFO_KID = 36;
    public static final int VALUE_VIDEO_INFO_BARRAGE_URL = 37;
    public static final int VALUE_VIDEO_HEAD_SIZE = 38;
    public static final int VALUE_VIDEO_INFO_LOUDNESS = 39;
    public static final int VALUE_VIDEO_INFO_PEAK = 40;
    public static final int VALUE_VIDEO_INFO_QUALITY_TYPE = 41;
    public static final int VALUE_VIDEO_INFO_INFO_ID = 42;
    public static final int VALUE_VIDEO_INFO_AI_BARRAGE_URL = 43;
    public static final int VALUE_VIDEO_INFO_REAL_BITRATE = 44;
    public static final int VALUE_VIDEO_VIEWPORT = 45;
    public static final int VALUE_VIDEO_INFO_RESOLUTION_FILEID = 46;
    public static final int VALUE_VIDEO_INFO_FIRST_MOOF_RANGE = 47;
    private int mVersion = 1;
    private Resolution mResolution = Resolution.Standard;
    private String mResolutionStr = Resolution.Standard.toString(VideoRef.TYPE_VIDEO);
    private String mFileId = null;
    private String mP2pVerifyUrl = null;
    private long mUrlExpiredT = 0L;
    private String mKeyseed = null;
    private static final String KEY_VER1_MAIN_URL = "main_url";
    private static final String KEY_VER1_BACKUP_URL = "backup_url";
    private static final String KEY_VER1_BACKUP_URL_1 = "backup_url_1";
    private static final String KEY_VER1_BACKUP_URL_2 = "backup_url_2";
    private static final String KEY_VER1_BACKUP_URL_3 = "backup_url_3";
    private static final String KEY_VER1_VWIDTH = "vwidth";
    private static final String KEY_VER1_VHEIGHT = "vheight";
    private static final String KEY_VER1_BITRATE = "bitrate";
    private static final String KEY_VER1_QUALITY_TYPE = "quality_type";
    private static final String KEY_VER1_ENCRYPT = "encrypt";
    private static final String KEY_VER1_SPADEA = "spade_a";
    private static final String KEY_VER1_GBR = "gbr";
    private static final String KEY_VER1_STOREPATH = "storePath";
    private static final String KEY_VER1_VTYPE = "vtype";
    private static final String KEY_VER1_ATYPE = "atype";
    private static final String KEY_VER1_DEFINITION = "definition";
    private static final String KEY_VER1_CODEC_TYPE = "codec_type";
    private static final String KEY_VER1_PRELOAD_SIZE = "preload_size";
    private static final String KEY_VER1_PLAY_LOAD_MIN_STEP = "play_load_min_step";
    private static final String KEY_VER1_PLAY_LOAD_MAX_STEP = "play_load_max_step";
    private static final String KEY_VER1_SIZE = "size";
    private static final String KEY_VER1_PRELOAD_INTERVAL = "preload_interval";
    private static final String KEY_VER1_USE_VIDEO_PROXY = "use_video_proxy";
    private static final String KEY_VER1_SOCKET_BUFFER = "socket_buffer";
    private static final String KEY_VER1_FILE_HASH = "file_hash";
    private static final String KEY_VER1_QUALITY = "quality";
    private static final String KEY_VER1_FILEID = "file_id";
    private static final String KEY_VER1_P2PVERIFYURL = "p2p_verify_url";
    public static final String KEY_LOGO_TYPE = "logo_type";
    private static final String KEY_VER1_URL_EXPIRED = "url_expire";
    private static final String KEY_VER1_CHECK_INFO = "check_info";
    private static final String KEY_VER1_INIT_RANGE = "init_range";
    private static final String KEY_VER1_INDEX_RANGE = "index_range";
    private static final String KEY_VER1_FIRST_MOOF_RANGE = "first_moof_range";
    private static final String KEY_VER1_QUALITY_DESC = "quality_desc";
    private static final String KEY_VER1_KID = "kid";
    private static final String KEY_VER1_BARRAGE_MASK_OFFSET = "barrage_mask_offset";
    private static final String KEY_VER1_BARRAGE_MASK_URL = "barrage_mask_url";
    private static final String KEY_VER1_AI_BARRAGE_URL = "effect_barrage_url";
    private static final String KEY_VER1_FITTER_INFO = "fitter_info";
    private static final String KEY_VER1_VOLUME = "volume";
    private static final String KEY_VER1_LOUDNESS = "loudness";
    private static final String KEY_VER1_PEAK = "peak";
    private static final String KEY_VER1_PACKET_OFFSET = "pkt_offset";
    private static final String KEY_VER1_LANGUAGE_ID = "language_id";
    private static final String KEY_VER1_LANGUAGE_CODE = "language_code";
    private static final String KEY_VER1_DUB_VERSION = "dub_version";
    private static final String KEY_VER1_REAL_BITRATE = "real_bitrate";
    private static final String KEY_VER1_PALLAS_FID_LABELS = "pallas_fid_labels";
    public String[] mURLs;
    public String mMainUrl;
    public String mBackupUrl1;
    public String mBackupUrl2;
    public String mBackupUrl3;
    public int mVWidth;
    public int mVHeight;
    public int mBitrate;
    public int mGbr;
    public boolean mEncrypt = false;
    public String mSpadea = null;
    public String mStorePath;
    public String mVType;
    public String mCodecType;
    public String mFileHash;
    public String mDefinition;
    public int preloadSize;
    public int playLoadMinStep;
    public int playLoadMaxStep;
    public long mSize = 0L;
    public int mVideoDuration = 0;
    public int preloadInterval = 0;
    public int useVideoProxy = 1;
    private int mSocketBuffer = 0;
    public boolean isAutoDefinition = false;
    public String mQuality;
    private String mLogoType;
    private int mMediaType = 0;
    private String mCheckInfo;
    private String mInitRange;
    private String mIndexRange;
    private String mFirstMoofRange;
    private String mKid;
    protected JSONObject mPreloadGear = null;
    public float mLoudness = 0.0f;
    public float mPeak = 0.0f;
    private int mQualityType = 0;
    public HashMap<Double, Long> mPacketOffset;
    public int mInfoId = -1;
    public int mLanguageId = -1;
    public String mLanguageCode = "";
    public String mDubVersion = "";
    public int mRealBitrate;
    private static final String KEY_VER2_MAIN_URL = "MainPlayUrl";
    private static final String KEY_VER2_MEDIA_TYPE = "MediaType";
    private static final String KEY_VER2_VWIDTH = "Width";
    private static final String KEY_VER2_VHEIGHT = "Height";
    private static final String KEY_VER2_BITRATE = "Bitrate";
    private static final String KEY_VER2_SPADEA = "PlayAuth";
    private static final String KEY_VER2_VTYPE = "Format";
    private static final String KEY_VER2_DEFINITION = "Definition";
    private static final String KEY_VER2_CODEC_TYPE = "Codec";
    private static final String KEY_VER2_PRELOAD_SIZE = "PreloadSize";
    private static final String KEY_VER2_PLAY_LOAD_MIN_STEP = "PreloadMinStep";
    private static final String KEY_VER2_PLAY_LOAD_MAX_STEP = "PreloadMaxStep";
    private static final String KEY_VER2_SIZE = "Size";
    private static final String KEY_VER2_PRELOAD_INTERVAL = "PreloadInterval";
    private static final String KEY_VER2_FILE_HASH = "FileHash";
    private static final String KEY_VER2_LOGO_TYPE = "Logo";
    private static final String KEY_VER2_QUALITY = "Quality";
    private static final String KEY_VER2_BACKUP_URL = "BackupPlayUrl";
    private static final String KEY_VER2_FILEID = "FileID";
    private static final String KEY_VER2_P2PVERIFYURL = "P2pVerifyURL";
    private static final String KEY_VER2_CHECK_INFO = "CheckInfo";
    private static final String KEY_VER2_INIT_RANGE = "InitRange";
    private static final String KEY_VER2_INDEX_RANGE = "IndexRange";
    private static final String KEY_VER2_FIRST_MOOF_RANGE = "FirstMoofRange";
    private static final String KEY_VER2_KID = "PlayAuthID";
    private static final String KEY_VER2_QUALITY_TYPE = "QualityType";
    private static final String KEY_VER2_LANGUAGE_ID = "LanguageId";
    private static final String KEY_VER2_LANGUAGE_CODE = "LanguageCode";
    private static final String KEY_VER2_DUB_VERSION = "DubVersion";
    private static final String KEY_VER2_REAL_BITRATE = "RealBitrate";
    private String[] mURLsVer2 = null;
    private String mMainUrlVer2;
    private String mFileHashVer2;
    private int mVWidthVer2;
    private int mVHeightVer2;
    private int mBitrateVer2;
    private String mSpadeaVer2 = null;
    private String mVTypeVer2;
    private String mCodecTypeVer2 = null;
    private String mDefinitionVer2;
    private int preLoadSizeVer2;
    private int preLoadMinStepVer2;
    private int preLoadMaxStepVer2;
    private int preLoadIntervalVer2 = 0;
    private long mSizeVer2 = 0L;
    private String mLogoTypeVer2 = null;
    private String mQualityVer2 = null;
    private String mBackupUrl1Ver2 = null;
    private String mQualityDesc = null;
    private String mBarrageMaskOffset = null;
    private MediaBitrateFitterInfo mBitrateFitterInfo = null;
    private String mBarrageMaskUrl;
    private String mAIBarrageUrl;
    private static final String KEY_VER4_FILEID = "FileId";
    private static final String KEY_VER4_MD5 = "Md5";
    private static final String KEY_VER4_FILE_TYPE = "FileType";
    private static final String KEY_VER4_VTYPE = "Format";
    private static final String KEY_VER4_CODEC_TYPE = "Codec";
    private static final String KEY_VER4_DEFINITION = "Definition";
    private static final String KEY_VER4_MAIN_URL = "MainPlayUrl";
    private static final String KEY_VER4_BACKUP_URL = "BackupPlayUrl";
    private static final String KEY_VER4_BITRATE = "Bitrate";
    private static final String KEY_VER4_VWIDTH = "Width";
    private static final String KEY_VER4_VHEIGHT = "Height";
    private static final String KEY_VER4_SIZE = "Size";
    private static final String KEY_VER4_CHECK_INFO = "CheckInfo";
    private static final String KEY_VER4_INIT_RANGE = "InitRange";
    private static final String KEY_VER4_INDEX_RANGE = "IndexRange";
    private static final String KEY_VER4_FIRST_MOOF_RANGE = "FirstMoofRange";
    private static final String KEY_VER4_PLAYAUTH = "PlayAuth";
    private static final String KEY_VER4_PLAYAUTHID = "PlayAuthId";
    private static final String KEY_VER4_LOGO_TYPE = "LogoType";
    private static final String KEY_VER4_QUALITY = "Quality";
    private static final String KEY_VER4_QUALITY_TYPE = "QualityType";
    private static final String KEY_VER4_REAL_BITRATE = "RealBitrate";
    private static final String KEY_VER4_VOLUME = "Volume";
    private static final String KEY_VER4_LOUDNESS = "Loudness";
    private static final String KEY_VER4_PEAK = "Peak";

    @Deprecated
    public VideoInfo(String keyseed) {
        this.mKeyseed = keyseed;
    }

    public void parseFromPb(VideoModelPb.Video pb) {
    }

    public void parseFromPb(VideoModelPb.Audio pb) {
    }

    public void extractFields(JSONObject obj) {
        if (obj == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)obj.optString(KEY_VER1_MAIN_URL))) {
            if (this.mVersion != 3) {
                this.mVersion = 1;
            }
        } else if (!TextUtils.isEmpty((CharSequence)obj.optString("MainPlayUrl")) && this.mVersion != 4) {
            this.mVersion = 2;
        }
        if (this.mVersion == 1) {
            String lables;
            JSONObject volume;
            ArrayList<String> urlList = new ArrayList<String>();
            this.mMainUrl = TTHelper.base64Decode(obj.optString(KEY_VER1_MAIN_URL), this.mKeyseed);
            this.mBackupUrl1 = TTHelper.base64Decode(obj.optString(KEY_VER1_BACKUP_URL_1), this.mKeyseed);
            this.mBackupUrl2 = TTHelper.base64Decode(obj.optString(KEY_VER1_BACKUP_URL_2), this.mKeyseed);
            this.mBackupUrl3 = TTHelper.base64Decode(obj.optString(KEY_VER1_BACKUP_URL_3), this.mKeyseed);
            if (!TextUtils.isEmpty((CharSequence)this.mMainUrl)) {
                urlList.add(this.mMainUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl1)) {
                urlList.add(this.mBackupUrl1);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl2)) {
                urlList.add(this.mBackupUrl2);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl3)) {
                urlList.add(this.mBackupUrl3);
            }
            this.mURLs = new String[urlList.size()];
            urlList.toArray(this.mURLs);
            try {
                this.mVWidth = Integer.parseInt(obj.optString(KEY_VER1_VWIDTH));
            }
            catch (NumberFormatException e) {
                this.mVWidth = 0;
            }
            try {
                this.mVHeight = Integer.parseInt(obj.optString(KEY_VER1_VHEIGHT));
            }
            catch (NumberFormatException e) {
                this.mVHeight = 0;
            }
            try {
                this.mBitrate = obj.optInt(KEY_VER1_BITRATE);
            }
            catch (Exception e) {
                this.mBitrate = 0;
            }
            try {
                this.mRealBitrate = obj.optInt(KEY_VER1_REAL_BITRATE);
            }
            catch (Exception e) {
                this.mRealBitrate = 0;
            }
            try {
                this.mQualityType = obj.optInt(KEY_VER1_QUALITY_TYPE);
            }
            catch (Exception e) {
                this.mQualityType = 0;
            }
            this.mEncrypt = obj.optBoolean(KEY_VER1_ENCRYPT);
            this.mSpadea = obj.optString(KEY_VER1_SPADEA);
            this.mGbr = obj.optInt(KEY_VER1_GBR);
            this.mStorePath = obj.optString(KEY_VER1_STOREPATH);
            this.mVType = obj.optString(KEY_VER1_VTYPE);
            this.mDefinition = obj.optString(KEY_VER1_DEFINITION);
            this.mCodecType = obj.optString(KEY_VER1_CODEC_TYPE);
            try {
                this.mSize = obj.optLong(KEY_VER1_SIZE, 0L);
            }
            catch (Exception e) {
                this.mSize = 0L;
            }
            if (obj.has(KEY_VER1_VOLUME) && (volume = obj.optJSONObject(KEY_VER1_VOLUME)) != null && (volume.has(KEY_VER1_LOUDNESS) || volume.has(KEY_VER1_PEAK))) {
                this.mLoudness = (float)volume.optDouble(KEY_VER1_LOUDNESS);
                this.mPeak = (float)volume.optDouble(KEY_VER1_PEAK);
            }
            if (obj.has(KEY_VER1_PALLAS_FID_LABELS)) {
                lables = obj.optString(KEY_VER1_PALLAS_FID_LABELS);
                this.externalizablePallasLabels(lables);
            }
            this.preloadSize = obj.optInt(KEY_VER1_PRELOAD_SIZE);
            this.playLoadMinStep = obj.optInt(KEY_VER1_PLAY_LOAD_MIN_STEP);
            this.playLoadMaxStep = obj.optInt(KEY_VER1_PLAY_LOAD_MAX_STEP);
            this.preloadInterval = obj.optInt(KEY_VER1_PRELOAD_INTERVAL, -1);
            this.useVideoProxy = obj.optInt(KEY_VER1_USE_VIDEO_PROXY, 1);
            this.mSocketBuffer = obj.optInt(KEY_VER1_SOCKET_BUFFER, 0);
            this.mFileHash = obj.optString(KEY_VER1_FILE_HASH);
            this.mQuality = obj.optString(KEY_VER1_QUALITY);
            this.mQualityDesc = obj.optString(KEY_VER1_QUALITY_DESC);
            this.mLogoType = obj.optString(KEY_LOGO_TYPE);
            this.mFileId = obj.optString(KEY_VER1_FILEID);
            if (!TextUtils.isEmpty((CharSequence)this.mFileId) && !TextUtils.isEmpty((CharSequence)this.mVType) && (this.mVType.equals("hls") || this.mVType.equals("m3u8"))) {
                this.mFileHash = "fileid" + this.mFileId;
            }
            this.mP2pVerifyUrl = TTHelper.base64Decode(obj.optString(KEY_VER1_P2PVERIFYURL));
            this.mUrlExpiredT = obj.optLong(KEY_VER1_URL_EXPIRED);
            this.mCheckInfo = obj.optString(KEY_VER1_CHECK_INFO);
            this.mInitRange = obj.optString(KEY_VER1_INIT_RANGE);
            this.mIndexRange = obj.optString(KEY_VER1_INDEX_RANGE);
            this.mFirstMoofRange = obj.optString(KEY_VER1_FIRST_MOOF_RANGE);
            this.mKid = obj.optString(KEY_VER1_KID);
            this.mBarrageMaskUrl = TTHelper.base64Decode(obj.optString(KEY_VER1_BARRAGE_MASK_URL), this.mKeyseed);
            this.mAIBarrageUrl = TTHelper.base64Decode(obj.optString(KEY_VER1_AI_BARRAGE_URL), this.mKeyseed);
            if (obj.has(KEY_VER1_FITTER_INFO)) {
                this.mBitrateFitterInfo = new MediaBitrateFitterInfo();
                this.mBitrateFitterInfo.extractFields(obj.optJSONObject(KEY_VER1_FITTER_INFO));
            }
            if (obj.has(KEY_VER1_PALLAS_FID_LABELS)) {
                lables = obj.optString(KEY_VER1_PALLAS_FID_LABELS);
                this.externalizablePallasLabels(lables);
            }
            if (obj.has(KEY_VER1_PACKET_OFFSET)) {
                String packetOffsetStr = obj.optString(KEY_VER1_PACKET_OFFSET);
                try {
                    JSONArray packetOffsetArr = new JSONArray(packetOffsetStr);
                    if (packetOffsetArr.length() > 0) {
                        this.mPacketOffset = new HashMap();
                        for (int i = 0; i < packetOffsetArr.length(); ++i) {
                            JSONArray packetArray = packetOffsetArr.optJSONArray(i);
                            if (packetArray == null || packetArray.length() != 2) continue;
                            Double time = packetArray.optDouble(0);
                            Long offset = packetArray.optLong(1);
                            this.mPacketOffset.put(time, offset);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.mLanguageId = obj.optInt(KEY_VER1_LANGUAGE_ID, -1);
                this.mLanguageCode = obj.optString(KEY_VER1_LANGUAGE_CODE, "");
                this.mDubVersion = obj.optString(KEY_VER1_DUB_VERSION, "");
            }
            catch (Exception e) {
                this.mLanguageId = -1;
                this.mLanguageCode = "";
                this.mDubVersion = "";
            }
        } else if (this.mVersion == 2) {
            this.mBitrateVer2 = obj.optInt("Bitrate");
            try {
                this.mRealBitrate = obj.optInt("RealBitrate");
            }
            catch (Exception e) {
                this.mRealBitrate = 0;
            }
            this.mFileHashVer2 = obj.optString(KEY_VER2_FILE_HASH);
            this.mSizeVer2 = obj.optLong("Size");
            this.mVHeightVer2 = obj.optInt("Height");
            this.mVWidthVer2 = obj.optInt("Width");
            this.mVTypeVer2 = obj.optString("Format");
            this.mCodecTypeVer2 = obj.optString("Codec");
            this.mLogoTypeVer2 = obj.optString(KEY_VER2_LOGO_TYPE);
            this.mDefinitionVer2 = obj.optString("Definition");
            this.mQualityVer2 = obj.optString("Quality");
            this.mSpadeaVer2 = obj.optString("PlayAuth");
            this.mMainUrlVer2 = obj.optString("MainPlayUrl");
            this.mBackupUrl1Ver2 = obj.optString("BackupPlayUrl");
            String mediaType = obj.optString(KEY_VER2_MEDIA_TYPE);
            try {
                this.mQualityType = obj.optInt("QualityType");
            }
            catch (Exception e) {
                this.mQualityType = 0;
            }
            if (!TextUtils.isEmpty((CharSequence)mediaType)) {
                if (mediaType.equals("video")) {
                    this.mMediaType = VideoRef.TYPE_VIDEO;
                } else if (mediaType.equals("audio")) {
                    this.mMediaType = VideoRef.TYPE_AUDIO;
                }
            }
            ArrayList<String> urlList = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.mMainUrlVer2)) {
                urlList.add(this.mMainUrlVer2);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl1Ver2)) {
                urlList.add(this.mBackupUrl1Ver2);
            }
            this.mURLsVer2 = new String[urlList.size()];
            urlList.toArray(this.mURLsVer2);
            this.preLoadIntervalVer2 = obj.optInt(KEY_VER2_PRELOAD_INTERVAL, -1);
            this.preLoadMinStepVer2 = obj.optInt(KEY_VER2_PLAY_LOAD_MIN_STEP);
            this.preLoadMaxStepVer2 = obj.optInt(KEY_VER2_PLAY_LOAD_MAX_STEP);
            this.preLoadSizeVer2 = obj.optInt(KEY_VER2_PRELOAD_SIZE);
            this.mFileId = obj.optString(KEY_VER2_FILEID);
            if (!TextUtils.isEmpty((CharSequence)this.mFileId) && !TextUtils.isEmpty((CharSequence)this.mVTypeVer2) && (this.mVTypeVer2.equals("hls") || this.mVTypeVer2.equals("m3u8"))) {
                this.mFileHashVer2 = "fileid" + this.mFileId;
            }
            this.mP2pVerifyUrl = obj.optString(KEY_VER2_P2PVERIFYURL);
            this.mCheckInfo = obj.optString("CheckInfo");
            this.mInitRange = obj.optString("InitRange");
            this.mIndexRange = obj.optString("IndexRange");
            this.mFirstMoofRange = obj.optString("FirstMoofRange");
            this.mKid = obj.optString(KEY_VER2_KID);
            if (obj.has(KEY_VER1_FITTER_INFO)) {
                this.mBitrateFitterInfo = new MediaBitrateFitterInfo();
                this.mBitrateFitterInfo.extractFields(obj.optJSONObject(KEY_VER1_FITTER_INFO));
            }
            if (obj.has(KEY_VER1_PACKET_OFFSET)) {
                String packetOffsetStr = obj.optString(KEY_VER1_PACKET_OFFSET);
                try {
                    JSONArray packetOffsetArr = new JSONArray(packetOffsetStr);
                    if (packetOffsetArr.length() > 0) {
                        this.mPacketOffset = new HashMap();
                        for (int i = 0; i < packetOffsetArr.length(); ++i) {
                            JSONArray packetArray = packetOffsetArr.optJSONArray(i);
                            if (packetArray == null || packetArray.length() != 2) continue;
                            Double time = packetArray.optDouble(0);
                            Long offset = packetArray.optLong(1);
                            this.mPacketOffset.put(time, offset);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.mLanguageId = obj.optInt(KEY_VER2_LANGUAGE_ID, -1);
                this.mLanguageCode = obj.optString(KEY_VER2_LANGUAGE_CODE, "");
                this.mDubVersion = obj.optString(KEY_VER2_DUB_VERSION, "");
            }
            catch (Exception e) {
                this.mLanguageId = -1;
                this.mLanguageCode = "";
                this.mDubVersion = "";
            }
        } else if (this.mVersion == 3) {
            JSONObject barrage_info;
            JSONObject base_range_info;
            JSONObject check_info;
            JSONObject p2p_info;
            JSONObject encrypt_info;
            JSONObject audioMeta;
            JSONObject videoMeta;
            JSONObject volume;
            ArrayList<String> urlList = new ArrayList<String>();
            this.mMainUrl = obj.optString(KEY_VER1_MAIN_URL);
            this.mBackupUrl1 = obj.optString(KEY_VER1_BACKUP_URL);
            urlList.add(this.mMainUrl);
            urlList.add(this.mBackupUrl1);
            this.mURLs = new String[urlList.size()];
            urlList.toArray(this.mURLs);
            if (obj.has(KEY_VER1_VOLUME) && (volume = obj.optJSONObject(KEY_VER1_VOLUME)) != null && (volume.has(KEY_VER1_LOUDNESS) || volume.has(KEY_VER1_PEAK))) {
                this.mLoudness = (float)volume.optDouble(KEY_VER1_LOUDNESS);
                this.mPeak = (float)volume.optDouble(KEY_VER1_PEAK);
            }
            if (obj.has(KEY_VER1_PALLAS_FID_LABELS)) {
                String lables = obj.optString(KEY_VER1_PALLAS_FID_LABELS);
                this.externalizablePallasLabels(lables);
            }
            if ((videoMeta = obj.optJSONObject("video_meta")) != null) {
                this.mLogoType = videoMeta.optString(KEY_LOGO_TYPE);
                this.mQualityDesc = videoMeta.optString(KEY_VER1_QUALITY_DESC);
                this.mVType = videoMeta.optString(KEY_VER1_VTYPE);
                this.mDefinition = videoMeta.optString(KEY_VER1_DEFINITION);
                this.mCodecType = videoMeta.optString(KEY_VER1_CODEC_TYPE);
                try {
                    this.mVWidth = Integer.parseInt(videoMeta.optString(KEY_VER1_VWIDTH));
                }
                catch (NumberFormatException e) {
                    this.mVWidth = 0;
                }
                try {
                    this.mVHeight = Integer.parseInt(videoMeta.optString(KEY_VER1_VHEIGHT));
                }
                catch (NumberFormatException e) {
                    this.mVHeight = 0;
                }
                try {
                    this.mBitrate = videoMeta.optInt(KEY_VER1_BITRATE);
                }
                catch (Exception e) {
                    this.mBitrate = 0;
                }
                try {
                    this.mRealBitrate = videoMeta.optInt(KEY_VER1_REAL_BITRATE);
                }
                catch (Exception e) {
                    this.mRealBitrate = 0;
                }
                try {
                    this.mQualityType = videoMeta.optInt(KEY_VER1_QUALITY_TYPE);
                }
                catch (Exception e) {
                    this.mQualityType = 0;
                }
                this.mQuality = videoMeta.optString(KEY_VER1_QUALITY);
                this.mFileId = videoMeta.optString(KEY_VER1_FILEID);
                this.mFileHash = videoMeta.optString(KEY_VER1_FILE_HASH);
                if (!TextUtils.isEmpty((CharSequence)this.mFileId) && !TextUtils.isEmpty((CharSequence)this.mVType) && (this.mVType.equals("hls") || this.mVType.equals("m3u8") || TextUtils.isEmpty((CharSequence)this.mFileHash))) {
                    this.mFileHash = "fileid" + this.mFileId;
                }
                try {
                    this.mSize = videoMeta.optLong(KEY_VER1_SIZE, 0L);
                }
                catch (Exception e) {
                    this.mSize = 0L;
                }
            }
            if ((audioMeta = obj.optJSONObject("audio_meta")) != null) {
                this.mQualityDesc = audioMeta.optString(KEY_VER1_QUALITY_DESC);
                this.mVType = audioMeta.optString(KEY_VER1_ATYPE);
                this.mDefinition = audioMeta.optString(KEY_VER1_DEFINITION);
                this.mQuality = audioMeta.optString(KEY_VER1_QUALITY);
                this.mCodecType = audioMeta.optString(KEY_VER1_CODEC_TYPE);
                try {
                    this.mBitrate = audioMeta.optInt(KEY_VER1_BITRATE);
                }
                catch (Exception e) {
                    this.mBitrate = 0;
                }
                try {
                    this.mRealBitrate = audioMeta.optInt(KEY_VER1_REAL_BITRATE);
                }
                catch (Exception e) {
                    this.mRealBitrate = 0;
                }
                this.mFileId = audioMeta.optString(KEY_VER1_FILEID);
                this.mFileHash = audioMeta.optString(KEY_VER1_FILE_HASH);
                if (!TextUtils.isEmpty((CharSequence)this.mFileId) && TextUtils.isEmpty((CharSequence)this.mFileHash)) {
                    this.mFileHash = "fileid" + this.mFileId;
                }
                try {
                    this.mSize = audioMeta.optLong(KEY_VER1_SIZE, 0L);
                }
                catch (Exception e) {
                    this.mSize = 0L;
                }
            }
            if ((encrypt_info = obj.optJSONObject("encrypt_info")) != null) {
                this.mEncrypt = encrypt_info.optBoolean(KEY_VER1_ENCRYPT);
                this.mSpadea = encrypt_info.optString(KEY_VER1_SPADEA);
                this.mKid = encrypt_info.optString(KEY_VER1_KID);
            }
            if ((p2p_info = obj.optJSONObject("p2p_info")) != null) {
                this.mP2pVerifyUrl = p2p_info.optString(KEY_VER1_P2PVERIFYURL);
            }
            if ((check_info = obj.optJSONObject(KEY_VER1_CHECK_INFO)) != null) {
                this.mCheckInfo = check_info.optString(KEY_VER1_CHECK_INFO);
            }
            if ((base_range_info = obj.optJSONObject("base_range_info")) != null) {
                this.mInitRange = base_range_info.optString(KEY_VER1_INIT_RANGE);
                this.mIndexRange = base_range_info.optString(KEY_VER1_INDEX_RANGE);
                this.mFirstMoofRange = base_range_info.optString(KEY_VER1_FIRST_MOOF_RANGE);
            }
            if ((barrage_info = obj.optJSONObject("barrage_info")) != null) {
                this.mBarrageMaskOffset = barrage_info.optString(KEY_VER1_BARRAGE_MASK_OFFSET);
            }
            if (obj.has(KEY_VER1_FITTER_INFO)) {
                this.mBitrateFitterInfo = new MediaBitrateFitterInfo();
                this.mBitrateFitterInfo.extractFields(obj.optJSONObject(KEY_VER1_FITTER_INFO));
            }
            if (obj.has(KEY_VER1_PACKET_OFFSET)) {
                String packetOffsetStr = obj.optString(KEY_VER1_PACKET_OFFSET);
                try {
                    JSONArray packetOffsetArr = new JSONArray(packetOffsetStr);
                    if (packetOffsetArr.length() > 0) {
                        this.mPacketOffset = new HashMap();
                        for (int i = 0; i < packetOffsetArr.length(); ++i) {
                            JSONArray packetArray = packetOffsetArr.optJSONArray(i);
                            if (packetArray == null || packetArray.length() != 2) continue;
                            Double time = packetArray.optDouble(0);
                            Long offset = packetArray.optLong(1);
                            this.mPacketOffset.put(time, offset);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.mLanguageId = obj.optInt(KEY_VER1_LANGUAGE_ID, -1);
                this.mLanguageCode = obj.optString(KEY_VER1_LANGUAGE_CODE, "");
                this.mDubVersion = obj.optString(KEY_VER1_DUB_VERSION, "");
            }
            catch (Exception e) {
                this.mLanguageId = -1;
                this.mLanguageCode = "";
                this.mDubVersion = "";
            }
        } else if (this.mVersion == 4) {
            JSONObject volumeObj;
            this.mBitrate = obj.optInt("Bitrate");
            try {
                this.mRealBitrate = obj.optInt("RealBitrate");
            }
            catch (Exception e) {
                this.mRealBitrate = 0;
            }
            if (this.mRealBitrate <= 0) {
                this.mRealBitrate = this.mBitrate;
            }
            if ((volumeObj = obj.optJSONObject(KEY_VER4_VOLUME)) != null) {
                this.mLoudness = (float)volumeObj.optDouble(KEY_VER4_LOUDNESS);
                this.mPeak = (float)volumeObj.optDouble(KEY_VER4_PEAK);
            }
            this.mFileHash = obj.optString(KEY_VER4_MD5);
            this.mSize = obj.optLong("Size");
            this.mVHeight = obj.optInt("Height");
            this.mVWidth = obj.optInt("Width");
            this.mVType = obj.optString("Format");
            this.mCodecType = obj.optString("Codec");
            this.mLogoType = obj.optString(KEY_VER4_LOGO_TYPE);
            this.mDefinition = obj.optString("Definition");
            this.mQuality = obj.optString("Quality");
            this.mSpadea = obj.optString("PlayAuth");
            this.mMainUrl = obj.optString("MainPlayUrl");
            this.mBackupUrl1 = obj.optString("BackupPlayUrl");
            if (obj.has(KEY_VER1_PALLAS_FID_LABELS)) {
                String lables = obj.optString(KEY_VER1_PALLAS_FID_LABELS);
                this.externalizablePallasLabels(lables);
            }
            try {
                this.mQualityType = obj.optInt("QualityType");
            }
            catch (Exception e) {
                this.mQualityType = 0;
            }
            String fileType = obj.optString(KEY_VER4_FILE_TYPE);
            if (!TextUtils.isEmpty((CharSequence)fileType)) {
                if (fileType.equals("video")) {
                    this.mMediaType = VideoRef.TYPE_VIDEO;
                } else if (fileType.equals("audio")) {
                    this.mMediaType = VideoRef.TYPE_AUDIO;
                }
            }
            ArrayList<String> urlList = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.mMainUrl)) {
                urlList.add(this.mMainUrl);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mBackupUrl1)) {
                urlList.add(this.mBackupUrl1);
            }
            this.mURLs = new String[urlList.size()];
            urlList.toArray(this.mURLs);
            this.mFileId = obj.optString(KEY_VER4_FILEID);
            if (!TextUtils.isEmpty((CharSequence)this.mFileId) && !TextUtils.isEmpty((CharSequence)this.mVType) && (this.mVType.equals("hls") || this.mVType.equals("m3u8"))) {
                this.mFileHash = "fileid" + this.mFileId;
            }
            this.mCheckInfo = obj.optString("CheckInfo");
            this.mInitRange = obj.optString("InitRange");
            this.mIndexRange = obj.optString("IndexRange");
            this.mFirstMoofRange = obj.optString("FirstMoofRange");
            this.mKid = obj.optString(KEY_VER4_PLAYAUTHID);
            try {
                this.mLanguageId = obj.optInt(KEY_VER2_LANGUAGE_ID, -1);
                this.mLanguageCode = obj.optString(KEY_VER2_LANGUAGE_CODE, "");
                this.mDubVersion = obj.optString(KEY_VER2_DUB_VERSION, "");
            }
            catch (Exception e) {
                this.mLanguageId = -1;
                this.mLanguageCode = "";
                this.mDubVersion = "";
            }
        }
    }

    public VideoInfo copyInfo() {
        VideoInfo info = new VideoInfo(this.mKeyseed);
        info.mVersion = this.mVersion;
        info.mURLs = this.mURLs;
        info.mMainUrl = this.mMainUrl;
        info.mBackupUrl1 = this.mBackupUrl1;
        info.mBackupUrl2 = this.mBackupUrl2;
        info.mBackupUrl3 = this.mBackupUrl3;
        info.mVWidth = this.mVWidth;
        info.mVHeight = this.mVHeight;
        info.mEncrypt = this.mEncrypt;
        info.mSpadea = this.mSpadea;
        info.mGbr = this.mGbr;
        info.mStorePath = this.mStorePath;
        info.mVType = this.mVType;
        info.mCodecType = this.mCodecType;
        info.mFileHash = this.mFileHash;
        info.mDefinition = this.mDefinition;
        info.preloadSize = this.preloadSize;
        info.playLoadMinStep = this.playLoadMinStep;
        info.playLoadMaxStep = this.playLoadMaxStep;
        info.mSize = this.mSize;
        info.mVideoDuration = this.mVideoDuration;
        info.preloadInterval = this.preloadInterval;
        info.useVideoProxy = this.useVideoProxy;
        info.mSocketBuffer = this.mSocketBuffer;
        info.isAutoDefinition = this.isAutoDefinition;
        info.mQuality = this.mQuality;
        info.mLogoType = this.mLogoType;
        info.mFileHash = this.mFileHash;
        info.mCheckInfo = this.mCheckInfo;
        info.mInitRange = this.mInitRange;
        info.mIndexRange = this.mIndexRange;
        info.mFirstMoofRange = this.mFirstMoofRange;
        info.mKid = this.mKid;
        info.mQualityType = this.mQualityType;
        info.mURLsVer2 = this.mURLsVer2;
        info.mMainUrlVer2 = this.mMainUrlVer2;
        info.mVWidthVer2 = this.mVWidthVer2;
        info.mVHeightVer2 = this.mVHeightVer2;
        info.mSpadeaVer2 = this.mSpadeaVer2;
        info.mVTypeVer2 = this.mVTypeVer2;
        info.mCodecTypeVer2 = this.mCodecTypeVer2;
        info.mDefinitionVer2 = this.mDefinitionVer2;
        info.preLoadSizeVer2 = this.preLoadSizeVer2;
        info.preLoadMinStepVer2 = this.preLoadMinStepVer2;
        info.preLoadMaxStepVer2 = this.preLoadMaxStepVer2;
        info.mSizeVer2 = this.mSizeVer2;
        info.preLoadIntervalVer2 = this.preLoadIntervalVer2;
        info.mLogoTypeVer2 = this.mLogoTypeVer2;
        info.mFileId = this.mFileId;
        info.mP2pVerifyUrl = this.mP2pVerifyUrl;
        info.mMediaType = this.mMediaType;
        info.mFileHashVer2 = this.mFileHashVer2;
        info.mRealBitrate = this.mRealBitrate;
        return info;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public void setVersion(int version) {
        this.mVersion = version;
    }

    @Override
    public int getMediatype() {
        return this.mMediaType;
    }

    public void setMediaType(int mediaType) {
        this.mMediaType = mediaType;
    }

    @Override
    public Resolution getResolution() {
        return this.mResolution;
    }

    public void setResolution(Resolution resolution) {
        this.mResolution = resolution;
    }

    public boolean isUseVideoProxy() {
        if (this.mVersion == 2 || this.mVersion == 4) {
            return false;
        }
        return this.useVideoProxy == 1;
    }

    public int getSocketBuffer() {
        if (this.mVersion == 2 || this.mVersion == 4) {
            return 0;
        }
        return this.mSocketBuffer;
    }

    public int getPreloadInterval() {
        if (this.mVersion == 2 || this.mVersion == 4) {
            return this.preLoadIntervalVer2;
        }
        return this.preloadInterval;
    }

    @Override
    public int getValueInt(int key) {
        if (key == 38) {
            if (this.mBitrateFitterInfo != null) {
                return this.mBitrateFitterInfo.getHeaderSize();
            }
            return 0;
        }
        if (this.mVersion == 2) {
            switch (key) {
                case 1: {
                    return this.mVWidthVer2;
                }
                case 2: {
                    return this.mVHeightVer2;
                }
                case 3: {
                    return this.mBitrateVer2;
                }
                case 9: {
                    return this.preLoadSizeVer2;
                }
                case 10: {
                    return this.preLoadMinStepVer2;
                }
                case 11: {
                    return this.preLoadMaxStepVer2;
                }
                case 13: {
                    return this.preLoadIntervalVer2;
                }
                case 41: {
                    return this.mQualityType;
                }
                case 42: {
                    return this.mInfoId;
                }
                case 44: {
                    return this.mRealBitrate;
                }
            }
            return -1;
        }
        switch (key) {
            case 1: {
                return this.mVWidth;
            }
            case 2: {
                return this.mVHeight;
            }
            case 3: {
                return this.mBitrate;
            }
            case 9: {
                return this.preloadSize;
            }
            case 10: {
                return this.playLoadMinStep;
            }
            case 11: {
                return this.playLoadMaxStep;
            }
            case 13: {
                return this.preloadInterval;
            }
            case 20: {
                return this.mGbr;
            }
            case 22: {
                return this.mSocketBuffer;
            }
            case 21: {
                return this.useVideoProxy;
            }
            case 27: {
                return this.mVideoDuration;
            }
            case 41: {
                return this.mQualityType;
            }
            case 42: {
                return this.mInfoId;
            }
            case 44: {
                return this.mRealBitrate;
            }
        }
        return -1;
    }

    @Override
    public String getValueStr(int key) {
        switch (key) {
            case 26: {
                return this.mResolutionStr;
            }
            case 28: {
                return this.mFileId;
            }
            case 29: {
                return this.mP2pVerifyUrl;
            }
            case 31: {
                return this.mCheckInfo;
            }
            case 34: {
                return this.mInitRange;
            }
            case 35: {
                return this.mIndexRange;
            }
            case 47: {
                return this.mFirstMoofRange;
            }
            case 36: {
                return this.mKid;
            }
        }
        if (this.mVersion == 2) {
            switch (key) {
                case 0: {
                    return this.mMainUrlVer2;
                }
                case 15: {
                    return this.mFileHashVer2;
                }
                case 5: {
                    return this.mSpadeaVer2;
                }
                case 6: {
                    return this.mVTypeVer2;
                }
                case 8: {
                    return this.mCodecTypeVer2;
                }
                case 7: {
                    return this.mDefinitionVer2;
                }
                case 19: {
                    return this.mLogoTypeVer2;
                }
                case 18: {
                    return this.mQualityVer2;
                }
                case 17: {
                    return this.mBackupUrl1Ver2;
                }
            }
            return "";
        }
        switch (key) {
            case 0: {
                return this.mMainUrl;
            }
            case 15: {
                return this.mFileHash;
            }
            case 5: {
                return this.mSpadea;
            }
            case 6: {
                return this.mVType;
            }
            case 8: {
                return this.mCodecType;
            }
            case 7: {
                return this.mDefinition;
            }
            case 18: {
                return this.mQuality;
            }
            case 17: {
                return this.mBackupUrl1;
            }
            case 23: {
                return this.mBackupUrl2;
            }
            case 24: {
                return this.mBackupUrl3;
            }
            case 25: {
                return this.mStorePath;
            }
            case 19: {
                return this.mLogoType;
            }
            case 32: {
                return this.mQualityDesc;
            }
            case 33: {
                return this.mBarrageMaskOffset;
            }
            case 37: {
                return this.mBarrageMaskUrl;
            }
            case 43: {
                return this.mAIBarrageUrl;
            }
        }
        return "";
    }

    @Override
    public String[] getValueStrArr(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 16: {
                    return this.mURLsVer2;
                }
            }
            return new String[0];
        }
        switch (key) {
            case 16: {
                return this.mURLs;
            }
        }
        return new String[0];
    }

    @Override
    public float getValueFloat(int key) {
        switch (key) {
            case 39: {
                return this.mLoudness;
            }
            case 40: {
                return this.mPeak;
            }
        }
        return 0.0f;
    }

    @Override
    public boolean getValueBool(int key) {
        if (this.mVersion == 1) {
            switch (key) {
                case 4: {
                    return this.mEncrypt;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public long getValueLong(int key) {
        if (this.mVersion == 2) {
            switch (key) {
                case 12: {
                    return this.mSizeVer2;
                }
            }
            return -1L;
        }
        switch (key) {
            case 12: {
                return this.mSize;
            }
            case 30: {
                return this.mUrlExpiredT;
            }
        }
        return -1L;
    }

    public void setValue(int key, String[] value) {
        switch (key) {
            case 16: {
                this.mURLs = value;
                this.mURLsVer2 = value;
                return;
            }
        }
    }

    public void setValue(int key, float value) {
        switch (key) {
            case 39: {
                this.mLoudness = value;
                return;
            }
            case 40: {
                this.mPeak = value;
                return;
            }
        }
    }

    public void setValue(int key, boolean value) {
        switch (key) {
            case 4: {
                this.mEncrypt = value;
                return;
            }
        }
    }

    public void setValue(int key, long value) {
        switch (key) {
            case 12: {
                this.mSize = value;
                this.mSizeVer2 = value;
                return;
            }
        }
    }

    public void setValue(int key, String value) {
        switch (key) {
            case 26: {
                this.mResolutionStr = value;
                return;
            }
            case 0: {
                this.mMainUrlVer2 = value;
                this.mMainUrl = value;
                return;
            }
            case 15: {
                this.mFileHashVer2 = value;
                this.mFileHash = value;
                return;
            }
            case 5: {
                this.mSpadeaVer2 = value;
                this.mSpadea = value;
                return;
            }
            case 6: {
                this.mVTypeVer2 = value;
                this.mVType = value;
                return;
            }
            case 8: {
                this.mCodecTypeVer2 = value;
                this.mCodecType = value;
                return;
            }
            case 7: {
                this.mDefinitionVer2 = value;
                this.mDefinition = value;
                return;
            }
            case 19: {
                this.mLogoTypeVer2 = value;
                this.mLogoType = value;
                return;
            }
            case 18: {
                this.mQualityVer2 = value;
                this.mQuality = value;
                return;
            }
            case 17: {
                this.mBackupUrl1Ver2 = value;
                this.mBackupUrl1 = value;
                return;
            }
            case 23: {
                this.mBackupUrl2 = value;
                return;
            }
            case 24: {
                this.mBackupUrl3 = value;
                return;
            }
            case 25: {
                this.mStorePath = value;
                return;
            }
        }
    }

    public void setValue(int key, int value) {
        switch (key) {
            case 1: {
                this.mVWidth = value;
                this.mVWidthVer2 = value;
                return;
            }
            case 2: {
                this.mVHeight = value;
                this.mVHeightVer2 = value;
                return;
            }
            case 3: {
                this.mBitrate = value;
                this.mBitrateVer2 = value;
                return;
            }
            case 9: {
                this.preloadSize = value;
                this.preLoadSizeVer2 = value;
                return;
            }
            case 10: {
                this.playLoadMinStep = value;
                return;
            }
            case 11: {
                this.playLoadMaxStep = value;
                return;
            }
            case 13: {
                this.preloadInterval = value;
                this.preLoadIntervalVer2 = value;
                return;
            }
            case 20: {
                this.mGbr = value;
                return;
            }
            case 22: {
                this.mSocketBuffer = value;
                return;
            }
            case 21: {
                this.useVideoProxy = value;
                return;
            }
            case 27: {
                this.mVideoDuration = value;
                return;
            }
        }
    }

    public void setResolutionBaseMap(HashMap<String, Resolution> resolutionMap) {
        if (resolutionMap == null || resolutionMap.size() <= 0) {
            return;
        }
        String resolutionString = null;
        if (this.mMediaType == VideoRef.TYPE_AUDIO) {
            String quality = this.getValueStr(18);
            resolutionString = TextUtils.isEmpty((CharSequence)quality) ? Resolution.Standard.toString(this.mMediaType) : quality;
        } else if (this.mMediaType == VideoRef.TYPE_VIDEO) {
            String definition = this.getValueStr(7);
            resolutionString = TextUtils.isEmpty((CharSequence)definition) ? Resolution.Standard.toString(this.mMediaType) : definition;
        }
        this.mResolution = resolutionMap.get(resolutionString);
        if (this.mResolution == null) {
            this.mResolution = Resolution.Standard;
        }
    }

    @Override
    @Nullable
    public JSONObject toBashJsonObject() {
        try {
            int headerSize;
            JSONObject jsonObject = new JSONObject();
            String[] urls = this.getValueStrArr(16);
            if (urls == null || urls.length <= 0) {
                return null;
            }
            String initRange = this.getValueStr(34);
            String formatType = this.getValueStr(6);
            if (!TextUtils.isEmpty((CharSequence)formatType) && formatType.equals("mp4") && (headerSize = this.getValueInt(38)) > 0) {
                initRange = "0-" + (headerSize - 1);
            }
            jsonObject.put(KEY_VER1_MAIN_URL, (Object)urls[0]);
            jsonObject.put(KEY_VER1_BACKUP_URL_1, (Object)(urls.length > 1 ? urls[1] : ""));
            jsonObject.put(KEY_VER1_BITRATE, this.getValueInt(3));
            jsonObject.put(KEY_VER1_VWIDTH, this.getValueInt(1));
            jsonObject.put(KEY_VER1_VHEIGHT, this.getValueInt(2));
            jsonObject.put(KEY_VER1_INIT_RANGE, (Object)initRange);
            jsonObject.put(KEY_VER1_INDEX_RANGE, (Object)this.getValueStr(35));
            jsonObject.put(KEY_VER1_FIRST_MOOF_RANGE, (Object)this.getValueStr(47));
            jsonObject.put(KEY_VER1_CHECK_INFO, (Object)this.getValueStr(31));
            jsonObject.put(KEY_VER1_KID, (Object)this.getValueStr(36));
            jsonObject.put(KEY_VER1_FILE_HASH, (Object)TTHelper.encodeUrl(this.getValueStr(15)));
            jsonObject.put(KEY_VER1_LOUDNESS, (double)this.getValueFloat(39));
            jsonObject.put(KEY_VER1_PEAK, (double)this.getValueFloat(40));
            jsonObject.put("info_id", this.getValueInt(42));
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Nullable
    public MediaBitrateFitterInfo getBitrateFitterInfo() {
        return this.mBitrateFitterInfo;
    }

    @Override
    public Map<String, Object> toMediaInfo() {
        String p2pVerify;
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put(KEY_VER1_FILEID, this.getValueStr(28));
        info.put("media_type", this.getMediatype() == VideoRef.TYPE_VIDEO ? "video" : "audio");
        info.put("file_size", this.getValueLong(12));
        if (1 == EngineGlobalConfig.getInstance().getEnableUseRealBitrate()) {
            if (this.getValueInt(44) > 0) {
                info.put(KEY_VER1_BITRATE, this.getValueInt(44));
            } else {
                info.put(KEY_VER1_BITRATE, this.getValueInt(3));
            }
        } else {
            info.put(KEY_VER1_BITRATE, this.getValueInt(3));
        }
        info.put(KEY_VER1_QUALITY, this.getValueStr(18));
        info.put(KEY_VER1_DEFINITION, this.getValueStr(7));
        info.put("width", this.getValueInt(1));
        info.put("height", this.getValueInt(2));
        info.put("codec", this.getValueStr(8));
        info.put("urls", this.getValueStrArr(16));
        info.put(KEY_VER1_FILE_HASH, this.getValueStr(15));
        if (this.mPreloadGear != null) {
            info.put("preload_gear_data", this.mPreloadGear);
        }
        if ((p2pVerify = this.getValueStr(29)) == null) {
            p2pVerify = "";
        }
        info.put("p2p_crc", TTHelper.encodeUrl(p2pVerify));
        return info;
    }

    @Override
    public int fromMediaInfoJsonObject(JSONObject jsonObject) {
        return -1;
    }

    private void externalizablePallasLabels(String labels) {
        if (labels == null || TextUtils.isEmpty((CharSequence)labels)) {
            return;
        }
        try {
            String preload;
            JSONObject lables = new JSONObject(labels);
            if (lables.has("preloadsize") && (preload = lables.optString("preloadsize")) != null && !TextUtils.isEmpty((CharSequence)preload)) {
                JSONObject preGear;
                this.mPreloadGear = preGear = new JSONObject(preload);
            }
        }
        catch (JSONException err) {
            err.printStackTrace();
        }
    }
}

