/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategy.preload;

import com.ss.ttvideoengine.IPreLoaderItemCallBackListener;
import com.ss.ttvideoengine.PreLoaderItemCallBackInfo;
import com.ss.ttvideoengine.PreloaderURLItem;
import com.ss.ttvideoengine.PreloaderVidItem;
import com.ss.ttvideoengine.PreloaderVideoModelItem;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.source.DirectUrlSource;
import com.ss.ttvideoengine.source.Source;
import com.ss.ttvideoengine.source.VidPlayAuthTokenSource;
import com.ss.ttvideoengine.source.VideoModelSource;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.strategy.preload.PreloadListener;
import com.ss.ttvideoengine.strategy.source.StrategySource;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.List;

public class PreloadSync
implements PreloadListener {
    private static final String TAG = "StrategyPreload";
    private final List<StrategySource> mStrategySources = new ArrayList<StrategySource>();
    private final int mPreloadSize;
    private boolean mStop;
    private PreloadListener mListener;

    public PreloadSync(List<StrategySource> strategySources, int preloadSize) {
        this.mStrategySources.addAll(strategySources);
        this.mPreloadSize = preloadSize;
    }

    public void start() {
        this.preload();
    }

    public void stop() {
        this.mStop = true;
    }

    @Override
    public void onResult(int result, String videoID) {
        this.preloadNext();
        StrategyManager.instance().runOnWorkThread(() -> {
            if (this.mListener != null) {
                this.mListener.onResult(result, videoID);
            }
        });
    }

    private void preloadNext() {
        this.mStrategySources.remove(0);
        this.preload();
    }

    private void preload() {
        if (this.mStop || this.mStrategySources.size() <= 0) {
            return;
        }
        StrategySource strategySource = this.mStrategySources.get(0);
        if (strategySource == null) {
            this.preloadNext();
        } else {
            this.preload(strategySource);
        }
    }

    private void preload(StrategySource source) {
        long preloadSize = (long)this.mPreloadSize * 1024L;
        Source.Type sourceType = source.type();
        String vid = source.vid();
        switch (sourceType) {
            case DIRECT_URL_SOURCE: {
                DirectUrlSource directUrlSource = (DirectUrlSource)source;
                PreloaderURLItem preloaderUrlItem = new PreloaderURLItem(directUrlSource, preloadSize);
                preloaderUrlItem.setCallBackListener(new PreloadCallback(vid, this));
                TTVideoEngine.addTask(preloaderUrlItem);
                break;
            }
            case VID_PLAY_AUTH_TOKEN_SOURCE: {
                VidPlayAuthTokenSource playAuthTokenSource = (VidPlayAuthTokenSource)source;
                Resolution resolution = playAuthTokenSource.resolution();
                PreloaderVidItem preloadVidItem = new PreloaderVidItem((VidPlayAuthTokenSource)source, preloadSize);
                preloadVidItem.setCallBackListener(new PreloadCallback(vid, this, preloadVidItem, resolution));
                TTVideoEngine.addTask(preloadVidItem);
                break;
            }
            case VIDEO_MODEL_SOURCE: {
                VideoModelSource videoModelSource = (VideoModelSource)source;
                PreloaderVideoModelItem preloaderVideoModelItem = new PreloaderVideoModelItem(videoModelSource, preloadSize);
                preloaderVideoModelItem.setCallBackListener(new PreloadCallback(vid, this));
                TTVideoEngine.addTask(preloaderVideoModelItem);
            }
        }
    }

    public void setListener(PreloadListener listener) {
        this.mListener = listener;
    }

    protected static class PreloadCallback
    implements IPreLoaderItemCallBackListener {
        private final String mVideoID;
        private final PreloadListener mPreloadListener;
        private final PreloaderVidItem mPreloaderVidItem;
        private final Resolution mResolution;

        public PreloadCallback(String videoID, PreloadListener preloadListener) {
            this(videoID, preloadListener, null, null);
        }

        public PreloadCallback(String videoID, PreloadListener preloadListener, PreloaderVidItem preloaderVidItem, Resolution resolution) {
            this.mVideoID = videoID;
            this.mPreloadListener = preloadListener;
            this.mPreloaderVidItem = preloaderVidItem;
            this.mResolution = resolution;
        }

        @Override
        public void preloadItemInfo(PreLoaderItemCallBackInfo info) {
            if (info == null) {
                return;
            }
            int key = info.getKey();
            switch (key) {
                case 4: {
                    if (this.mPreloaderVidItem == null) {
                        return;
                    }
                    VideoModel videoModel = info.fetchVideoModel;
                    if (videoModel == null) {
                        return;
                    }
                    this.mPreloaderVidItem.mResolution = TTVideoEngine.findDefaultResolution(info.fetchVideoModel, this.mResolution);
                    break;
                }
                case 2: {
                    TTVideoEngineLog.d(PreloadSync.TAG, "preload result success\uff0cvideoID:" + this.mVideoID);
                    this.mPreloadListener.onResult(2, this.mVideoID);
                    break;
                }
                case 3: {
                    TTVideoEngineLog.d(PreloadSync.TAG, "preload result failed, videoID:" + this.mVideoID);
                    this.mPreloadListener.onResult(3, this.mVideoID);
                    break;
                }
                case 5: {
                    TTVideoEngineLog.d(PreloadSync.TAG, "preload result canceled, videoID:" + this.mVideoID);
                    this.mPreloadListener.onResult(5, this.mVideoID);
                    break;
                }
            }
        }
    }
}

