/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.Nullable;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.DataLoaderListener;
import com.ss.ttvideoengine.DataLoaderListener2;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.utils.DataLoaderCDNLog;
import com.ss.ttvideoengine.utils.Error;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

class DataLoaderListenerWrapper
implements DataLoaderListener {
    private DataLoaderListener mListener;
    private final CopyOnWriteArrayList<DataLoaderListener2> mListener2s = new CopyOnWriteArrayList();

    DataLoaderListenerWrapper() {
    }

    void setListener(DataLoaderListener listener) {
        this.mListener = listener;
    }

    void addListener(DataLoaderListener2 listener) {
        this.mListener2s.addIfAbsent(listener);
    }

    void removeListener(DataLoaderListener2 listener) {
        this.mListener2s.remove(listener);
    }

    void clearListeners() {
        this.mListener = null;
        this.mListener2s.clear();
    }

    @Override
    @Nullable
    public String apiStringForFetchVideoModel(Map<String, String> param, String videoId, Resolution resolution) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            return listener.apiStringForFetchVideoModel(param, videoId, resolution);
        }
        return null;
    }

    @Override
    @Nullable
    public String authStringForFetchVideoModel(String videoId, Resolution resolution) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            return listener.authStringForFetchVideoModel(videoId, resolution);
        }
        return null;
    }

    @Override
    public void dataLoaderError(String videoId, int errorType, Error error) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.dataLoaderError(videoId, errorType, error);
        }
    }

    @Override
    public void onNotify(int what, long code, long parameter, String info) {
        for (DataLoaderListener2 listener2 : this.mListener2s) {
            listener2.onNotify(what, code, parameter, info);
        }
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onNotify(what, code, parameter, info);
        }
    }

    @Override
    public void onLogInfo(int what, String logType, JSONObject log) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onLogInfo(what, logType, log);
        }
    }

    @Override
    public void onTaskProgress(DataLoaderHelper.DataLoaderTaskProgressInfo progressInfo) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onTaskProgress(progressInfo);
        }
    }

    @Override
    public void onNotifyCDNLog(DataLoaderCDNLog log) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onNotifyCDNLog(log);
        }
    }

    @Override
    public void onNotifyCDNLog(JSONObject log) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onNotifyCDNLog(log);
        }
    }

    @Override
    @Nullable
    public String getCheckSumInfo(String fileKey) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            return listener.getCheckSumInfo(fileKey);
        }
        return null;
    }

    @Override
    public boolean loadLibrary(String name) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            return listener.loadLibrary(name);
        }
        return false;
    }

    @Override
    public void onLogInfoToMonitor(int what, String logType, JSONObject log) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onLogInfoToMonitor(what, logType, log);
        }
    }

    @Override
    public void onLoadProgress(DataLoaderHelper.DataLoaderTaskLoadProgress loadProgress) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            listener.onLoadProgress(loadProgress);
        }
    }

    @Override
    @Nullable
    public HashMap<String, String> getCustomHttpHeaders(String url) {
        DataLoaderListener listener = this.mListener;
        if (listener != null) {
            return listener.getCustomHttpHeaders(url);
        }
        return null;
    }
}

