/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.Nullable;
import com.ss.ttvideoengine.IPreLoaderItemCallBackListener;
import com.ss.ttvideoengine.PreLoaderItemCallBackInfo;
import com.ss.ttvideoengine.PreloaderFilePathListener;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.source.VideoModelSource;
import com.ss.ttvideoengine.utils.Error;
import java.util.Map;

public class PreloaderVideoModelItem {
    public IVideoModel mVideoModel = null;
    public Resolution mResolution = Resolution.Undefine;
    public long mPreloadSize = 0L;
    public float mPreloadMilliSecond = 0.0f;
    public long mTimePreloadLowerLimitSize = 0L;
    public long mTimePreloadUpperLimitSize = 0L;
    public long mPreloadMilliSecondOffset;
    public long mAudioHeaderExtraSize;
    public long mAudioPacketExtraOffset;
    public long mVideoHeaderExtraSize;
    public long mVideoPacketExtraOffset;
    public boolean mForbidP2p = false;
    public int mGearStrategyEnabled = 0;
    public Map<Integer, String> mParams = null;
    public String mTag = "";
    public String mSubTag = "";
    private int mPriorityLevel = 0;
    private PreloaderFilePathListener mFilePathListener = null;
    @Nullable
    private IPreLoaderItemCallBackListener mCallBackListener = null;

    public PreloaderVideoModelItem(VideoModelSource source, long preloadSize) {
        this.mVideoModel = source.videoModel();
        this.mResolution = source.resolution();
        this.mPreloadSize = preloadSize;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, long preloadSize, PreloaderFilePathListener listener) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mFilePathListener = listener;
    }

    public PreloaderVideoModelItem(IVideoModel videoModel, Resolution resolution, long preloadSize, PreloaderFilePathListener listener) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mFilePathListener = listener;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, long preloadSize, boolean forbidP2p) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mForbidP2p = forbidP2p;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, long preloadSize, long preloadMilliSecondOffset, long preloadMilliSecond, boolean forbidP2p) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mPreloadMilliSecondOffset = preloadMilliSecondOffset;
        this.mPreloadMilliSecond = preloadMilliSecond;
        this.mForbidP2p = forbidP2p;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, long preloadSize, long preloadMilliSecondOffset, boolean forbidP2p) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadSize = preloadSize;
        this.mPreloadMilliSecondOffset = preloadMilliSecondOffset;
        this.mForbidP2p = forbidP2p;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, float preloadMilliSecond, long timePreloadLowerLimitSize, long timePreloadUpperLimitSize) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadMilliSecond = preloadMilliSecond;
        this.mTimePreloadLowerLimitSize = timePreloadLowerLimitSize;
        this.mTimePreloadUpperLimitSize = timePreloadUpperLimitSize;
    }

    public PreloaderVideoModelItem(VideoModel videoModel, Resolution resolution, long preloadMilliSecondOffset, float preloadMilliSecond, long timePreloadLowerLimitSize, long timePreloadUpperLimitSize) {
        this.mVideoModel = videoModel;
        this.mResolution = resolution;
        this.mPreloadMilliSecondOffset = preloadMilliSecondOffset;
        this.mPreloadMilliSecond = preloadMilliSecond;
        this.mTimePreloadLowerLimitSize = timePreloadLowerLimitSize;
        this.mTimePreloadUpperLimitSize = timePreloadUpperLimitSize;
    }

    public void setFilePathListener(PreloaderFilePathListener listener) {
        this.mFilePathListener = listener;
    }

    public void setCallBackListener(@Nullable IPreLoaderItemCallBackListener listener) {
        this.mCallBackListener = listener;
    }

    @Nullable
    public IPreLoaderItemCallBackListener getCallBackListener() {
        return this.mCallBackListener;
    }

    PreloaderFilePathListener getFilePathListener() {
        return this.mFilePathListener;
    }

    public void setPriorityLevel(int priorityLevel) {
        this.mPriorityLevel = priorityLevel;
    }

    public int getPriorityLevel() {
        return this.mPriorityLevel;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setSubTag(String subTag) {
        this.mSubTag = subTag;
    }

    public String getSubTag() {
        return this.mSubTag;
    }

    public void _notifyError(int errorCode) {
        if (this.getCallBackListener() != null) {
            PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(3);
            callBackInfo.preloadError = new Error("kTTVideoErrorDomainDataLoaderPreload", errorCode);
            this.getCallBackListener().preloadItemInfo(callBackInfo);
        }
    }
}

