/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.text.TextUtils;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictor;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorRecordOld;
import com.bytedance.vcloud.networkpredictor.SpeedPredictorResultCollection;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TestSpeedListener;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;

public class TTTestSpeedListener
implements TestSpeedListener {
    private static final String TAG = "TTVideoEngine";
    private static final int TYPE_VIDEO = 0;
    private static final int TYPE_AUDIO = 1;
    public float mAverageDownloadSpeed = 0.0f;
    public float mAveragePredictSpeed = 0.0f;
    public int mSpeedAverageCount = 0;
    private WeakReference<TTVideoEngine> engineWeakReference;
    private ISpeedPredictor mPredictor;
    private long lastSampleTimestamp = 0L;
    private ISpeedPredictor mAbrPredictor;

    TTTestSpeedListener(TTVideoEngine engine, ISpeedPredictor predictor, ISpeedPredictor abrPredictor) {
        this.engineWeakReference = new WeakReference<TTVideoEngine>(engine);
        this.mPredictor = predictor;
        this.mAbrPredictor = abrPredictor;
    }

    @Override
    public void onNotify(int what, long code, long parameter, String info, String logType, String extraInfoJsonStr) {
        ISpeedPredictor abrPredictor;
        TTVideoEngineLog.d(TAG, String.format(Locale.US, "speed notify, what:%d, code:%d, para:%d, inf:%s, extraInfoJsonStr:%s", what, code, parameter, info, extraInfoJsonStr));
        TTVideoEngine engine = (TTVideoEngine)this.engineWeakReference.get();
        if (engine == null) {
            return;
        }
        if (what == 2) {
            engine.getLogger().updateGlobalNetworkSpeed(code, parameter, -1);
        }
        if ((abrPredictor = this.mAbrPredictor) == null) {
            return;
        }
        if (what == 2) {
            SpeedPredictorRecordOld speedRecord = new SpeedPredictorRecordOld();
            speedRecord.setSteamId(info);
            speedRecord.setBytes(code);
            speedRecord.setTime(parameter);
            long rtt = this._getTcpInfoRtt(extraInfoJsonStr);
            long lastRecvDate = this._getIntInfoFromtcpInfoJson(extraInfoJsonStr, "tcpLastRecvDate");
            speedRecord.setTcpInfoRtt(rtt);
            speedRecord.setLastRecvDate(lastRecvDate);
            String protocol = this._getProtocolFromJson(extraInfoJsonStr);
            speedRecord.setProtocol(protocol);
            boolean isVideo = true;
            if (!TextUtils.isEmpty((CharSequence)logType) && logType.equals("audio")) {
                isVideo = false;
            }
            speedRecord.setTrackType(isVideo ? 0 : 1);
            speedRecord.setTimestamp(System.currentTimeMillis());
            if (speedRecord.getTime() != 0L) {
                DecimalFormat speedFormat = new DecimalFormat("#.000000000");
                double speed = (double)speedRecord.getBytes() / (double)speedRecord.getTime();
                String speedStr = speedFormat.format(speed);
                TTVideoEngineLog.d(TAG, String.format(Locale.US, "[ABR]: speedRecord:%s", speedStr));
            }
            Map<String, Integer> streamidMediaTypeMap = this._getCurrentPlaybackStreamId();
            this._streamInfoMapAppendOtherInfo(streamidMediaTypeMap);
            abrPredictor.update(speedRecord, streamidMediaTypeMap);
            ++this.mSpeedAverageCount;
            Map<String, String> downloadVideoSpeedInfo = abrPredictor.getDownloadSpeed(0);
            float predictVideoSpeed = abrPredictor.getPredictSpeed(0);
            Map<String, String> downloadAudioSpeedInfo = abrPredictor.getDownloadSpeed(1);
            float predictAudioSpeed = abrPredictor.getPredictSpeed(1);
            StringBuffer streamVideoId = new StringBuffer(" ");
            StringBuffer streamAudioId = new StringBuffer(" ");
            HashMap<String, String> extraVideoMap = new HashMap<String, String>();
            HashMap<String, String> extraAudioMap = new HashMap<String, String>();
            float downVideoSpeedf = this._getDownSpeed(downloadVideoSpeedInfo, streamVideoId, extraVideoMap);
            float downAudioSpeedf = this._getDownSpeed(downloadAudioSpeedInfo, streamAudioId, extraAudioMap);
            long timestamp = System.currentTimeMillis();
            long timeInterval = timestamp - this.lastSampleTimestamp;
            if (this.lastSampleTimestamp == 0L) {
                timeInterval = 0L;
            }
            this.lastSampleTimestamp = timestamp;
            if (downVideoSpeedf > 0.0f && this.mSpeedAverageCount > 0) {
                this.mAverageDownloadSpeed += (downVideoSpeedf - this.mAverageDownloadSpeed) / (float)this.mSpeedAverageCount;
            }
            if (predictVideoSpeed > 0.0f && this.mSpeedAverageCount > 0) {
                this.mAveragePredictSpeed += (predictVideoSpeed - this.mAveragePredictSpeed) / (float)this.mSpeedAverageCount;
            }
            engine.getLogger().updateNetworkSpeedPredictorSampleValue(streamVideoId.toString(), streamAudioId.toString(), downVideoSpeedf, downAudioSpeedf, predictVideoSpeed, predictAudioSpeed, timeInterval, extraVideoMap, extraAudioMap);
            engine.getLogger().setIsMultiDimensionsInput(1);
            engine.getLogger().setIsMultiDimensionsOut(0);
        }
    }

    @Override
    public void onNotify(int what, String info) {
        ISpeedPredictor abrPredictor;
        TTVideoEngineLog.d(TAG, String.format(Locale.US, "speed notify, what:%d, info:%s", what, info));
        TTVideoEngine engine = (TTVideoEngine)this.engineWeakReference.get();
        if (engine == null) {
            return;
        }
        if (what == 2) {
            engine.getLogger().updateMultiNetworkSpeed(info);
        }
        if ((abrPredictor = this.mAbrPredictor) == null || TTVideoEngine.getSpeedPredictorInputType() != 2) {
            return;
        }
        if (what == 2) {
            Map<String, Integer> streamidMediaTypeMap = this._getCurrentPlaybackStreamId();
            this._streamInfoMapAppendOtherInfo(streamidMediaTypeMap);
            abrPredictor.update(info, streamidMediaTypeMap);
            if (info != null) {
                TTVideoEngineLog.d(TAG, String.format(Locale.US, "[ABR]: speedRecordsJson:%s", info));
            }
            ++this.mSpeedAverageCount;
            Map<String, String> downloadVideoSpeedInfo = abrPredictor.getDownloadSpeed(0);
            float predictVideoSpeed = abrPredictor.getPredictSpeed(0);
            Map<String, String> downloadAudioSpeedInfo = abrPredictor.getDownloadSpeed(1);
            float predictAudioSpeed = abrPredictor.getPredictSpeed(1);
            StringBuffer streamVideoId = new StringBuffer(" ");
            StringBuffer streamAudioId = new StringBuffer(" ");
            HashMap<String, String> extraVideoMap = new HashMap<String, String>();
            HashMap<String, String> extraAudioMap = new HashMap<String, String>();
            float downVideoSpeedf = this._getDownSpeed(downloadVideoSpeedInfo, streamVideoId, extraVideoMap);
            float downAudioSpeedf = this._getDownSpeed(downloadAudioSpeedInfo, streamAudioId, extraAudioMap);
            if (downVideoSpeedf > 0.0f && this.mSpeedAverageCount > 0) {
                this.mAverageDownloadSpeed += (downVideoSpeedf - this.mAverageDownloadSpeed) / (float)this.mSpeedAverageCount;
            }
            if (predictVideoSpeed > 0.0f && this.mSpeedAverageCount > 0) {
                this.mAveragePredictSpeed += (predictVideoSpeed - this.mAveragePredictSpeed) / (float)this.mSpeedAverageCount;
            }
            SpeedPredictorResultCollection downloadSpeedCollection = abrPredictor.getMultidimensionalDownloadSpeedsObj();
            SpeedPredictorResultCollection predictSpeedCollection = abrPredictor.getMultidimensionalPredictSpeedsObj();
            long timestamp = System.currentTimeMillis();
            long timeInterval = timestamp - this.lastSampleTimestamp;
            if (this.lastSampleTimestamp == 0L) {
                timeInterval = 0L;
            }
            this.lastSampleTimestamp = timestamp;
            if (engine.getIntOption(525) == 0) {
                TTVideoEngineLog.d(TAG, String.format(Locale.US, "[SPEEDPREDICT] use sing predictor data outing", new Object[0]));
                engine.getLogger().updateNetworkSpeedPredictorSampleValue(streamVideoId.toString(), streamAudioId.toString(), downVideoSpeedf, downAudioSpeedf, predictVideoSpeed, predictAudioSpeed, timeInterval, extraVideoMap, extraAudioMap);
                engine.getLogger().setIsMultiDimensionsOut(0);
            } else if (engine.getIntOption(525) == 1) {
                TTVideoEngineLog.d(TAG, String.format(Locale.US, "[SPEEDPREDICT] use multi data outing", new Object[0]));
                if (predictSpeedCollection != null && predictSpeedCollection.getResultCollection() != null && !predictSpeedCollection.getResultCollection().isEmpty()) {
                    engine.getLogger().updateNetworkSpeedPredictorSampleMutiValue(downloadSpeedCollection, predictSpeedCollection, timeInterval);
                }
                engine.getLogger().setIsMultiDimensionsOut(1);
            }
            engine.getLogger().setIsMultiDimensionsInput(2);
        }
    }

    @Override
    public void onNotifyGlobalSpeed(long size, long time, int interval) {
        TTVideoEngine engine = (TTVideoEngine)this.engineWeakReference.get();
        if (engine != null) {
            engine.getLogger().updateGlobalNetworkSpeed(size, time, interval);
        }
    }

    private float _getDownSpeed(Map<String, String> downSpeedInfos, StringBuffer streamId, Map<String, String> extraMap) {
        if (downSpeedInfos != null && downSpeedInfos.size() > 1 && downSpeedInfos.get("download_speed") != null) {
            float downloadSpeed = 0.0f;
            try {
                downloadSpeed = Float.parseFloat(downSpeedInfos.get("download_speed"));
            }
            catch (NumberFormatException e) {
                downloadSpeed = 0.0f;
                TTVideoEngineLog.e(TAG, String.format(Locale.US, "[SPEEDPREDICT] exception %s", e.toString()));
            }
            for (Map.Entry<String, String> it : downSpeedInfos.entrySet()) {
                String itValue = it.getKey();
                if (itValue == null || itValue.equals("stream_id") || itValue.equals("download_speed")) continue;
                extraMap.put(it.getKey(), it.getValue());
            }
            String streamIdTemp = downSpeedInfos.get("stream_id");
            if (streamIdTemp != null && !streamIdTemp.equals("-1")) {
                streamId = streamId.delete(0, streamId.capacity()).append(downSpeedInfos.get("stream_id"));
                return downloadSpeed;
            }
        }
        return 0.0f;
    }

    private Map<String, Integer> _getCurrentPlaybackStreamId() {
        List<VideoInfo> infoList;
        TTVideoEngine engine = (TTVideoEngine)this.engineWeakReference.get();
        if (engine == null) {
            return null;
        }
        IVideoModel videoModel = engine.getIVideoModel();
        if (videoModel == null) {
            return null;
        }
        HashMap<String, Integer> streamIdMediaTypeMap = new HashMap<String, Integer>();
        if (videoModel.hasData() && (infoList = videoModel.getVideoInfoList()) != null && infoList.size() > 0) {
            for (VideoInfo info : infoList) {
                int mediaType = info.getMediatype();
                streamIdMediaTypeMap.put(info.getValueStr(15), mediaType);
            }
        }
        return streamIdMediaTypeMap;
    }

    private void _streamInfoMapAppendOtherInfo(Map<String, Integer> streamidMediaTypeMap) {
        TTVideoEngine engine = (TTVideoEngine)this.engineWeakReference.get();
        if (engine == null || streamidMediaTypeMap == null) {
            return;
        }
        long videoBuf = engine.getLongOption(62);
        long audioBuf = engine.getLongOption(61);
        int maxVideoBuf = engine.getIntOption(0) * 1000;
        int maxAudioBuf = engine.getIntOption(0) * 1000;
        streamidMediaTypeMap.put("playerVideoBufLen", (int)videoBuf);
        streamidMediaTypeMap.put("playerAudioBufLen", (int)audioBuf);
        streamidMediaTypeMap.put("playerVideoMaxBufLen", maxVideoBuf);
        streamidMediaTypeMap.put("playerAudioMaxBufLen", maxAudioBuf);
    }

    private long _getTcpInfoRtt(String jsonStr) {
        if (jsonStr == null || jsonStr.length() <= 0) {
            return -1L;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            JSONObject tcpInfoJsonOb = jsonObject.optJSONObject("tcpInfo");
            String tcpRtt = tcpInfoJsonOb.optString("tcpRtt");
            try {
                return Long.parseLong(tcpRtt);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private long _getIntInfoFromtcpInfoJson(String jsonStr, String key) {
        if (jsonStr == null || jsonStr.length() <= 0) {
            return -1L;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            JSONObject tcpInfoJsonOb = jsonObject.optJSONObject("tcpInfo");
            String value = tcpInfoJsonOb.optString(key);
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    private String _getProtocolFromJson(String jsonStr) {
        if (jsonStr == null || jsonStr.length() <= 0) {
            return "unknown";
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            String protocol = jsonObject.optString("protocol");
            return protocol;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

