/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ss.ttvideoengine.model.VideoCacheInfo;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VideoCacheManager {
    private final LinkedHashMap<String, File> cache = new LinkedHashMap(0, 0.75f, true);
    private final LinkedHashMap<String, VideoCacheInfo> keyCache = new LinkedHashMap(0, 0.75f, true);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    public static final int INIT_CACHE = 0;
    public static final int CLEAR_CACHE = 1;
    public static final int CLEAN_IFNECESSARY = 2;
    private static String TAG = "VideoCacheManager";
    public static final int KEY_NUMBER = 4;
    public static final int KEY_NUMBER_ENCRYPTED = 5;
    private static volatile File dir;
    private volatile long maxSize = 0xC800000L;
    private volatile float cleanFactor = 0.3f;
    private volatile boolean isInited = false;
    private final ProtectKeyManager protectKeyManager = new ProtectKeyManager();
    private ClearTask clearTask = new ClearTask();

    public static VideoCacheManager getInstance() {
        return VideoCacheManagerSingletonHolder.instance;
    }

    private VideoCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCacheInfoExist(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return false;
        }
        boolean isExist = false;
        if (this.readLock.tryLock()) {
            try {
                isExist = this.keyCache.containsKey(key);
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                this.readLock.unlock();
            }
        }
        return isExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoCacheInfo getCacheInfo(String key) {
        if (key == null) {
            return null;
        }
        VideoCacheInfo info = null;
        if (this.readLock.tryLock()) {
            try {
                info = this.keyCache.get(key);
                if (info != null) {
                    info.spadeaKey = TTHelper.customBase64Decode(info.spadeaKey);
                    String[] keys = this.extractKeys(info.fileName);
                    if (!this.isValidKeys(keys) || !this.checkMD5(info.filePath, keys[2], Long.parseLong(keys[3]))) {
                        TTVideoEngineLog.d(TAG, String.format("get info err", key));
                        info = null;
                    }
                }
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                this.readLock.unlock();
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheInfo(String key, String path) {
        if (this.writeLock.tryLock()) {
            try {
                String[] keys = this.extractKeys(key);
                if (this.isValidKeys(keys)) {
                    String infoKey = String.format("%s_%s", keys[0], keys[1]);
                    String fileKey = String.format("%s_%s_%s_%s", keys[0], keys[1], keys[2], keys[3]);
                    String spadeaKey = null;
                    if (keys.length == 5) {
                        spadeaKey = keys[4];
                    }
                    VideoCacheInfo info = new VideoCacheInfo(path, fileKey, fileKey, spadeaKey);
                    if (!this.keyCache.containsKey(infoKey)) {
                        this.keyCache.put(infoKey, info);
                    }
                }
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public static void setDir(File cacheDir) {
        if (cacheDir != null) {
            dir = cacheDir;
        }
    }

    public void start() {
        this.clearTask.postMessage(this, 0);
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void addProtectKey(String key) {
        if (!TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.i(TAG, String.format("start add protect key:%s", key));
            this.protectKeyManager.addProtectKey(key);
            TTVideoEngineLog.d(TAG, String.format("end add protect key:%s", key));
        }
    }

    public void removeProtectKey(String key) {
        if (!TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.i(TAG, String.format("start remove protect key:%s", key));
            this.protectKeyManager.removeProtectKey(key);
            TTVideoEngineLog.d(TAG, String.format("end remove protect key:%s", key));
        }
    }

    boolean isValidDir(File dir) {
        return dir != null && dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite();
    }

    boolean checkMD5(String filePath, String md5, long fileSize) {
        if (filePath == null || md5 == null || fileSize <= 0L) {
            return false;
        }
        File f = new File(filePath);
        if (!f.exists() || f.length() < fileSize) {
            TTVideoEngineLog.e(TAG, String.format("file not exist or filesize not engough:%s length:%d filesize:%d", filePath, f.length(), fileSize));
            return false;
        }
        MessageDigest digest = null;
        byte[] buffer = new byte[16384];
        try (FileInputStream in = new FileInputStream(f);){
            int len;
            digest = MessageDigest.getInstance("MD5");
            long sumSize = 0L;
            while ((len = (int)(fileSize - sumSize > 16384L ? 16384L : fileSize - sumSize)) != 0) {
                int readLen = in.read(buffer, 0, len);
                if (readLen < 0) {
                    TTVideoEngineLog.e(TAG, String.format("read data err:%s", filePath));
                    break;
                }
                sumSize += (long)readLen;
                digest.update(buffer, 0, readLen);
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            return false;
        }
        BigInteger bigInt = new BigInteger(1, digest.digest());
        String computedMD5 = String.format("%032x", bigInt);
        TTVideoEngineLog.i(TAG, String.format("cache md5:%s compute md5:%s", md5, bigInt.toString(16)));
        if (md5.equals(computedMD5)) {
            TTVideoEngineLog.i(TAG, "md5 match right");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        TTVideoEngineLog.i(TAG, "start init videocachemanager");
        this.writeLock.lock();
        try {
            if (!this.isInited && this.isValidDir(dir)) {
                File[] files = dir.listFiles();
                if (files != null && files.length > 0) {
                    final HashMap<File, Long> fileModifyTime = new HashMap<File, Long>(files.length);
                    ArrayList<File> cacheFiles = new ArrayList<File>(files.length);
                    for (File f : files) {
                        if (!f.isFile()) continue;
                        cacheFiles.add(f);
                        fileModifyTime.put(f, f.lastModified());
                    }
                    Collections.sort(cacheFiles, new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return Long.valueOf(TTHelper.safelyUnbox((Long)fileModifyTime.get(lhs))).compareTo(TTHelper.safelyUnbox((Long)fileModifyTime.get(rhs)));
                        }
                    });
                    for (File f : cacheFiles) {
                        String transformSpaeda;
                        TTVideoEngineLog.i(TAG, String.format("add file:%s", f.getName()));
                        this.cache.put(this.getKey(f), f);
                        String[] keys = this.extractKeys(f);
                        if (!this.isValidKeys(keys)) continue;
                        String infoKey = String.format("%s_%s", keys[0], keys[1]);
                        String fileKey = String.format("%s_%s_%s_%s", keys[0], keys[1], keys[2], keys[3]);
                        String spadeaKey = null;
                        if (keys.length == 5) {
                            spadeaKey = keys[4];
                        }
                        String temFilePath = f.getCanonicalPath();
                        if (spadeaKey != null && spadeaKey.length() > 0 && (transformSpaeda = TTHelper.customBase64Encode(spadeaKey)) != null && !transformSpaeda.equals(spadeaKey)) {
                            temFilePath = temFilePath.replace(spadeaKey, transformSpaeda);
                            f.renameTo(new File(temFilePath));
                            spadeaKey = transformSpaeda;
                        }
                        VideoCacheInfo info = new VideoCacheInfo(temFilePath, fileKey, fileKey, spadeaKey);
                        this.keyCache.put(infoKey, info);
                    }
                }
                this.isInited = true;
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.writeLock.unlock();
        }
        TTVideoEngineLog.d(TAG, "end init videocachemanager");
    }

    private String getKey(File f) {
        return f.getName();
    }

    private String[] extractKeys(File f) {
        String fileName = f.getName();
        if (fileName == null) {
            return null;
        }
        return this.extractKeys(fileName);
    }

    private String[] extractKeys(String str) {
        if (str == null) {
            return null;
        }
        String[] str1 = str.split("\\.");
        if (str1 != null && str1.length > 0) {
            return str1[0].split("_");
        }
        return null;
    }

    boolean isValidKeys(String[] keys) {
        if (keys == null || keys.length != 4 && keys.length != 5) {
            return false;
        }
        for (String key : keys) {
            if (key != null) continue;
            return false;
        }
        return true;
    }

    void clear() {
        TTVideoEngineLog.d(TAG, "start clear all cache");
        this.trimSize(0L);
        TTVideoEngineLog.d(TAG, "end clear all cache");
    }

    void cleanIfNecessary() {
        TTVideoEngineLog.d(TAG, "start clean file maxSize: " + this.maxSize);
        this.trimSize(this.maxSize);
        TTVideoEngineLog.d(TAG, "end clean file maxSize: " + this.maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSize(long maxSize) {
        HashSet<String> removed = null;
        HashSet<String> keysRemoved = null;
        HashSet<File> filesToDelete = new HashSet<File>();
        TTVideoEngineLog.d(TAG, "start trim");
        this.writeLock.lock();
        try {
            long size = 0L;
            for (Map.Entry<String, File> entry : this.cache.entrySet()) {
                size += entry.getValue().length();
            }
            TTVideoEngineLog.d(TAG, "current file size: " + size + ", maxsize: " + maxSize);
            if (size <= maxSize) {
                return;
            }
            long sizeAfterClear = (long)((float)maxSize * this.cleanFactor);
            removed = new HashSet<String>();
            keysRemoved = new HashSet<String>();
            for (Map.Entry<String, File> entry : this.cache.entrySet()) {
                File f = entry.getValue();
                if (f != null && f.exists()) {
                    if (!this.protectKeyManager.containsKey(this.getKey(f))) {
                        long len = f.length();
                        File tmpFile = new File(f.getAbsolutePath() + "-tmp");
                        if (f.renameTo(tmpFile)) {
                            filesToDelete.add(tmpFile);
                            size -= len;
                            removed.add(entry.getKey());
                            String[] keys = this.extractKeys(f);
                            if (this.isValidKeys(keys)) {
                                keysRemoved.add(String.format("%s_%s", keys[0], keys[1]));
                            }
                        }
                    }
                } else {
                    removed.add(entry.getKey());
                }
                if (size > sizeAfterClear) continue;
                break;
            }
            for (String key : removed) {
                this.cache.remove(key);
            }
            for (String key : keysRemoved) {
                this.keyCache.remove(key);
            }
        }
        catch (Throwable t) {
            TTVideoEngineLog.d(t);
        }
        finally {
            this.writeLock.unlock();
        }
        for (File f : filesToDelete) {
            try {
                TTVideoEngineLog.d(TAG, String.format("delete file name:%s", f.getName()));
                f.delete();
            }
            catch (Throwable ignored) {
                TTVideoEngineLog.d(ignored);
            }
        }
        TTVideoEngineLog.d(TAG, "end trim");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkCacheFileIntegrity(String filePath, String md5, long fileSize) {
        File file = new File(filePath);
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        if (file.length() < fileSize) {
            return false;
        }
        MessageDigest digest = null;
        long readFileSize = fileSize;
        int frameSize = 10240;
        int readBufferSize = readFileSize < (long)frameSize ? (int)readFileSize : frameSize;
        int readSize = 0;
        String result = null;
        FileInputStream in = null;
        try {
            digest = MessageDigest.getInstance("MD5");
            in = new FileInputStream(file);
            byte[] buffer = new byte[readBufferSize];
            boolean done = false;
            while (!done) {
                int dataLength = readFileSize < (long)readBufferSize ? (int)readFileSize : readBufferSize;
                readSize = in.read(buffer, 0, dataLength);
                digest.update(buffer, 0, readSize);
                if (readFileSize <= (long)readSize) {
                    done = true;
                    continue;
                }
                readFileSize -= (long)readSize;
            }
            byte[] digestBytes = digest.digest();
            StringBuilder stringBuilder = new StringBuilder("");
            for (byte digestByte : digestBytes) {
                int v = digestByte & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() < 2) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            result = stringBuilder.toString();
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
        }
        if (result != null) {
            return result.equals(md5);
        }
        return false;
    }

    private static class ClearTask {
        private HandlerThread mHandlerThread;
        private Handler mHandler;

        public ClearTask() {
            try {
                this.mHandlerThread = new HandlerThread("clearCacheThread");
                this.mHandlerThread.start();
                this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                    public void handleMessage(@NonNull Message msg) {
                        try {
                            VideoCacheManager manager = (VideoCacheManager)msg.obj;
                            switch (msg.what) {
                                case 0: {
                                    manager.init();
                                    break;
                                }
                                case 1: {
                                    manager.clear();
                                    break;
                                }
                                case 2: {
                                    manager.cleanIfNecessary();
                                    break;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Throwable e) {
                this.mHandlerThread.quit();
                this.mHandlerThread = null;
                this.mHandler = null;
            }
        }

        public void postMessage(VideoCacheManager manager, int code) {
            if (this.mHandler != null && this.mHandlerThread != null) {
                Message message = new Message();
                message.what = code;
                message.obj = manager;
                this.mHandler.sendMessage(message);
            }
        }
    }

    private static final class ProtectKeyManager {
        private final Map<String, Integer> protectKeys = new HashMap<String, Integer>();

        private ProtectKeyManager() {
        }

        synchronized void addProtectKey(String key) {
            if (!TextUtils.isEmpty((CharSequence)key)) {
                Integer count = this.protectKeys.get(key);
                if (count == null) {
                    this.protectKeys.put(key, 1);
                } else {
                    count = count + 1;
                    this.protectKeys.put(key, count);
                }
            }
        }

        synchronized void removeProtectKey(String key) {
            Integer count;
            if (!TextUtils.isEmpty((CharSequence)key) && (count = this.protectKeys.get(key)) != null) {
                if (count == 1) {
                    this.protectKeys.remove(key);
                } else {
                    count = count - 1;
                    this.protectKeys.put(key, count);
                }
            }
        }

        synchronized boolean containsKey(String key) {
            if (!TextUtils.isEmpty((CharSequence)key)) {
                return this.protectKeys.containsKey(key);
            }
            return false;
        }
    }

    private static class VideoCacheManagerSingletonHolder {
        private static final VideoCacheManager instance = new VideoCacheManager();

        private VideoCacheManagerSingletonHolder() {
        }
    }
}

