/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.database;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.ss.ttvideoengine.database.DBHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class VideoModelDBManager {
    private static final String TAG = "VideoModelDBManager";
    private static final String NAME = "videomodel";
    private static final int MAX_CACHE_SIZE = 200;
    private static final int MIN_CACHE_SIZE = 20;
    private static SQLiteDatabase mDB;
    private static VideoModelDBManager mInstance;
    private static int mCacheSize;
    private static boolean sEnableSizeLimit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoModelDBManager getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<VideoModelDBManager> clazz = VideoModelDBManager.class;
        synchronized (VideoModelDBManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new VideoModelDBManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VideoModelDBManager(Context context) {
        if (context == null) {
            return;
        }
        DBHelper helper = DBHelper.getInstance(context);
        if (helper != null) {
            try {
                mDB = helper.getWritableDatabase();
                if (mDB != null) {
                    String order = String.format("CREATE TABLE IF NOT EXISTS %s(vid TEXT PRIMARY KEY,videomodel TEXT,time INTEGER)", NAME);
                    mDB.execSQL(order);
                }
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
            }
        }
    }

    public static void setCacheSize(int cacheSize) {
        mCacheSize = cacheSize;
    }

    public static void setEnableSizeLimit(boolean enableSizeLimit) {
        sEnableSizeLimit = enableSizeLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String vid, String videomodelStr) {
        if (mDB == null || TextUtils.isEmpty((CharSequence)videomodelStr) || TextUtils.isEmpty((CharSequence)vid)) {
            return;
        }
        TTVideoEngineLog.i(TAG, "insert vid:" + vid + " videomodel:" + videomodelStr);
        boolean sqlExcHappen = false;
        try {
            mDB.beginTransaction();
            try {
                String order = String.format("REPLACE INTO %s VALUES ('%s','%s',%d)", NAME, vid, videomodelStr, System.currentTimeMillis());
                mDB.execSQL(order);
                if (sEnableSizeLimit) {
                    String limitsizeOrder = String.format("DELETE FROM %s WHERE vid IN (SELECT vid FROM %s ORDER BY time DESC LIMIT -1 OFFSET %d)", NAME, NAME, mCacheSize);
                    mDB.execSQL(limitsizeOrder);
                }
                mDB.setTransactionSuccessful();
            }
            catch (SQLException e) {
                TTVideoEngineLog.d(e);
                sqlExcHappen = true;
            }
            catch (IllegalStateException e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                mDB.endTransaction();
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            sqlExcHappen = true;
        }
        if (sqlExcHappen) {
            int curCount = VideoModelDBManager.count();
            TTVideoEngineLog.d(TAG, "sqlExcHappen count " + curCount);
            if (curCount > 0 && (mCacheSize = curCount - 10) < 20) {
                mCacheSize = 20;
            }
        }
    }

    public static void delete(String vid) {
        if (mDB == null) {
            return;
        }
        try {
            mDB.beginTransaction();
            try {
                String order = String.format("DELETE FROM %s WHERE vid='%s'", NAME, vid);
                mDB.execSQL(order);
                mDB.setTransactionSuccessful();
            }
            catch (Exception e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                mDB.endTransaction();
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        TTVideoEngineLog.i(TAG, "deleted vid:" + vid);
    }

    public static CacheInfo query(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid) || mDB == null) {
            return null;
        }
        CacheInfo info = null;
        try {
            String order = String.format("SELECT * FROM %s WHERE vid='%s'", NAME, vid);
            Cursor c = mDB.rawQuery(order, null);
            info = new CacheInfo();
            info.vid = vid;
            if (c.moveToFirst()) {
                info.videoModelStr = c.getString(c.getColumnIndex(NAME));
                info.time = c.getLong(c.getColumnIndex("time"));
            }
            c.close();
            TTVideoEngineLog.d(TAG, "query vid:" + vid + " videomodel:" + info.videoModelStr);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        return info;
    }

    public static int count() {
        if (mDB == null) {
            return -1;
        }
        int count = 0;
        try {
            String order = String.format("SELECT COUNT(*) FROM %s", NAME);
            Cursor c = mDB.rawQuery(order, null);
            if (c.moveToFirst()) {
                count = (int)c.getLong(0);
            }
            c.close();
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        TTVideoEngineLog.d(TAG, "count:" + count);
        return count;
    }

    public static void clear() {
        if (mDB == null) {
            return;
        }
        try {
            mDB.beginTransaction();
            try {
                String order = String.format("DELETE FROM %s ", NAME);
                mDB.execSQL(order);
                mDB.setTransactionSuccessful();
                TTVideoEngineLog.i(TAG, "all cleared");
            }
            catch (Exception e) {
                TTVideoEngineLog.d(e);
            }
            finally {
                mDB.endTransaction();
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }

    static {
        mCacheSize = 200;
        sEnableSizeLimit = true;
    }

    public static class CacheInfo {
        public long time = 0L;
        public String videoModelStr = null;
        public String vid = null;
    }
}

