/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.download;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.database.KVDBManager;
import com.ss.ttvideoengine.download.DownloadTask;
import com.ss.ttvideoengine.download.DownloadURLTask;
import com.ss.ttvideoengine.download.DownloadVidTask;
import com.ss.ttvideoengine.download.IDownloaderListener;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Collections;
import org.json.JSONObject;

public class Downloader {
    private static final String TAG = "TTVideoEngine.Downloader";
    private static final String tasksIndex = "TTVideoEngine_download_index_v01";
    private static final String dataBaseName = "TTVideoEngine_download_database_v01";
    private static final int MESSAGE_PROGRESS = 0;
    private static final int MESSAGE_FAIL = 1;
    private static final int MESSAGE_SUSPEND = 2;
    private static final int MESSAGE_COMPLETE = 3;
    private static final int MESSAGE_LOADTASKS = 4;
    private static final int MESSAGE_OPEN_DB_FAIL = 5;
    private static final int PRIVATE_MESSAGE_LOADALLTASK = 10;
    private static final int PRIVATE_MESSAGE_SAVETASK = 11;
    private static final long MIN_FREE_SIZE = 0x40000000L;
    private static final Downloader ourInstance = new Downloader();
    private IDownloaderListener listener = null;
    private long maxDownloadOperationCount = 1L;
    private long limitFreeDiskSize = 0x40000000L;
    private long maxTaskId = -1L;
    private ArrayList<DownloadTask> allTasks = null;
    private ArrayList<DownloadTask> waitingTasks = null;
    private ArrayList<DownloadTask> runingTasks = null;
    private ArrayList<DownloadTask> temLoadedTasks = null;
    private ArrayList<Long> indexArray = null;
    private boolean readAllTask = false;
    private boolean loadData = false;
    private Handler mHandler = null;
    private Context mContext = null;
    private KVDBManager dbObject = null;
    private TaskThread taskThread = new TaskThread();

    public static Downloader getInstance() {
        return ourInstance;
    }

    private Downloader() {
        this.allTasks = new ArrayList();
        this.indexArray = new ArrayList();
        this.waitingTasks = new ArrayList();
        this.runingTasks = new ArrayList();
    }

    public void loadAllTasks(Context context) {
        if (context == null) {
            TTVideoEngineLog.e(TAG, "[downloader] context == null");
            if (this.listener != null) {
                this.listener.downloaderDidLoadAllTask(this, null, new Error("kTTVideoErrorDomainDownload", -9999, 0, "context is null"));
            }
            return;
        }
        if (!DataLoaderHelper.getDataLoader().isRunning()) {
            TTVideoEngineLog.e(TAG, "[downloader] need start dataloader first.");
            if (this.listener != null) {
                this.listener.downloaderDidLoadAllTask(this, null, new Error("kTTVideoErrorDomainDownload", -9946, 0, "need start medialoader"));
            }
            return;
        }
        if (this.readAllTask) {
            if (this.listener != null) {
                ArrayList<DownloadTask> temArray = new ArrayList<DownloadTask>(this.allTasks);
                this.listener.downloaderDidLoadAllTask(this, temArray, null);
            }
        } else if (!this.loadData) {
            this.loadData = true;
            this.mContext = context;
            this.initHandle();
            ArrayList<Object> temObj = new ArrayList<Object>();
            temObj.add(this);
            this.taskThread.postMessage(temObj, 10);
        }
    }

    @Nullable
    public DownloadURLTask urlTask(String[] urls, String key, @Nullable String videoId, DownloadTask.EncryptVersion encryptVersion) {
        if (!FeatureManager.hasPermission()) {
            return null;
        }
        if (urls == null || urls.length < 1 || TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.e(TAG, "[downloader] urls or key is invalid.");
            return null;
        }
        ArrayList<String> temArray = new ArrayList<String>();
        Collections.addAll(temArray, urls);
        DownloadURLTask urlTask = DownloadURLTask.taskItem(key, temArray, videoId, encryptVersion);
        if (urlTask != null && (urlTask = (DownloadURLTask)this.addTask(urlTask)) != null) {
            urlTask.updateUrls(temArray);
        }
        return urlTask;
    }

    @Nullable
    public DownloadURLTask urlTask(String[] urls, String key, @Nullable String videoId) {
        if (!FeatureManager.hasPermission()) {
            return null;
        }
        if (urls == null || urls.length < 1 || TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.e(TAG, "[downloader] urls or key is invalid.");
            return null;
        }
        ArrayList<String> temArray = new ArrayList<String>();
        for (int i = 0; i < urls.length; ++i) {
            temArray.add(urls[i]);
        }
        DownloadURLTask urlTask = DownloadURLTask.taskItem(key, temArray, videoId);
        if (urlTask != null && (urlTask = (DownloadURLTask)this.addTask(urlTask)) != null) {
            urlTask.updateUrls(temArray);
        }
        return urlTask;
    }

    @Nullable
    public DownloadVidTask vidTask(String videoId, Resolution resolution, boolean h265Enable, boolean baseDashEnable, boolean httpsEnable) {
        if (!FeatureManager.hasPermission()) {
            return null;
        }
        String codecType = "h264";
        if (h265Enable) {
            codecType = "h265";
        }
        return this.vidTask(videoId, resolution, codecType, baseDashEnable, httpsEnable);
    }

    @Nullable
    public DownloadVidTask vidTask(String videoId, Resolution resolution, String codecType, boolean baseDashEnable, boolean httpsEnable) {
        return this.vidTask(videoId, resolution, codecType, baseDashEnable, httpsEnable, null);
    }

    @Nullable
    public DownloadVidTask vidTask(String videoId, Resolution resolution, String authToken) {
        return this.vidTask(videoId, resolution, null, false, false, authToken);
    }

    @Nullable
    public DownloadVidTask vidTask(String videoId, Resolution resolution, String codecType, boolean baseDashEnable, boolean httpsEnable, String authToken) {
        if (!FeatureManager.hasPermission()) {
            return null;
        }
        DownloadVidTask vidTask = DownloadVidTask.taskItem(videoId, resolution, codecType, baseDashEnable, httpsEnable, authToken);
        if (vidTask != null && (vidTask = (DownloadVidTask)this.addTask(vidTask)) != null) {
            vidTask.mContext = this.mContext;
        }
        return vidTask;
    }

    @Nullable
    public DownloadVidTask vidTask(VideoModel model, Resolution resolution) {
        if (!FeatureManager.hasPermission()) {
            return null;
        }
        DownloadVidTask vidTask = DownloadVidTask.taskItem(model, resolution);
        if (vidTask != null && (vidTask = (DownloadVidTask)this.addTask(vidTask)) != null) {
            vidTask.mContext = this.mContext;
            vidTask.setVideoModel(model);
        }
        return vidTask;
    }

    public void setListener(IDownloaderListener listener) {
        this.listener = listener;
    }

    @Nullable
    public IDownloaderListener getListener() {
        return this.listener;
    }

    public void setMaxDownloadOperationCount(long maxDownloadOperationCount) {
        this.maxDownloadOperationCount = maxDownloadOperationCount;
    }

    public long getMaxDownloadOperationCount() {
        return this.maxDownloadOperationCount;
    }

    public void setLimitFreeDiskSize(long limitFreeDiskSize) {
        this.limitFreeDiskSize = limitFreeDiskSize;
    }

    public long getLimitFreeDiskSize() {
        return this.limitFreeDiskSize;
    }

    public void resumeAllTasks() {
        if (this.allTasks == null) {
            return;
        }
        for (DownloadTask task : this.allTasks) {
            if (task == null || task.getState() != 3 && task.getState() != 0) continue;
            task.resume();
        }
    }

    public void suspendAllTasks() {
        if (this.allTasks == null) {
            return;
        }
        for (DownloadTask task : this.allTasks) {
            if (task == null) continue;
            task.suspend();
        }
    }

    public void invalidateAndCancelAllTasks() {
        if (this.allTasks == null) {
            return;
        }
        for (DownloadTask task : this.allTasks) {
            if (task == null) continue;
            task.invalidateAndCancel();
        }
    }

    boolean shouldResume(DownloadTask task) {
        if ((long)this.runingTasks.size() < this.maxDownloadOperationCount || this.runingTasks.contains(task) && (task.getState() == 3 || task.getState() == 5)) {
            long freeSize = TTHelper.getFreeSize(this.mContext);
            TTVideoEngineLog.i(TAG, "[downloader] get free size, size = " + freeSize + ", limite = " + this.getLimitFreeDiskSize());
            if (freeSize <= this.getLimitFreeDiskSize()) {
                task.receiveError(new Error("kTTVideoErrorDomainDownload", -9947, 0, "available size is less than 1073741824 M"));
                return false;
            }
            return true;
        }
        task.setState(1);
        if (!this.waitingTasks.contains(task)) {
            this.waitingTasks.add(task);
        }
        TTVideoEngineLog.d(TAG, "[downloader] task is waiting, task info " + task.toString());
        return false;
    }

    boolean suspended(DownloadTask task) {
        if (this.waitingTasks.contains(task)) {
            this.waitingTasks.remove(task);
            TTVideoEngineLog.d(TAG, "[downloader] task is waiting. key =" + task.toString());
            task.setState(3);
        }
        return true;
    }

    void resume(DownloadTask task) {
        if (!FeatureManager.hasPermission()) {
            return;
        }
        if (!this.runingTasks.contains(task)) {
            this.runingTasks.add(task);
        }
        if (this.waitingTasks.contains(task)) {
            TTVideoEngineLog.i(TAG, "[downloader] resume task. is waiting,  task = " + task.toString());
            this.waitingTasks.remove(task);
        }
        if (task.bytesReceived < 1L || task.bytesExpectedToReceive < 1L) {
            return;
        }
        if (this.listener != null) {
            this.listener.downloaderDidResume(this, task, task.bytesReceived, task.bytesExpectedToReceive);
        }
    }

    void completeError(DownloadTask task, Error error) {
        if (task.finished && !task.canceled) {
            TTVideoEngineLog.d(TAG, "[downloader] task did finished, info = " + task.toString());
            return;
        }
        if (error != null) {
            TTVideoEngineLog.d(TAG, "[downloader] error info " + error.toString());
        }
        task.finished = true;
        this.saveTaskInfo(task);
        if (this.listener != null) {
            if (error == null) {
                this.listener.downloaderProgress(this, task, task.bytesExpectedToReceive, task.bytesExpectedToReceive);
            }
            this.listener.downloaderDidComplete(this, task, error);
        }
        TTVideoEngineLog.d(TAG, "[downloader] task complete, task info = " + task.toString());
        this.tryNextWaitingTask(task);
    }

    void cancel(DownloadTask task) {
        this.allTasks.remove(task);
        this.indexArray.remove(task.taskIdentifier);
        this.waitingTasks.remove(task);
        Error error = new Error("kTTVideoErrorDomainDownload", -9995, 0, "task info: " + task.toString());
        task.receiveError(error);
    }

    public void progress(String info) {
        if (TextUtils.isEmpty((CharSequence)info)) {
            return;
        }
        if (this.mHandler != null) {
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)0, (Object)info));
        }
    }

    public void downloadFail(String key, Error error) {
        if (TextUtils.isEmpty((CharSequence)key) || error == null) {
            return;
        }
        if (this.mHandler != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(key);
            objects.add(error);
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)1, objects));
        }
    }

    public void downloadDidSuspened(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.mHandler != null) {
            this.mHandler.sendMessage(Message.obtain((Handler)this.mHandler, (int)2, (Object)key));
        }
    }

    void tryNextWaitingTask(DownloadTask nowTask) {
        if (this.runingTasks.contains(nowTask)) {
            this.runingTasks.remove(nowTask);
        }
        if ((long)this.runingTasks.size() >= this.maxDownloadOperationCount) {
            TTVideoEngineLog.d(TAG, "[downloader] running task count is " + this.runingTasks.size() + " max count is " + this.maxDownloadOperationCount);
            return;
        }
        if (this.waitingTasks.size() < 1) {
            TTVideoEngineLog.d(TAG, "[downloader] waiting task is empty");
            return;
        }
        DownloadTask task = this.waitingTasks.get(0);
        this.waitingTasks.remove(task);
        task.resume();
        TTVideoEngineLog.d(TAG, "[downloader] auto resume waiting task: " + task.toString());
    }

    private DownloadTask addTask(DownloadTask task) {
        task.setDownloader(this);
        try {
            if (this.readAllTask) {
                if (this.allTasks.contains(task)) {
                    int index = this.allTasks.indexOf(task);
                    task = this.allTasks.get(index);
                    task.setDownloader(this);
                }
                ++this.maxTaskId;
                task.taskIdentifier = this.maxTaskId;
                if (this.indexArray.contains(this.maxTaskId)) {
                    TTVideoEngineLog.e(TAG, "[downloader] add task fail. taskIdentifier = " + this.maxTaskId);
                    task = null;
                } else {
                    this.indexArray.add(this.maxTaskId);
                    this.allTasks.add(task);
                }
                this.saveTaskInfo(task);
            }
            TTVideoEngineLog.e(TAG, "[downloader] should load all tasks first.");
            task = null;
            return task;
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            return task;
        }
    }

    private DownloadTask taskForKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        ArrayList<DownloadTask> temArray = new ArrayList<DownloadTask>(this.allTasks);
        DownloadTask temTask = null;
        for (DownloadTask task : temArray) {
            if (task.mediaKeys != null && task.mediaKeys.size() > 0) {
                for (String temKey : task.mediaKeys) {
                    if (!key.equals(temKey)) continue;
                    temTask = task;
                    break;
                }
            }
            if (temTask == null) continue;
            break;
        }
        return temTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<DownloadTask> _loadAllTasks() {
        ArrayList<DownloadTask> temArray = new ArrayList<DownloadTask>();
        try {
            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(tasksIndex, 0);
            String indexV1 = sharedPreferences.getString("index", "");
            ArrayList<String> strArrayV1 = this.stringToStringArray(indexV1);
            String indexV2 = this.dbObject.get("index");
            ArrayList<String> strArrayV2 = this.stringToStringArray(indexV2);
            if (strArrayV1 == null && strArrayV2 == null) {
                return temArray;
            }
            if (indexV1 == null || !indexV1.equals(indexV2)) {
                TTVideoEngineLog.e(TAG, "[downloader] index maybe save fail.");
                if (strArrayV1 == null || strArrayV2 != null) {
                    strArrayV1 = strArrayV1 == null && strArrayV2 != null ? strArrayV2 : (strArrayV2.size() > strArrayV1.size() ? strArrayV2 : strArrayV1);
                }
            }
            TTVideoEngineLog.d(TAG, "[downloader] index array:" + strArrayV1.toString());
            long contentSize = 0L;
            long cacheSize = 0L;
            DownloadTask task = null;
            String temKey = null;
            String temValue = null;
            JSONObject temJson = null;
            DataLoaderHelper.DataLoaderCacheInfo cacheFileInfo = null;
            for (int i = 0; i < strArrayV1.size(); ++i) {
                block29: {
                    task = null;
                    temKey = strArrayV1.get(i);
                    temValue = this.dbObject.get(temKey);
                    temJson = new JSONObject(temValue);
                    if (temJson.optJSONObject("base_json") != null) {
                        String taskType = temJson.optJSONObject("base_json").optString("task_type");
                        if (taskType.equals("url_task")) {
                            task = DownloadURLTask.taskItem();
                        } else if (taskType.equals("vid_task")) {
                            task = DownloadVidTask.taskItem();
                        }
                    }
                    if (task != null) break block29;
                    TTVideoEngineLog.e(TAG, "[downloader] load task fail. taskIdentifier = " + temKey);
                    if (task == null) continue;
                    temArray.add(task);
                    task.setDownloader(this);
                    continue;
                }
                try {
                    task.assignWithJson(temJson);
                    contentSize = 0L;
                    cacheSize = 0L;
                    cacheFileInfo = null;
                    if (task.mediaKeys != null && task.mediaKeys.size() > 0) {
                        for (int j = 0; j < task.mediaKeys.size(); ++j) {
                            String key = task.mediaKeys.get(j);
                            cacheFileInfo = DataLoaderHelper.getDataLoader().getCacheInfo(key);
                            if (cacheFileInfo == null) continue;
                            contentSize += Math.max(cacheFileInfo.mMediaSize, 0L);
                            cacheSize += Math.max(cacheFileInfo.mCacheSizeFromZero, 0L);
                        }
                    }
                    task.bytesExpectedToReceive = contentSize;
                    task.bytesReceived = cacheSize;
                    if (task.getState() == 5) {
                        if (task.bytesReceived > 0L || task.bytesExpectedToReceive > 0L) {
                            if (task.bytesReceived == task.bytesExpectedToReceive) {
                                task.setState(5);
                            } else {
                                task.setState(3);
                            }
                        } else {
                            task.setState(0);
                        }
                    }
                    if (task.canceled && task.error != null) {
                        task.setState(5);
                    }
                    if (task.getState() == 2) {
                        task.setState(3);
                    }
                    if (task.getState() == 1) {
                        if (task.bytesReceived > 0L) {
                            task.setState(3);
                        } else {
                            task.setState(0);
                        }
                    }
                    if (task.getState() == 4) {
                        TTVideoEngineLog.e(TAG, "[downloader] task state invalid. is canceling");
                        task.setState(3);
                    }
                    if (task == null) continue;
                    temArray.add(task);
                }
                catch (Throwable e) {
                    try {
                        TTVideoEngineLog.d(e);
                        task = null;
                        if (task == null) continue;
                        temArray.add(task);
                    }
                    catch (Throwable throwable) {
                        if (task != null) {
                            temArray.add(task);
                            task.setDownloader(this);
                        }
                        throw throwable;
                    }
                    task.setDownloader(this);
                    continue;
                }
                task.setDownloader(this);
                continue;
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        return temArray;
    }

    private void saveTaskInfo(DownloadTask task) {
        SaveInfos infos = new SaveInfos();
        infos.task = task;
        infos.alltasks = new ArrayList<DownloadTask>(this.allTasks);
        ArrayList<Object> temObj = new ArrayList<Object>();
        temObj.add(this);
        temObj.add(infos);
        this.taskThread.postMessage(temObj, 11);
    }

    private void writeIndexesToDisk(ArrayList<DownloadTask> allTasks) {
        ArrayList<Long> stringIndexes = new ArrayList<Long>();
        for (DownloadTask task : allTasks) {
            if (stringIndexes.contains(task.taskIdentifier)) continue;
            stringIndexes.add(task.taskIdentifier);
        }
        Collections.sort(stringIndexes);
        String string = this.indexToString(stringIndexes);
        this.dbObject.save("index", string);
        SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(tasksIndex, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("index", string);
        editor.commit();
    }

    private void writeTask(DownloadTask task, ArrayList<DownloadTask> allTasks) {
        this.writeIndexesToDisk(allTasks);
        String jsonString = task.jsonObject().toString();
        String key = String.valueOf(task.taskIdentifier);
        TTVideoEngineLog.i(TAG, "[downloader] write task. key " + key + " value: " + jsonString);
        if (allTasks.contains(task)) {
            boolean result = this.dbObject.save(key, jsonString);
            if (!result) {
                TTVideoEngineLog.e(TAG, "[downloader] save task fail, videoid = " + task.videoId + " taskIdentifier = " + task.taskIdentifier);
                task.receiveError(new Error("kTTVideoErrorDomainDownload", -9949, -1, jsonString));
            }
        } else {
            boolean result = this.dbObject.remove(key);
            if (!result) {
                TTVideoEngineLog.e(TAG, "[downloader] remove task fail, videoid = " + task.videoId + " taskIdentifier = " + task.taskIdentifier);
                task.receiveError(new Error("kTTVideoErrorDomainDownload", -9949, -1, jsonString));
            }
        }
    }

    @Nullable
    private ArrayList<String> stringToStringArray(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        ArrayList<String> temIndex = null;
        try {
            String[] strs = str.split(",");
            if (strs != null && strs.length > 0) {
                temIndex = new ArrayList<String>();
                for (String indexStr : strs) {
                    if (TextUtils.isEmpty((CharSequence)indexStr)) continue;
                    temIndex.add(indexStr);
                }
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        return temIndex;
    }

    private String indexToString(ArrayList<Long> longArray) {
        if (longArray != null) {
            StringBuilder sb = new StringBuilder(longArray.size());
            for (int i = 0; i < longArray.size(); ++i) {
                sb.append(longArray.get(i));
                if (i >= longArray.size() - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private void initHandle() {
        if (this.mHandler != null) {
            return;
        }
        final Downloader downloader = this;
        this.mHandler = new Handler(TTHelper.getLooper()){

            public void handleMessage(@NonNull Message msg) {
                block35: {
                    try {
                        super.handleMessage(msg);
                        if (msg.what == 1) {
                            ArrayList objects;
                            String key;
                            DownloadTask temTask;
                            if (msg.obj instanceof ArrayList && (temTask = Downloader.this.taskForKey(key = (String)(objects = (ArrayList)msg.obj).get(0))) != null) {
                                Error error = (Error)objects.get(1);
                                if (!temTask._shouldRetry(error)) {
                                    temTask.setState(5);
                                }
                                temTask.receiveError(error);
                                if (temTask.mediaKeys != null && temTask.mediaKeys.size() > 0) {
                                    for (int i = 0; i < temTask.mediaKeys.size(); ++i) {
                                        String tem = temTask.mediaKeys.get(i);
                                        DataLoaderHelper.getDataLoader().suspendedDownload(tem);
                                    }
                                }
                            }
                            break block35;
                        }
                        if (msg.what == 2) {
                            String key = (String)msg.obj;
                            DownloadTask temTask = Downloader.this.taskForKey(key);
                            if (temTask != null) {
                                if (temTask.getState() != 5 && temTask.getState() != 3) {
                                    temTask.setState(3);
                                }
                                TTVideoEngineLog.d(Downloader.TAG, "[downloader] task did suspended " + temTask.toString());
                                Downloader.this.tryNextWaitingTask(temTask);
                            }
                            break block35;
                        }
                        if (msg.what == 0) {
                            try {
                                String info = (String)msg.obj;
                                String[] temArray = info.split(",");
                                if (temArray.length < 4) {
                                    return;
                                }
                                long cacheSize = Long.parseLong(temArray[0]);
                                long mediaSize = Long.parseLong(temArray[1]);
                                TTVideoEngineLog.i(Downloader.TAG, "[downloader] download progress, bytesReceived = " + cacheSize + " expectedToReceive = " + mediaSize);
                                if (mediaSize <= 0L) {
                                    return;
                                }
                                String key = temArray[2];
                                String localFilePath = temArray[3];
                                DownloadTask temTask = downloader.taskForKey(key);
                                if (temTask == null) {
                                    TTVideoEngineLog.e(Downloader.TAG, "[downloader] exect fail. key = " + key + ", task is null");
                                    DataLoaderHelper.getDataLoader().suspendedDownload(key);
                                    return;
                                }
                                if (temTask.getState() == 3 || temTask.getState() == 5) {
                                    TTVideoEngineLog.i(Downloader.TAG, "[downloader] task should suspend. key = " + key + ", state = " + temTask.getState());
                                    DataLoaderHelper.getDataLoader().suspendedDownload(key);
                                    Downloader.this.tryNextWaitingTask(temTask);
                                    return;
                                }
                                temTask.bytesReceivedMap.put(key, cacheSize);
                                temTask.bytesExpectedToReceiveMap.put(key, mediaSize);
                                long countOfBytesReceived = 0L;
                                long countOfBytesExpectedToReceive = 0L;
                                boolean allStreamsCome = true;
                                if (temTask.mediaKeys != null && temTask.mediaKeys.size() > 0) {
                                    for (String temKey : temTask.mediaKeys) {
                                        if (!temTask.bytesReceivedMap.containsKey(temKey)) {
                                            allStreamsCome = false;
                                            continue;
                                        }
                                        countOfBytesReceived += temTask.bytesReceivedMap.get(temKey).longValue();
                                        countOfBytesExpectedToReceive += temTask.bytesExpectedToReceiveMap.get(temKey).longValue();
                                    }
                                } else {
                                    allStreamsCome = false;
                                }
                                temTask.bytesReceived = countOfBytesReceived;
                                temTask.bytesExpectedToReceive = countOfBytesExpectedToReceive;
                                if (!temTask.mFirstResumeCallback && downloader != null && downloader.listener != null) {
                                    downloader.listener.downloaderDidResume(downloader, temTask, temTask.bytesReceived, temTask.bytesExpectedToReceive);
                                    temTask.mFirstResumeCallback = true;
                                }
                                if (allStreamsCome && temTask.bytesReceived > 0L && temTask.bytesReceived == temTask.bytesExpectedToReceive) {
                                    temTask.availableLocalFilePath = localFilePath;
                                    temTask.downloadEnd();
                                    return;
                                }
                                long currentTs = System.currentTimeMillis();
                                long interval = currentTs - temTask.updateTs;
                                if (interval > 1000L) {
                                    long freeSize = TTHelper.getFreeSize(Downloader.this.mContext);
                                    TTVideoEngineLog.i(Downloader.TAG, "[downloader] get free size, size = " + freeSize);
                                    if (freeSize <= Downloader.this.getLimitFreeDiskSize()) {
                                        temTask.receiveError(new Error("kTTVideoErrorDomainDownload", -9947, 0, "available size is less than " + Downloader.this.getLimitFreeDiskSize() + " Byte"));
                                        if (temTask.mediaKeys != null) {
                                            for (int i = 0; i < temTask.mediaKeys.size(); ++i) {
                                                String taskKey = temTask.mediaKeys.get(i);
                                                DataLoaderHelper.getDataLoader().suspendedDownload(taskKey);
                                            }
                                        }
                                        return;
                                    }
                                }
                                if (temTask.updateTs < 1L || interval >= 1000L) {
                                    TTVideoEngineLog.i(Downloader.TAG, "[downloader] notify listener. key = " + key);
                                    if (downloader != null && downloader.listener != null && temTask.getState() != 3) {
                                        downloader.listener.downloaderWriteData(downloader, temTask, temTask.bytesReceived - temTask.updateBytesReceived, interval);
                                        downloader.listener.downloaderProgress(downloader, temTask, temTask.bytesReceived, temTask.bytesExpectedToReceive);
                                    }
                                    temTask.updateTs = currentTs;
                                    temTask.updateBytesReceived = temTask.bytesReceived;
                                }
                                break block35;
                            }
                            catch (Throwable e) {
                                TTVideoEngineLog.d(e);
                            }
                            break block35;
                        }
                        if (msg.what == 5) {
                            downloader.loadData = false;
                            TTVideoEngineLog.e(Downloader.TAG, "[downloader] create KV db fail");
                            if (downloader.listener != null) {
                                downloader.listener.downloaderDidLoadAllTask(downloader, null, new Error("kTTVideoErrorDomainDownload", -9943, 0, "create kv db fail"));
                            }
                        } else if (msg.what == 4 && downloader.listener != null) {
                            ArrayList<DownloadTask> temArray = new ArrayList<DownloadTask>(downloader.temLoadedTasks);
                            if (temArray.size() > 0) {
                                DownloadTask task = (DownloadTask)temArray.get(temArray.size() - 1);
                                downloader.maxTaskId = task.taskIdentifier;
                            }
                            for (DownloadTask temTask : temArray) {
                                downloader.indexArray.add(temTask.taskIdentifier);
                            }
                            downloader.allTasks.clear();
                            downloader.allTasks.addAll(temArray);
                            downloader.readAllTask = true;
                            downloader.loadData = false;
                            TTVideoEngineLog.d(Downloader.TAG, "[downloader] did load alltask. size = " + temArray.size());
                            downloader.listener.downloaderDidLoadAllTask(downloader, temArray, null);
                        }
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                    }
                }
            }
        };
    }

    private static class TaskThread {
        private HandlerThread mHandlerThread;
        private Handler mHandler;

        public TaskThread() {
            try {
                this.mHandlerThread = new HandlerThread("vcloud.engine.download.tasks");
                this.mHandlerThread.start();
                this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                    public void handleMessage(@NonNull Message msg) {
                        try {
                            if (!(msg.obj instanceof ArrayList)) {
                                TTVideoEngineLog.d(Downloader.TAG, "[downloader] obj should instance of ArrayList");
                                return;
                            }
                            ArrayList arrayList = (ArrayList)msg.obj;
                            Downloader downloader = (Downloader)arrayList.get(0);
                            switch (msg.what) {
                                case 10: {
                                    downloader.dbObject = new KVDBManager(downloader.mContext, Downloader.dataBaseName);
                                    if (!downloader.dbObject.isCreateDBSuccess()) {
                                        if (downloader.mHandler != null) {
                                            downloader.mHandler.sendMessage(Message.obtain((Handler)downloader.mHandler, (int)5));
                                        }
                                        return;
                                    }
                                    TTVideoEngineLog.d(Downloader.TAG, "[downloader] open db success");
                                    downloader.temLoadedTasks = downloader._loadAllTasks();
                                    if (downloader.mHandler == null) break;
                                    downloader.mHandler.sendMessage(Message.obtain((Handler)downloader.mHandler, (int)4));
                                    break;
                                }
                                case 11: {
                                    if (arrayList.size() != 2) break;
                                    SaveInfos infos = (SaveInfos)arrayList.get(1);
                                    if (infos != null) {
                                        downloader.writeTask(infos.task, infos.alltasks);
                                    }
                                    break;
                                }
                            }
                        }
                        catch (Throwable e) {
                            TTVideoEngineLog.d(e);
                        }
                    }
                };
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
                this.mHandlerThread = null;
                this.mHandler = null;
            }
        }

        public void postMessage(ArrayList<Object> obj, int code) {
            if (this.mHandler != null && this.mHandlerThread != null) {
                Message message = Message.obtain();
                message.what = code;
                message.obj = obj;
                this.mHandler.sendMessage(message);
            }
        }
    }

    private class SaveInfos {
        DownloadTask task = null;
        ArrayList<DownloadTask> alltasks = null;

        private SaveInfos() {
        }
    }
}

