/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.fetcher;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.VideoModelCache;
import com.ss.ttvideoengine.database.VideoModelDBManager;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.net.ChannelSelect;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoInfoFetcher {
    private static final String TAG = "VideoInfoFetcher";
    private static final int MSG_IS_RETRY = 0;
    private static final int MSG_IS_ERROR = 1;
    private static final int MSG_IS_SUCCESS = 2;
    private static final int MSG_IS_EXCEPTION = 3;
    private Handler mHandler;
    public VideoModel mVideoModel;
    private boolean mCancelled = false;
    private int mRetryIndex = 0;
    private int mType = 0;
    private String mApiString = "";
    private String mKeyseed;
    private String mAuth;
    private boolean mUseFallbakApi;
    private static final String KEY_CODE = "code";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_LOGID = "tttrace_id";
    private FetcherListener mListener;
    private TTVNetClient mNetworkSession;
    private HashMap<String, Resolution> mResolutionMap = null;
    private int mPlayVersion;
    private boolean isExternNetClient;
    private String mHost;
    private ArrayList<String> mTriedHost;
    private TreeMap<String, String> queryMap;
    private Future mFuture = null;
    private JSONObject mEnvParams;
    private JSONObject mParams;
    private String mURLWithoutParams;
    private String mProjectTag;
    private long mStartFetchT = 0L;
    private Context mContext;
    private String mVID;
    private boolean mUseVideoModelCache = false;
    private boolean mUseVideoModelCacheForce = false;
    private boolean mGetMethodEnable = true;
    private int mErrorCode = -1;
    private int mMaxRetryCount = 1;
    private String[] EnvParamsStrs = new String[]{"device_type", "device_id", "ac", "aid", "device_platform", "ab_version", "app_name", "version_code", "os_version", "menifest_version_code", "update_version_code", "user_id", "web_id", "player_version", "barragemask"};
    private String[] ParamsStrs = new String[]{"Action", "Version", "video_id", "codec_type", "base64", "url_type", "format_type", "ptoken", "preload", "cdn_type"};
    private static HashMap<String, Integer> errorMapping;

    public VideoInfoFetcher(Context context, TTVNetClient client, String projectTag) {
        this.mContext = context;
        this.mHandler = new MyHandler(this, TTHelper.getLooper());
        if (client == null && TTVideoEngineConfig.gNetClient != null) {
            client = TTVideoEngineConfig.gNetClient;
        }
        if (client == null) {
            this.isExternNetClient = false;
            this.mNetworkSession = new TTHTTPNetwork();
        } else {
            this.isExternNetClient = true;
            this.mNetworkSession = client;
        }
        this.mProjectTag = projectTag;
        this.mMaxRetryCount = InfoWrapper.getApiRetryCount();
        this.mTriedHost = new ArrayList();
    }

    public VideoInfoFetcher(Context context, TTVNetClient client) {
        this.mContext = context;
        this.mHandler = new MyHandler(this, TTHelper.getLooper());
        if (client == null && TTVideoEngineConfig.gNetClient != null) {
            client = TTVideoEngineConfig.gNetClient;
        }
        if (client == null) {
            this.isExternNetClient = false;
            this.mNetworkSession = new TTHTTPNetwork();
        } else {
            this.isExternNetClient = true;
            this.mNetworkSession = client;
        }
        this.mProjectTag = "";
        this.mMaxRetryCount = InfoWrapper.getApiRetryCount();
        this.mTriedHost = new ArrayList();
    }

    public void setUseVideoModelCacheForce(boolean useVideoModelCacheForce) {
        this.mUseVideoModelCacheForce = useVideoModelCacheForce;
    }

    public void setVideoID(String vid) {
        this.mVID = vid;
    }

    public void setUseVideoModelCache(boolean useVideoModelCache) {
        this.mUseVideoModelCache = useVideoModelCache;
        if (useVideoModelCache) {
            VideoModelDBManager.getInstance(this.mContext);
        }
    }

    public void setListener(FetcherListener listener) {
        this.mListener = listener;
    }

    public void setPlayType(int type) {
        this.mType = type;
    }

    public void setUseFallbakApi(Boolean useFallbakApi) {
        this.mUseFallbakApi = useFallbakApi;
    }

    public void fetchInfo(String apiString, String auth, int playversion, String keyseed) {
        TTVideoEngineLog.i(TAG, "fetchInfo apiString " + apiString + ", auth " + auth + ", playversion " + playversion + ", keyseed " + keyseed);
        this.mApiString = apiString;
        this.mAuth = auth;
        this.mRetryIndex = 0;
        this.mPlayVersion = playversion;
        this.mKeyseed = keyseed;
        try {
            URL url = new URL(apiString);
            this.mHost = url.getHost();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this._fetchInfoInternal();
    }

    public void fetchInfo(String apiString, String auth, int playversion) {
        this.fetchInfo(apiString, auth, playversion, null);
    }

    public void fetchInfo(String apiString, String auth) {
        this.mApiString = apiString;
        this.mAuth = auth;
        this.mRetryIndex = 0;
        this._fetchInfoInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        VideoInfoFetcher videoInfoFetcher = this;
        synchronized (videoInfoFetcher) {
            this.mHandler.removeCallbacksAndMessages(null);
            if (this.mListener == null) {
                return;
            }
            this.mListener.onLog("fetcher cancelled");
            if (this.mCancelled) {
                return;
            }
            this.mCancelled = true;
            if (this.mFuture != null) {
                this.mFuture.cancel(true);
            }
            this.mNetworkSession.cancel();
        }
    }

    public void setResolutionMap(HashMap<String, Resolution> resolutionMap) {
        this.mResolutionMap = resolutionMap;
    }

    private void _fetchInfoInternal() {
        if (this.mUseVideoModelCache && (TextUtils.isEmpty((CharSequence)this.mApiString) || !NetUtils.isNetAvailable(this.mContext) || this.mUseVideoModelCacheForce)) {
            TTVideoEngineLog.i(TAG, "get videomodel from DB");
            EngineThreadPool.addExecuteTask(new Runnable(){

                @Override
                public void run() {
                    VideoModelDBManager.CacheInfo info = VideoModelDBManager.query(VideoInfoFetcher.this.mVID);
                    if (info != null && !TextUtils.isEmpty((CharSequence)info.videoModelStr)) {
                        try {
                            JSONObject vmJSON = new JSONObject(info.videoModelStr);
                            TTVideoEngineLog.i(VideoInfoFetcher.TAG, "using videomodel from DB");
                            VideoInfoFetcher.this._getInfoSuccess(vmJSON, info);
                            return;
                        }
                        catch (Exception e) {
                            TTVideoEngineLog.e(VideoInfoFetcher.TAG, e.toString());
                        }
                    }
                    if (TextUtils.isEmpty((CharSequence)VideoInfoFetcher.this.mApiString)) {
                        VideoInfoFetcher.this._notifyError(new Error("kTTVideoErrorDomainFetchingInfo", -9999, "apistring empty and no cache"));
                    } else {
                        VideoInfoFetcher.this._beginToFetch(VideoInfoFetcher.this.mApiString, null);
                    }
                }
            });
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mApiString)) {
            this._notifyError(new Error("kTTVideoErrorDomainFetchingInfo", -9999, "apistring empty"));
            return;
        }
        if (!this.mTriedHost.contains(this.mHost)) {
            this.mTriedHost.add(this.mHost);
        }
        this._beginToFetch(this.mApiString, null);
    }

    private String _parseAPIString(String apistr) {
        if (TextUtils.isEmpty((CharSequence)apistr)) {
            return "_parseAPIString:apistring is empty";
        }
        try {
            URL url = new URL(apistr);
            this.mHost = url.getHost();
        }
        catch (Throwable e) {
            return "_parseAPIString:apistring to URL error";
        }
        String[] strSplitByQM = apistr.split("[?]");
        if (strSplitByQM.length < 2) {
            return "_parseAPIString:apistring param is empty";
        }
        String[] pramStrs = strSplitByQM[1].split("&");
        this.mURLWithoutParams = strSplitByQM[0] + "?";
        this.mEnvParams = new JSONObject();
        this.mParams = new JSONObject();
        this.queryMap = new TreeMap();
        for (int i = 0; i < pramStrs.length; ++i) {
            String[] kv;
            if (this.mGetMethodEnable) {
                kv = pramStrs[i].split("=");
                this.queryMap.put(kv[0], kv[1]);
                continue;
            }
            if (pramStrs[i].indexOf("Action") == 0 || pramStrs[i].indexOf("Version") == 0) {
                this.mURLWithoutParams = this.mURLWithoutParams + pramStrs[i];
                this.mURLWithoutParams = this.mURLWithoutParams + "&";
                kv = pramStrs[i].split("=");
                this.queryMap.put(kv[0], kv[1]);
                continue;
            }
            String[] keyAndValue = pramStrs[i].split("=");
            if (keyAndValue.length < 2) continue;
            String key = keyAndValue[0];
            String value = keyAndValue[1];
            for (int j = 2; j < keyAndValue.length; ++j) {
                value = value + "=" + keyAndValue[j];
            }
            try {
                int k;
                for (k = 0; k < this.EnvParamsStrs.length; ++k) {
                    if (!this.EnvParamsStrs[k].equals(key)) continue;
                    this.mEnvParams.put(key, (Object)value);
                }
                for (k = 0; k < this.ParamsStrs.length; ++k) {
                    if (!this.ParamsStrs[k].equals(key)) continue;
                    this.mParams.put(key, (Object)value);
                }
                continue;
            }
            catch (JSONException e) {
                return "_parseAPIString:put params error";
            }
        }
        this.mURLWithoutParams = this.mURLWithoutParams.substring(0, this.mURLWithoutParams.length() - 1);
        return null;
    }

    private void _beginToFetch(String url, JSONObject httpJsonBody) {
        TTVideoEngineLog.i(TAG, "_beginToFetch url " + url);
        this.mStartFetchT = SystemClock.elapsedRealtime();
        HashMap<String, String> headers = null;
        if (!TextUtils.isEmpty((CharSequence)this.mAuth)) {
            headers = new HashMap<String, String>();
            headers.put("Authorization", this.mAuth);
        }
        boolean newStartTaskExit = false;
        Method[] methods = this.mNetworkSession.getClass().getDeclaredMethods();
        if (methods != null && methods.length > 0) {
            for (Method meth : methods) {
                if (meth == null || meth.getName() == null || !meth.getName().equals("startTask") || meth.getParameterTypes().length != 5) continue;
                newStartTaskExit = true;
                break;
            }
        }
        if (newStartTaskExit) {
            this.mNetworkSession.startTask(url, headers, null, 0, new TTVNetClient.CompletionListener(){

                @Override
                public void onCompletion(JSONObject jsonObject, Error error) {
                    if (jsonObject != null || error == null) {
                        if (error != null) {
                            VideoInfoFetcher.this.mErrorCode = error.internalCode;
                        }
                        VideoInfoFetcher.this._getInfoSuccess(jsonObject, null);
                    } else {
                        VideoInfoFetcher.this._retryIfNeeded(error);
                    }
                }
            });
        } else {
            this.mNetworkSession.startTask(url, headers, new TTVNetClient.CompletionListener(){

                @Override
                public void onCompletion(JSONObject jsonObject, Error error) {
                    if (jsonObject != null || error == null) {
                        VideoInfoFetcher.this._getInfoSuccess(jsonObject, null);
                    } else {
                        VideoInfoFetcher.this._retryIfNeeded(error);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _getInfoSuccess(JSONObject jsonObject, VideoModelDBManager.CacheInfo DBCacheinfo) {
        TTVideoEngineLog.i(TAG, "_getInfoSuccess");
        VideoInfoFetcher videoInfoFetcher = this;
        synchronized (videoInfoFetcher) {
            ChannelSelect.getInstance().setChannelSelected(this.mPlayVersion, this.mHost);
            if (this.mCancelled || jsonObject == null) {
                TTVideoEngineLog.i(TAG, "_getInfoSuccess mCancelled " + this.mCancelled + " or jsonObject is null " + jsonObject);
                return;
            }
            VideoModel model = new VideoModel();
            if (jsonObject.has("ResponseMetadata") || jsonObject.has("Result")) {
                JSONObject metadata = jsonObject.optJSONObject("ResponseMetadata");
                if (metadata == null) {
                    TTVideoEngineLog.i(TAG, "_getInfoSuccess metadata is null");
                    return;
                }
                JSONObject errorInfo = metadata.optJSONObject("Error");
                if (errorInfo != null) {
                    String errorDescription = errorInfo.toString() + " RequestId:" + metadata.optString("RequestId");
                    int codeN = -1;
                    codeN = this.mPlayVersion == 2 ? this.parseErrorCode(errorInfo) : this.mErrorCode;
                    Error error = new Error("kTTVideoErrorDomainFetchingInfo", -9969, codeN, errorDescription);
                    error.parameters.put("log_id", metadata.optString("RequestId"));
                    this._retryIfNeeded(error);
                    return;
                }
                JSONObject resultInfo = jsonObject.optJSONObject("Result");
                if (resultInfo == null) {
                    this._retryIfNeeded(new Error("kTTVideoErrorDomainFetchingInfo", -9997, "fetched info Result is empty"));
                    return;
                }
                JSONObject resultAfterDec = null;
                if (this.mPlayVersion == 2) {
                    try {
                        resultAfterDec = resultInfo.optJSONObject("Data");
                    }
                    catch (Throwable throwable) {
                        this._retryIfNeeded(new Error("kTTVideoErrorDomainFetchingInfo", -9977, throwable.toString()));
                        return;
                    }
                } else {
                    resultAfterDec = resultInfo;
                }
                if (resultAfterDec == null) {
                    this._retryIfNeeded(new Error("kTTVideoErrorDomainFetchingInfo", -9997, "fetched info Result is empty after decrypt"));
                    return;
                }
                try {
                    model.extractFields(resultAfterDec);
                }
                catch (Throwable throwable) {
                    this._retryIfNeeded(new Error("kTTVideoErrorDomainFetchingInfo", -9976, "fetched info Result is empty after decrypt"));
                    return;
                }
                if (model.hasData() && model.getVideoRefInt(4) != 10 && model.getVideoRefInt(4) != 0 && this.mType == 0) {
                    this._notifyException(model.getVideoRefInt(4), "ver2 server side error,hh");
                    return;
                }
            }
            if (model != null) {
                model.setUpResolution(this.mResolutionMap);
            }
            this._notifySuccess(model);
            if (this.mUseVideoModelCache) {
                if (DBCacheinfo == null) {
                    VideoModelDBManager.insert(this.mVID, jsonObject.toString());
                    VideoModelCache.getInstance().put(this.mVID, this.mApiString, model);
                } else {
                    VideoModelCache.VideoModelCacheInfo memoryCacheInfo = new VideoModelCache.VideoModelCacheInfo();
                    memoryCacheInfo.model = model;
                    memoryCacheInfo.modelGotTime = DBCacheinfo.time;
                    VideoModelCache.getInstance().put(this.mVID, null, memoryCacheInfo);
                }
            }
        }
    }

    private int parseErrorCode(JSONObject errorInfo) {
        int codeN = -1;
        if (errorInfo.has("CodeN")) {
            codeN = errorInfo.optInt("CodeN");
        } else if (errorInfo.has("Code")) {
            String codeStr = errorInfo.optString("Code");
            if (TextUtils.isEmpty((CharSequence)codeStr)) {
                return codeN;
            }
            int index = codeStr.indexOf(".");
            if (index > 0) {
                codeStr = codeStr.substring(0, index);
            }
            if (errorMapping == null) {
                errorMapping = new HashMap();
                errorMapping.put("InvalidClientTokenId", 100009);
                errorMapping.put("SignatureDoesNotMatch", 100010);
                errorMapping.put("MissingSignature", 100005);
                errorMapping.put("InvalidTimestamp", 100006);
                errorMapping.put("LackProjectPolicy", 100012);
                errorMapping.put("AccessDenied", 100013);
                errorMapping.put("InternalServiceError", 100014);
                errorMapping.put("InternalServiceTimeout", 100016);
                errorMapping.put("FlowLimitExceeded", 100018);
                errorMapping.put("ServiceUnavailableTemp", 100019);
                errorMapping.put("MethodNotAllowed", 100020);
            }
            if (errorMapping.containsKey(codeStr)) {
                try {
                    codeN = errorMapping.get(codeStr);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        return codeN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _retryIfNeeded(Error error) {
        TTVideoEngineLog.i(TAG, "_retryIfNeeded error " + error);
        VideoInfoFetcher videoInfoFetcher = this;
        synchronized (videoInfoFetcher) {
            if (this.mCancelled) {
                return;
            }
            if (error != null) {
                if (TextUtils.isEmpty((CharSequence)error.domain) && error.code == -9979) {
                    error = new Error("kTTVideoErrorDomainFetchingInfo", -9994, error.internalCode, error.description);
                } else if (TextUtils.isEmpty((CharSequence)error.domain)) {
                    error = new Error("kTTVideoErrorDomainFetchingInfo", -9994, error.internalCode, error.description);
                }
            } else {
                error = new Error("kTTVideoErrorDomainFetchingInfo", -9994);
            }
            if (error.code == -9969) {
                if (error.internalCode / 10000 != 10 && error.internalCode != -9970) {
                    error.code = -9990;
                }
                String apiLogStr = "<apiStr:" + this.mApiString + ">";
                error.description = error.description + apiLogStr;
                this._notifyError(error);
                return;
            }
            if (error.internalCode == 502 && this.mRetryIndex >= this.mMaxRetryCount && this.mApiString != null && this.mHost != null) {
                int hostIndex = this.mApiString.indexOf(this.mHost);
                String query = this.mApiString.substring(hostIndex + this.mHost.length());
                if (!this._isTriedAllHost()) {
                    String host = ChannelSelect.getInstance().selectNext(this.mPlayVersion, this.mHost);
                    String protocol = this.mApiString.substring(0, hostIndex);
                    this.mApiString = protocol + host + query;
                    this.mHost = host;
                    this.mRetryIndex = -1;
                }
            }
            if (this.mRetryIndex < this.mMaxRetryCount) {
                this._notifyShouldRetry(error);
                ++this.mRetryIndex;
                this._fetchInfoInternal();
            } else {
                String apiLogStr = "<apiStr:" + this.mApiString + ">";
                error.description = error.description + apiLogStr;
                this._notifyError(error);
            }
        }
    }

    private boolean _isTriedAllHost() {
        boolean ret = false;
        if (this.mTriedHost == null) {
            return false;
        }
        List hostList = ChannelSelect.getInstance().groupByApiVersionLocked(this.mPlayVersion);
        if (hostList != null) {
            ret = hostList.size() == this.mTriedHost.size();
        }
        return ret;
    }

    private void _notifyShouldRetry(Error error) {
        Message message = this.mHandler.obtainMessage(0, (Object)error);
        this.mHandler.sendMessage(message);
    }

    private void _notifyError(Error error) {
        TTVideoEngineLog.i(TAG, "_notifyError " + error);
        Message message = this.mHandler.obtainMessage(1, (Object)error);
        this.mHandler.sendMessage(message);
    }

    private void _notifySuccess(VideoModel model) {
        TTVideoEngineLog.i(TAG, "_notifySuccess");
        Message message = this.mHandler.obtainMessage(2, (Object)model);
        this.mHandler.sendMessage(message);
    }

    private void _notifyException(int status, String excMessage) {
        TTVideoEngineLog.i(TAG, "_notifyException " + status + ", excMessage " + excMessage);
        Message message = this.mHandler.obtainMessage(3, status, 0, (Object)excMessage);
        this.mHandler.sendMessage(message);
    }

    public static interface FetcherListener {
        public void onRetry(Error var1);

        public void onCompletion(VideoModel var1, Error var2);

        public void onStatusException(int var1, String var2);

        public void onLog(String var1);
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<VideoInfoFetcher> mFetcherRef;

        public MyHandler(VideoInfoFetcher fetcher, Looper looper) {
            super(looper);
            this.mFetcherRef = new WeakReference<VideoInfoFetcher>(fetcher);
        }

        public void handleMessage(Message msg) {
            VideoInfoFetcher fetcher = (VideoInfoFetcher)this.mFetcherRef.get();
            if (fetcher == null) {
                return;
            }
            FetcherListener listener = fetcher.mListener;
            if (listener == null) {
                return;
            }
            if (fetcher.mCancelled) {
                listener.onLog("fetcher is cancelled");
                return;
            }
            switch (msg.what) {
                case 0: {
                    Error error = (Error)msg.obj;
                    listener.onRetry(error);
                    break;
                }
                case 1: {
                    Error error = (Error)msg.obj;
                    listener.onCompletion(null, error);
                    break;
                }
                case 2: {
                    VideoModel model;
                    fetcher.mVideoModel = model = (VideoModel)msg.obj;
                    listener.onCompletion(model, null);
                    break;
                }
                case 3: {
                    int status = msg.arg1;
                    listener.onStatusException(status, (String)msg.obj);
                    break;
                }
            }
        }
    }
}

