/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import com.ss.ttvideoengine.log.HeadsetStateMonitor;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;

class HeadsetStateHistory
implements HeadsetStateMonitor.HeadsetStateChangedListener {
    private static final String TAG = "HeadsetStateHistory";
    private final ArrayList<String> mConnectionHistoryList;
    private final HeadsetStateMonitor mHeadsetStateMonitor;
    private volatile long mLastSwitchTime = 0L;

    public HeadsetStateHistory(HeadsetStateMonitor headsetStateMonitor) {
        this.mHeadsetStateMonitor = headsetStateMonitor;
        this.mConnectionHistoryList = new ArrayList();
    }

    public void start() {
        this.mHeadsetStateMonitor.addStateChangedListener(this);
        TTVideoEngineLog.d(TAG, "start");
    }

    @Override
    public void onHeadsetStateChanged(boolean connected, boolean wireless) {
        this.mLastSwitchTime = System.currentTimeMillis();
        this.addToHistory(connected, wireless);
    }

    public ArrayList<String> get() {
        return new ArrayList<String>(this.mConnectionHistoryList);
    }

    public long getLastSwitchTime() {
        return this.mLastSwitchTime;
    }

    public void reset() {
        this.mLastSwitchTime = 0L;
        this.mConnectionHistoryList.clear();
    }

    public void stop() {
        this.mHeadsetStateMonitor.removeStateChangedListener(this);
        TTVideoEngineLog.d(TAG, "stop");
    }

    private void addToHistory(boolean connected, boolean wireless) {
        HashMap<String, Number> historyMap = new HashMap<String, Number>();
        historyMap.put("t", System.currentTimeMillis());
        historyMap.put("bt", wireless ? 1 : 0);
        historyMap.put("con", connected ? 1 : 0);
        this.mConnectionHistoryList.add(new JSONObject(historyMap).toString());
    }
}

