/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.log.VideoEventOneOpera;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class VideoEventOneEvent {
    private static final String TAG = "VideoEventOneEvent";
    public static final String monitorName = "videoplayer_oneevent";
    public static final String EVENT_TYPE_NET = "block_net";
    public static final String EVENT_TYPE_DECODE = "block_decode";
    public static final String END_TYPE_SEEK = "seek";
    public static final String END_TYPE_SWITCH = "switch";
    public static final String END_TYPE_EXIT = "exit";
    public static final String END_TYPE_SPEED = "speed";
    public static final String END_TYPE_EPISODE = "episode";
    public static final String END_TYPE_WAIT = "wait";
    public static final String END_TYPE_TIMEOUT = "timeout";
    public static final String END_TYPE_ERROR = "error";
    public static final int BUFFERING_TYPE_AUDIO = 1;
    public static final int BUFFERING_TYPE_VIDEO = 2;
    public static final int BUFFERING_TYPE_BOTHS = 3;
    public VideoEventBase mEventBase;
    private VideoEventOneOpera mEventOpera;
    private HashMap mLastEventTimeMap = null;
    public EventContext mEventContext = null;
    public long mAccuCostTime = 0L;
    public ArrayList<String> mRebufList = new ArrayList();
    public long mFirstFrameTime = Integer.MIN_VALUE;
    public int mIsAVBadInterlaced = 0;

    VideoEventOneEvent(VideoEventBase base, VideoEventOneOpera opera) {
        this.mEventBase = base;
        this.mEventOpera = opera;
        this.mLastEventTimeMap = new HashMap();
        this.mEventContext = new EventContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        HashMap hashMap = this.mLastEventTimeMap;
        synchronized (hashMap) {
            this.mLastEventTimeMap = new HashMap();
        }
        this.mAccuCostTime = 0L;
        this.mRebufList = new ArrayList();
        this.mFirstFrameTime = Integer.MIN_VALUE;
        this.mIsAVBadInterlaced = 0;
    }

    public void movieShouldRetry() {
        ++this.mEventContext.mRetryCount;
    }

    public void showedFirstFrame() {
        this.mFirstFrameTime = System.currentTimeMillis();
    }

    public void moviePreStalled(int type) {
        this.mEventContext.mPreStartT = System.currentTimeMillis();
        this.mEventContext.mBufferingType = type;
        TTVideoEngineLog.d(TAG, "movie stall type:" + type);
        if (this.mEventBase != null) {
            this.mEventBase.updateMDLInfo();
        }
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            this.mEventContext.mPlayerReqOffset = this.mEventBase.mDataSource.getLogValueLong(144);
        }
    }

    public int getMovieStalledType() {
        return this.mEventContext.mBufferingType;
    }

    public void onAVBadInterlaced() {
        this.mIsAVBadInterlaced = 1;
    }

    public void movieStalled(int curPos, int index) {
        TTVideoEngineLog.d(TAG, "movieStalled");
        this.mEventContext.mStartT = System.currentTimeMillis();
        this.mEventContext.mVideoPos = curPos;
        this.mEventContext.mIndex = index;
        this.mEventContext.mEventType = EVENT_TYPE_NET;
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            Object is_abr;
            this.mEventContext.mResolutionBefore = this.mEventBase.mCurrentResolution;
            this.mEventContext.mConfigBitrateBefore = this.mEventBase.mCurrentConfigBitrate;
            this.mEventContext.mQualityDescBefore = this.mEventBase.mCurrentQualityDesc;
            if (this.mEventBase.abrInfo != null && (is_abr = this.mEventBase.abrInfo.get("abr_used")) != null) {
                this.mEventContext.mIsABR = (Integer)is_abr;
            }
            this.mEventContext.mBytesFromMDL = this.mEventBase.mDataSource.getLogValueLong(56);
            Map<String, Long> bufStates = LoggerUtils.parsePlayerBufferString(this.mEventBase.mDataSource.getLogValueStr(55));
            if (bufStates.get("fvl") != null) {
                this.mEventContext.mVideoLenBeforeMS = bufStates.get("fvl");
            }
            if (bufStates.get("fal") != null) {
                this.mEventContext.mAudioLenBeforeMS = bufStates.get("fal");
            }
            if (bufStates.get("dvl") != null) {
                this.mEventContext.mVideoLenDecBeforeMs = bufStates.get("dvl");
            }
            if (bufStates.get("dal") != null) {
                this.mEventContext.mAudioLenDecBeforeMs = bufStates.get("dal");
            }
            if (bufStates.get("bvl") != null) {
                this.mEventContext.mVideoLenBaseBeforeMs = bufStates.get("bvl");
            }
            if (bufStates.get("bal") != null) {
                this.mEventContext.mAudioLenBaseBeforeMs = bufStates.get("bal");
            }
            if (bufStates.get("fvlim") != null) {
                this.mEventContext.mVideoLenOnlyBefore = bufStates.get("fvlim");
            }
            if (bufStates.get("falim") != null) {
                this.mEventContext.mAudioLenOnlyBefore = bufStates.get("falim");
            }
            this.mEventBase.mNetworkType = VideoEventBase.getNetType();
            if (this.mEventBase.mEnablePowerReport) {
                double cpuRate = this.mEventBase.getCPURate();
                double cpuSpeed = this.mEventBase.getCPUSpeed();
                if (cpuRate > 0.0 && cpuSpeed > 0.0) {
                    this.mEventContext.mCpuRate = cpuRate;
                    this.mEventContext.mCpuSpeed = cpuSpeed;
                } else {
                    EngineThreadPool.addExecuteTask(new StatisticDataRunnable(this.mEventContext, this.mEventBase));
                }
                int isPowerSaveMod = DeviceMonitorUtils.isPowerSaveMode(this.mEventBase.mContext);
                if (isPowerSaveMod >= 0) {
                    this.mEventContext.mPowerSaveMode = isPowerSaveMod;
                }
                this.mEventContext.mCurrent = this.mEventBase.getBatteryCurrent();
            }
        }
    }

    public void movieStallEnd(String reason) {
        if (this.mEventContext.mStartT <= 0L || this.mEventContext.mEventType.isEmpty()) {
            TTVideoEngineLog.d(TAG, "movieStallEnd without movieStalled, return.");
            this.mEventContext.mPreStartT = Integer.MIN_VALUE;
            this.mEventContext.mBufferingType = -1;
            return;
        }
        this.mEventContext.mEndT = System.currentTimeMillis();
        TTVideoEngineLog.d(TAG, "movieStallEnd");
        this.mEventContext.mCostTime = this.mEventContext.mEndT - this.mEventContext.mStartT;
        if (this.mEventContext.mCostTime > 0L) {
            this.mAccuCostTime += this.mEventContext.mCostTime;
        }
        this.mEventContext.mEndType = reason;
        this.mEventContext.mLastSeekTime = this.mEventOpera.getLastSeekTime();
        if (this.mEventContext.mLastSeekTime == 0L) {
            this.mEventContext.mLastSeekTime = this.mEventContext.mStartT;
        }
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            this.mEventContext.mResolutionAfter = this.mEventBase.mCurrentResolution;
            this.mEventContext.mConfigBitrateAfter = this.mEventBase.mCurrentConfigBitrate;
            this.mEventContext.mQualityDescAfter = this.mEventBase.mCurrentQualityDesc;
            Map<String, Long> bytesInfo = this.mEventBase.mDataSource.bytesInfo();
            if (bytesInfo != null) {
                this.mEventContext.mVideoLenAfterMS = TTHelper.safelyUnbox(bytesInfo.get("vlen"));
                this.mEventContext.mAudioLenAfterMS = TTHelper.safelyUnbox(bytesInfo.get("alen"));
                this.mEventContext.mVideoLenDecAfterMs = TTHelper.safelyUnbox(bytesInfo.get("vDecLen"));
                this.mEventContext.mVideoLenBaseAfterMs = TTHelper.safelyUnbox(bytesInfo.get("vBaseLen"));
                this.mEventContext.mAudioLenDecAfterMs = TTHelper.safelyUnbox(bytesInfo.get("aDecLen"));
                this.mEventContext.mAudioLenBaseAfterMs = TTHelper.safelyUnbox(bytesInfo.get("aBaseLen"));
                this.mEventContext.mVideoAudioGap = TTHelper.safelyUnbox(bytesInfo.get("avGap"));
            }
        }
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("p", this.mEventContext.mVideoPos);
        map.put("t", this.mEventContext.mEndT);
        map.put("c", this.mEventContext.mCostTime);
        this.mRebufList.add(new JSONObject(map).toString());
        this.mEventBase.degradeModeChangeSession();
        this.sendOneEvent();
        this._triggerBufferEndCb();
        this.mEventContext = new EventContext();
    }

    public void triggerBufferStartCb() {
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            String url;
            HashMap<String, String> infos = new HashMap<String, String>();
            if (this.mEventBase.mEnableMDL > 0) {
                infos.put("cur_url", this.mEventBase.mdlVideoInfo.mdl_cur_url);
                infos.put("cur_ip", this.mEventBase.mdlVideoInfo.mdl_cur_ip);
                url = this.mEventBase.mdlVideoInfo.mdl_cur_url;
            } else {
                infos.put("cur_url", this.mEventBase.mCurURL);
                infos.put("cur_ip", this.mEventBase.mCurIP);
                url = this.mEventBase.mCurURL;
            }
            try {
                String host = Uri.parse((String)url).getHost();
                infos.put("cur_host", host);
            }
            catch (Exception e) {
                TTVideoEngineLog.i(TAG, "triggerBufferStartCb:" + e.toString());
            }
            this.mEventBase.mDataSource.onInfo(0, infos);
        }
    }

    public void _triggerBufferEndCb() {
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("cost_time", this.mEventContext.mCostTime);
            infos.put("exit_type", this.mEventContext.mEndType);
            JSONObject mdlInfo = this.mEventBase.getMDLInfo();
            if (mdlInfo != null) {
                if (!mdlInfo.isNull("video")) {
                    try {
                        VideoEventBase.MDLTrackInfo trackInfo = this.mEventBase.getMdlTrackInfo(mdlInfo.getJSONObject("video"));
                        infos.put("cur_url", trackInfo.mdl_cur_url);
                        infos.put("cur_ip", trackInfo.mdl_cur_ip);
                        String host = Uri.parse((String)trackInfo.mdl_cur_url).getHost();
                        infos.put("cur_host", host);
                    }
                    catch (Exception e) {
                        TTVideoEngineLog.d(e);
                    }
                }
            } else {
                infos.put("cur_url", this.mEventBase.mCurURL);
                infos.put("cur_ip", this.mEventBase.mCurIP);
                try {
                    String host = Uri.parse((String)this.mEventBase.mCurURL).getHost();
                    infos.put("cur_host", host);
                }
                catch (Exception e) {
                    TTVideoEngineLog.i(TAG, "_triggerBufferEndCb:" + e.toString());
                }
            }
            this.mEventBase.mDataSource.onInfo(1, infos);
        }
    }

    public void sendOneEvent() {
        this.mEventBase.updateVideoInfo(null);
        TTVideoEngineLog.i(TAG, "report async");
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase, this.mEventContext));
    }

    public long getStalledVideoBufferTime() {
        return this.mEventContext.mVideoLenBeforeMS;
    }

    public long getStatlledAudioBufferTime() {
        return this.mEventContext.mAudioLenBeforeMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastRebufTime() {
        if (this.mEventContext.mStartT > 0L) {
            return 0L;
        }
        HashMap hashMap = this.mLastEventTimeMap;
        synchronized (hashMap) {
            if (this.mLastEventTimeMap.containsKey(EVENT_TYPE_NET)) {
                return (Long)this.mLastEventTimeMap.get(EVENT_TYPE_NET);
            }
            return -1L;
        }
    }

    private JSONObject toJsonObject(EventContext eventContext, VideoEventBase eventBase) {
        long last_event_time;
        HashMap map = new HashMap();
        if (eventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", eventBase.mSessionID);
            if (eventBase.mCurURL == null || eventBase.mCurURL.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mInitialURL);
            } else {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mCurURL);
            }
            if (eventBase.mCurIP == null || eventBase.mCurIP.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mInitialIP);
            } else {
                LoggerUtils.putToMap(map, "cdn_ip", eventBase.mCurIP);
            }
            LoggerUtils.putToMap(map, "resolution", eventBase.mCurrentResolution);
            LoggerUtils.putToMap(map, "source_type", eventBase.mSourceTypeStr);
            LoggerUtils.putToMap(map, "v", eventBase.mVid);
            LoggerUtils.putToMap(map, "pv", eventBase.pv);
            LoggerUtils.putToMap(map, "pc", eventBase.pc);
            LoggerUtils.putToMap(map, "sv", eventBase.sv);
            LoggerUtils.putToMap(map, "sdk_version", eventBase.sdk_version);
            LoggerUtils.putToMap(map, "vtype", eventBase.vtype);
            LoggerUtils.putToMap(map, "tag", eventBase.mTag);
            LoggerUtils.putToMap(map, "subtag", eventBase.mSubTag);
            LoggerUtils.putToMap(map, "p2p_cdn_type", eventBase.mP2PCDNType);
            LoggerUtils.putToMap(map, "codec", eventBase.codec_type);
            LoggerUtils.putToMap(map, "video_codec_nameid", eventBase.videoCodecNameId);
            LoggerUtils.putToMap(map, "audio_codec_nameid", eventBase.audioCodecNameId);
            LoggerUtils.putToMap(map, "format_type", eventBase.formatType);
            LoggerUtils.putToMap(map, "drm_type", eventBase.mDrmType);
            LoggerUtils.putToMap(map, "play_speed", eventBase.mPlaySpeed);
            LoggerUtils.putToMap(map, "net_type", eventBase.mNetworkType);
            LoggerUtils.putToMap(map, "mdl_version", eventBase.mMdlVersion);
            LoggerUtils.putToMap(map, "enable_mdl", eventBase.mEnableMDL);
            LoggerUtils.putToMap(map, "video_hw", eventBase.mVideoHW);
            LoggerUtils.putToMap(map, "user_hw", eventBase.mVideoHWUser);
            LoggerUtils.putToMap(map, "cur_task_num", eventBase.mdl_cur_task_num);
            LoggerUtils.putToMap(map, "mdl_conc_count", eventBase.mdl_conc_count);
            LoggerUtils.putToMap(map, "mdl_mem_buffer_len", eventBase.mdlVideoInfo.mdl_mem_buffer_len);
            LoggerUtils.putToMap(map, "mdl_disk_buffer_len", eventBase.mdlVideoInfo.mdl_disk_buffer_len);
            LoggerUtils.putToMap(map, "mdl_send_offset", eventBase.mdlVideoInfo.mdl_send_offset);
            LoggerUtils.putToMap(map, "mdl_last_req_offset", eventBase.mdlVideoInfo.mdl_last_req_offset);
            LoggerUtils.putToMap(map, "mdl_last_ip_list", eventBase.mdlVideoInfo.mdl_last_ip_list);
            LoggerUtils.putToMap(map, "cur_req_pos", eventBase.mdlVideoInfo.mdl_cur_req_pos);
            LoggerUtils.putToMap(map, "cur_end_pos", eventBase.mdlVideoInfo.mdl_cur_end_pos);
            LoggerUtils.putToMap(map, "cur_cache_pos", eventBase.mdlVideoInfo.mdl_cur_cache_pos);
            LoggerUtils.putToMap(map, "cache_type", eventBase.mdlVideoInfo.mdl_cache_type);
            LoggerUtils.putToMap(map, "cur_ip", eventBase.mdlVideoInfo.mdl_cur_ip);
            LoggerUtils.putToMap(map, "cur_host", eventBase.mdlVideoInfo.mdl_cur_host);
            LoggerUtils.putToMap(map, "reply_size", eventBase.mdlVideoInfo.mdl_reply_size);
            LoggerUtils.putToMap(map, "down_pos", eventBase.mdlVideoInfo.mdl_down_pos);
            LoggerUtils.putToMap(map, "player_wait_time", eventBase.mdlVideoInfo.mdl_player_wait_time);
            LoggerUtils.putToMap(map, "player_wait_num", eventBase.mdlVideoInfo.mdl_player_wait_num);
            LoggerUtils.putToMap(map, "mdl_stage", eventBase.mdlVideoInfo.mdl_stage);
            LoggerUtils.putToMap(map, "mdl_ec", eventBase.mdlVideoInfo.mdl_error_code);
            LoggerUtils.putToMap(map, "mdl_speed", eventBase.mdlVideoInfo.mdl_speed);
            LoggerUtils.putToMap(map, "mdl_file_key", eventBase.mdlVideoInfo.mdl_file_key);
            LoggerUtils.putToMap(map, "mdl_is_socrf", eventBase.mdlVideoInfo.mdl_is_socrf);
            LoggerUtils.putToMap(map, "mdl_req_num", eventBase.mdlVideoInfo.mdl_req_num);
            LoggerUtils.putToMap(map, "mdl_url_index", eventBase.mdlVideoInfo.mdl_url_index);
            LoggerUtils.putToMap(map, "mdl_re_url", eventBase.mdlVideoInfo.mdl_re_url);
            LoggerUtils.putToMap(map, "mdl_cur_source", eventBase.mdlVideoInfo.mdl_cur_soure);
            LoggerUtils.putToMap(map, "mdl_extra_info", eventBase.mdlVideoInfo.mdl_extra_info);
            LoggerUtils.putToMap(map, "mdl_fs", eventBase.mdlVideoInfo.mdl_fs);
            LoggerUtils.putToMap(map, "mdl_p2p_sp", eventBase.mdlVideoInfo.mdl_pcdn_full_speed);
            LoggerUtils.putToMap(map, "mdl_tbs", eventBase.mdlVideoInfo.mdl_tbs);
            LoggerUtils.putToMap(map, "mdl_lbs", eventBase.mdlVideoInfo.mdl_lbs);
            LoggerUtils.putToMap(map, "mdl_response_cache", this.mEventBase.mdlVideoInfo.mdl_cdn_cache);
            LoggerUtils.putToMap(map, "mdl_response_cinfo", this.mEventBase.mdlVideoInfo.mdl_client_info);
            LoggerUtils.putToMap(map, "a_cur_req_pos", eventBase.mdlAudioInfo.mdl_cur_req_pos);
            LoggerUtils.putToMap(map, "a_cur_end_pos", eventBase.mdlAudioInfo.mdl_cur_end_pos);
            LoggerUtils.putToMap(map, "a_cur_cache_pos", eventBase.mdlAudioInfo.mdl_cur_cache_pos);
            LoggerUtils.putToMap(map, "a_cache_type", eventBase.mdlAudioInfo.mdl_cache_type);
            LoggerUtils.putToMap(map, "a_cur_ip", eventBase.mdlAudioInfo.mdl_cur_ip);
            LoggerUtils.putToMap(map, "a_cur_host", eventBase.mdlAudioInfo.mdl_cur_host);
            LoggerUtils.putToMap(map, "a_reply_size", eventBase.mdlAudioInfo.mdl_reply_size);
            LoggerUtils.putToMap(map, "a_down_pos", eventBase.mdlAudioInfo.mdl_down_pos);
            LoggerUtils.putToMap(map, "a_player_wait_time", eventBase.mdlAudioInfo.mdl_player_wait_time);
            LoggerUtils.putToMap(map, "a_player_wait_num", eventBase.mdlAudioInfo.mdl_player_wait_num);
            LoggerUtils.putToMap(map, "a_mdl_stage", eventBase.mdlAudioInfo.mdl_stage);
            LoggerUtils.putToMap(map, "a_mdl_ec", eventBase.mdlAudioInfo.mdl_error_code);
            LoggerUtils.putToMap(map, "a_mdl_speed", eventBase.mdlAudioInfo.mdl_speed);
            LoggerUtils.putToMap(map, "a_mdl_file_key", eventBase.mdlAudioInfo.mdl_file_key);
            LoggerUtils.putToMap(map, "a_mdl_is_socrf", eventBase.mdlAudioInfo.mdl_is_socrf);
            LoggerUtils.putToMap(map, "a_mdl_req_num", eventBase.mdlAudioInfo.mdl_req_num);
            LoggerUtils.putToMap(map, "a_mdl_url_index", eventBase.mdlAudioInfo.mdl_url_index);
            LoggerUtils.putToMap(map, "a_mdl_re_url", eventBase.mdlAudioInfo.mdl_re_url);
            LoggerUtils.putToMap(map, "a_mdl_cur_source", eventBase.mdlAudioInfo.mdl_cur_soure);
            LoggerUtils.putToMap(map, "a_mdl_extra_info", eventBase.mdlAudioInfo.mdl_extra_info);
            LoggerUtils.putToMap(map, "a_mdl_fs", eventBase.mdlAudioInfo.mdl_fs);
            LoggerUtils.putToMap(map, "a_mdl_p2p_sp", eventBase.mdlAudioInfo.mdl_pcdn_full_speed);
            LoggerUtils.putToMap(map, "a_mdl_tbs", eventBase.mdlAudioInfo.mdl_tbs);
            LoggerUtils.putToMap(map, "a_mdl_lbs", eventBase.mdlAudioInfo.mdl_lbs);
            LoggerUtils.putToMap(map, "a_mdl_response_cache", this.mEventBase.mdlAudioInfo.mdl_cdn_cache);
            LoggerUtils.putToMap(map, "a_mdl_response_cinfo", this.mEventBase.mdlAudioInfo.mdl_client_info);
        }
        LoggerUtils.putToMap(map, "event_type", eventContext.mEventType);
        LoggerUtils.putToMap(map, "cost_time", eventContext.mCostTime);
        LoggerUtils.putToMap(map, "end_type", eventContext.mEndType);
        LoggerUtils.putToMap(map, "index", eventContext.mIndex);
        long first_frame_interval = -1L;
        if (this.mFirstFrameTime > 0L) {
            first_frame_interval = eventContext.mStartT - this.mFirstFrameTime;
        }
        LoggerUtils.putToMap(map, "first_frame_interval", first_frame_interval);
        long seek_interval = -1L;
        if (eventContext.mLastSeekTime > 0L) {
            seek_interval = eventContext.mStartT - eventContext.mLastSeekTime;
        }
        LoggerUtils.putToMap(map, "last_seek_interval", seek_interval);
        long event_interval = -1L;
        if (this.mLastEventTimeMap.containsKey(eventContext.mEventType) && (last_event_time = ((Long)this.mLastEventTimeMap.get(eventContext.mEventType)).longValue()) > 0L) {
            event_interval = eventContext.mStartT - last_event_time;
        }
        LoggerUtils.putToMap(map, "last_event_interval", event_interval);
        LoggerUtils.putToMap(map, "last_switch_interval", -1);
        LoggerUtils.putToMap(map, "video_pos", eventContext.mVideoPos);
        LoggerUtils.putToMap(map, "retry_count", eventContext.mRetryCount);
        LoggerUtils.putToMap(map, "reuse_socket", eventBase.mReuseSocket);
        LoggerUtils.putToMap(map, "read_count_mdl", eventContext.mBytesFromMDL);
        LoggerUtils.putToMap(map, "audio_len_before", eventContext.mAudioLenBeforeMS);
        LoggerUtils.putToMap(map, "video_len_before", eventContext.mVideoLenBeforeMS);
        LoggerUtils.putToMap(map, "audio_len_after", eventContext.mAudioLenAfterMS);
        LoggerUtils.putToMap(map, "video_len_after", eventContext.mVideoLenAfterMS);
        LoggerUtils.putToMap(map, "vlen_dec_before", eventContext.mVideoLenDecBeforeMs);
        LoggerUtils.putToMap(map, "vlen_base_before", eventContext.mVideoLenBaseBeforeMs);
        LoggerUtils.putToMap(map, "alen_dec_before", eventContext.mAudioLenDecBeforeMs);
        LoggerUtils.putToMap(map, "alen_base_before", eventContext.mAudioLenBaseBeforeMs);
        LoggerUtils.putToMap(map, "vlen_dec_after", eventContext.mVideoLenDecAfterMs);
        LoggerUtils.putToMap(map, "vlen_base_after", eventContext.mVideoLenBaseAfterMs);
        LoggerUtils.putToMap(map, "alen_dec_after", eventContext.mAudioLenDecAfterMs);
        LoggerUtils.putToMap(map, "alen_base_after", eventContext.mAudioLenBaseAfterMs);
        LoggerUtils.putToMap(map, "vlen_only_before", eventContext.mVideoLenOnlyBefore);
        LoggerUtils.putToMap(map, "alen_only_before", eventContext.mAudioLenOnlyBefore);
        LoggerUtils.putToMap(map, "player_req_offset", eventContext.mPlayerReqOffset);
        LoggerUtils.putToMap(map, "av_gap", eventContext.mVideoAudioGap);
        LoggerUtils.putToMap(map, "buffer_reason", eventContext.mBufferingType);
        LoggerUtils.putToMap(map, "pst", eventContext.mPreStartT);
        LoggerUtils.putToMap(map, "st", eventContext.mStartT);
        LoggerUtils.putToMap(map, "et", eventContext.mEndT);
        LoggerUtils.putToMap(map, "resolution_before", eventContext.mResolutionBefore);
        LoggerUtils.putToMap(map, "resolution_after", eventContext.mResolutionAfter);
        LoggerUtils.putToMap(map, "bitrate_before", eventContext.mConfigBitrateBefore);
        LoggerUtils.putToMap(map, "bitrate_after", eventContext.mConfigBitrateAfter);
        LoggerUtils.putToMap(map, "is_abr", eventContext.mIsABR);
        LoggerUtils.putToMap(map, "quality_desc_before", eventContext.mQualityDescBefore);
        LoggerUtils.putToMap(map, "quality_desc_after", eventContext.mQualityDescAfter);
        LoggerUtils.putToMap(map, "bad_interlaced", this.mIsAVBadInterlaced);
        LoggerUtils.putToMap(map, "cpu_rate", (float)eventContext.mCpuRate);
        LoggerUtils.putToMap(map, "cpu_speed", (float)eventContext.mCpuSpeed);
        LoggerUtils.putToMap(map, "power_save_mode", eventContext.mPowerSaveMode);
        LoggerUtils.putToMap(map, "battery_current", eventContext.mCurrent);
        LoggerUtils.putToMap(map, "network_score", PortraitNetworkScore.getInstance().getLastPortraitResult());
        LoggerUtils.putToMap(map, "target_bitrate", (float)PortraitNetworkScore.getInstance().getLastTargetBitrate());
        TTVideoEngineLog.d(TAG, "OneEvent:" + ((Object)map).toString());
        return new JSONObject(map);
    }

    private static class StatisticDataRunnable
    implements Runnable {
        private final WeakReference<EventContext> rEvent;
        private final WeakReference<VideoEventBase> rEventBase;

        public StatisticDataRunnable(EventContext event, VideoEventBase eventBase) {
            this.rEvent = new WeakReference<EventContext>(event);
            this.rEventBase = new WeakReference<VideoEventBase>(eventBase);
        }

        @Override
        public void run() {
            DeviceMonitorUtils.CPUInfo cpuInfo;
            EventContext event = (EventContext)this.rEvent.get();
            VideoEventBase eventBase = (VideoEventBase)this.rEventBase.get();
            if (event != null && eventBase != null && (cpuInfo = eventBase.getCurrentCPUInfo()) != null) {
                event.mCpuRate = cpuInfo.cpuAppRate > 0.0 ? cpuInfo.cpuAppRate : (double)1.4E-45f;
                event.mCpuSpeed = cpuInfo.cpuAppSpeed > 0.0 ? cpuInfo.cpuAppSpeed : (double)1.4E-45f;
            }
        }
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventOneEvent rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;
        private EventContext rEventContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventOneEvent event, VideoEventBase base, EventContext eventContext) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rEventContext = eventContext;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            final boolean isUpload = this.rEventBase != null && this.rEventBase.isUploadLogEnabled;
            final JSONObject jsonEvent = this.rEvent.toJsonObject(this.rEventContext, this.rEventBase);
            if (this.rHandler == null || this.rHandler.getLooper() == null) {
                VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneEvent.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneEvent.monitorName);
                }
            });
            HashMap hashMap = this.rEvent.mLastEventTimeMap;
            synchronized (hashMap) {
                this.rEvent.mLastEventTimeMap.remove(this.rEventContext.mEventType);
                this.rEvent.mLastEventTimeMap.put(this.rEventContext.mEventType, this.rEventContext.mEndT);
            }
        }
    }

    private class EventContext {
        public String mEventType = "";
        public long mCostTime = Integer.MIN_VALUE;
        public String mEndType = "";
        public long mPreStartT = Integer.MIN_VALUE;
        public int mBufferingType = -1;
        public long mStartT = Integer.MIN_VALUE;
        public long mEndT = Integer.MIN_VALUE;
        public long mLastSeekTime = Integer.MIN_VALUE;
        public int mVideoPos = Integer.MIN_VALUE;
        public int mRetryCount = 0;
        public long mVideoLenBeforeMS = -1L;
        public long mAudioLenBeforeMS = -1L;
        public long mVideoLenAfterMS = 0L;
        public long mAudioLenAfterMS = 0L;
        public long mBytesFromMDL = 0L;
        public int mIndex = 0;
        public long mVideoLenDecBeforeMs = 0L;
        public long mVideoLenDecAfterMs = 0L;
        public long mAudioLenDecBeforeMs = 0L;
        public long mAudioLenDecAfterMs = 0L;
        public long mVideoLenBaseBeforeMs = 0L;
        public long mVideoLenBaseAfterMs = 0L;
        public long mAudioLenBaseBeforeMs = 0L;
        public long mAudioLenBaseAfterMs = 0L;
        public long mVideoLenOnlyBefore = Integer.MIN_VALUE;
        public long mAudioLenOnlyBefore = Integer.MIN_VALUE;
        public long mPlayerReqOffset = Integer.MIN_VALUE;
        public long mVideoAudioGap = 0L;
        public String mResolutionBefore = "";
        public String mResolutionAfter = "";
        public int mConfigBitrateBefore = Integer.MIN_VALUE;
        public int mConfigBitrateAfter = Integer.MIN_VALUE;
        public int mIsABR = Integer.MIN_VALUE;
        public String mQualityDescBefore = "";
        public String mQualityDescAfter = "";
        public double mCpuRate = 1.4E-45f;
        public double mCpuSpeed = 1.4E-45f;
        public int mPowerSaveMode = Integer.MIN_VALUE;
        public float mCurrent = Float.MIN_VALUE;

        private EventContext() {
        }
    }
}

