/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ss.ttvideoengine.log.DeviceMonitorUtils;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class VideoEventOneNoRender {
    private static final String TAG = "VideoEventOneNoRender";
    public static final String EVENT_TYPE = "av_norender";
    public static final String monitorName = "videoplayer_oneevent";
    public static final String END_TYPE_EXIT = "exit";
    public static final String END_TYPE_WAIT = "wait";
    public static final int REASON_PLAYER = 0;
    public static final int REASON_TEXTURE_RENDER_NO_CALLBACK = 1;
    public static final int REASON_TEXTURE_RENDER_NO_DRAW = 2;
    public static final int TYPE_VIDEO = 0;
    public static final int TYPE_AUDIO = 1;
    public static final int NO_RENDER_DURATION_UPLOAD_THRESHOLD = 1000;
    private VideoEventBase mEventBase;
    private EventContext mEventContext;
    private boolean isStarted;
    private int index;
    public long mFirstFrameTime = Integer.MIN_VALUE;
    public int mIsAVBadInterlaced = 0;
    private ArrayList<String> mAudioHistoryList;
    private ArrayList<String> mVideoHistoryList;

    public VideoEventOneNoRender(VideoEventBase eventBase) {
        this.mEventBase = eventBase;
        this.mEventContext = new EventContext();
    }

    public void start(int type, int reason, int clock, long lastRebufTime, long lastSeekTime, long lastHeadsetSwitchTime) {
        long curTime;
        this.isStarted = true;
        this.mEventContext.startTime = curTime = System.currentTimeMillis();
        this.mEventContext.noRenderType = type;
        this.mEventContext.reason = reason;
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            String nStageError;
            Map<String, Long> bufStates = LoggerUtils.parsePlayerBufferString(this.mEventBase.mDataSource.getLogValueStr(55));
            if (bufStates.get("fvl") != null) {
                this.mEventContext.videoFormatLengthMs = bufStates.get("fvl");
            }
            if (bufStates.get("fal") != null) {
                this.mEventContext.audioFormatLengthMs = bufStates.get("fal");
            }
            if (bufStates.get("dvl") != null) {
                this.mEventContext.videoDecoderLengthMs = bufStates.get("dvl");
            }
            if (bufStates.get("dal") != null) {
                this.mEventContext.audioDecoderLengthMs = bufStates.get("dal");
            }
            if (bufStates.get("bvl") != null) {
                this.mEventContext.videoBaseLengthMs = bufStates.get("bvl");
            }
            if (bufStates.get("bal") != null) {
                this.mEventContext.audioBaseLengthMs = bufStates.get("bal");
            }
            if (!TextUtils.isEmpty((CharSequence)(nStageError = VideoEventOneNoRender.parseNoRenderError(this.mEventBase.mDataSource.getLogValueStr(110))))) {
                this.mEventContext.stageError = nStageError;
                TTVideoEngineLog.d(TAG, "stage error: " + this.mEventContext.stageError);
            }
        }
        this.mEventContext.mBeginPos = clock;
        this.mEventContext.mLastRebufT = lastRebufTime == 0L ? this.mEventContext.startTime : lastRebufTime;
        this.mEventContext.mLastSeekT = lastSeekTime == 0L ? this.mEventContext.startTime : lastSeekTime;
        if (lastHeadsetSwitchTime > 0L) {
            this.mEventContext.mLastHeadsetSwitchInterval = curTime - lastHeadsetSwitchTime;
        }
        if (this.mEventBase != null) {
            Object is_abr;
            this.mEventContext.mResolutionBefore = this.mEventBase.mCurrentResolution;
            this.mEventContext.mQualityDescBefore = this.mEventBase.mCurrentQualityDesc;
            if (this.mEventBase.abrInfo != null && (is_abr = this.mEventBase.abrInfo.get("abr_used")) != null) {
                this.mEventContext.mIsABR = (Integer)is_abr;
            }
            if (this.mEventBase.mDataSource != null) {
                this.mEventContext.mIsRadioMode = this.mEventBase.mDataSource.getLogValueInt(88);
                this.mEventContext.mHeadset = this.mEventBase.mDataSource.getLogValueInt(89);
                this.mEventContext.mBt = this.mEventBase.mDataSource.getLogValueInt(90);
                this.mEventContext.mIsBackground = this.mEventBase.mDataSource.getLogValueInt(94);
                long t = this.mEventBase.mDataSource.getLogValueLong(91);
                if (t > 0L) {
                    this.mEventContext.mLastAVSwitchInterval = curTime - t;
                }
                if ((t = this.mEventBase.mDataSource.getLogValueLong(92)) > 0L) {
                    this.mEventContext.mLastResSwitchInterval = curTime - t;
                }
                if ((t = this.mEventBase.mDataSource.getLogValueLong(95)) > 0L) {
                    this.mEventContext.mLastForebackSwitchInterval = curTime - t;
                }
                if ((t = this.mEventBase.mDataSource.getLogValueLong(112)) > 0L) {
                    this.mEventContext.mLastSetSurfaceNullInterval = curTime - t;
                }
                this.mEventContext.mEnableGloablMuteFeature = this.mEventBase.mDataSource.getLogValueInt(121);
                this.mEventContext.mGlobalMute = this.mEventBase.mDataSource.getLogValueInt(122);
            }
            if (this.mEventBase.mEnablePowerReport) {
                double cpuRate = this.mEventBase.getCPURate();
                double cpuSpeed = this.mEventBase.getCPUSpeed();
                if (cpuRate > 0.0 && cpuSpeed > 0.0) {
                    this.mEventContext.mCpuRate = cpuRate;
                    this.mEventContext.mCpuSpeed = cpuSpeed;
                } else {
                    EngineThreadPool.addExecuteTask(new StatisticDataRunnable(this.mEventContext, this.mEventBase));
                }
                int isPowerSaveMod = DeviceMonitorUtils.isPowerSaveMode(this.mEventBase.mContext);
                if (isPowerSaveMod >= 0) {
                    this.mEventContext.mPowerSaveMode = isPowerSaveMod;
                }
                this.mEventContext.mCurrent = this.mEventBase.getBatteryCurrent();
            }
        }
    }

    static String parseNoRenderError(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] array = str.split(";|=");
        if (array == null || array.length == 0) {
            return null;
        }
        for (int i = 0; i < array.length - 1; i += 2) {
            try {
                map.put(array[i], Integer.parseInt(array[i + 1]));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        return new JSONObject(map).toString();
    }

    public void end(int clock, String end_type) {
        if (!this.isStarted()) {
            return;
        }
        this.isStarted = false;
        long curT = System.currentTimeMillis();
        if (this.mEventContext.startTime > 0L) {
            this.mEventContext.costTime = curT - this.mEventContext.startTime;
        }
        this.mEventContext.mEndType = end_type;
        this.mEventContext.mEndPos = clock;
        this.mEventContext.mEndT = curT;
        if (this.mEventBase != null && this.mEventBase.mDataSource != null) {
            this.mEventContext.mSetValidSurfaceTimeout = this.mEventBase.mDataSource.getLogValueInt(113);
        }
        this.addToHistory();
        this.maybeSendEvent();
        this.mEventContext = new EventContext();
    }

    public void updateReason(int reason) {
        if (this.mEventContext.reason != 0 && reason == 0) {
            this.mEventContext.reason = 0;
        }
    }

    private void addToHistory() {
        String history = VideoEventOneNoRender.generateHistory(this.mEventContext);
        if (TextUtils.isEmpty((CharSequence)history)) {
            return;
        }
        if (this.mEventContext.noRenderType == 0) {
            if (this.mVideoHistoryList == null) {
                this.mVideoHistoryList = new ArrayList();
            }
            this.mVideoHistoryList.add(history);
        } else if (this.mEventContext.noRenderType == 1) {
            if (this.mAudioHistoryList == null) {
                this.mAudioHistoryList = new ArrayList();
            }
            this.mAudioHistoryList.add(history);
        }
    }

    private static String generateHistory(@NonNull EventContext eventContext) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("st", eventContext.startTime);
        map.put("c", eventContext.costTime);
        map.put("reason", eventContext.reason);
        try {
            return new JSONObject(map).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void maybeSendEvent() {
        if (this.mEventContext.costTime < 1000L) {
            TTVideoEngineLog.d(TAG, "duration less than threshold, abort event");
            return;
        }
        ++this.index;
        this.mEventBase.updateVideoInfo(null);
        EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this, this.mEventBase, this.mEventContext));
    }

    public void reset() {
        this.mEventContext = new EventContext();
        this.mVideoHistoryList = null;
        this.mAudioHistoryList = null;
        this.isStarted = false;
        this.index = 0;
        this.mFirstFrameTime = Integer.MIN_VALUE;
        this.mIsAVBadInterlaced = 0;
    }

    public void showedFirstFrame() {
        this.mFirstFrameTime = System.currentTimeMillis();
    }

    public void onAVBadInterlaced() {
        this.mIsAVBadInterlaced = 1;
    }

    public void updateEventBase(VideoEventBase eventBase) {
        this.mEventBase = eventBase;
    }

    public boolean isType(int type) {
        return this.mEventContext.noRenderType == type;
    }

    public int getType() {
        return this.mEventContext.noRenderType;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public String getRenderStageError() {
        return this.mEventContext.stageError;
    }

    public ArrayList<String> getVideoHistory() {
        return this.mVideoHistoryList;
    }

    public ArrayList<String> getAudioHistory() {
        return this.mAudioHistoryList;
    }

    public JSONObject toJsonObject(VideoEventBase eventBase, EventContext eventContext) {
        HashMap map = new HashMap();
        LoggerUtils.putToMap(map, "event_type", EVENT_TYPE);
        if (eventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", eventBase.mSessionID);
            LoggerUtils.putToMap(map, "sdk_version", eventBase.sdk_version);
        }
        LoggerUtils.putToMap(map, "r_stage_errcs", eventContext.stageError);
        LoggerUtils.putToMap(map, "video_len_before", eventContext.videoFormatLengthMs);
        LoggerUtils.putToMap(map, "audio_len_before", eventContext.audioFormatLengthMs);
        LoggerUtils.putToMap(map, "vlen_dec_before", eventContext.videoDecoderLengthMs);
        LoggerUtils.putToMap(map, "alen_dec_before", eventContext.audioDecoderLengthMs);
        LoggerUtils.putToMap(map, "vlen_base_before", eventContext.videoBaseLengthMs);
        LoggerUtils.putToMap(map, "alen_base_before", eventContext.audioBaseLengthMs);
        LoggerUtils.putToMap(map, "cost_time", eventContext.costTime);
        LoggerUtils.putToMap(map, "index", this.index);
        LoggerUtils.putToMap(map, "norender_type", eventContext.noRenderType);
        LoggerUtils.putToMap(map, "reason", eventContext.reason);
        if (eventBase != null) {
            if (eventBase.mCurURL == null || eventBase.mCurURL.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mInitialURL);
            } else {
                LoggerUtils.putToMap(map, "cdn_url", eventBase.mCurURL);
            }
            LoggerUtils.putToMap(map, "source_type", eventBase.mSourceTypeStr);
            LoggerUtils.putToMap(map, "v", eventBase.mVid);
            LoggerUtils.putToMap(map, "vtype", eventBase.vtype);
            LoggerUtils.putToMap(map, "tag", eventBase.mTag);
            LoggerUtils.putToMap(map, "subtag", eventBase.mSubTag);
            LoggerUtils.putToMap(map, "codec", eventBase.codec_type);
            LoggerUtils.putToMap(map, "video_codec_nameid", eventBase.videoCodecNameId);
            LoggerUtils.putToMap(map, "audio_codec_nameid", eventBase.audioCodecNameId);
            LoggerUtils.putToMap(map, "format_type", eventBase.formatType);
            LoggerUtils.putToMap(map, "drm_type", eventBase.mDrmType);
            LoggerUtils.putToMap(map, "play_speed", eventBase.mPlaySpeed);
            LoggerUtils.putToMap(map, "enable_mdl", eventBase.mEnableMDL);
            LoggerUtils.putToMap(map, "video_hw", eventBase.mVideoHW);
            LoggerUtils.putToMap(map, "user_hw", eventBase.mVideoHWUser);
        }
        LoggerUtils.putToMap(map, "st", eventContext.startTime);
        LoggerUtils.putToMap(map, "et", eventContext.mEndT);
        LoggerUtils.putToMap(map, "end_type", eventContext.mEndType);
        LoggerUtils.putToMap(map, "resolution_before", eventContext.mResolutionBefore);
        LoggerUtils.putToMap(map, "radio_mode", eventContext.mIsRadioMode);
        LoggerUtils.putToMap(map, "setvalidsurface_timeout", eventContext.mSetValidSurfaceTimeout);
        LoggerUtils.putToMap(map, "last_av_switch_interval", eventContext.mLastAVSwitchInterval);
        LoggerUtils.putToMap(map, "last_res_switch_interval", eventContext.mLastResSwitchInterval);
        LoggerUtils.putToMap(map, "headset", eventContext.mHeadset);
        LoggerUtils.putToMap(map, "bt", eventContext.mBt);
        LoggerUtils.putToMap(map, "last_headset_switch_interval", eventContext.mLastHeadsetSwitchInterval);
        LoggerUtils.putToMap(map, "is_background", eventContext.mIsBackground);
        LoggerUtils.putToMap(map, "last_foreback_switch_interval", eventContext.mLastForebackSwitchInterval);
        LoggerUtils.putToMap(map, "last_setsurfacenull_interval", eventContext.mLastSetSurfaceNullInterval);
        long first_frame_interval = -1L;
        if (this.mFirstFrameTime > 0L) {
            first_frame_interval = eventContext.startTime - this.mFirstFrameTime;
        }
        LoggerUtils.putToMap(map, "first_frame_interval", first_frame_interval);
        LoggerUtils.putToMap(map, "begin_pos", eventContext.mBeginPos);
        LoggerUtils.putToMap(map, "end_pos", eventContext.mEndPos);
        if (eventContext.mLastRebufT > 0L) {
            LoggerUtils.putToMap(map, "last_rebuf_interval", eventContext.startTime - eventContext.mLastRebufT);
        }
        if (eventContext.mLastSeekT > 0L) {
            LoggerUtils.putToMap(map, "last_seek_interval", eventContext.startTime - eventContext.mLastSeekT);
        }
        LoggerUtils.putToMap(map, "is_abr", eventContext.mIsABR);
        LoggerUtils.putToMap(map, "quality_desc_before", eventContext.mQualityDescBefore);
        LoggerUtils.putToMap(map, "bad_interlaced", this.mIsAVBadInterlaced);
        LoggerUtils.putToMap(map, "enable_global_mute_feature", eventContext.mEnableGloablMuteFeature);
        LoggerUtils.putToMap(map, "global_mute", eventContext.mGlobalMute);
        LoggerUtils.putToMap(map, "cpu_rate", (float)eventContext.mCpuRate);
        LoggerUtils.putToMap(map, "cpu_speed", (float)eventContext.mCpuSpeed);
        LoggerUtils.putToMap(map, "power_save_mode", eventContext.mPowerSaveMode);
        LoggerUtils.putToMap(map, "battery_current", eventContext.mCurrent);
        return new JSONObject(map);
    }

    public static int unifyReason(int textureRenderReason) {
        int reason = 2;
        switch (textureRenderReason) {
            case 0: {
                reason = 1;
                break;
            }
            case 1: {
                reason = 2;
            }
        }
        return reason;
    }

    private static class StatisticDataRunnable
    implements Runnable {
        private final WeakReference<EventContext> rEvent;
        private final WeakReference<VideoEventBase> rEventBase;

        public StatisticDataRunnable(EventContext event, VideoEventBase eventBase) {
            this.rEvent = new WeakReference<EventContext>(event);
            this.rEventBase = new WeakReference<VideoEventBase>(eventBase);
        }

        @Override
        public void run() {
            DeviceMonitorUtils.CPUInfo cpuInfo;
            EventContext event = (EventContext)this.rEvent.get();
            VideoEventBase eventBase = (VideoEventBase)this.rEventBase.get();
            if (event != null && eventBase != null && (cpuInfo = eventBase.getCurrentCPUInfo()) != null) {
                event.mCpuRate = cpuInfo.cpuAppRate > 0.0 ? cpuInfo.cpuAppRate : (double)1.4E-45f;
                event.mCpuSpeed = cpuInfo.cpuAppSpeed > 0.0 ? cpuInfo.cpuAppSpeed : (double)1.4E-45f;
            }
        }
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private final VideoEventOneNoRender event;
        private final Handler handler;
        private final VideoEventBase eventBase;
        private final EventContext eventContext;

        public AsyncGetLogDataRunnable(VideoEventOneNoRender event, VideoEventBase base, EventContext eventContext) {
            this.event = event;
            this.eventBase = base;
            this.eventContext = eventContext;
            this.handler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.event == null) {
                return;
            }
            boolean isUpload = this.eventBase != null && this.eventBase.isUploadLogEnabled;
            JSONObject json = this.event.toJsonObject(this.eventBase, this.eventContext);
            this.handler.post(() -> VideoEventManager.instance.addEventV2(isUpload, json, VideoEventOneNoRender.monitorName));
        }
    }

    private static class EventContext {
        int noRenderType = Integer.MIN_VALUE;
        int reason = Integer.MIN_VALUE;
        long videoFormatLengthMs = Integer.MIN_VALUE;
        long audioFormatLengthMs = Integer.MIN_VALUE;
        long videoDecoderLengthMs = Integer.MIN_VALUE;
        long audioDecoderLengthMs = Integer.MIN_VALUE;
        long videoBaseLengthMs = Integer.MIN_VALUE;
        long audioBaseLengthMs = Integer.MIN_VALUE;
        long startTime = Integer.MIN_VALUE;
        long costTime = Integer.MIN_VALUE;
        String stageError;
        long mEndT = Integer.MIN_VALUE;
        String mResolutionBefore = null;
        long mLastRebufT = Integer.MIN_VALUE;
        long mLastSeekT = Integer.MIN_VALUE;
        int mBeginPos = Integer.MIN_VALUE;
        int mEndPos = Integer.MIN_VALUE;
        String mEndType = null;
        int mIsABR = Integer.MIN_VALUE;
        String mQualityDescBefore = "";
        int mIsRadioMode = Integer.MIN_VALUE;
        long mLastAVSwitchInterval = Integer.MIN_VALUE;
        long mLastResSwitchInterval = Integer.MIN_VALUE;
        int mHeadset = Integer.MIN_VALUE;
        int mBt = Integer.MIN_VALUE;
        long mLastHeadsetSwitchInterval = Integer.MIN_VALUE;
        int mIsBackground = Integer.MIN_VALUE;
        long mLastForebackSwitchInterval = Integer.MIN_VALUE;
        long mLastSetSurfaceNullInterval = Integer.MIN_VALUE;
        int mSetValidSurfaceTimeout = Integer.MIN_VALUE;
        int mEnableGloablMuteFeature = 0;
        int mGlobalMute = 0;
        double mCpuRate = 1.4E-45f;
        double mCpuSpeed = 1.4E-45f;
        int mPowerSaveMode = Integer.MIN_VALUE;
        float mCurrent = Float.MIN_VALUE;

        private EventContext() {
        }
    }
}

