/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.text.TextUtils;
import com.ss.ttvideoengine.log.VideoEventOnePlay;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VideoEventOneStorage {
    private static final String TAG = "VideoEventOneStorage";
    private ConcurrentMap<String, StorageContext> mStorageMap = new ConcurrentHashMap<String, StorageContext>();

    private VideoEventOneStorage() {
    }

    public static final VideoEventOneStorage getInstance() {
        return VideoEventOneStorageHolder.instance;
    }

    public void storeVideoId(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            TTVideoEngineLog.i(TAG, "storeVideoId return");
            return;
        }
        this.getStorageContextFromMap(vid);
    }

    public void storeSessionId(String vid, String sessionId) {
        if (TextUtils.isEmpty((CharSequence)vid) || TextUtils.isEmpty((CharSequence)sessionId)) {
            TTVideoEngineLog.i(TAG, "storeSessionId return");
            return;
        }
        StorageContext storageContext = this.getStorageContextFromMap(vid);
        storageContext.mSessionId = sessionId;
        TTVideoEngineLog.i(TAG, "storeSessionId, session id:" + storageContext.mSessionId);
    }

    private StorageContext getStorageContextFromMap(String vid) {
        StorageContext storageContext = (StorageContext)this.mStorageMap.get(vid);
        if (storageContext == null) {
            TTVideoEngineLog.i(TAG, "getStorageContextFromMap, new context, vid:" + vid);
            storageContext = new StorageContext();
            this.mStorageMap.put(vid, storageContext);
        } else {
            TTVideoEngineLog.i(TAG, "getStorageContextFromMap, old context, vid:" + vid);
        }
        return storageContext;
    }

    public void storeOnePlay(String vid, VideoEventOnePlay onePlay) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            TTVideoEngineLog.i(TAG, "storeOnePlay return");
            return;
        }
        TTVideoEngineLog.d(TAG, "storeOnePlay, vid:" + vid);
        StorageContext storageContext = this.getStorageContextFromMap(vid);
        if (storageContext.mOnePlay == null) {
            TTVideoEngineLog.i(TAG, "storeOnePlay new, vid:" + vid);
            storageContext.mOnePlay = onePlay;
        } else {
            TTVideoEngineLog.i(TAG, "storeOnePlay store, vid:" + vid);
            this.storeOnePlayInternal(storageContext.mOnePlay, onePlay);
        }
    }

    private void storeOnePlayInternal(VideoEventOnePlay _old, VideoEventOnePlay _new) {
        _old.et = _new.et;
        _old.videoBufferLength = _new.videoBufferLength;
        _old.audioBufferLength = _new.audioBufferLength;
        _old.leave_reason = _new.leave_reason;
        _old.leave_block_t = _new.leave_block_t;
        _old.leave_method = _new.leave_method;
        _old.server_local_diff = _new.server_local_diff;
        _old.videoAudioGap = _new.videoAudioGap;
        if (_new.errt != Integer.MIN_VALUE) {
            _old.errt = _new.errt;
        }
        if (_new.errc != Integer.MIN_VALUE) {
            _old.errc = _new.errc;
        }
        if (_new.lastSeekStartT != Integer.MIN_VALUE) {
            _old.lastSeekStartT = _new.lastSeekStartT;
        }
        if (_new.lastSeekEndT != Integer.MIN_VALUE) {
            _old.lastSeekEndT = _new.lastSeekEndT;
        }
        if (_new.lastBufferStartT != Integer.MIN_VALUE) {
            _old.lastBufferStartT = _new.lastBufferStartT;
        }
        if (_new.lastBufferEndT != Integer.MIN_VALUE) {
            _old.lastBufferEndT = _new.lastBufferEndT;
        }
        if (_new.lastResolutionStartT != Integer.MIN_VALUE) {
            _old.lastResolutionStartT = _new.lastResolutionStartT;
        }
        if (_new.lastResolutionEndT != Integer.MIN_VALUE) {
            _old.lastResolutionEndT = _new.lastResolutionEndT;
        }
        if (_new.lastSeekPosition != Integer.MIN_VALUE) {
            _old.lastSeekPosition = _new.lastSeekPosition;
        }
        if (_new.lastHijackCode != -1) {
            _old.lastHijackCode = _new.lastHijackCode;
        }
        _old.bc += _new.bc;
        _old.br += _new.br;
        _old.watchduration += _new.watchduration;
        _old.vps += _new.vps;
        _old.vds += _new.vds;
        _old.bufferAccuT += _new.bufferAccuT;
        _old.mPlayList.addAll(_new.mPlayList);
        _old.mPauseList.addAll(_new.mPauseList);
        _old.mResolutionList.addAll(_new.mResolutionList);
        _old.mPlaySpeedList.addAll(_new.mPlaySpeedList);
        _old.mRadiomodeList.addAll(_new.mRadiomodeList);
        _old.mLoopList.addAll(_new.mLoopList);
        _old.mErrorList.addAll(_new.mErrorList);
        _old.mRebufList.addAll(_new.mRebufList);
        _old.mSeekList.addAll(_new.mSeekList);
        _old.mAVOutsyncList.addAll(_new.mAVOutsyncList);
        _old.mAVOutsyncCount += _new.mAVOutsyncCount;
        _old.dropCount += _new.dropCount;
        _old.loopcount += _new.loopcount;
        _old.switchResolutionCount += _new.switchResolutionCount;
        _old.bufferAccuT += _new.bufferAccuT;
        _old.decoderBufferAccuT += _new.decoderBufferAccuT;
        _old.seekCount += _new.seekCount;
        _old.mBufferTimeout += _new.mBufferTimeout;
        _old.networkTimeout += _new.networkTimeout;
        _old.seek_accu_t += _new.seek_accu_t;
    }

    public VideoEventOnePlay restoreOnePlay(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            TTVideoEngineLog.i(TAG, "restoreOnePlay return");
            return null;
        }
        TTVideoEngineLog.d(TAG, "degrade mode, restore onePlay from context, vid:" + vid);
        StorageContext storageContext = this.getStorageContextFromMap(vid);
        return storageContext.mOnePlay;
    }

    public String getSessionId(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            TTVideoEngineLog.i(TAG, "getSessionId return");
            return null;
        }
        StorageContext storageContext = this.getStorageContextFromMap(vid);
        TTVideoEngineLog.i(TAG, "getSessionId, session id:" + storageContext.mSessionId);
        return storageContext.mSessionId;
    }

    public void removeByVideoId(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            TTVideoEngineLog.i(TAG, "removeByVideoId return");
            return;
        }
        this.mStorageMap.remove(vid);
        TTVideoEngineLog.i(TAG, "removeByVideoId remove vid:" + vid + ", map size:" + this.mStorageMap.size());
    }

    public static String extractVideoId(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        int index1 = url.indexOf("?rk=");
        int index2 = url.indexOf("&k=");
        if (index1 == -1 || index2 == -1) {
            return null;
        }
        return url.substring(index1 + 4, index2);
    }

    private class StorageContext {
        private String mSessionId = null;
        private VideoEventOnePlay mOnePlay = null;

        private StorageContext() {
        }
    }

    private static class VideoEventOneStorageHolder {
        private static final VideoEventOneStorage instance = new VideoEventOneStorage();

        private VideoEventOneStorageHolder() {
        }
    }
}

