/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.model.MediaBitrateFitterInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BareVideoInfo
extends VideoInfo {
    private static final String TAG = "TTVideoEngine.BareVideoInfo";
    private int mMediaType = -1;
    private int mVWidth = 0;
    private int mVHeight = 0;
    private long mBitrate = 0L;
    private long mDuration = 0L;
    private long mSize = 0L;
    private long mExpire = -1L;
    private String mFileHash = null;
    private String mFileId = null;
    private String mCodecType = null;
    private String mFormat = null;
    private String mCheckInfo = null;
    private Resolution mResolution = null;
    private String mQuality = null;
    private String mGear = null;
    private String mSpadea = null;
    private String mQualityDesc = null;
    private List<String> mUrls = null;

    private BareVideoInfo() {
        super(null);
    }

    @Override
    public int getMediatype() {
        return this.mMediaType;
    }

    @Override
    public int getValueInt(int key) {
        int val = 0;
        switch (key) {
            case 1: {
                val = this.mVWidth;
                break;
            }
            case 2: {
                val = this.mVHeight;
                break;
            }
            case 3: {
                val = (int)this.mBitrate;
                break;
            }
            case 27: {
                val = (int)this.mDuration;
            }
        }
        return val;
    }

    @Override
    @Nullable
    public String getValueStr(int key) {
        String val = null;
        switch (key) {
            case 28: {
                val = this.mFileId;
                break;
            }
            case 31: {
                val = this.mCheckInfo;
                break;
            }
            case 15: {
                val = this.mFileHash;
                break;
            }
            case 8: {
                val = this.mCodecType;
                break;
            }
            case 18: {
                val = this.mQuality;
                break;
            }
            case 6: {
                val = this.mFormat;
                break;
            }
            case 7: {
                val = this.mGear;
                break;
            }
            case 32: {
                val = this.mQualityDesc;
                break;
            }
            case 5: {
                val = this.mSpadea;
            }
        }
        return val;
    }

    @Override
    @NonNull
    public String[] getValueStrArr(int key) {
        String[] val;
        switch (key) {
            case 16: {
                if (this.mUrls != null) {
                    val = this.mUrls.toArray(new String[0]);
                    break;
                }
                val = new String[]{};
                break;
            }
            default: {
                val = new String[]{};
            }
        }
        return val;
    }

    @Override
    public boolean getValueBool(int key) {
        return false;
    }

    @Override
    public long getValueLong(int key) {
        long val = 0L;
        switch (key) {
            case 12: {
                val = this.mSize;
                break;
            }
            case 30: {
                val = this.mExpire;
            }
        }
        return val;
    }

    @Override
    public Resolution getResolution() {
        return this.mResolution;
    }

    @Override
    public void setValue(int key, String[] value) {
        switch (key) {
            case 16: {
                this.mUrls = new ArrayList<String>();
                Collections.addAll(this.mUrls, value);
                return;
            }
        }
    }

    @Override
    @Nullable
    public JSONObject toBashJsonObject() {
        return super.toBashJsonObject();
    }

    @Override
    @Nullable
    public MediaBitrateFitterInfo getBitrateFitterInfo() {
        return null;
    }

    @Override
    public Map<String, Object> toMediaInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("file_id", this.getValueStr(28));
        info.put("media_type", this.getMediatype() == VideoRef.TYPE_VIDEO ? "video" : "audio");
        info.put("file_size", this.getValueLong(12));
        info.put("bitrate", this.getValueInt(3));
        info.put("quality", this.getValueStr(18));
        info.put("definition", this.getValueStr(7));
        info.put("resolution", this.mResolution != null ? this.mResolution.getIndex() : 0);
        info.put("width", this.getValueInt(1));
        info.put("height", this.getValueInt(2));
        info.put("codec", this.getValueStr(8));
        info.put("urls", this.getValueStrArr(16));
        info.put("file_hash", this.getValueStr(15));
        if (this.mPreloadGear != null) {
            info.put("preload_gear_data", this.mPreloadGear);
        }
        return info;
    }

    @Override
    public int fromMediaInfoJsonObject(JSONObject jsonObject) {
        try {
            this.mFileId = jsonObject.optString("file_id");
            this.mMediaType = jsonObject.optString("media_type").compareTo("audio") == 0 ? VideoRef.TYPE_AUDIO : VideoRef.TYPE_VIDEO;
            this.mSize = jsonObject.optLong("file_size");
            this.mBitrate = jsonObject.optInt("bitrate");
            this.mQuality = jsonObject.optString("quality");
            this.mDefinition = jsonObject.optString("definition");
            this.mResolution = Resolution.valueOf(jsonObject.optInt("resolution", 0));
            this.mVWidth = jsonObject.optInt("width");
            this.mVHeight = jsonObject.optInt("height");
            this.mCodecType = jsonObject.optString("codec");
            JSONArray jUrls = jsonObject.getJSONArray("urls");
            for (int i = 0; i < jUrls.length(); ++i) {
                String url = jUrls.getString(i);
                if (TextUtils.isEmpty((CharSequence)url)) continue;
                if (this.mUrls == null) {
                    this.mUrls = new ArrayList<String>();
                }
                this.mUrls.add(url);
            }
            this.mFileHash = jsonObject.optString("file_hash");
            return 0;
        }
        catch (Exception e) {
            TTVideoEngineLog.i(TAG, "[GearStrategy]fromMediaInfoJsonObject exception=" + e);
            return -1;
        }
    }

    public static class Builder {
        private int mMediaType = 0;
        private int mVWidth = 0;
        private int mVHeight = 0;
        private long mBitrate = 0L;
        private long mDuration = 0L;
        private long mSize = 0L;
        private long mExpire = -1L;
        private String mFileHash = null;
        private String mFileId = null;
        private String mCodecType = null;
        private String mFormat = null;
        private String mCheckInfo = null;
        private Resolution mResolution = null;
        private String mQuality = null;
        private String mQualityDesc = null;
        private String mGear = null;
        private String mSpadea = null;
        private List<String> mUrls = null;

        public Builder mediaType(int mediaType) {
            this.mMediaType = mediaType;
            return this;
        }

        public Builder vWidth(int vWidth) {
            this.mVWidth = vWidth;
            return this;
        }

        public Builder vHeight(int vHeight) {
            this.mVHeight = vHeight;
            return this;
        }

        public Builder bitrate(long bitrate) {
            this.mBitrate = bitrate;
            return this;
        }

        public Builder size(long size) {
            this.mSize = size;
            return this;
        }

        public Builder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder expire(long expire) {
            this.mExpire = expire;
            return this;
        }

        public Builder format(String format) {
            this.mFormat = format;
            return this;
        }

        public Builder fileHash(String fileHash) {
            this.mFileHash = fileHash;
            return this;
        }

        public Builder fileId(String fileId) {
            this.mFileId = fileId;
            return this;
        }

        public Builder codecType(String codecType) {
            this.mCodecType = codecType;
            return this;
        }

        public Builder gear(String gear) {
            this.mGear = gear;
            return this;
        }

        public Builder quality(String quality) {
            this.mQuality = quality;
            return this;
        }

        public Builder qualityDesc(String qualityDesc) {
            this.mQualityDesc = qualityDesc;
            return this;
        }

        public Builder spadea(String spadea) {
            this.mSpadea = spadea;
            return this;
        }

        public Builder resolution(Resolution resolution) {
            this.mResolution = resolution;
            return this;
        }

        public Builder checkInfo(String checkInfo) {
            this.mCheckInfo = checkInfo;
            return this;
        }

        public Builder urls(List<String> urls) {
            this.mUrls = urls;
            return this;
        }

        public Builder addUrl(String url) {
            if (this.mUrls == null) {
                this.mUrls = new ArrayList<String>();
            }
            this.mUrls.add(url);
            return this;
        }

        public BareVideoInfo build() {
            BareVideoInfo info = new BareVideoInfo();
            info.mMediaType = this.mMediaType;
            info.mVWidth = this.mVWidth;
            info.mVHeight = this.mVHeight;
            info.mBitrate = this.mBitrate;
            info.mDuration = this.mDuration;
            info.mSize = this.mSize;
            info.mExpire = this.mExpire;
            info.mFileHash = this.mFileHash;
            info.mFileId = this.mFileId;
            info.mCodecType = this.mCodecType;
            info.mFormat = this.mFormat;
            info.mCheckInfo = this.mCheckInfo;
            info.mResolution = this.mResolution;
            info.mQuality = this.mQuality;
            info.mQualityDesc = this.mQualityDesc;
            info.mGear = this.mGear;
            info.mSpadea = this.mSpadea;
            info.mUrls = this.mUrls;
            return info;
        }
    }
}

