/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.os.SystemClock;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DNSServerIP {
    private static final String TAG = "DNSServerIP";
    private static volatile String mServerIP;
    private static volatile long mServerIPTime;
    private static final int UPDATE_PEROID = 300000;

    public static void updateDNSServerIP() {
        if (SystemClock.elapsedRealtime() - mServerIPTime < 300000L) {
            return;
        }
        EngineThreadPool.addExecuteTask(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress inetAddress = InetAddress.getByName("whoami.akamai.net");
                    if (inetAddress != null) {
                        mServerIP = inetAddress.getHostAddress();
                        mServerIPTime = SystemClock.elapsedRealtime();
                        TTVideoEngineLog.i(DNSServerIP.TAG, "update dns server ip:" + mServerIP);
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        });
    }

    public static String getDNSServerIP() {
        DNSServerIP.updateDNSServerIP();
        return mServerIP;
    }
}

