/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.preload;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.concurrent.ConcurrentHashMap;

public class PreloadLoadProgressCenter {
    private static final String TAG = "MediaTaskCenter";
    private ConcurrentHashMap<String, DataLoaderHelper.DataLoaderTaskLoadProgress> mLoadProgress = new ConcurrentHashMap();

    private PreloadLoadProgressCenter() {
    }

    public static PreloadLoadProgressCenter center() {
        return SingleBuilder.center;
    }

    public void putByRawKey(String rawKey, DataLoaderHelper.DataLoaderTaskLoadProgress loadProgress) {
        if (TextUtils.isEmpty((CharSequence)rawKey) || loadProgress == null) {
            TTVideoEngineLog.e(TAG, "[preload] param is invalid");
            return;
        }
        this.mLoadProgress.put(rawKey, loadProgress);
    }

    @Nullable
    public DataLoaderHelper.DataLoaderTaskLoadProgress getLoadProgressByRawKey(String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey)) {
            TTVideoEngineLog.e(TAG, "[preload] get, param is invalid key is null");
            return null;
        }
        return this.mLoadProgress.get(rawKey);
    }

    public void removeLoadProgressByRawKey(String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey)) {
            TTVideoEngineLog.e(TAG, "[preload] remove, param is invalid key is null");
            return;
        }
        this.mLoadProgress.remove(rawKey);
    }

    private static class SingleBuilder {
        private static PreloadLoadProgressCenter center = new PreloadLoadProgressCenter();

        private SingleBuilder() {
        }
    }
}

