/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.source.strategy;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTVideoEngineConfig;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.source.strategy.CodecStrategy;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.WeakHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONObject;

public class SmartUrlFetcher
implements WeakHandler.IHandler {
    private static final String TAG = "CodecStrategy_SmartUrlFetcher";
    private static final int MSG_COMPLETE = 1;
    private static final int MSG_ERROR = 2;
    public static final int CACHE_TYPE_NONE = 0;
    public static final int CACHE_TYPE_HINT_CACHE = 1;
    private final TTVNetClient mHttpClient;
    private final Handler mH;
    private final Callback mCallback;
    private RequestParams mRequestParams;
    private volatile boolean mCanceled;

    public SmartUrlFetcher(Callback callback) {
        this.mCallback = callback;
        this.mHttpClient = TTVideoEngineConfig.gNetClient != null ? TTVideoEngineConfig.gNetClient : new TTHTTPNetwork();
        Looper looper = Looper.myLooper() == null ? Looper.getMainLooper() : Looper.myLooper();
        this.mH = new WeakHandler(looper, this);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Object[] objects = (Object[])msg.obj;
                this.notifyComplete((RequestParams)objects[0], (Integer)objects[1], (Result)objects[2]);
                break;
            }
            case 2: {
                Object[] objects = (Object[])msg.obj;
                this.notifyError((RequestParams)objects[0], (Error)objects[1]);
                break;
            }
        }
    }

    public void setRequestParams(RequestParams requestParams) {
        this.mRequestParams = requestParams;
    }

    public void start() {
        RequestParams params;
        String cacheKey;
        Result cached;
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(TAG, "start " + this.mRequestParams);
        }
        if ((cached = SmartUrlCache.get(cacheKey = SmartUrlCache.key(params = this.mRequestParams))) != null) {
            this.notifyComplete(params, 1, cached);
        } else {
            this.fetch(cacheKey, params);
        }
    }

    private void fetch(final String cacheKey, final RequestParams params) {
        String requestUrl = SmartUrlFetcher.buildRequestUrl(params);
        this.mHttpClient.startTask(requestUrl, new TTVNetClient.CompletionListener(){

            @Override
            public void onCompletion(JSONObject jsonBody, Error error) {
                if (SmartUrlFetcher.this.mCanceled) {
                    return;
                }
                if (error != null) {
                    SmartUrlFetcher.this.notifyError(params, error);
                } else if (jsonBody == null) {
                    SmartUrlFetcher.this.notifyError(params, new Error("kTTVideoErrorDomainFetchingSmartUrlInfo", -9997));
                } else {
                    Result result = Result.parseResult(jsonBody);
                    if (result.error != null) {
                        SmartUrlFetcher.this.notifyError(params, result.error);
                    } else {
                        SmartUrlCache.put(cacheKey, result);
                        SmartUrlFetcher.this.notifyComplete(params, 0, result);
                    }
                }
            }
        });
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(TAG, "fetch " + params + ", requestUrl = " + requestUrl);
        }
    }

    private void notifyError(RequestParams params, Error error) {
        error.domain = "kTTVideoErrorDomainFetchingSmartUrlInfo";
        if (this.mH.getLooper() == Looper.myLooper()) {
            if (this.mCanceled) {
                if (TTVideoEngineLog.d()) {
                    TTVideoEngineLog.d(TAG, "notifyError canceled");
                }
                return;
            }
            if (this.mCallback == null) {
                return;
            }
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(TAG, "notifyError " + params + " " + error);
            }
            this.mCallback.onError(params, error);
        } else {
            this.mH.obtainMessage(2, (Object)new Object[]{params, error}).sendToTarget();
        }
    }

    private void notifyComplete(RequestParams params, int hintCacheType, Result result) {
        if (this.mH.getLooper() == Looper.myLooper()) {
            if (this.mCanceled) {
                if (TTVideoEngineLog.d()) {
                    TTVideoEngineLog.d(TAG, "notifyComplete canceled");
                }
                return;
            }
            if (this.mCallback == null) {
                return;
            }
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(TAG, "notifyComplete " + params + " " + hintCacheType + " " + result);
            }
            this.mCallback.onComplete(params, hintCacheType, result);
        } else {
            this.mH.obtainMessage(1, (Object)new Object[]{params, hintCacheType, result}).sendToTarget();
        }
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        this.mHttpClient.cancel();
        this.mH.removeCallbacksAndMessages(null);
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(TAG, "cancel " + this.mRequestParams);
        }
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    private static String buildRequestUrl(RequestParams params) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("PlayUrl", params.playUrl);
        map.put("Codec", params.codec);
        map.put("Definition", params.definition);
        StringBuilder urlBuilder = new StringBuilder();
        String host = CodecStrategy.SmartUrlVod.getApiHost();
        if (host != null && !host.startsWith("http")) {
            urlBuilder.append("https://");
        }
        urlBuilder.append(host).append("/api/general/getSmartStrategyLitePlayInfo20220101").append("?").append((CharSequence)TTHelper.buildUrlEncodedQuery(map));
        return urlBuilder.toString();
    }

    public static class SmartUrlCache {
        public static final String TAG = "CodecStrategy_SmartUrlCache";
        private static final Map<String, CacheHolder> sCacheMap = new HashMap<String, CacheHolder>();

        @NonNull
        public static String key(@NonNull RequestParams requestParams) {
            if (!TextUtils.isEmpty((CharSequence)requestParams.cacheKey)) {
                return requestParams.cacheKey;
            }
            return requestParams.playUrl;
        }

        public static Result get(@NonNull String key) {
            Result result = SmartUrlCache.find(key);
            TTVideoEngineLog.d(TAG, "get " + key + " " + result);
            return result;
        }

        private static Result find(@NonNull String key) {
            CacheHolder holder = sCacheMap.get(key);
            if (holder == null) {
                return null;
            }
            if (holder.expiredMS == -1L) {
                return holder.result;
            }
            if (holder.expiredMS < SystemClock.uptimeMillis()) {
                return holder.result;
            }
            return null;
        }

        public static void put(@NonNull String key, Result result) {
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(TAG, "put " + key + " " + result);
            }
            sCacheMap.put(key, new CacheHolder(result, -1L));
        }

        public static void remove(@NonNull String key) {
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(TAG, "remove " + key);
            }
            sCacheMap.remove(key);
        }

        public static void clear() {
            if (TTVideoEngineLog.d()) {
                TTVideoEngineLog.d(TAG, "clear");
            }
            sCacheMap.clear();
        }

        public static class CacheHolder {
            private final Result result;
            private final long expiredMS;

            public CacheHolder(@NonNull Result result, long expiredMS) {
                this.result = result;
                this.expiredMS = expiredMS;
            }
        }
    }

    public static class Result {
        public static final int DataStoreStatusUndefined = 0;
        public static final int DataStoreStatusNotExist = 1;
        public static final int DataStoreStatusHasOriginalStream = 2;
        public static final int DataStoreStatusHasEncodeStream = 3;
        public static final int StreamTypeUndefined = 0;
        public static final int StreamTypeOriginalStream = 1;
        public static final int StreamTypeStrategyEncodeStream = 2;
        public static final int StreamTypeFallbackEncodeStream = 3;
        public final int dataStoreStatus;
        public final int streamType;
        public final String originalPlayUrl;
        public final IVideoModel videoModel;
        public final JSONObject jsonResult;
        public final Error error;

        public Result(JSONObject jsonResult, Error error) {
            this.dataStoreStatus = -1;
            this.streamType = -1;
            this.originalPlayUrl = null;
            this.videoModel = null;
            this.jsonResult = jsonResult;
            this.error = error;
        }

        public Result(int dataStoreStatus, int streamType, String originalPlayUrl, IVideoModel videoModel, JSONObject jsonResult, Error error) {
            this.dataStoreStatus = dataStoreStatus;
            this.streamType = streamType;
            this.originalPlayUrl = originalPlayUrl;
            this.videoModel = videoModel;
            this.jsonResult = jsonResult;
            this.error = error;
        }

        private static Result parseResult(@NonNull JSONObject jsonBody) {
            JSONObject jsonResult = jsonBody.optJSONObject("Result");
            if (jsonResult == null) {
                return new Result(jsonBody, new Error("kTTVideoErrorDomainFetchingSmartUrlInfo", -9979, "Result is null"));
            }
            int dataStoreStatus = jsonResult.optInt("DataStoreStatus");
            int streamType = jsonResult.optInt("StreamType");
            String originalPlayUrl = jsonResult.optString("OriginalPlayUrl");
            JSONObject playInfoModel = jsonResult.optJSONObject("PlayInfoModel");
            if (playInfoModel == null || !Result.isStreamTypeValid(streamType)) {
                return new Result(dataStoreStatus, streamType, originalPlayUrl, null, jsonBody, null);
            }
            try {
                VideoModel model = new VideoModel();
                model.extractFields(playInfoModel);
                return new Result(dataStoreStatus, streamType, originalPlayUrl, model, jsonBody, null);
            }
            catch (Throwable throwable) {
                return new Result(dataStoreStatus, streamType, originalPlayUrl, null, jsonBody, new Error("kTTVideoErrorDomainFetchingSmartUrlInfo", -9976, "video model extract failed: " + throwable));
            }
        }

        private static boolean isStreamTypeValid(int streamType) {
            return streamType == 2 || streamType == 3;
        }

        public boolean isEncodeStream() {
            Resolution resolution;
            VideoInfo videoInfo;
            String vid;
            if (this.videoModel != null && (vid = this.videoModel.getVideoRefStr(2)) != null && (videoInfo = this.videoModel.getVideoInfo(resolution = CodecStrategy.SmartUrlVod.findTargetResolution(this.videoModel), false)) != null) {
                String mainUrl = videoInfo.getValueStr(0);
                String backupUrl = videoInfo.getValueStr(17);
                return !TextUtils.isEmpty((CharSequence)mainUrl) || !TextUtils.isEmpty((CharSequence)backupUrl);
            }
            return false;
        }

        public String toString() {
            return "Result{dataStoreStatus=" + this.dataStoreStatus + ", streamType=" + this.streamType + ", originalPlayUrl='" + this.originalPlayUrl + '\'' + ", videoModel=" + this.videoModel + ", jsonResult=" + this.jsonResult + ", error=" + this.error + '}';
        }
    }

    public static class RequestParams {
        public String videoId;
        public String playUrl;
        public String cacheKey;
        public String codec;
        public String definition;

        public String toString() {
            return "RequestParams{videoId='" + this.videoId + '\'' + ", playUrl='" + this.playUrl + '\'' + ", cacheKey='" + this.cacheKey + '\'' + ", codec='" + this.codec + '\'' + ", definition='" + this.definition + '\'' + '}';
        }
    }

    public static interface Callback {
        public void onComplete(@NonNull RequestParams var1, int var2, @NonNull Result var3);

        public void onError(@NonNull RequestParams var1, @NonNull Error var2);
    }
}

