/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.strategrycenter;

import com.bytedance.vcloud.networkpredictor.AwemeSpeedPredictor;
import com.bytedance.vcloud.networkpredictor.DefaultSpeedPredictor;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictor;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorListener;
import com.bytedance.vcloud.networkpredictor.ISpeedPredictorMLConfig;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.Locale;
import java.util.Map;

public class StrategyCenter {
    private static final String TAG = "TTVideoEngine";
    private static ISpeedPredictorListener speedPredictorListener;
    private static ISpeedPredictorMLConfig speedPredictorMlConfig;
    private static Map sConfigInfo;
    public static ISpeedPredictor sNetSpeedPredictor;
    public static ISpeedPredictor sNetAbrSpeedPredictor;

    private StrategyCenter() {
    }

    public static StrategyCenter getInstance() {
        return StrategyCenterHolder.instance;
    }

    public static void setSpeedPredictorMlConfig(ISpeedPredictorMLConfig mlConfig) {
        speedPredictorMlConfig = mlConfig;
    }

    public static void setSpeedPredictorListener(ISpeedPredictorListener predictorListener) {
        speedPredictorListener = predictorListener;
    }

    public static void setConfigInfo(Map configInfo) {
        sConfigInfo = configInfo;
    }

    public static void setSpeedQueueSize(int size) {
        if (sNetSpeedPredictor != null) {
            sNetSpeedPredictor.setSpeedQueueSize(size);
        }
    }

    public static void createSpeedPredictor(int type) {
        if (sNetSpeedPredictor != null) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format(Locale.US, "[IESSpeedPredictor] start speed predictor, type:%d", type));
        if (type == 1 || type == 0 || type == 2 || type == 3) {
            sNetSpeedPredictor = new DefaultSpeedPredictor(type);
        } else {
            try {
                sNetSpeedPredictor = new AwemeSpeedPredictor(speedPredictorListener);
                ((AwemeSpeedPredictor)sNetSpeedPredictor).setupAlgorithmTypeAndConfig(type, speedPredictorMlConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void createNewStartAndSelectGearSpeedPredictor(int type) {
        if (sNetSpeedPredictor != null) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format(Locale.US, "[IESSpeedPredictor] start new speed predictor, type:%d", type));
        sNetSpeedPredictor = new DefaultSpeedPredictor(type);
        sNetSpeedPredictor.setConfigInfo(sConfigInfo);
    }

    public static void createAbrSpeedPredictor(int type, int intervalMs) {
        if (sNetAbrSpeedPredictor != null) {
            return;
        }
        TTVideoEngineLog.d(TAG, String.format(Locale.US, "[ABR] start speed predictor, type:%d\uff0cintervalMs:%d", type, intervalMs));
        sNetAbrSpeedPredictor = new DefaultSpeedPredictor(type);
    }

    public static void closeNewStartAndSelectGearSpeedPredictor() {
        sNetSpeedPredictor.release();
    }

    private static class StrategyCenterHolder {
        private static final StrategyCenter instance = new StrategyCenter();

        private StrategyCenterHolder() {
        }
    }
}

