/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.text.TextUtils;
import com.ss.ttvideoengine.DataLoaderHelper;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.utils.TTHelper;

public class MDLExtraInfoHelper {
    public static String createMDLExtraInfo(VideoInfo info) {
        String p2pVerify;
        StringBuilder extraInfo = new StringBuilder();
        String fileId = info.getValueStr(28);
        if (fileId == null) {
            fileId = "";
        }
        if ((p2pVerify = info.getValueStr(29)) == null) {
            p2pVerify = "";
        }
        extraInfo.append("fileId=");
        extraInfo.append(fileId);
        extraInfo.append("&bitrate=");
        extraInfo.append(info.getValueInt(44));
        extraInfo.append("&pcrc=");
        extraInfo.append(TTHelper.encodeUrl(p2pVerify));
        return extraInfo.toString();
    }

    public static String createMDLExtraInfo(VideoInfo info, DataLoaderHelper.DataLoaderTaskItem taskItem) {
        String p2pVerify;
        StringBuilder extraInfo = new StringBuilder();
        String fileId = info.getValueStr(28);
        if (fileId == null) {
            fileId = "";
        }
        if ((p2pVerify = info.getValueStr(29)) == null) {
            p2pVerify = "";
        }
        int bitrate = info.getValueInt(44);
        extraInfo.append("fileId=");
        extraInfo.append(fileId);
        extraInfo.append("&bitrate=");
        extraInfo.append(bitrate);
        extraInfo.append("&pcrc=");
        extraInfo.append(TTHelper.encodeUrl(p2pVerify));
        extraInfo.append("&tag=");
        extraInfo.append(TTHelper.encodeUrl(taskItem.mTag));
        if (!TextUtils.isEmpty((CharSequence)taskItem.mSubTag)) {
            extraInfo.append("&stag=");
            extraInfo.append(TTHelper.encodeUrl(taskItem.mSubTag));
        }
        return extraInfo.toString();
    }

    public static void addPCDNFlag(DataLoaderHelper.DataLoaderTaskItem item, DataLoaderHelper.DataLoaderTaskItem.TrackItem trackItem) {
        int p2pCdnType = 0;
        if (item.mURLItem != null) {
            p2pCdnType = item.mURLItem.getCdnType();
        } else if (item.mVidItem != null) {
            p2pCdnType = item.mVidItem.getCdnType();
        }
        trackItem.mExternalInfo = MDLExtraInfoHelper.addPCDNFlag(p2pCdnType, trackItem.mExternalInfo);
    }

    public static String addPCDNFlag(int p2pCDNType, String extraInfo) {
        if (p2pCDNType > 0) {
            String enablePCDN = "fp=1";
            if (!TextUtils.isEmpty((CharSequence)extraInfo)) {
                extraInfo = extraInfo + "&";
                extraInfo = extraInfo + enablePCDN;
            } else {
                extraInfo = enablePCDN;
            }
        }
        return extraInfo;
    }

    public static void addTags(DataLoaderHelper.DataLoaderTaskItem item, DataLoaderHelper.DataLoaderTaskItem.TrackItem trackItem) {
        if (item.mTag != null) {
            trackItem.mExternalInfo = trackItem.mExternalInfo == null ? "tag=" + TTHelper.encodeUrl(item.mTag) : trackItem.mExternalInfo + "&tag=" + TTHelper.encodeUrl(item.mTag);
        }
        if (item.mSubTag != null) {
            trackItem.mExternalInfo = trackItem.mExternalInfo == null ? "stag=" + TTHelper.encodeUrl(item.mSubTag) : trackItem.mExternalInfo + "&stag=" + TTHelper.encodeUrl(item.mSubTag);
        }
    }
}

