/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.content.Context;
import com.ss.ttvideoengine.log.HeadsetStateMonitor;
import com.ss.ttvideoengine.utils.IPlayDurationManager;
import com.ss.ttvideoengine.utils.PlayDuration;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class PlayDurationManager
implements IPlayDurationManager {
    private static final String TAG = "PlayDurationManager";
    private final PlayDuration mTotalPlayDuration;
    private final PlayDuration mWiredPlayDuration;
    private final PlayDuration mWirelessPlayDuration;
    private final HeadsetStateMonitor mHeadsetMonitor;
    private volatile boolean mIsPlaying;
    private final HeadsetStateMonitor.HeadsetStateChangedListener mHeadsetStateChangedListener = new HeadsetStateMonitor.HeadsetStateChangedListener(){

        @Override
        public void onHeadsetStateChanged(boolean connected, boolean wireless) {
            TTVideoEngineLog.d(PlayDurationManager.TAG, "onHeadsetStateChanged: " + connected + ", " + wireless);
            if (!connected) {
                PlayDurationManager.this.mWiredPlayDuration.stop();
                PlayDurationManager.this.mWirelessPlayDuration.stop();
            } else if (wireless && PlayDurationManager.this.mIsPlaying) {
                PlayDurationManager.this.mWirelessPlayDuration.start();
                PlayDurationManager.this.mWiredPlayDuration.stop();
            } else if (!wireless && PlayDurationManager.this.mIsPlaying) {
                PlayDurationManager.this.mWiredPlayDuration.start();
                PlayDurationManager.this.mWirelessPlayDuration.stop();
            }
            TTVideoEngineLog.d(PlayDurationManager.TAG, String.format("wiredDuration: %s, wirelessDuration: %s", PlayDurationManager.this.mWiredPlayDuration.getPlayedDuration(), PlayDurationManager.this.mWirelessPlayDuration.getPlayedDuration()));
        }
    };

    public PlayDurationManager(HeadsetStateMonitor headsetStateMonitor) {
        this.mHeadsetMonitor = headsetStateMonitor;
        this.mTotalPlayDuration = new PlayDuration();
        this.mWiredPlayDuration = new PlayDuration();
        this.mWirelessPlayDuration = new PlayDuration();
        headsetStateMonitor.addStateChangedListener(this.mHeadsetStateChangedListener);
    }

    @Override
    public void start() {
        if (this.mIsPlaying) {
            TTVideoEngineLog.i(TAG, "Already started");
            return;
        }
        this.mIsPlaying = true;
        this.mTotalPlayDuration.start();
        if (this.mHeadsetMonitor.isWiredConnected()) {
            this.mWiredPlayDuration.start();
        } else if (this.mHeadsetMonitor.isWirelessConnected()) {
            this.mWirelessPlayDuration.start();
        }
        TTVideoEngineLog.d(TAG, "start play");
    }

    @Override
    public void stop() {
        if (!this.mIsPlaying) {
            TTVideoEngineLog.i(TAG, "Already stopped");
            return;
        }
        this.mIsPlaying = false;
        this.mTotalPlayDuration.stop();
        if (this.mHeadsetMonitor.isWiredConnected()) {
            this.mWiredPlayDuration.stop();
        }
        if (this.mHeadsetMonitor.isWirelessConnected()) {
            this.mWirelessPlayDuration.stop();
        }
        TTVideoEngineLog.d(TAG, String.format("stop: play duration: %s, wiredDuration: %s, wirelessDuration: %s", this.mTotalPlayDuration.getPlayedDuration(), this.mWiredPlayDuration.getPlayedDuration(), this.mWirelessPlayDuration.getPlayedDuration()));
    }

    @Override
    public int getPlayedDuration() {
        return this.mTotalPlayDuration.getPlayedDuration();
    }

    @Override
    public long getWiredPlayedDuration() {
        return this.mWiredPlayDuration.getPlayedDuration();
    }

    @Override
    public long getWirelessPlayedDuration(Context context) {
        return this.mWirelessPlayDuration.getPlayedDuration();
    }

    @Override
    public void clear() {
        this.mTotalPlayDuration.clear();
        this.mWiredPlayDuration.clear();
        this.mWirelessPlayDuration.clear();
    }

    @Override
    public void reset() {
        this.mTotalPlayDuration.reset();
        this.mWiredPlayDuration.reset();
        this.mWirelessPlayDuration.reset();
    }

    @Override
    public void release() {
        this.mHeadsetMonitor.removeStateChangedListener(this.mHeadsetStateChangedListener);
    }
}

