/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.utils;

import android.text.TextUtils;
import com.ss.ttvideoengine.log.VideoEventLoggerV2;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.lang.reflect.Method;

public class TTVideoEngineUtils {
    private static final String TAG = "TTVideoEngineUtils";
    public static final int SENSITIVE_SCENE_NONE = 0;
    public static final int SENSITIVE_SCENE_USER_DISAGREE = 1;
    public static final int SENSITIVE_SCENE_TEEN_MODE = 2;
    public static final int SENSITIVE_SCENE_GUEST_MODE = 3;
    public static int sEnableHTTPSForFetch = 1;
    public static int sSensitiveScene = 0;

    public static String BuildHttpsApi(String apiString) {
        String ret = apiString;
        if (sEnableHTTPSForFetch == 1 && !TextUtils.isEmpty((CharSequence)apiString) && apiString.startsWith("http://")) {
            TTVideoEngineLog.i(TAG, "fetch api need replace https");
            ret = apiString.replaceFirst("http://", "https://");
        }
        return ret;
    }

    public static void setSensitiveScene(int scene) {
        switch (scene) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                sSensitiveScene = scene;
            }
        }
    }

    public static int getSensitiveScene() {
        if (VideoEventLoggerV2.sIsColdStart == 1 && sSensitiveScene > 0) {
            return sSensitiveScene;
        }
        try {
            Class<?> PrivacyPolicyClazz = Class.forName("com.ss.android.ugc.aweme.utils.PrivacyPolicyAgreementUtils");
            Method isUserAgreeMethod = PrivacyPolicyClazz.getMethod("isUserAgreePrivacyPolicy", new Class[0]);
            boolean isUserAgreePrivacyPolicy = (Boolean)isUserAgreeMethod.invoke(null, new Object[0]);
            TTVideoEngineLog.d(TAG, "isUserAgreePrivacyPolicy:" + isUserAgreePrivacyPolicy);
            if (!isUserAgreePrivacyPolicy) {
                return 1;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "get PrivacyPolicy failed:" + e.toString());
        }
        Class<?> ComplianceServiceClazz = null;
        try {
            ComplianceServiceClazz = Class.forName("com.ss.android.ugc.aweme.compliance.api.ComplianceServiceProvider");
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "get ComplianceServiceProvider failed:" + e.toString());
            return -1;
        }
        try {
            if (ComplianceServiceClazz == null) {
                return -1;
            }
            Class<?> TeenModeServiceClazz = Class.forName("com.ss.android.ugc.aweme.compliance.api.services.teenmode.ITeenModeService");
            Method teenModeServiceMethod = ComplianceServiceClazz.getMethod("teenModeService", new Class[0]);
            Object teenModeServiceObj = teenModeServiceMethod.invoke(null, new Object[0]);
            Method isTeenModeOnMethod = TeenModeServiceClazz.getMethod("isTeenModeON", new Class[0]);
            boolean isTeenModeOn = (Boolean)isTeenModeOnMethod.invoke(teenModeServiceObj, new Object[0]);
            TTVideoEngineLog.d(TAG, "isTeenModeOn:" + isTeenModeOn);
            if (isTeenModeOn) {
                return 2;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "get teenModeService failed:" + e.toString());
        }
        try {
            if (ComplianceServiceClazz == null) {
                return -1;
            }
            Class<?> BusinessServiceClazz = Class.forName("com.ss.android.ugc.aweme.compliance.api.services.businesses.IComplianceBusinessService");
            Method businessServiceMethod = ComplianceServiceClazz.getMethod("businessService", new Class[0]);
            Object businessServiceObj = businessServiceMethod.invoke(null, new Object[0]);
            Method isGuestModeMethod = BusinessServiceClazz.getMethod("isGuestMode", new Class[0]);
            boolean isGuestMode = (Boolean)isGuestModeMethod.invoke(businessServiceObj, new Object[0]);
            TTVideoEngineLog.d(TAG, "isGuestMode:" + isGuestMode);
            if (isGuestMode) {
                return 3;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "get businessService failed:" + e.toString());
        }
        return -1;
    }
}

