/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import android.util.Log;

public class CacheModuleLoader {
    private static final String TAG = CacheModuleLoader.class.getSimpleName();
    public static boolean inited = false;
    private static LibraryLoaderProxy sLibraryLoaderProxy = null;

    public static void setLoadProxy(LibraryLoaderProxy proxy) {
        sLibraryLoaderProxy = proxy;
    }

    public static synchronized boolean loadLibrary() {
        if (inited) {
            return true;
        }
        if (sLibraryLoaderProxy == null) {
            sLibraryLoaderProxy = new DefaultLibraryLoaderProxy();
        }
        try {
            inited = sLibraryLoaderProxy.loadLibrary("cachemodule");
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("load cacheModule fail : " + e.getMessage()));
        }
        return inited;
    }

    private static class DefaultLibraryLoaderProxy
    implements LibraryLoaderProxy {
        private DefaultLibraryLoaderProxy() {
        }

        @Override
        public boolean loadLibrary(String libname) {
            boolean loaded = false;
            try {
                System.loadLibrary(libname);
                loaded = true;
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)("default load cacheModule fail : " + t.getMessage()));
            }
            return loaded;
        }
    }

    public static interface LibraryLoaderProxy {
        public boolean loadLibrary(String var1);
    }
}

