/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.vcloud.cacheModule;

import com.bytedance.vcloud.cacheModule.CacheModuleLoader;
import com.bytedance.vcloud.cacheModule.CalledByNative;
import java.util.HashMap;
import java.util.Map;

public class CacheSettings {
    private final Map<OptionKey, String> mStrOptionMap = new HashMap<OptionKey, String>();
    private IGenerateFileKeyCallback mGenerateFileKeyCallback = null;
    private IExchangeUrlCallback mExchangeUrlCallback = null;

    private CacheSettings() {
    }

    public static CacheSettings getInstance() {
        return CacheSettingsHandler.sInstance;
    }

    public void setStringOption(OptionKey key, String value) {
        this.mStrOptionMap.put(key, value);
        if (CacheModuleLoader.inited) {
            this._setStringOption(key.value(), value);
        }
    }

    public String getStringOption(OptionKey key) {
        return this.mStrOptionMap.get(key);
    }

    public void setGenerateFileKeyCallback(IGenerateFileKeyCallback cb) {
        this.mGenerateFileKeyCallback = cb;
        if (CacheModuleLoader.inited) {
            this._setGenerateFileKeyCb(this.mGenerateFileKeyCallback != null);
        }
    }

    @CalledByNative
    public static String generateFileKeyCB(String url, String hlsFileKey, Object extraInfo) {
        CacheSettings cacheSettings = CacheSettings.getInstance();
        if (cacheSettings.mGenerateFileKeyCallback == null) {
            return null;
        }
        return cacheSettings.mGenerateFileKeyCallback.generateFileKey(url, hlsFileKey, (Map)extraInfo);
    }

    public void setExchangeUrlCallback(IExchangeUrlCallback cb) {
        this.mExchangeUrlCallback = cb;
        if (CacheModuleLoader.inited) {
            this._setExchangeUrlCb(this.mExchangeUrlCallback != null);
        }
    }

    @CalledByNative
    public static String exchangeUrlCB(String url) {
        CacheSettings cacheSettings = CacheSettings.getInstance();
        if (cacheSettings.mExchangeUrlCallback == null) {
            return null;
        }
        return cacheSettings.mExchangeUrlCallback.exchangeUrl(url);
    }

    private native void _setStringOption(int var1, String var2);

    private native void _setGenerateFileKeyCb(boolean var1);

    private native void _setExchangeUrlCb(boolean var1);

    static {
        CacheModuleLoader.loadLibrary();
    }

    public static interface IExchangeUrlCallback {
        public String exchangeUrl(String var1);
    }

    public static interface IGenerateFileKeyCallback {
        public String generateFileKey(String var1, String var2, Map<String, String> var3);
    }

    private static class CacheSettingsHandler {
        public static CacheSettings sInstance = new CacheSettings();

        private CacheSettingsHandler() {
        }
    }

    public static class OptionKey {
        public static final OptionKey CACHE_DIR = new OptionKey(0);
        public static final OptionKey DOWNLOAD_DIR = new OptionKey(1);
        private int mName = -1;

        private OptionKey(int name) {
            this.mName = name;
        }

        public int value() {
            return this.mName;
        }
    }
}

