/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.bytedance.vcloud.strategy.IPreloadTaskCallbackListener;
import com.bytedance.vcloud.strategy.ISelectBitrateListener;
import com.ss.mediakit.medialoader.AVMDLCopyOperation;
import com.ss.mediakit.medialoader.AVMDLCopyOperationListener;
import com.ss.mediakit.medialoader.AVMDLDataLoader;
import com.ss.mediakit.medialoader.AVMDLDataLoaderConfigure;
import com.ss.mediakit.medialoader.AVMDLDataLoaderListener;
import com.ss.mediakit.medialoader.AVMDLDataLoaderNotifyInfo;
import com.ss.mediakit.medialoader.AVMDLFileInfo;
import com.ss.mediakit.medialoader.AVMDLLibraryManagerWrapper;
import com.ss.mediakit.medialoader.AVMDLStartCompleteListener;
import com.ss.mediakit.medialoader.AVMDLTaskEventListener;
import com.ss.mediakit.medialoader.IAVMDLLibraryLoader;
import com.ss.mediakit.medialoader.LoaderListener;
import com.ss.mediakit.net.AVMDLDNSParser;
import com.ss.mediakit.net.AVMDLMultiNetwork;
import com.ss.ttm.vcshared.VCBaseKitLoader;
import com.ss.ttvideoengine.AppInfo;
import com.ss.ttvideoengine.DataLoaderHelperAdapter;
import com.ss.ttvideoengine.DataLoaderListener;
import com.ss.ttvideoengine.DataLoaderListener2;
import com.ss.ttvideoengine.DataLoaderListenerWrapper;
import com.ss.ttvideoengine.DataLoaderResourceProvider;
import com.ss.ttvideoengine.EngineGlobalConfig;
import com.ss.ttvideoengine.FeatureManager;
import com.ss.ttvideoengine.IPreLoaderItemCallBackListener;
import com.ss.ttvideoengine.InfoWrapper;
import com.ss.ttvideoengine.LibraryLoaderProxy;
import com.ss.ttvideoengine.PreLoaderItemCallBackInfo;
import com.ss.ttvideoengine.PreloaderURLItem;
import com.ss.ttvideoengine.PreloaderVidItem;
import com.ss.ttvideoengine.PreloaderVideoModelItem;
import com.ss.ttvideoengine.Resolution;
import com.ss.ttvideoengine.TTNetWorkListener;
import com.ss.ttvideoengine.TTNetworkStateCallback;
import com.ss.ttvideoengine.TTVideoEngine;
import com.ss.ttvideoengine.TTVideoEngineHelper;
import com.ss.ttvideoengine.TestSpeedListener;
import com.ss.ttvideoengine.VideoInfoCollector;
import com.ss.ttvideoengine.VideoModelCache;
import com.ss.ttvideoengine.cache.CopyCacheItem;
import com.ss.ttvideoengine.download.Downloader;
import com.ss.ttvideoengine.fetcher.FetcherApiHelper;
import com.ss.ttvideoengine.fetcher.VideoInfoFetcher;
import com.ss.ttvideoengine.log.IVideoEventUploader;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventEngineUploader;
import com.ss.ttvideoengine.model.IVideoInfo;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.model.MediaBitrateFitterInfo;
import com.ss.ttvideoengine.model.VideoInfo;
import com.ss.ttvideoengine.model.VideoModel;
import com.ss.ttvideoengine.model.VideoRef;
import com.ss.ttvideoengine.net.NetUtils;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.preload.PreloadConfig;
import com.ss.ttvideoengine.preload.PreloadLoadProgressCenter;
import com.ss.ttvideoengine.preload.PreloadMedia;
import com.ss.ttvideoengine.preload.PreloadModelMedia;
import com.ss.ttvideoengine.preload.PreloadScene;
import com.ss.ttvideoengine.preload.PreloadTaskConfig;
import com.ss.ttvideoengine.preload.PreloadURLMedia;
import com.ss.ttvideoengine.preload.PreloadUtil;
import com.ss.ttvideoengine.selector.BestResolution;
import com.ss.ttvideoengine.selector.strategy.GearStrategyConfig;
import com.ss.ttvideoengine.selector.strategy.GearStrategyContext;
import com.ss.ttvideoengine.selector.strategy.IGearStrategyListener;
import com.ss.ttvideoengine.setting.SettingsHelper;
import com.ss.ttvideoengine.source.strategy.CodecStrategy;
import com.ss.ttvideoengine.source.strategy.SmartUrlFetcher;
import com.ss.ttvideoengine.strategrycenter.ISelectBitrateCallback;
import com.ss.ttvideoengine.strategrycenter.StrategyHelper;
import com.ss.ttvideoengine.strategy.StrategyManager;
import com.ss.ttvideoengine.utils.DataLoaderCDNLog;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.FormatProvider;
import com.ss.ttvideoengine.utils.Inspector;
import com.ss.ttvideoengine.utils.MDLExtraInfoHelper;
import com.ss.ttvideoengine.utils.TTHelper;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import com.ss.ttvideoengine.utils.TTVideoEngineUtils;
import com.ss.ttvideoengine.utils.ValueWeakReference;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataLoaderHelper
implements AVMDLDataLoaderListener,
AVMDLStartCompleteListener {
    public static final int ERROR_TYPE_NONE = 0;
    public static final int ERROR_TYPE_FETCHVIDEOMODEL = 1;
    public static final int ERROR_TYPE_MODULESTART = 2;
    public static final int ERROR_TYPE_FETCHDATA = 3;
    public static final int ERROR_TYPE_FILEOPERATION = 4;
    private static final String TAG = "DataLoaderHelper";
    public static final String monitorName = "videoplayer_mdl_sample";
    private static final int MAX_URL_LENGTH = 3096;
    public static final int IsStart = 0;
    public static final int IsClose = 1;
    public static final String MDL_PREFIX = "mdl://";
    public static final int IsUnknown = 0;
    public static final int IsPlayTask = 1;
    public static final int IsPreloadTask = 2;
    public static final int DATALOADER_KEY_STRING_CACHEDIR = 0;
    public static final int DATALOADER_KEY_INT_MAXCACHESIZE = 1;
    public static final int DATALOADER_KEY_INT_RWTIMEOUT = 2;
    public static final int DATALOADER_KEY_INT_OPENTIMEOUT = 3;
    public static final int DATALOADER_KEY_INT_TRYCOUNT = 4;
    public static final int DATALOADER_KEY_INT_LOADER_TYPE = 5;
    public static final int DATALOADER_KEY_INT_VERSION_INFO = 6;
    public static final int DATALOADER_KEY_INT_ENABLE_EXTERN_DNS = 7;
    public static final int DATALOADER_KEY_INT_ENABLE_SOCKET_REUSE = 8;
    public static final int DATALOADER_KEY_INT_ENABLE_SOCKET_IDLE_TIMEOUT = 9;
    public static final int DATALOADER_KEY_INT_PLAY_LOG = 10;
    public static final int DATALOADER_KEY_INT_PARALLEL_NUM = 11;
    public static final int DATALOADER_KEY_INT_PRELOAD_STRAGETY = 12;
    public static final int DATALOADER_KEY_INT_CHECKSUM_LEVEL = 13;
    public static final int DATALOADER_KEY_INT_TEST_SPEED_VERSION = 14;
    public static final int DATALOADER_KEY_INT_NEED_DL_LOAD_P2P_LIB = 15;
    @Deprecated
    public static final int DATALOADER_KEY_INT_P2P_LEVEL = 16;
    public static final int DATALOADER_KEY_INT_WRITEFILENOTIFY_INTERVALMS = 17;
    public static final int DATALOADER_KEY_INT_IGNORE_PLAYER_STALL = 18;
    public static final int DATALOADER_KEY_INT_PRELOAD_FLOAT_SIZE = 19;
    public static final int DATALOADER_KEY_INT_PRELOAD_PRE_CONNECT = 20;
    public static final int DATALOADER_KEY_INT_ENABLE_DOWNLOADER_LOG = 21;
    public static final int DATALOADER_KEY_INT_ENABLE_TTNETLOADER = 22;
    public static final int DATALOADER_KEY_INT_TTNETLOADER_CRONET_BUF_SIZE_KB = 23;
    public static final int DATALOADER_KEY_INT_ENABLE_TTQUICHELOADER = 24;
    public static final int DATALOADER_KEY_INT_ENABLE_TTQUICHELOADER_CHECK_WITH_NETWORK_TYPE = 25;
    public static final int DATALOADER_KEY_INT_ENCRYPT_VERSION = 30;
    public static final int DATALOADER_KEY_INT_ENABLE_OKHTTPLOADER = 31;
    public static final int DATALOADER_KEY_INT_FORBID_NATIVE_MDL_FOR_ORIGINAL_URL = 32;
    public static final int DATALOADER_KEY_INT_NEED_MDL_LOAD_MDLV2_LIB = 33;
    public static final int DATALOADER_KEY_INT_PCDN_AUTO = 34;
    public static final int DATALOADER_KEY_INT_IS_CLOSE_FILE_CACHE = 50;
    public static final int DATALOADER_KEY_INT_MAX_CACHE_AGE = 55;
    public static final int DATALOADER_KEY_INT_IS_ENABLE_MAX_CACHE_AGE_FOR_ALL_DIR = 56;
    public static final int DATALOADER_KEY_ENABLE_PRELOAD_REUSE = 60;
    public static final int DATALOADER_KEY_HEART_BEAT_INTERVAL = 61;
    public static final int DATALOADER_KEY_SET_ALOG_WRITE_PTR = 62;
    public static final int DATALOADER_KEY_INT_MAX_IP_COUNT = 63;
    public static final int DATALOADER_KEY_INT_ENABLE_IP_BUCKET = 64;
    public static final int DATALOADER_KEY_INT_ERROR_STATE_TRUST_TIME = 65;
    public static final int DATALOADER_KEY_INT_ONLY_USE_CDN = 66;
    public static final int DATALOADER_KEY_INT_PRELOAD_WAIT_LIST_TYPE = 80;
    public static final int DATALOADER_PRELOAD_WAIT_LIST_IS_STACK = 0;
    public static final int DATALOADER_PRELOAD_WAIT_LIST_IS_QUEUE = 1;
    public static final int DATALOADER_KEY_INT_MAIN_DNS_TYPE = 90;
    public static final int DATALOADER_KEY_INT_BACKUP_DNS_TYPE = 91;
    public static final int DATALOADER_KEY_INT_DNS_MAIN_DELAYED_USE_BACKUP_TIME = 92;
    public static final int DATALOADER_KEY_INT_ENABLE_BENCHMARK_IO = 93;
    public static final int DATALOADER_KEY_INT_SPEED_COEFFICIENTVALUE = 94;
    @Deprecated
    public static final int DATALOADER_KEY_INT_ENABLE_P2P_STRAGETY_CONTROL = 95;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_MIN_PLAYNUM = 96;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_MAX_LEAVE_WAIT_TIME = 97;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_MAX_BUFFERING_TIME = 98;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_EXPIRED_TIME = 99;
    public static final int DATALOADER_KEY_INT_MAX_TLS_VEERSION = 100;
    public static final int DATALOADER_KEY_INT_ENABLE_SESSION_REUSE = 101;
    public static final int DATALOADER_KEY_STRING_NET_CACHE_DIR = 102;
    public static final int DATALOADER_KEY_INT_ENABLE_DNS_PARALLEL_PARSE = 103;
    public static final int DATALOADER_KEY_INT_ENABLE_DNS_BACKUP_IP = 104;
    public static final int DATALOADER_KEY_INT_ENABLE_DNS_REFRESH = 105;
    public static final int DATALOADER_KEY_INT_ENABLE_DNS_LOG = 106;
    public static final int DATALOADER_KEY_STRING_OWN_DNS_HOST = 107;
    public static final int DATALOADER_KEY_STRING_GOOGLE_DNS_HOST = 108;
    public static final int PRELOAD_PROBETYPE_INTERVAL = 0;
    public static final int PRELOAD_PROBETYPE_PLAYTASKPROGRESS = 1;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_MIN_NET_SPEED = 109;
    public static final int DATALOADER_KEY_INT_P2P_STRAGETY_MIN_NET_NETWORK_LEVEL = 110;
    public static final int DATALOADER_KEY_STRING_DOWNLOAD_DIR = 111;
    public static final int DATALOADER_KEY_INT_MULTI_SPEED_SAMPL_INTERVAL = 112;
    public static final int DATALOADER_KEY_INT_GLOBAL_SPEED_SAMPLE_INTERVAL = 113;
    public static final int STRATEGY_INTERACTION_BLOCK_DURATION_PRELOADED = 120;
    public static final int STRATEGY_INTERACTION_BLOCK_DURATION_NON_PRELOADED = 121;
    public static final int DATALOADER_KEY_INT_ENABLE_PREPARSE_HOST = 114;
    public static final int DATALOADER_KEY_INT_ENABLE_BACKUP_IP = 115;
    public static final int DATALOADER_KEY_STRING_SETTINGS_REGION_CN_HOST = 116;
    public static final int DATALOADER_KEY_STRING_SETTINGS_REGION_SG_HOST = 117;
    public static final int DATALOADER_KEY_STRING_SETTINGS_REGION_US_HOST = 118;
    public static final int DATALOADER_KEY_INT_SETTINGS_ENABLE = 119;
    public static final int DATALOADER_KEY_INT_USE_NEW_SPEED_TEST_SINGLE = 121;
    public static final int DATALOADER_KEY_INT_TRACE_HOST = 122;
    public static final int DATALOADER_KEY_DEVICE_SCORE = 123;
    public static final int DATALOADER_KEY_INT_ENABLE_EVENTINFO = 200;
    public static final int DATALOADER_KEY_LIVE_ENEBALE_P2P = 500;
    public static final int DATALOADER_KEY_LIVE_LOADER_TYPE = 501;
    public static final int DATALOADER_KEY_LIVE_LOADER_ENABLE = 502;
    public static final int DATALOADER_KEY_LIVE_WATCH_DURATION_THRESHOLD = 505;
    public static final int DATALOADER_KEY_LIVE_CACHE_HTTP_TO_P2P = 506;
    public static final int DATALOADER_KEY_LIVE_CAHCE_P2P_TO_HTTP = 507;
    public static final int DATALOADER_KEY_LIVE_TRY_SWITCH_P2P_TIMES = 508;
    public static final int DATALOADER_KEY_LIVE_WAIT_P2P_THREDTHOLD = 509;
    public static final int DATALOADER_KEY_LIVE_MOBILE_UPLOAD_ALLOW = 510;
    public static final int DATALOADER_KEY_LIVE_MOBILE_DOWNLOAD_ALLOW = 511;
    public static final int DATALOADER_KEY_ENABLE_ALOG = 512;
    public static final int DATALOADER_KEY_LIVE_RECV_DATA_TIMEOUT = 513;
    public static final int DATALOADER_KEY_LIVE_CONTAINER_STRING = 514;
    public static final int DATALOADER_KEY_INT_NETWORK_CHANGED = 1000;
    public static final int DATALOADER_KEY_INT_ENABLE_PRECONNECT = 1001;
    public static final int DATALOADER_KEY_INT_PRECONNECT_NUM = 1002;
    public static final int DATALOADER_KEY_GET_MDL_PROTOCOL_HANDLE = 1003;
    public static final int DATALOADER_KEY_SET_MDL_PROTOCOL_STATUS = 1004;
    public static final int DATALOADER_KEY_SET_MDL_PROTOCOL_ENABLE = 1005;
    public static final int DATALOADER_KEY_SET_RINGBUFFER_SIZE_KB = 1006;
    public static final int DATALOADER_KEY_ENABLE_FILECACHE_V2 = 1007;
    public static final int DATALOADER_KEY_GET_ACCESS_TYPE = 1008;
    public static final int DATALOADER_KEY_ENABLE_FILE_RING_BUFFER = 1009;
    public static final int DATALOADER_KEY_FILE_EXTEND_BUFFER = 1010;
    public static final int DATALOADER_KEY_INT_ENABLE_NETWORK_CHANGED_LISTEN = 1011;
    public static final int DATALOADER_KEY_INT_ENABLE_REPORT_SPEED = 1100;
    public static final int DATALOADER_KEY_INT_ENABLE_LOADER_PREEMPT = 1101;
    public static final int DATALOADER_KEY_INT_ACCESS_CHECK_LEVEL = 1102;
    public static final int DATALOADER_KEY_INT_START_NEXT_DOWNLOAD_THRESHOLD = 1103;
    public static final int DATALOADER_KEY_INT_CURRENT_ACCESS_TYPE = 1104;
    public static final int DATALOADER_KEY_INT_SOCKET_BUFF_KB = 1105;
    public static final int DATALOADER_KEY_STR_VDP_ABTEST_ID = 1106;
    public static final int DATALOADER_KEY_STR_VDP_ABGROUP_ID = 1107;
    public static final int DATALOADER_KEY_INT_ENABLE_SYNDNS_P2P = 1108;
    public static final int DATALOADER_KEY_INT_SET_BACKUP_LOADERTYPE = 1109;
    public static final int DATALOADER_KEY_INT_XY_LIB_VALUE = 1110;
    public static final int DATALOADER_KEY_INT_CHECK_PRELOAD_LEVEL = 1111;
    public static final int DATALOADER_KEY_INT_NEED_SPEED_TEST_BY_TIMEINTERNAL = 1112;
    public static final int DATALOADER_KEY_INT_AUDIO_PRELOAD_FIRST = 1113;
    public static final int DATALOADER_KEY_INT_HEADER_DATA_MEM_CACHE = 1114;
    public static final int DATALOADER_KEY_INT_IPV6_NUM = 1115;
    public static final int DATALOADER_KEY_INT_IPV4_NUM = 1116;
    public static final int DATALOADER_KEY_INT_FORBID_BYPASS_COOKIE = 1117;
    public static final int DATALOADER_KEY_INT_ENABLE_LAZY_BUFFERPOOL = 1118;
    public static final int DATALOADER_KEY_INT_SESSION_TIMEOUT = 1119;
    public static final int DATALOADER_KEY_INT_ENABLE_NEW_BUFFERPOOL = 1120;
    public static final int DATALOADER_KEY_INT_NEW_BUFFERPOOL_BLOCK_SIZE = 1121;
    public static final int DATALOADER_KEY_INT_NEW_BUFFERPOOL_RESIDENT_SIZE = 1122;
    public static final int DATALOADER_KEY_INT_NEW_BUFFERPOOL_GROWCOUNT = 1123;
    public static final int DATALOADER_KEY_INT_ENABLE_PLAYINFO_CACHE = 1124;
    public static final int DATALOADER_KEY_INT_P2P_FIRSTRANGE_TYPE = 1125;
    public static final int DATALOADER_KEY_INT_P2P_PREDOWN = 1126;
    public static final int DATALOADER_KEY_INT_ENABLE_PLAY_LOG = 1127;
    public static final int DATALOADER_KEY_INT_ENABLE_NETSCHEDULER = 1128;
    public static final int DATALOADER_KEY_INT_NETSCHEDULER_BLOCK_ALL_NETERR = 1129;
    public static final int DATALOADER_KEY_INT_NETSCHEDULER_BLOCK_ERR_COUNT = 1130;
    public static final int DATALOADER_KEY_INT_NETSCHEDULER_BLOCK_DURATION_MS = 1131;
    public static final int DATALOADER_KEY_INT_FIRSTRANGE_LEFT_THRESHOLD = 1132;
    public static final int DATALOADER_KEY_INT_ALLOW_TRY_THE_LAST_URL = 1133;
    public static final int DATALOADER_KEY_INT_ENABLE_CACHE_REQRANGE = 1134;
    public static final int DATALOADER_KEY_INT_ENABLE_LOADER_SEEK = 1135;
    public static final int DATALOADER_KEY_INT_P2P_PREDOWN_PEER_COUNT = 1136;
    public static final int DATALOADER_KEY_INT_ENABLE_DYNAMIC_SOCKET_TIMEOUT = 1137;
    public static final int DATALOADER_KEY_INT_INITIAL_SOCKET_TIMEOUT = 1138;
    public static final int DATALOADER_KEY_INT_MAX_SOCKET_REUSE_NUM = 1139;
    public static final int DATALOADER_KEY_INT_FORCE_DNS_EXPIRED_TIME = 1140;
    public static final int DATALOADER_KEY_INT_DEFAULT_DNS_EXPIRED_TIME = 1141;
    public static final int DATALOADER_KEY_INT64_P2P_STRAGETY_VALUE = 1142;
    public static final int DATALOADER_KEY_INT_P2P_FIRSTRANGE_LOADER_TYPE = 1143;
    public static final int DATALOADER_KEY_INT_CONNECT_POOL_STRAGETY_VALUE = 1144;
    public static final int DATALOADER_KEY_INT_MAX_ALIVE_HOST_NUM = 1145;
    public static final int DATALOADER_KEY_INT_FILE_EXTEND_SIZE = 1146;
    public static final int DATALOADER_KEY_INT_MIN_ALLOW_SPEED = 1147;
    public static final int DATALOADER_KEY_INT_BLOCK_HOST_ERR_IP_COUNT = 1148;
    public static final int DATALOADER_KEY_STRING_NETSCHEDULER_CONFIG_STR = 1149;
    public static final int DATALOADER_KEY_INT_ENABLE_IOMANAGER = 1150;
    public static final int DATALOADER_KEY_INT_ENABLE_OWN_VDP_PRELOAD_NOTIFY = 1151;
    public static final int DATALOADER_KEY_LONG_DOWNLOAD_MONITOR_TIME_INTERNAL = 1152;
    public static final int DATALOADER_KEY_LONG_DOWNLOAD_MONITOR_MIN_LOAD_SIZE = 1153;
    public static final int DATALOADER_KEY_INT_ENABLE_MDLV2 = 1154;
    public static final int DATALOADER_KEY_INT_ENABLE_SPLIT_PRELOAD_WITH_DATALOADER = 1155;
    public static final int DATALOADER_KEY_INT_PRELOAD_LOWER_BOUND_BUFFER_MS = 1156;
    public static final int DATALOADER_KEY_INT_PRELOAD_UPPER_BOUND_BUFFER_MS = 1157;
    public static final int DATALOADER_KEY_INT_MAX_FILE_MEM_CACHE_SIZE = 1158;
    public static final int DATALOADER_KEY_INT_MAX_FILE_MEM_CACHE_NUM = 1159;
    public static final int DATALOADER_KEY_INT_ENABLE_EARLY_DATA = 1160;
    public static final int DATALOADER_KEY_INT_SOCKET_RECV_BUFF_BYTES = 1161;
    public static final int DATALOADER_KEY_INT_ENABLE_SPEED_PREDICT = 1162;
    public static final int DATALOADER_KEY_INT_ENABLE_BUFFER_PRELOAD = 1163;
    public static final int DATALOADER_KEY_ENABLE_USE_ORIGINAL_URL = 1164;
    public static final int DATALOADER_KEY_STRING_DYNAMIC_PRECONNECT_CONFIG_STR = 1165;
    public static final int DATALOADER_KEY_ENABLE_LOADER_LOG_EXTRACT_URLS = 1166;
    public static final int DATALOADER_KEY_MAX_LOADER_LOG_NUM = 1167;
    public static final int DATALOADER_KEY_CHECK_CONTENT_TYPE_METHOD = 1168;
    public static final int DATALOADER_KEY_DISABLE_THREAD_POOL = 1169;
    public static final int DATALOADER_KEY_ENABLE_UPDATE_NET_STATUS = 1170;
    public static final int DATALOADER_KEY_INT_ENABLE_SPEED_ENGINE = 1171;
    public static final int DATALOADER_KEY_INT_ENABLE_SPEED_REPORT = 1172;
    public static final int DATALOADER_KEY_STR_SPEED_ENGINE_SETTING = 1173;
    public static final int DATALOADER_KEY_STRING_MDL_EXTENSION_OPTS = 1500;
    public static final int DATALOADER_KEY_INT_ENABLE_MULTI_NETWORK = 1501;
    public static final int DATALOADER_KEY_STRING_MDL_TEMP_OPTS = 1502;
    public static final int DATALOADER_KEY_INT_DASH_MIN_AUDIO_PRELOAD_SIZE = 1503;
    public static final int DATALOADER_KEY_INT_DASH_AUDIO_PRELOAD_RATIO = 1504;
    public static final int DATALOADER_KEY_INT_ENABLE_STRATEGY_CENTER_CANCEL_ALL = 1505;
    public static final int DATALOADER_KEY_STRING_SET_CUSTON_UA_1 = 1506;
    public static final int DATALOADER_KEY_STRING_SET_CUSTON_UA_2 = 1507;
    public static final int DATALOADER_KEY_STRING_SET_CUSTON_UA_3 = 1508;
    public static final int DATALOADER_KEY_STRING_GET_CUSTON_UA = 1509;
    public static final int DATALOADER_KEY_STRING_FILE_RINGBUFFER_OPT_STR = 1510;
    public static final int DATALOADER_KEY_STRING_N80_OPTS = 1511;
    public static final int DATALOADER_KEY_STRING_TTQUICHE_OPTS = 1512;
    public static final int DATALOADER_KEY_INT_PRELOAD_CHECK_URL = 1513;
    public static final int DATALOADER_KEY_INT_ENABLE_BYTEMEDIANETLOADER = 1701;
    public static final int DATALOADER_KEY_INT_ENABLE_STORAGE_MODULE = 2000;
    public static final int DATALOADER_KEY_INT_STO_PLAY_DLD_WIN_SIZE_KB_NM = 2001;
    public static final int DATALOADER_KEY_INT_STO_PLAY_DLD_WIN_SIZE_KB_LS = 2002;
    public static final int DATALOADER_KEY_INT_STO_RING_BUFFER_SIZE_KB = 2003;
    public static final int DATALOADER_KEY_INT_STO_IO_WRITE_LIMIT_KB_TH1 = 2004;
    public static final int DATALOADER_KEY_INT_STO_IO_WRITE_LIMIT_KB_TH2 = 2005;
    public static final int DATALOADER_KEY_INT_STO_MAX_IDLE_TIME_SEC = 2006;
    public static final int DATALOADER_KEY_STRING_STO_STRATEGY_CONFIG = 2007;
    public static final int DATALOADER_KEY_INT_THREAD_STACK_SIZE_LEVEL = 2008;
    public static final int DATALOADER_KEY_INT_THREADPOOL_MIN_COUNT = 2009;
    public static final int DATALOADER_KEY_INT_ENABLE_THREADPOOL_CHECK_IDLE = 2010;
    public static final int DATALOADER_KEY_INT_THREADPOOL_IDLE_TTL_SECOND = 2011;
    public static final int DATALOADER_KEY_INT_LIMIT_IP_NUM = 2012;
    public static final int DATALOADER_KEY_INT_NON_BLOCK_RANGE_MODE = 2013;
    public static final int DATALOADER_KEY_INT_NON_BLOCK_RANGE_MAX_KB = 2014;
    public static final int DATALOADER_KEY_INT_NET_UNREACHABLE_STOP_RETRY = 2015;
    public static final int DATALOADER_KEY_INT_ENABLE_WAIT_NET_REACHABLE = 2016;
    public static final int DATALOADER_KEY_INT_ENABLE_FILE_MUTEX_OPTIMIZE = 2017;
    public static final int DATALOADER_KEY_INT_SKIP_CDN_BEFORE_EXPIRED_SEC = 2018;
    public static final int DATALOADER_KEY_INT_NET_UNREACHABLE_TIMEOUT = 2019;
    public static final int DATALOADER_KEY_INT_P2P_COST_TAG_1 = 2020;
    public static final int DATALOADER_KEY_INT_P2P_COST_TAG_2 = 2021;
    public static final int DATALOADER_KEY_INT_IGNORE_TEXT_PLAIN_SPEED_TEST = 2022;
    public static final int DATALOADER_KEY_INT_OPTIMIZE_RANGE = 2023;
    public static final int DATALOADER_KEY_INT_NET_LOG_MAX_SIZE = 2024;
    public static final int DATALOADER_KEY_INT_CHECK_CACHE_DIR = 2025;
    public static final int DATALOADER_KEY_INT_ENABLE_P2P_UPLOAD = 2100;
    public static final int DATALOADER_KEY_STRING_VDP_EXT_GLOBAL_INFO = 2101;
    public static final int DATALOADER_KEY_INT_DEV_DISK_SIZE_MB = 2102;
    public static final int DATALOADER_KEY_INT_CUR_DISK_SIZE_MB = 2103;
    public static final int DATALOADER_KEY_INT_DEV_MEMORY_SIZE_MB = 2104;
    public static final int DATALOADER_KEY_INT_CUR_MEMORY_SIZE_MB = 2105;
    public static final int DATALOADER_KEY_STRING_VDP_EXT_DYNAMIC_INFO = 2106;
    public static final int DATALOADER_KEY_INT_ENABLE_DUMPLIBMD5 = 9000;
    public static final int DATALOADER_KEY_INT_IGNOREPLAYINFO = 9001;
    public static final int DATALOADER_KEY_STRING_SETTINGS_DOMAIN = 9002;
    public static final int DATALOADER_KEY_STRING_DM_DOMAIN = 9003;
    public static final int DATALOADER_KEY_STRING_FORESIGHT_DOMAIN = 9004;
    public static final int DATALOADER_KEY_STRING_P2P_DOMAINS = 9005;
    public static final int DATALOADER_KEY_STRING_KEYSERVICE_DOMAINS = 9006;
    public static final int DATALOADER_KEY_STRING_KEY_TOKEN = 9007;
    public static final int DATALOADER_KEY_INT_ENABLE_HLS = 9008;
    public static final int DATALOADER_KEY_IS_SUPPORT_HLS = 9009;
    public static final int DATALOADER_KEY_STRING_IS_SOCKET_TRAIN_CENTER_CONFIG = 9010;
    public static final int DATALOADER_KEY_STRING_IS_CACHE_DIR_LIST_STR = 9011;
    public static final int DATALOADER_KEY_STRING_IS_P2P_CONFIG_STR = 9012;
    public static final int DATALOADER_KEY_INT_ENABLE_LIBMANAGER = 9013;
    public static final int DATALOADER_KEY_ENABLE_MUTLI_DOWNLOAD_PATH = 9014;
    public static final int DATALOADER_KEY_ENABLE_LOAD_P2P_ASYNC = 9015;
    public static final int DATALOADER_KEY_ENABLE_HLS_PROXY = 9016;
    public static final int DATALOADER_KEY_INT_HLS_TS_FILE_KEY_GENERATE_TYPE = 12001;
    public static final int DATALOADER_KEY_INT_ENABLE_VIDEOMDOEL_HIT_CACHE_CALLBACK = 12002;
    public static final int DATALOADER_KEY_GLOBAL_OPTION_START = 50000;
    public static final int DATALOADER_KEY_GLOBAL_OPTION_END = 60000;
    public static final int DATALOADER_KEY_NOTIFY_INVALID = -1;
    public static final int DATALOADER_KEY_NOTIFY_TASKLOG = 0;
    public static final int DATALOADER_KEY_NOTIFY_OWNVDPLOG = 1;
    public static final int DATALOADER_KEY_NOTIFY_SPEEDINFO = 2;
    public static final int DATALOADER_KEY_NOTIFY_HEARTBEATLOG = 3;
    public static final int DATALOADER_KEY_NOTIFY_OWNLIVEMDLLOG = 4;
    public static final int DATALOADER_KEY_NOTIFY_OWNLIVEMDLLOG_SAMPLE = 5;
    public static final int DATALOADER_KEY_NOTIFY_DNSLOG = 6;
    public static final int DATALOADER_KEY_NOTIFY_DOWNLOADERLOG = 7;
    public static final int DATALOADER_KEY_NOTIFY_PRELOAD_CANCLLED = 8;
    public static final int DATALOADER_KEY_NOTIFY_TRIGGER_PRELOAD = 9;
    public static final int DATALOADER_KEY_NOTIFY_NEWLOG = 10;
    public static final int DATALOADER_KEY_NOTIFY_IOSPEEDINFO = 20;
    public static final int DATALOADER_KEY_NOTIFY_PRELOADEND = 21;
    public static final int DATALOADER_KEY_NOTIFY_TASKOPEN = 30;
    public static final int DATALOADER_KEY_NOTIFY_FILE_DELETE_SIZE_BY_USEDTIME = 31;
    public static final int DATALOADER_KEY_NOTIFY_SPEEDINFO_BY_TIMEINTERNAL = 32;
    public static final int DATALOADER_KEY_PLAY_INFO_RENDER_START = 22;
    public static final int DATALOADER_KEY_PLAY_INFO_PLAYING_POS = 23;
    public static final int DATALOADER_KEY_PLAY_INFO_LOAD_PERCENT = 24;
    public static final int DATALOADER_KEY_PLAY_INFO_BUFFERING_START = 25;
    public static final int DATALOADER_KEY_PLAY_INFO_BUFFERING_END = 26;
    public static final int DATALOADER_KEY_PLAY_INFO_CURRENT_BUFFER = 27;
    public static final int DATALOADER_KEY_PLAY_INFO_SEEK_ACTION = 28;
    public static final int DATALOADER_PRELOAD_STRAGETY_ALLOW_PRELOAD_WHEN_PLAY = 0;
    public static final int DATALOADER_PRELOAD_STRAGETY_NOT_ALLOW_PLAYING_KEY_PRELOAD = 1;
    public static final int DATALOADER_PRELOAD_STRAGETY_NOT_ALLOW_PRELOAD_WHEN_PLAY = 2;
    public static final int DATALOADER_PRELOAD_STRAGETY_NEW = 100;
    public static final int DATALOADER_PRELOAD_STRAGETY_CENTER = 200;
    public static final int DATALOADER_PRELOADER_PRIORITY_DEFAULT = 0;
    public static final int DATALOADER_PRELOADER_PRIORITY_IDLE = 10;
    public static final int DATALOADER_PRELOADER_PRIORITY_HIGH = 100;
    public static final int DATALOADER_PRELOADER_PRIORITY_HIGHEST = 10000;
    public static final int DATALOADER_SPEED_TEST_BY_TIMEINTERNAL_NOTIFY_BY_GENERAL_SPEEDINFO = 1;
    public static final int DATALOADER_SPEED_TEST_BY_TIMEINTERNAL_NOTIFY_BY_TIMEINTERNAL_SPEEDINFO = 2;
    private static final int PRIVATE_MESSAGE_ADD_MEDIA_CENTER = 111;
    private static final int PRIVATE_MESSAGE_REMOVE_MEDIA_CENTER = 112;
    private static final int PRIVATE_MESSAGE_REMOVE_MEDIA_LIST_CENTER = 113;
    private static final int PRIVATE_MESSAGE_FOCUS_MEDIA = 114;
    private static final int PRIVATE_MESSAGE_ADD_PRIORITY_PRELOAD_TASK = 115;
    private static final int PRIVATE_MESSAGE_REMOVE_PRIORITY_PRELOAD_TASK = 116;
    public static final String PRELOAD_DEFAULT_SCENE = "default";
    private volatile boolean isProxyLibraryLoaded = false;
    private volatile LibraryLoaderProxy mProxy = null;
    private final DataLoaderListenerWrapper mListener = new DataLoaderListenerWrapper();
    private TestSpeedListener mTestSpeedListener = null;
    private volatile int mState = 1;
    private DataLoaderTaskQueue mPreloadTasks = new DataLoaderTaskQueue();
    private DataLoaderTaskQueue mExecuteTasks = new DataLoaderTaskQueue();
    private DataLoaderTaskQueue mAllPreloadTasks = new DataLoaderTaskQueue();
    private DataLoaderTaskQueue mAllPlayTasks = new DataLoaderTaskQueue();
    private final HashMap<String, ArrayList<WeakReference<TTVideoEngine>>> mAllUsingEngies = new HashMap();
    private final ReentrantLock mEngineLock = new ReentrantLock();
    private AVMDLDataLoader mInnerDataLoader = null;
    private AVMDLDataLoaderConfigure mConfigure = null;
    private DataLoaderHelperAdapter mDataLoaderHelperAdapter = new DataLoaderHelperAdapter();
    private Context mContext = null;
    private ClassLoader mClasssLoader = null;
    private VideoModelCache mModelCache = null;
    private Exception mException = null;
    private String mVersionInfo = null;
    private DataLoaderHeartBeat mHeartBeat = null;
    private IVideoEventUploader mUploader = null;
    private VideoEventEngineUploader mEngineUploader = null;
    private int mNeedDLLoadP2PLib = 0;
    private boolean mNeedMDLLoadMDLV2Lib = false;
    private long mMdlProtocolHandle = -1L;
    private boolean mInvalidMdlProcotol = true;
    private int mMdlDataSourceId = 0;
    private boolean mEnableMdlProtocol = false;
    private final ReentrantLock mLock = new ReentrantLock();
    private int mHeartBeatInterval = 0;
    private int mEnableReportSpeed = 0;
    private int mEnableNetworkChangedListen = 0;
    private TTNetworkStateCallback mNetWorkChangeCb = null;
    private WeakReference<TTNetworkStateCallback> mNetWorkChangeCbr = null;
    private int mCurrentAccessType = -1;
    private int mEnableDumpLibMd5 = 0;
    private int mNeedSpeedTestByTimeInternal = 0;
    private boolean mAudioPreloadFirst = false;
    private int mPreloadTaskIgnorePlayerStall = 1;
    private String mUpdatePlaySourceId = null;
    private int mFloatSize = 0;
    private int mPreloadPreConnect = 0;
    private int mEnablePreParseHost = 0;
    private int mEnableBackupIP = 0;
    private int mEnableHls = 1;
    private boolean mSupporHls = false;
    private PreloadMediaThread mediaOperateThread = null;
    private boolean mReportLogEnable = true;
    private int mBackupLoaderType = 0;
    private int mMdlPreloadStrategy = 0;
    private int mMdlOldPreloadStrategy = 0;
    private int mEnableMdlV2 = 0;
    private int mEnableBufferPreload = 0;
    private int mEnableSetMDLNetStatus = 0;
    private int mEnableStrategyCenterCancelAll = 0;
    private int mEnableCheckPreloadUrls = 0;
    private int mEnableSplitPreload = 0;
    private int mDashAudioPreloadMinSize = 0;
    private int mDashAudioPreloadRatio = 0;
    private boolean mForbidNativeMDLForOriUrl = false;
    private final PreloadUtil mPreloadUtil = new PreloadUtil();
    private int mEnableLibManager = 0;
    private int mEnableLoadP2pAsync = 0;
    private int mEnableHLSProxy = 0;
    private int mEnableVideoModelHitCacheCallback = 1;

    public void onStartComplete() {
        TTVideoEngineLog.d(TAG, "MediaDataLoader start complete");
        SettingsHelper.helper().config().load(SettingsHelper.MODULE_ALL);
        this.mCurrentAccessType = TTNetWorkListener.getInstance().getCurrentAccessType();
        if (this.mInnerDataLoader != null) {
            this.mInnerDataLoader.setIntValue(7219, this.mCurrentAccessType);
            if (!StrategyHelper.helper().isRunning()) {
                TTVideoEngineLog.d(TAG, "strategy center running failed, set mdl preload strategy back " + this.mMdlOldPreloadStrategy);
                this.mInnerDataLoader.setIntValue(1030, this.mMdlOldPreloadStrategy);
            }
        }
        this.mDataLoaderHelperAdapter.onMDLStartComplete();
    }

    public void notifyPreloadCancelled(String reason, String traceId) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onNotify(8, 0L, 0L, reason);
    }

    public void notifyTriggerPreload(long buffer) {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onNotify(9, 0L, buffer, "");
    }

    private DataLoaderHelper() {
        this.mModelCache = VideoModelCache.getInstance();
        this.mConfigure = AVMDLDataLoaderConfigure.getDefaultonfigure();
    }

    public static DataLoaderHelper getDataLoader() {
        return Holder.instance;
    }

    public void setNetworkClient(TTVNetClient client) {
    }

    public void setUploader(IVideoEventUploader uploader) {
        this.mUploader = uploader;
    }

    public synchronized void setEngineUploader(VideoEventEngineUploader engineUploader) {
        this.mEngineUploader = engineUploader;
    }

    public void setLoaderEventListener(LoaderListener listener) {
        this.mLock.lock();
        try {
            AVMDLDataLoader.getInstance().setEventListener(listener);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setListener(DataLoaderListener listener) {
        this.mLock.lock();
        try {
            this.mListener.setListener(listener);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addListener(DataLoaderListener2 listener) {
        this.mLock.lock();
        try {
            this.mListener.addListener(listener);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void removeListener(DataLoaderListener2 listener) {
        this.mLock.lock();
        try {
            this.mListener.removeListener(listener);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setTestSpeedListener(TestSpeedListener listener) {
        this.mLock.lock();
        try {
            this.mTestSpeedListener = listener;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setContext(Context context) {
        if (context == null) {
            TTVideoEngineLog.d(TAG, "set context null");
            return;
        }
        this.mLock.lock();
        try {
            if (this.mContext == null) {
                SettingsHelper.helper().setContext(context);
                SettingsHelper.helper().loadMDLCache();
            }
            this.mContext = context;
        }
        finally {
            this.mLock.unlock();
        }
        TTVideoEngineLog.d(TAG, "set context end" + context);
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            TTVideoEngineLog.d(TAG, "class loader null");
            return;
        }
        this.mLock.lock();
        try {
            if (this.mClasssLoader == null) {
                this.mClasssLoader = classLoader;
            }
        }
        finally {
            this.mLock.unlock();
        }
        TTVideoEngineLog.d(TAG, "set class loader end" + classLoader);
    }

    public void setReportLogEnable(boolean reportLogEnable) {
        this.mLock.lock();
        try {
            this.mReportLogEnable = reportLogEnable;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isReportLogEnable() {
        this.mLock.lock();
        try {
            boolean bl = this.mReportLogEnable;
            return bl;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setLoadProxy(LibraryLoaderProxy proxy) {
        this.mLock.lock();
        try {
            if (proxy != null) {
                this.mProxy = proxy;
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    private boolean loadLibrary() {
        if (this.mProxy == null) {
            return true;
        }
        this.dumpLibMd5();
        if (this.mProxy != null && !this.isProxyLibraryLoaded) {
            if (this.mEnableMdlV2 == 1) {
                try {
                    this.mProxy.loadLibrary("avmdlbase");
                    this.isProxyLibraryLoaded = this.mProxy.loadLibrary("avmdlv2");
                }
                catch (Exception e) {
                    this.isProxyLibraryLoaded = false;
                }
            }
            TTVideoEngineLog.d(TAG, "try to load avmdl: " + this.isProxyLibraryLoaded);
            if (!this.isProxyLibraryLoaded) {
                this.isProxyLibraryLoaded = this.mProxy.loadLibrary("avmdl");
            }
        }
        return this.isProxyLibraryLoaded;
    }

    private void dumpLibMd5() {
        if (this.mEnableDumpLibMd5 != 1) {
            return;
        }
        if (this.mContext == null) {
            return;
        }
        String app_path = null;
        try {
            app_path = this.mContext.getApplicationInfo().dataDir + "/lib";
        }
        catch (Exception e) {
            app_path = null;
        }
        if (app_path == null) {
            return;
        }
        String libPath = app_path + File.separatorChar + "libavmdl.so";
        String md = TTHelper.getFileMd5(new File(libPath));
        if (md != null) {
            TTVideoEngineLog.e(TAG, "libavmdl md5: " + md);
        }
    }

    @SuppressLint(value={"CI_DefaultLocale"})
    private boolean initInternal() {
        if (this.mInnerDataLoader != null) {
            return true;
        }
        if (!AVMDLDataLoader.isVCBasekitStaticLinked()) {
            VCBaseKitLoader.loadLibrary();
        }
        boolean hasLoadLib = false;
        if (this.mEnableLibManager == 1) {
            if (this.mProxy != null || this.mListener != null) {
                AVMDLLibraryManagerWrapper.setLibraryLoader((IAVMDLLibraryLoader)new IAVMDLLibraryLoader(){

                    public boolean loadLibrary(String libName) {
                        if (DataLoaderHelper.this.mProxy != null) {
                            return DataLoaderHelper.this.mProxy.loadLibrary(libName);
                        }
                        if (DataLoaderHelper.this.mListener != null) {
                            DataLoaderHelper.this.mListener.loadLibrary(libName);
                        }
                        return false;
                    }
                });
            }
            if (this.mEnableMdlV2 == 1) {
                AVMDLLibraryManagerWrapper.setEnableV2((boolean)true);
            }
            if (AVMDLDataLoader.initWithLibraryManager() == 0) {
                hasLoadLib = true;
            }
        }
        boolean isP2pLibraryLoadPending = false;
        if (!hasLoadLib) {
            boolean result;
            if (!this.loadLibrary()) {
                TTVideoEngineLog.e(TAG, String.format("library load fail", new Object[0]));
                return false;
            }
            if (this.mProxy == null && this.mEnableMdlV2 == 1 && this.mListener != null && !this.mNeedMDLLoadMDLV2Lib) {
                TTVideoEngineLog.d(TAG, "try to load mdlv2");
                AVMDLDataLoader.loadAVMDLBaseLibrary();
                hasLoadLib = result = this.mListener.loadLibrary("avmdlv2");
                TTVideoEngineLog.d(TAG, "load mdlv2: " + result);
            }
            if (!hasLoadLib) {
                if (AVMDLDataLoader.init((this.mProxy != null ? 1 : 0) != 0, (this.mNeedDLLoadP2PLib != 0 ? 1 : 0) != 0, (this.mEnableMdlV2 == 1 && this.mNeedMDLLoadMDLV2Lib ? 1 : 0) != 0) != 0) {
                    TTVideoEngineLog.e(TAG, String.format("library has not been loaded", new Object[0]));
                    return false;
                }
                TTVideoEngineLog.e("P2PLIB", String.format("loadertype:%d NeedDLLoadP2PLib:%d, liveloaderType: %d", this.mConfigure.mLoaderType, this.mNeedDLLoadP2PLib, this.mConfigure.mLiveLoaderType));
                if (this.mNeedDLLoadP2PLib == 0 && this.mListener != null && (this.mConfigure.mEnablePcdnAuto == 1 || this.mConfigure.mLoaderType > 0 || this.mConfigure.mLiveLoaderType != 10000 && this.mConfigure.mLiveLoaderType >= 7)) {
                    if (this.mEnableLoadP2pAsync == 1) {
                        TTVideoEngineLog.e("P2PLIB", "delay to load p2p lib");
                        isP2pLibraryLoadPending = true;
                    } else {
                        TTVideoEngineLog.e("P2PLIB", "try to load p2p lib");
                        result = this.mListener.loadLibrary("avmdlp2p");
                        TTVideoEngineLog.e("P2PLIB", String.format("load p2p lib result:%d", result ? 1 : 0));
                    }
                }
            }
        }
        if (this.mConfigure.mEnableByteMediaNetLoader > 0) {
            TTVideoEngineLog.d("ByteMediaNet", "enable byte media try init env, context:" + this.mContext + "  classloader:" + this.mClasssLoader);
            if (this.mContext != null && this.mClasssLoader != null) {
                AVMDLDataLoader.initByteMediaNetEnv((Context)this.mContext, (ClassLoader)this.mClasssLoader);
                TTVideoEngineLog.d("ByteMediaNet", "init byte media env end");
            }
        }
        try {
            this.mInnerDataLoader = AVMDLDataLoader.getInstance();
            this.mInnerDataLoader.setConfigure(this.mConfigure);
            this.mInnerDataLoader.setListener((AVMDLDataLoaderListener)this);
            this.mInnerDataLoader.setStartCompleteListener((AVMDLStartCompleteListener)this);
            if (isP2pLibraryLoadPending && this.mListener != null) {
                this.mInnerDataLoader.setPluginLibraryLoader(new IAVMDLLibraryLoader(){

                    public boolean loadLibrary(String libName) {
                        return DataLoaderHelper.this.mListener.loadLibrary(libName);
                    }
                });
            }
            if (this.mEnableHLSProxy == 1) {
                this.mDataLoaderHelperAdapter.initHLSCacheModule();
                this.mDataLoaderHelperAdapter.setHLSCacheDir(this.mConfigure.mCacheDir);
                this.mDataLoaderHelperAdapter.setHLSDownloadDir(this.mConfigure.mDownloadDir);
            }
            this.mHeartBeat = new DataLoaderHeartBeat();
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        this.mLock.lock();
        try {
            if (this.mState == 0) {
                TTVideoEngineLog.e(TAG, "DataLoader has started not need start");
                return;
            }
            if (!this.initInternal()) {
                String errMsg = "initMdlFail:" + AVMDLDataLoader.getLoadFailMsg();
                throw new Exception(errMsg);
            }
            this.mExecuteTasks.setMaxCount(4L);
            this.mPreloadTasks.setMaxCount(20L);
            if (this.mConfigure == null) {
                this.mConfigure = AVMDLDataLoaderConfigure.getDefaultonfigure();
            }
            JSONObject jsonObj = new JSONObject();
            try {
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppChannel)) {
                    jsonObj.put("app_channel", (Object)AppInfo.mAppChannel);
                }
                if (!TextUtils.isEmpty((CharSequence)InfoWrapper.getAppName())) {
                    jsonObj.put("app_name", (Object)InfoWrapper.getAppName());
                }
                if (!TextUtils.isEmpty((CharSequence)InfoWrapper.getDeviceID())) {
                    jsonObj.put("device_id", (Object)InfoWrapper.getDeviceID());
                }
                if (!TextUtils.isEmpty((CharSequence)AppInfo.mAppVersion)) {
                    jsonObj.put("app_version", (Object)AppInfo.mAppVersion);
                }
                if (!TextUtils.isEmpty((CharSequence)InfoWrapper.getAppID())) {
                    jsonObj.put("app_id", Integer.parseInt(InfoWrapper.getAppID()));
                }
                if (jsonObj.has("app_id")) {
                    this.mConfigure.mAppInfo = jsonObj.toString();
                }
            }
            catch (JSONException e) {
                TTVideoEngineLog.d(e);
            }
            if (this.mEngineUploader != null) {
                this.mConfigure.mEnableReportTaskLog = 1;
            }
            this.changeConfigWithPermission(this.mConfigure);
            this.mInnerDataLoader.setConfigure(this.mConfigure);
            this.mDataLoaderHelperAdapter.setHLSCacheDir(this.mConfigure.mCacheDir);
            if (this.mInnerDataLoader.start() < 0) {
                throw new Exception("start data loader fail");
            }
            TTVideoEngineLog.i(TAG, "[preload] preload strategy " + this.mMdlPreloadStrategy);
            this.tryStartStrategyCenter();
            this.mMdlProtocolHandle = this.mInnerDataLoader.getLongValue(7218);
            if (this.mMdlProtocolHandle == -1L) {
                this.mInvalidMdlProcotol = true;
            }
            this.mSupporHls = this.mInnerDataLoader.getLongValue(9407) == 1L;
            TTVideoEngineLog.i(TAG, "start: get mdlprotocolHandle: " + this.mMdlProtocolHandle);
            this.mHeartBeat.start(this.mInnerDataLoader, this.mHeartBeatInterval);
            this.mState = 0;
            TTNetWorkListener.getInstance().init(this.mContext);
            this.mNetWorkChangeCb = new TTNetworkStateCallback(){

                @Override
                public void onAccessChanged(int what, int from, int to) {
                    if (what != 0) {
                        return;
                    }
                    TTVideoEngineLog.d(DataLoaderHelper.TAG, "access changed, from: " + from + " to: " + to);
                    DataLoaderHelper.this.mCurrentAccessType = to;
                    DataLoaderHelper.this.setIntValue(1000, 1);
                    DataLoaderHelper.this.setIntValue(1104, to);
                }
            };
            this.mNetWorkChangeCbr = new WeakReference<TTNetworkStateCallback>(this.mNetWorkChangeCb);
            TTNetWorkListener.getInstance().startListen(this.mNetWorkChangeCbr);
            TTVideoEngineLog.d(TAG, "DataLoader start.");
        }
        finally {
            this.mLock.unlock();
        }
    }

    private void changeConfigWithPermission(AVMDLDataLoaderConfigure configure) {
        if (!FeatureManager.hasPermission("http_dns")) {
            configure.mEnableExternDNS = 0;
        }
        if (FeatureManager.hasPermission("native_mdl") && InfoWrapper.getNativeMdlEnable() == 1) {
            this.mEnableMdlProtocol = true;
        }
        StrategyManager.instance().mdlStart(configure);
    }

    public boolean isRunning() {
        boolean tem = false;
        this.mLock.lock();
        try {
            tem = this.mState == 0;
        }
        finally {
            this.mLock.unlock();
        }
        return tem;
    }

    public void resumeFileWriteIO() {
        if (this.mState != 0) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader != null) {
                this.mInnerDataLoader.resumeFileWriteIO();
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void close() {
        this.mLock.lock();
        try {
            if (this.mState == 1) {
                TTVideoEngineLog.e(TAG, "DataLoader not started, not need close");
                return;
            }
            this.mListener.clearListeners();
            this.mInnerDataLoader.close();
            this.cancelAllTasksInternal();
            this.removeAllPreloadMedia(null, 1);
            this.mState = 1;
            TTNetWorkListener.getInstance().stopListen(this.mNetWorkChangeCbr);
            TTNetWorkListener.getInstance().unregisterListener(this.mContext);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void disableAutoTrim(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || this.mInnerDataLoader == null) {
            return;
        }
        this.mLock.lock();
        try {
            this.mInnerDataLoader.makeFileAutoDeleteFlag(key, 1);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void enableAutoTrim(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || this.mInnerDataLoader == null) {
            return;
        }
        this.mLock.lock();
        try {
            this.mInnerDataLoader.makeFileAutoDeleteFlag(key, 0);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(String key, PreloaderVidItem vidItem) {
        if (this.mState != 0) {
            return;
        }
        if (vidItem == null || TextUtils.isEmpty((CharSequence)vidItem.mVideoId)) {
            TTVideoEngineLog.e(TAG, "videoId invalid.");
            return;
        }
        TTVideoEngineLog.i(TAG, String.format("addTask key is %s; videoId = %s", key, vidItem.mVideoId));
        this.mLock.lock();
        try {
            this._addTask(key, vidItem.mVideoId, vidItem.mPreloadSize, vidItem, null, null);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(PreloaderVidItem vidItem) {
        if (vidItem == null) {
            return;
        }
        if (this.mState != 0) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)vidItem.mVideoId)) {
            TTVideoEngineLog.e(TAG, "videoId invalid.");
            return;
        }
        String key = vidItem.mVideoId + "_" + vidItem.mResolution.toString(0) + vidItem.mCodecType + vidItem.mDashEnable + vidItem.mHlsEnable + vidItem.mEncryptEnable;
        this.mLock.lock();
        try {
            this._addTask(key, vidItem.mVideoId, vidItem.mPreloadSize, vidItem, null, null);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(PreloaderURLItem urlItem) {
        if (urlItem == null) {
            TTVideoEngineLog.e(TAG, "[preload] url item invalid");
            return;
        }
        this.mLock.lock();
        try {
            this._addTask(urlItem.getKey(), urlItem.getVideoId(), urlItem.getPreloadSize(), null, null, urlItem);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(String key, String videoId, VideoModel videoModel, Resolution resolution, long preloadSize) {
        PreloaderVideoModelItem modelItem = new PreloaderVideoModelItem(videoModel, resolution, preloadSize, null);
        this.addTask(modelItem);
    }

    public void addTask(VideoModel videoModel, Resolution resolution, long preloadSize) {
        this.addTask(videoModel, resolution, null, preloadSize);
    }

    public void addTask(VideoModel videoModel, Resolution resolution, Map<Integer, String> params, long preloadSize) {
        PreloaderVideoModelItem modelItem = new PreloaderVideoModelItem(videoModel, resolution, preloadSize, null);
        modelItem.mParams = params;
        this.addTask(modelItem);
    }

    public void addTask(IVideoModel videoModel, Resolution resolution, long preloadSize) {
        this.addTask(videoModel, resolution, null, preloadSize);
    }

    public void addTask(IVideoModel videoModel, Resolution resolution, Map<Integer, String> params, long preloadSize) {
        PreloaderVideoModelItem modelItem = new PreloaderVideoModelItem(videoModel, resolution, preloadSize, null);
        modelItem.mParams = params;
        this.addTask(modelItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preConnect(String url) {
        if (this.mState != 0 || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.mLock.lock();
        try {
            Uri uri = Uri.parse((String)url);
            int port = uri.getPort();
            if (port == -1) {
                port = 80;
                if (url.startsWith("https")) {
                    port = 443;
                }
            }
            if (uri != null && this.mInnerDataLoader != null) {
                this.mInnerDataLoader.preConnectByHost(uri.getHost(), port);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void switchToCellularNetwork() {
        TTVideoEngineLog.d("multinetwork", "start do switch to cellular");
        AVMDLMultiNetwork.switchToCellularNetwork();
        TTVideoEngineLog.d("multinetwork", "end do switch to cellular");
    }

    public void switchToDefaultNetwork() {
        TTVideoEngineLog.d("multinetwork", "start do switch to default");
        AVMDLMultiNetwork.switchToDefaultNetwork();
        TTVideoEngineLog.d("multinetwork", "end do switch to default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getCDNLog(String fKey) {
        if (this.mState != 0 || TextUtils.isEmpty((CharSequence)fKey)) {
            return null;
        }
        this.mLock.lock();
        try {
            String log;
            if (this.mInnerDataLoader != null && (log = this.mInnerDataLoader.getCDNLog(fKey)) != null) {
                JSONObject jsonLog = new JSONObject(log);
                TTVideoEngineLog.d(TAG, "get cdn log suc" + jsonLog.toString());
                JSONObject jSONObject = jsonLog;
                return jSONObject;
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "get log exception" + e.toString());
        }
        finally {
            this.mLock.unlock();
        }
        return null;
    }

    @Deprecated
    public void p2pPredown(String url) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(PreloaderVideoModelItem modelItem) {
        VideoInfo info;
        String key;
        String mediaInfoString;
        if (modelItem == null || modelItem.mVideoModel == null || modelItem.mResolution == null) {
            TTVideoEngineLog.e(TAG, "[preload] addTask videoModel input invalid");
            if (modelItem != null) {
                modelItem._notifyError(-100001);
            }
            return;
        }
        GearStrategyConfig gearStrategyConfig = TTVideoEngine.getGearStrategyConfig();
        if (modelItem.mGearStrategyEnabled > 0 && !TextUtils.isEmpty((CharSequence)(mediaInfoString = modelItem.mVideoModel.toMediaInfoJsonString()))) {
            List<VideoInfo> videoInfos;
            if (this.mEnableCheckPreloadUrls == 1 && modelItem.mVideoModel != null && (videoInfos = modelItem.mVideoModel.getVideoInfoList()) != null && !videoInfos.isEmpty()) {
                for (VideoInfo videoInfo : videoInfos) {
                    String[] urls;
                    for (String url : urls = videoInfo.getValueStrArr(16)) {
                        if (this._supportProxy(url)) continue;
                        return;
                    }
                }
            }
            StrategyHelper.helper().getCenter().addMedia(mediaInfoString, null, null, false);
            HashMap<String, String> params = new HashMap<String, String>();
            GearStrategyContext strategyContext = new GearStrategyContext(null);
            IGearStrategyListener listener = null;
            if (gearStrategyConfig != null) {
                listener = gearStrategyConfig.getGearStrategyListener();
            }
            if (1 == modelItem.mGearStrategyEnabled && !StrategyHelper.helper().isRunning()) {
                TTVideoEngineLog.w(TAG, "[GearStrategy] addTask strategy center not running");
                if (listener != null) {
                    listener.onBeforeSelect(modelItem.mVideoModel, params, 2, strategyContext.getUserData());
                    params.put("error_code", "-3");
                    params.put("error_desc", "strategy center not running");
                    listener.onAfterSelect(modelItem.mVideoModel, params, 2, strategyContext.getUserData());
                }
            } else {
                Map<String, Integer> result = null;
                String extraConfig = "";
                if (TTVideoEngine.getGearStrategyConfig() != null) {
                    extraConfig = TTVideoEngine.getGearStrategyConfig().getExtraConfig();
                }
                if (!TextUtils.isEmpty((CharSequence)extraConfig)) {
                    params.put("extra_config", extraConfig);
                }
                strategyContext.setVideoModel(modelItem.mVideoModel);
                if (2 == modelItem.mGearStrategyEnabled) {
                    if (listener == null) {
                        TTVideoEngineLog.w(TAG, "[GearStrategy] add task select method callback but listener is null");
                    } else {
                        listener.onBeforeSelect(modelItem.mVideoModel, params, 2, strategyContext.getUserData());
                        result = listener.selectBitrate(modelItem.mVideoModel, null, 2);
                        if (result != null) {
                            params.put("video_bitrarte", "" + result.get("video"));
                            params.put("audio_bitrarte", "" + result.get("audio"));
                        } else {
                            params.put("error_code", "-4");
                            params.put("error_desc", "select result null");
                        }
                        params.put("select_reason", "13");
                        listener.onAfterSelect(modelItem.mVideoModel, params, 2, strategyContext.getUserData());
                    }
                } else {
                    result = StrategyHelper.helper().selectResolution(modelItem.mVideoModel, 2, params, strategyContext);
                }
                if (result != null) {
                    Integer aBitrate;
                    int videoBitrate = 0;
                    int audioBitrate = 0;
                    Integer vBitrate = result.get("video");
                    if (vBitrate != null) {
                        videoBitrate = vBitrate;
                    }
                    if ((aBitrate = result.get("audio")) != null) {
                        audioBitrate = aBitrate;
                    }
                    TTVideoEngineLog.i(TAG, "[GearStrategy] gear strategy addTask mGearStrategyEnabled=" + modelItem.mGearStrategyEnabled + " videoBitrate=" + videoBitrate + " audioBitrate=" + audioBitrate);
                    IVideoInfo selectedInfo = null;
                    List<VideoInfo> videoInfos2 = modelItem.mVideoModel.getVideoInfoList();
                    if (videoBitrate > 0 && videoInfos2 != null) {
                        for (VideoInfo videoInfo : videoInfos2) {
                            if (videoInfo == null || videoInfo.getMediatype() == VideoRef.TYPE_AUDIO || videoInfo.getResolution() == null) continue;
                            long resolutionBitRate = 0L;
                            if (1 == EngineGlobalConfig.getInstance().getEnableUseRealBitrate()) {
                                resolutionBitRate = videoInfo.getValueInt(44);
                                if (resolutionBitRate <= 0L) {
                                    resolutionBitRate = videoInfo.getValueInt(3);
                                }
                            } else {
                                resolutionBitRate = videoInfo.getValueInt(3);
                            }
                            if (resolutionBitRate != (long)videoBitrate) continue;
                            selectedInfo = videoInfo;
                            break;
                        }
                    }
                    Map<Integer, String> videoInfoParams = TTVideoEngineHelper.paramsFromVideoInfo(selectedInfo);
                    if (selectedInfo != null) {
                        modelItem.mResolution = selectedInfo.getResolution();
                        modelItem.mParams = videoInfoParams;
                    }
                } else {
                    TTVideoEngineLog.d(TAG, "[GearStrategy]add task result is null");
                }
            }
        }
        String string = key = (info = modelItem.mVideoModel.getVideoInfo(modelItem.mResolution, modelItem.mParams, true)) != null ? info.getValueStr(15) : null;
        if (TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.e(TAG, "[preload] key invalid.");
            modelItem._notifyError(-100001);
            return;
        }
        String videoId = modelItem.mVideoModel.getVideoRefStr(2);
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            TTVideoEngineLog.e(TAG, "[preload] videoId invalid.");
            modelItem._notifyError(-100001);
            return;
        }
        this.mLock.lock();
        try {
            this._addTask(key, videoId, modelItem.mPreloadSize, null, modelItem, null);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(String key, String videoId, String url, long preloadSize) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            TTVideoEngineLog.e(TAG, "[preload] url invalid.");
            return;
        }
        PreloaderURLItem urlItem = new PreloaderURLItem(key, videoId, preloadSize, new String[]{url});
        this.addTask(urlItem);
    }

    public void addTask(String key, String videoId, String[] urls, long preloadSize) {
        if (urls == null || urls.length == 0) {
            TTVideoEngineLog.e(TAG, "urls invalid.");
            return;
        }
        PreloaderURLItem urlItem = new PreloaderURLItem(key, videoId, preloadSize, urls);
        this.addTask(urlItem);
    }

    public void addTask(String key, String videoId, String[] urls, long preloadSize, String cacheDir) {
        if (urls == null || urls.length == 0) {
            TTVideoEngineLog.e(TAG, "urls invalid.");
            return;
        }
        PreloaderURLItem urlItem = new PreloaderURLItem(key, videoId, preloadSize, urls, cacheDir);
        this.addTask(urlItem);
    }

    public void addTask(String url, String videoId, long preloadSize, String filePath) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            TTVideoEngineLog.e(TAG, "url invalid.");
            return;
        }
        this.addTask(new String[]{url}, videoId, preloadSize, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String[] urls, String videoId, long preloadSize, String filePath) {
        if (urls == null || urls.length == 0) {
            TTVideoEngineLog.e(TAG, "urls invalid.");
            return;
        }
        this.mLock.lock();
        try {
            String key = TTHelper.keyFromFilePath(this.mContext, filePath);
            PreloaderURLItem urlItem = new PreloaderURLItem(videoId, preloadSize, urls, filePath);
            urlItem.setKey(key);
            this.addTask(urlItem);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void addTask(String key, String videoId, long preloadSize, DataLoaderResourceProvider provider, String cacheDir) {
        if (provider == null) {
            TTVideoEngineLog.e(TAG, "provider invalid.");
            return;
        }
        PreloaderURLItem urlItem = new PreloaderURLItem(key, videoId, preloadSize, provider, cacheDir);
        this.addTask(urlItem);
    }

    public void addPreloadUrlMedia(PreloadURLMedia urlMedia) {
    }

    public void addPreloadModelMedia(PreloadModelMedia modelMedia) {
        if (!FeatureManager.hasPermission("preload")) {
            return;
        }
        if (modelMedia == null || modelMedia.mVideoModel == null || modelMedia.mResolution == null) {
            TTVideoEngineLog.e(TAG, "[preload] addTask videoModel input invalid");
            if (modelMedia != null && modelMedia.getCallBackListener() != null) {
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(3);
                callBackInfo.preloadError = new Error("kTTVideoErrorDomainDataLoaderPreload", -100001);
                modelMedia.getCallBackListener().preloadItemInfo(callBackInfo);
            }
            return;
        }
        String videoId = modelMedia.mVideoModel.getVideoRefStr(2);
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            TTVideoEngineLog.e(TAG, "[preload] videoId invalid.");
            if (modelMedia.getCallBackListener() != null) {
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(3);
                callBackInfo.preloadError = new Error("kTTVideoErrorDomainDataLoaderPreload", -100001);
                modelMedia.getCallBackListener().preloadItemInfo(callBackInfo);
            }
            return;
        }
        if (this.mMdlPreloadStrategy == 200) {
            this._ml_addMedia(modelMedia, modelMedia.mSceneId);
            return;
        }
    }

    public void addPreloadMedias(List<PreloadMedia> mediaList, String sceneId) {
        if (!FeatureManager.hasPermission("preload")) {
            return;
        }
        if (mediaList == null) {
            return;
        }
        if (sceneId == null) {
            sceneId = PreloadConfig.share().getCurrentSceneId();
        }
        TTVideoEngineLog.i(TAG, "[preload] add preload  mediaList ,size = " + mediaList.size() + "sceneId = " + sceneId);
        for (int i = 0; i < mediaList.size(); ++i) {
            PreloadMedia media = mediaList.get(i);
            media.mSceneId = sceneId;
            if (media instanceof PreloadURLMedia) {
                this.addPreloadUrlMedia((PreloadURLMedia)media);
                continue;
            }
            if (!(media instanceof PreloadModelMedia)) continue;
            if (i == mediaList.size() - 1) {
                ((PreloadModelMedia)media).isLast = true;
            }
            this.addPreloadModelMedia((PreloadModelMedia)media);
        }
    }

    public void removePreloadMedia(PreloadMedia media, String sceneId) {
    }

    public void addPriorityPreloadTask(PreloadModelMedia modelMedia) {
        if (modelMedia != null) {
            if (this.mediaOperateThread != null) {
                ArrayList<Object> temList = new ArrayList<Object>();
                temList.add(this);
                temList.add(modelMedia);
                this.mediaOperateThread.postMessage(temList, 115);
            } else {
                this._doMl_addPriorityTask(modelMedia);
            }
        }
    }

    public void removePriorityPreloadTask(String key) {
        if (key != null) {
            if (this.mediaOperateThread != null) {
                ArrayList<Object> temList = new ArrayList<Object>();
                temList.add(this);
                temList.add(key);
                this.mediaOperateThread.postMessage(temList, 116);
            } else {
                this._doMl_removePriorityTask(key);
            }
        }
    }

    public void checkLoaderType(int loaderType) {
        this.mLock.lock();
        if (this.mConfigure.mLoaderType == loaderType || this.mBackupLoaderType == loaderType) {
            this.mLock.unlock();
            return;
        }
        if (this.mBackupLoaderType > 0) {
            this.mLock.unlock();
            return;
        }
        try {
            this.mInnerDataLoader.setIntValue(7227, loaderType);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(TAG, "set backup loader type failed");
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void removeAllPreloadMedia(String sceneId, int moveFlag) {
        if (this.mMdlPreloadStrategy == 200) {
            this._ml_removeAllMedias(sceneId, moveFlag);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIntValue(int key, int value) {
        this.mLock.lock();
        TTVideoEngineLog.d(TAG, "setIntValue key = " + key + ", value = " + value);
        try {
            switch (key) {
                case 1: {
                    this.mConfigure.mMaxCacheSize = value;
                    return;
                }
                case 2: {
                    this.mConfigure.mRWTimeOut = value;
                    return;
                }
                case 3: {
                    this.mConfigure.mOpenTimeOut = value;
                    return;
                }
                case 4: {
                    this.mConfigure.mTryCount = value;
                    return;
                }
                case 5: {
                    this.mConfigure.mLoaderType = value;
                    if (!FeatureManager.hasPermission("pcdn")) return;
                    if (value <= 0) return;
                    this.mNeedDLLoadP2PLib = 1;
                    return;
                }
                case 50: {
                    this.mConfigure.mIsCloseFileCache = value;
                    return;
                }
                case 11: {
                    this.mConfigure.mPreloadParallelNum = value;
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(102, value);
                    return;
                }
                case 12: {
                    if (value >= 100) {
                        this.mMdlOldPreloadStrategy = this.mConfigure.mPreloadStrategy;
                        this.mConfigure.mPreloadStrategy = 100;
                    } else {
                        this.mMdlOldPreloadStrategy = this.mConfigure.mPreloadStrategy;
                        this.mConfigure.mPreloadStrategy = value;
                    }
                    this.mMdlPreloadStrategy = value;
                    if (value != 200) return;
                    this.mConfigure.mEnableIOManager = 1;
                    return;
                }
                case 80: {
                    this.mConfigure.mPreloadWaitListType = value;
                    return;
                }
                case 7: {
                    this.mConfigure.mEnableExternDNS = value;
                    return;
                }
                case 8: {
                    this.mConfigure.mEnableSocketReuse = value;
                    return;
                }
                case 9: {
                    this.mConfigure.mSocketIdleTimeOut = value;
                    return;
                }
                case 13: {
                    this.mConfigure.mCheckSumLevel = value;
                    return;
                }
                case 14: {
                    this.mConfigure.mTestSpeedTypeVersion = value;
                    return;
                }
                case 15: {
                    this.mNeedDLLoadP2PLib = value;
                    return;
                }
                case 33: {
                    this.mNeedMDLLoadMDLV2Lib = value != 0;
                    return;
                }
                case 34: {
                    this.mConfigure.mEnablePcdnAuto = value;
                    return;
                }
                case 30: {
                    this.mConfigure.mEncryptVersion = value;
                    return;
                }
                case 93: {
                    this.mConfigure.mEnableBenchMarkIOSpeed = value;
                    return;
                }
                case 94: {
                    this.mConfigure.mSpeedCoefficientValue = value;
                    return;
                }
                case 60: {
                    this.mConfigure.mEnablePreloadReUse = value;
                    return;
                }
                case 61: {
                    this.mHeartBeatInterval = value;
                    return;
                }
                case 1503: {
                    this.mDashAudioPreloadMinSize = value;
                    return;
                }
                case 1504: {
                    this.mDashAudioPreloadRatio = value;
                    return;
                }
                case 55: {
                    this.mConfigure.mMaxCacheAge = value;
                    return;
                }
                case 56: {
                    this.mConfigure.mEnableMaxCacheAgeForAllDir = value;
                    return;
                }
                case 90: {
                    this.mConfigure.mDNSMainType = value;
                    AVMDLDNSParser.setIntValue((int)0, (int)value);
                    return;
                }
                case 91: {
                    this.mConfigure.mDNSBackType = value;
                    AVMDLDNSParser.setIntValue((int)1, (int)value);
                    return;
                }
                case 92: {
                    this.mConfigure.mMainToBackUpDelayedTime = value;
                    AVMDLDNSParser.setIntValue((int)3, (int)value);
                    return;
                }
                case 63: {
                    this.mConfigure.mMaxIpCountEachDomain = value;
                    return;
                }
                case 64: {
                    this.mConfigure.mEnableIpBucket = value;
                    return;
                }
                case 65: {
                    this.mConfigure.mErrorStateTrustTime = value;
                    return;
                }
                case 66: {
                    this.mConfigure.mOnlyUseCdn = value;
                    return;
                }
                case 1000: {
                    if (this.mEnableNetworkChangedListen != 1) return;
                    this.clearNetinfoCache();
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(7217, 1);
                    return;
                }
                case 1100: {
                    this.mEnableReportSpeed = value;
                    return;
                }
                case 1001: {
                    this.mConfigure.mEnablePreconnect = value;
                    return;
                }
                case 1002: {
                    this.mConfigure.mPreconnectNum = value;
                    return;
                }
                case 1101: {
                    this.mConfigure.mEnableLoaderPreempt = value;
                    return;
                }
                case 1103: {
                    this.mConfigure.mNextDownloadThreshold = value;
                    return;
                }
                case 1102: {
                    this.mConfigure.mAccessCheckLevel = value;
                    return;
                }
                case 1004: {
                    this.mInvalidMdlProcotol = value != 0;
                    TTVideoEngineLog.i(TAG, "setIntValue: mInvalidMdlProcotol: " + this.mInvalidMdlProcotol);
                    return;
                }
                case 1011: {
                    this.mEnableNetworkChangedListen = value;
                    return;
                }
                case 1005: {
                    if (!FeatureManager.hasPermission("native_mdl")) {
                        return;
                    }
                    this.mEnableMdlProtocol = value == 1;
                    TTVideoEngineLog.i(TAG, "config DATALOADER_KEY_SET_MDL_PROTOCOL_ENABLE: " + this.mEnableMdlProtocol);
                    return;
                }
                case 500: {
                    this.mConfigure.mLiveP2pAllow = value;
                    return;
                }
                case 501: {
                    this.mConfigure.mLiveLoaderType = value;
                    return;
                }
                case 502: {
                    this.mConfigure.mLiveLoaderEnable = value;
                    return;
                }
                case 505: {
                    this.mConfigure.mLiveWatchDurationThreshold = value;
                    return;
                }
                case 506: {
                    this.mConfigure.mLiveCacheThresholdHttpToP2p = value;
                    return;
                }
                case 507: {
                    this.mConfigure.mLiveCacheThresholdP2pToHttp = value;
                    return;
                }
                case 508: {
                    this.mConfigure.mLiveMaxTrySwitchP2pTimes = value;
                    return;
                }
                case 509: {
                    this.mConfigure.mLiveWaitP2pReadyThreshold = value;
                    return;
                }
                case 510: {
                    this.mConfigure.mLiveMobileUploadAllow = value;
                    return;
                }
                case 511: {
                    this.mConfigure.mLiveMobileDownloadAllow = value;
                    return;
                }
                case 513: {
                    this.mConfigure.mLiveRecvDataTimeout = value;
                    return;
                }
                case 1104: {
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(7219, value);
                    return;
                }
                case 1105: {
                    this.mConfigure.mSocketSendBufferKB = value;
                    return;
                }
                case 1006: {
                    this.mConfigure.mRingBufferSizeKB = value;
                    return;
                }
                case 1007: {
                    this.mConfigure.mEnableFileCacheV2 = value;
                    return;
                }
                case 95: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 109: 
                case 110: {
                    return;
                }
                case 100: {
                    this.mConfigure.mMaxTlsVersion = value;
                    return;
                }
                case 101: {
                    this.mConfigure.mEnableSessionReuse = value;
                    return;
                }
                case 512: {
                    this.mConfigure.mAlogEnable = value;
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(7225, value);
                    return;
                }
                case 103: {
                    AVMDLDNSParser.setIntValue((int)4, (int)value);
                    return;
                }
                case 104: {
                    AVMDLDNSParser.setIntValue((int)5, (int)value);
                    return;
                }
                case 105: {
                    AVMDLDNSParser.setIntValue((int)6, (int)value);
                    return;
                }
                case 106: {
                    AVMDLDNSParser.setIntValue((int)7, (int)1);
                    return;
                }
                case 1108: {
                    this.mConfigure.mEnableSyncDnsForPcdn = value;
                    return;
                }
                case 1109: {
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(7227, value);
                    return;
                }
                case 9000: {
                    this.mEnableDumpLibMd5 = value;
                    return;
                }
                case 9001: {
                    this.mConfigure.mIgnorePlayInfo = value;
                    return;
                }
                case 1110: {
                    this.mConfigure.mXYLibValue = value;
                    return;
                }
                case 1111: {
                    this.mConfigure.mCheckPreloadLevel = value;
                    return;
                }
                case 1112: {
                    this.mNeedSpeedTestByTimeInternal = value;
                    return;
                }
                case 17: {
                    TTVideoEngineLog.i(TAG, "set write file notify intervalMS " + value);
                    this.mConfigure.mWriteFileNotifyIntervalMS = value;
                    return;
                }
                case 18: {
                    this.mPreloadTaskIgnorePlayerStall = value;
                    return;
                }
                case 1009: {
                    this.mConfigure.mEnableFileRingBuffer = value;
                    return;
                }
                case 1010: {
                    this.mConfigure.mEnableUseFileExtendLoaderBuffer = value;
                    return;
                }
                case 1113: {
                    this.mAudioPreloadFirst = value != 0;
                    return;
                }
                case 1115: {
                    this.mConfigure.mMaxIPV6Num = value;
                    return;
                }
                case 1116: {
                    this.mConfigure.mMaxIPV4Num = value;
                    return;
                }
                case 19: {
                    this.mFloatSize = value;
                    return;
                }
                case 20: {
                    this.mPreloadPreConnect = value;
                    return;
                }
                case 1117: {
                    this.mConfigure.mForbidByPassCookie = value;
                    return;
                }
                case 1118: {
                    this.mConfigure.mEnableLazyBufferpool = value;
                    return;
                }
                case 1119: {
                    this.mConfigure.mSessionTimeout = value;
                    return;
                }
                case 1120: {
                    this.mConfigure.mEnableNewBufferpool = value;
                    return;
                }
                case 1121: {
                    this.mConfigure.mNewBufferPoolBlockSize = value;
                    return;
                }
                case 1122: {
                    this.mConfigure.mNewBufferPoolResidentSize = value;
                    return;
                }
                case 1123: {
                    this.mConfigure.mNewBufferPoolGrowBlockCount = value;
                    return;
                }
                case 9008: {
                    this.mEnableHls = value;
                    return;
                }
                case 1124: {
                    this.mConfigure.mEnablePlayInfoCache = value;
                    return;
                }
                case 1125: {
                    this.mConfigure.mControlCDNRangeType = value;
                    return;
                }
                case 1126: {
                    this.mConfigure.mEnableP2PPreDown = value;
                    return;
                }
                case 1127: {
                    this.mConfigure.mEnablePlayLog = value;
                    return;
                }
                case 1128: {
                    this.mConfigure.mEnableNetScheduler = value;
                    return;
                }
                case 1134: {
                    this.mConfigure.mEnableCacheReqRange = value;
                    return;
                }
                case 1150: {
                    if (!FeatureManager.hasPermission("strategy_center")) return;
                    this.mConfigure.mEnableIOManager = value;
                    return;
                }
                case 1151: {
                    this.mConfigure.mEnableOwnVDPPreloadNotify = value;
                    return;
                }
                case 1132: {
                    this.mConfigure.mFirstRangeLeftThreshold = value;
                    return;
                }
                case 21: {
                    this.mConfigure.mEnableDownloaderLog = value;
                    return;
                }
                case 22: {
                    this.mConfigure.mEnableTTNetLoader = value;
                    return;
                }
                case 25: {
                    this.mConfigure.mEnableTTQuicHeLoaderCheckWithNetworkType = value;
                    return;
                }
                case 24: {
                    this.mConfigure.mEnableTTQuicHeLoader = value;
                    return;
                }
                case 23: {
                    this.mConfigure.mTTNetLoaderCronetBufSizeKB = value;
                    return;
                }
                case 1129: {
                    this.mConfigure.mNetSchedulerBlockAllNetErr = value;
                    return;
                }
                case 1130: {
                    this.mConfigure.mNetSchedulerBlockErrCount = value;
                    return;
                }
                case 1131: {
                    this.mConfigure.mNetSChedulerBlockDurationMs = value;
                    return;
                }
                case 1148: {
                    this.mConfigure.mNetSchedulerBlockHostIpErrCount = value;
                    return;
                }
                case 1133: {
                    this.mConfigure.mIsAllowTryTheLastUrl = value;
                    return;
                }
                case 112: {
                    this.mConfigure.mSpeedSampleInterval = value;
                    return;
                }
                case 121: {
                    this.mConfigure.mUseNewSpeedTestForSingle = value;
                    return;
                }
                case 113: {
                    this.mConfigure.mGlobalSpeedSampleInterval = value;
                    if (this.mInnerDataLoader == null) return;
                    this.mInnerDataLoader.setIntValue(7370, value);
                    return;
                }
                case 1135: {
                    this.mConfigure.mEnableLoaderSeek = value;
                    return;
                }
                case 1136: {
                    this.mConfigure.mP2PPreDownPeerCount = value;
                    return;
                }
                case 1137: {
                    this.mConfigure.mEnableDynamicTimeout = value;
                    return;
                }
                case 1138: {
                    this.mConfigure.mSocketInitialTimeout = value;
                    return;
                }
                case 1139: {
                    this.mConfigure.mMaxSocketReuseCount = value;
                    return;
                }
                case 1143: {
                    this.mConfigure.mP2PFirstRangeLoaderType = value;
                    return;
                }
                case 1141: {
                    AVMDLDNSParser.setIntValue((int)2, (int)value);
                    return;
                }
                case 1140: {
                    AVMDLDNSParser.setIntValue((int)10, (int)value);
                    return;
                }
                case 1145: {
                    this.mConfigure.mMaxAliveHostNum = value;
                    return;
                }
                case 200: {
                    this.mConfigure.mEnableEventInfo = value;
                    return;
                }
                case 1146: {
                    this.mConfigure.mFileExtendSizeKB = value;
                    return;
                }
                case 1147: {
                    this.mConfigure.mMinAllowSpeed = value;
                    return;
                }
                case 2000: {
                    this.mConfigure.mEnableStorageModule = value;
                    return;
                }
                case 2001: {
                    this.mConfigure.mStoPlayDldWinSizeKBNM = value;
                    return;
                }
                case 2002: {
                    this.mConfigure.mStoPlayDldWinSizeKBLS = value;
                    return;
                }
                case 2003: {
                    this.mConfigure.mStoRingBufferSizeKB = value;
                    return;
                }
                case 2004: {
                    this.mConfigure.mStoIoWriteLimitKBTh1 = value;
                    return;
                }
                case 2005: {
                    this.mConfigure.mStoIoWriteLimitKBTh2 = value;
                    return;
                }
                case 2006: {
                    this.mConfigure.mStoMaxIdleTimeSec = value;
                    return;
                }
                case 119: {
                    SettingsHelper.helper().setEnable(value);
                    return;
                }
                case 1154: {
                    this.mEnableMdlV2 = value;
                    return;
                }
                case 1158: {
                    this.mConfigure.mMaxFileMemCacheSize = value;
                    return;
                }
                case 1159: {
                    this.mConfigure.mMaxFileMemCacheNum = value;
                    return;
                }
                case 1155: {
                    this.mEnableSplitPreload = value;
                    return;
                }
                case 1156: {
                    if (value <= 0) return;
                    this.mPreloadUtil.mPlayBufferLowerBound = value;
                    return;
                }
                case 1157: {
                    if (value <= 0) return;
                    this.mPreloadUtil.mPlayBufferUpperBound = value;
                    return;
                }
                case 1163: {
                    this.mEnableBufferPreload = value;
                    return;
                }
                case 1513: {
                    this.mEnableCheckPreloadUrls = value;
                    return;
                }
                case 1505: {
                    this.mEnableStrategyCenterCancelAll = value;
                    return;
                }
                case 1170: {
                    this.mEnableSetMDLNetStatus = value;
                    return;
                }
                case 1160: {
                    if (value < 0) return;
                    this.mConfigure.mEnableEarlyData = value;
                    return;
                }
                case 2100: {
                    if (value < 0) return;
                    this.mConfigure.mEnableP2pUpload = value;
                    return;
                }
                case 2102: {
                    if (value < 0) return;
                    this.mConfigure.mDevDiskSizeMB = value;
                    return;
                }
                case 2104: {
                    if (value < 0) return;
                    this.mConfigure.mDevMemorySizeMB = value;
                    return;
                }
                case 1161: {
                    if (value <= 0) return;
                    this.mConfigure.mSocketRecvBufferSize = value;
                    return;
                }
                case 1162: {
                    if (value <= 0) return;
                    this.mConfigure.mEnableSpeedPredict = value;
                    return;
                }
                case 1171: {
                    if (value <= 0) return;
                    this.mConfigure.mEnableSpeedEngine = value;
                    return;
                }
                case 1172: {
                    if (value <= 0) return;
                    this.mConfigure.mEnableSpeedReport = value;
                    return;
                }
                case 1501: {
                    this.mConfigure.mEnableCellularUp = value;
                    return;
                }
                case 1164: {
                    this.mConfigure.mEnableUseOriginalUrl = value;
                    return;
                }
                case 1166: {
                    this.mConfigure.mEnableLoaderLogExtractUrls = value;
                    return;
                }
                case 1167: {
                    this.mConfigure.mMaxLoaderLogNum = value;
                    return;
                }
                case 1168: {
                    this.mConfigure.mCheckContentTypeMethod = value;
                    return;
                }
                case 1169: {
                    this.mConfigure.mCloseThreadPool = value;
                    return;
                }
                case 9013: {
                    this.mEnableLibManager = value;
                    return;
                }
                case 9015: {
                    this.mEnableLoadP2pAsync = value;
                    return;
                }
                case 9014: {
                    if (value != 1) {
                        if (value != 0) return;
                    }
                    this.mConfigure.mEnableMultiDownloadPath = value;
                    return;
                }
                case 1701: {
                    this.mConfigure.mEnableByteMediaNetLoader = value;
                    return;
                }
                case 2008: {
                    if (value < 0) return;
                    this.mConfigure.mThreadStackSizeLevel = value;
                    return;
                }
                case 2009: {
                    if (value <= 0) return;
                    this.mConfigure.mThreadPoolMinCount = value;
                    return;
                }
                case 2010: {
                    if (value <= 0) return;
                    this.mConfigure.mEnableThreadPoolCheckIdle = value;
                    return;
                }
                case 2011: {
                    if (value <= 0) return;
                    this.mConfigure.mThreadPoolTTLSecond = value;
                    return;
                }
                case 2012: {
                    if (value <= 0) return;
                    this.mConfigure.mMaxIpNum = value;
                    return;
                }
                case 32: {
                    this.mForbidNativeMDLForOriUrl = value > 0;
                    return;
                }
                case 2013: {
                    this.mConfigure.mNonBlockRangeMode = value;
                    return;
                }
                case 2014: {
                    this.mConfigure.mNonBlockRangeMaxSizeKB = value;
                    return;
                }
                case 2015: {
                    if (value < 0) return;
                    this.mConfigure.mNetUnreachableStopRetry = value;
                    return;
                }
                case 2016: {
                    if (value < 0) return;
                    this.mConfigure.mEnableWaitNetReachable = value;
                    return;
                }
                case 2017: {
                    this.mConfigure.mEnableFileMutexOptimize = value;
                    return;
                }
                case 2018: {
                    if (value <= 0) return;
                    this.mConfigure.mSkipCDNBeforeExpiredSec = value;
                    return;
                }
                case 2019: {
                    if (value <= 0) return;
                    this.mConfigure.mNetUnreachableTimeout = value;
                    return;
                }
                case 31: {
                    this.mConfigure.mEnableOkHttpLoader = value;
                    return;
                }
                case 2020: 
                case 2021: {
                    if (value < 1) return;
                    if (value > 32) {
                        return;
                    }
                    this.mConfigure.mP2PCostTag = !TextUtils.isEmpty((CharSequence)this.mConfigure.mP2PCostTag) ? this.mConfigure.mP2PCostTag + ',' + Integer.toString(value) : Integer.toString(value);
                    TTVideoEngineLog.d(TAG, "cur p2p cost tag is: " + this.mConfigure.mP2PCostTag);
                    return;
                }
                case 123: {
                    if (value <= 0) return;
                    this.mConfigure.mDeviceScoreEx = value;
                    return;
                }
                case 2022: {
                    if (value <= 0) return;
                    this.mConfigure.mIgnoreTextSpeedTest = value;
                    return;
                }
                case 2023: {
                    if (value <= 0) return;
                    this.mConfigure.mEnableOptimizeRange = value;
                    return;
                }
                case 2024: {
                    if (value <= 0) return;
                    this.mConfigure.mDownLogMaxSize = value;
                    return;
                }
                case 2025: {
                    this.mConfigure.mCheckCacheDir = value;
                    return;
                }
                case 12001: {
                    this.mConfigure.mHlsTsFileKeyGenerateType = value;
                    return;
                }
                case 9016: {
                    this.mEnableHLSProxy = value;
                    return;
                }
                case 12002: {
                    this.mEnableVideoModelHitCacheCallback = value;
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLongValue(int key, long value) {
        this.mLock.lock();
        TTVideoEngineLog.d(TAG, "setLongValue key = " + key + ", value = " + value);
        try {
            int k = -1;
            switch (key) {
                case 62: {
                    k = 1100;
                    break;
                }
                case 22: {
                    k = 7210;
                    break;
                }
                case 23: {
                    k = 7211;
                    break;
                }
                case 24: {
                    k = 7212;
                    break;
                }
                case 25: {
                    k = 7213;
                    break;
                }
                case 26: {
                    k = 7214;
                    break;
                }
                case 27: {
                    k = 7215;
                    break;
                }
                case 28: {
                    k = 7338;
                    break;
                }
                case 1142: {
                    this.mConfigure.mP2PStragetyLevel = value;
                    break;
                }
                case 1144: {
                    this.mConfigure.mConnectPoolStragetyValue = value;
                    break;
                }
                case 1152: {
                    this.mConfigure.mMonitorTimeInternal = value;
                    break;
                }
                case 1153: {
                    this.mConfigure.mMonitorMinAllowLoadSize = value;
                    break;
                }
            }
            if (this.mInnerDataLoader != null) {
                this.mInnerDataLoader.setLongValue(k, value);
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, "setLongValue failed, key: " + key + ", value: " + value);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayInfo(int key1, String key2, String vid, long value) {
        if (this.mState != 0) {
            TTVideoEngineLog.d(TAG, "dataloader not started, not allow set play info");
            return;
        }
        this.mLock.lock();
        this.setPlayInfoOnlyForPreload(key1, key2, vid, value);
        try {
            int k = -1;
            switch (key1) {
                case 22: {
                    k = 7210;
                    break;
                }
                case 23: {
                    k = 7211;
                    break;
                }
                case 24: {
                    k = 7212;
                    break;
                }
                case 25: {
                    k = 7213;
                    break;
                }
                case 26: {
                    k = 7214;
                    break;
                }
                case 27: {
                    k = 7215;
                    break;
                }
                case 28: {
                    k = 7338;
                    break;
                }
            }
            this.mInnerDataLoader.setInt64ValueByStrKey(k, key2, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
    }

    public boolean isNeedPlayInfo() {
        if (this.mEnableBufferPreload <= 0) {
            return false;
        }
        return this.mPreloadUtil.mPlayBufferLowerBound > 0L && this.mPreloadUtil.mPlayBufferUpperBound > 0L;
    }

    public void setPlayInfoOnlyForPreload(int key1, String key2, String vid, long value) {
        if (this.mState != 0) {
            TTVideoEngineLog.d(TAG, "dataloader not started, not allow set play info");
            return;
        }
        if (this.mEnableBufferPreload <= 0) {
            return;
        }
        this.mLock.lock();
        if (this.mPreloadUtil.mPlayBufferLowerBound > 0L && this.mPreloadUtil.mPlayBufferUpperBound > 0L) {
            this.mPreloadUtil.updatePlayInfo(key1, key2, vid, value);
        }
        this.mLock.unlock();
    }

    public void updateCurrentNetStatus() {
        if (this.mState != 0) {
            TTVideoEngineLog.d(TAG, "dataloader not started, not allow set play info");
            return;
        }
        if (this.mEnableSetMDLNetStatus <= 0) {
            return;
        }
        this.mLock.lock();
        int strength = TTNetWorkListener.getInstance().getCurrentAccessStrength();
        this.mInnerDataLoader.setIntValue(7410, strength);
        int networkScore = PortraitNetworkScore.getInstance().getPortraitResult();
        this.mInnerDataLoader.setIntValue(7409, networkScore);
        this.mLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStringValue(int key, String value) {
        TTVideoEngineLog.d(TAG, "setStringValue key = " + key + ", value = " + value);
        this.mLock.lock();
        try {
            switch (key) {
                case 0: {
                    this.mConfigure.mCacheDir = value;
                    return;
                }
                case 1106: {
                    this.mConfigure.mVdpABTestId = value;
                    return;
                }
                case 1107: {
                    this.mConfigure.mVdpGroupId = value;
                    return;
                }
                case 102: {
                    this.mConfigure.mNetCacheDir = value;
                    return;
                }
                case 1512: {
                    this.mConfigure.mMdlTTQuicHeOptsStr = value;
                    return;
                }
                case 107: {
                    AVMDLDNSParser.setStringValue((int)8, (String)value);
                    return;
                }
                case 108: {
                    AVMDLDNSParser.setStringValue((int)9, (String)value);
                    return;
                }
                case 9002: {
                    this.mConfigure.mSettingsDomain = value;
                    return;
                }
                case 9003: {
                    this.mConfigure.mDmDomain = value;
                    return;
                }
                case 9004: {
                    this.mConfigure.mForesightDomain = value;
                    return;
                }
                case 514: {
                    this.mConfigure.mLiveContainerString = value;
                    return;
                }
                case 9005: {
                    this.mConfigure.mDomains = value;
                    return;
                }
                case 111: {
                    this.mConfigure.mDownloadDir = value;
                    return;
                }
                case 1500: {
                    this.mConfigure.mMdlExtensionOptsStr = value;
                    return;
                }
                case 9006: {
                    this.mConfigure.mKeyDomain = value;
                    return;
                }
                case 9007: {
                    this.mConfigure.mKeyToken = value;
                    return;
                }
                case 9010: {
                    this.mConfigure.mSocketTraingCenterConfigStr = value;
                    return;
                }
                case 2007: {
                    this.mConfigure.mStoStrategyConfig = value;
                    return;
                }
                case 2101: {
                    this.mConfigure.mVdpExtGlobalInfo = value;
                    return;
                }
                case 9012: {
                    this.mConfigure.mP2PConfigStr = value;
                    return;
                }
                case 1149: {
                    this.mConfigure.mNetSchedulerConfigStr = value;
                    return;
                }
                case 1165: {
                    this.mConfigure.mDynamicPreconnectConfigStr = value;
                    return;
                }
                case 1502: {
                    this.mConfigure.mTemporaryOptStr = value;
                    return;
                }
                case 1510: {
                    this.mConfigure.mFileRingBufferOptStr = value;
                    return;
                }
                case 1506: 
                case 1507: 
                case 1508: {
                    if (!TextUtils.isEmpty((CharSequence)value)) {
                        this.mConfigure.mCustomUA = TextUtils.isEmpty((CharSequence)this.mConfigure.mCustomUA) ? value : this.mConfigure.mCustomUA + "," + value;
                    }
                    TTVideoEngineLog.d(TAG, "cur custom UA" + this.mConfigure.mCustomUA);
                    return;
                }
                case 1511: {
                    this.mConfigure.mN80OptsStr = value;
                    return;
                }
                case 1173: {
                    this.mConfigure.mSpeedEngineSetting = value;
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setIntValueSync(int key, int value) {
        this.mLock.lock();
        if (this.mInnerDataLoader == null) {
            this.mLock.unlock();
            TTVideoEngineLog.d(TAG, "setIntValueSync failed, key = " + key + ", value = " + value);
            return;
        }
        TTVideoEngineLog.d(TAG, "setIntValueSync key = " + key + ", value = " + value);
        try {
            switch (key) {
                case 2103: {
                    if (value < 0) return;
                    this.mInnerDataLoader.setIntValue(11003, value);
                    return;
                }
                case 2105: {
                    if (value < 0) return;
                    this.mInnerDataLoader.setIntValue(11005, value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStringValueSync(int key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        this.mLock.lock();
        if (this.mInnerDataLoader == null) {
            this.mLock.unlock();
            TTVideoEngineLog.d(TAG, "setStringValueSync failed, key = " + key + ", value = " + value);
            return;
        }
        TTVideoEngineLog.d(TAG, "setStringValueSync key = " + key + ", value = " + value);
        try {
            switch (key) {
                case 2106: {
                    this.mInnerDataLoader.setStringValue(11006, value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void setCacheInfoLists(String[] dirs, long[] maxCaches) {
        TTVideoEngineLog.d(TAG, "setcustom paths and maxcaches ");
        this.mLock.lock();
        try {
            this.mConfigure.setCacheInfoList(dirs, maxCaches);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getStringValue(int key) {
        this.mLock.lock();
        try {
            switch (key) {
                case 0: {
                    String string = this.mConfigure.mCacheDir;
                    return string;
                }
                case 6: {
                    if (this.mVersionInfo == null && this.mInnerDataLoader != null) {
                        this.mVersionInfo = this.mInnerDataLoader.getStringValue(11);
                    }
                    String string = this.mVersionInfo;
                    return string;
                }
                case 1509: {
                    String string = this.mConfigure.mCustomUA;
                    return string;
                }
                case 9010: {
                    String string = this.mConfigure.mSocketTraingCenterConfigStr;
                    return string;
                }
            }
            return null;
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
            return null;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getLongValue(int key) {
        this.mLock.lock();
        try {
            switch (key) {
                case 1003: {
                    long l = this.mEnableMdlProtocol ? this.mMdlProtocolHandle : -1L;
                    return l;
                }
                case 1152: {
                    long l = this.mConfigure.mMonitorTimeInternal;
                    return l;
                }
                case 1153: {
                    long l = this.mConfigure.mMonitorMinAllowLoadSize;
                    return l;
                }
            }
            return -1L;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getIntValue(int key) {
        this.mLock.lock();
        int value = -1;
        try {
            switch (key) {
                case 1008: {
                    value = this.mCurrentAccessType;
                    return value;
                }
                case 9009: {
                    value = this.mSupporHls ? 1 : 0;
                    return value;
                }
                case 12: {
                    value = this.mMdlPreloadStrategy;
                    return value;
                }
                case 1: {
                    value = this.mConfigure.mMaxCacheSize;
                    return value;
                }
                case 8: {
                    value = this.mConfigure.mEnableSocketReuse;
                    return value;
                }
                case 1001: {
                    value = this.mConfigure.mEnablePreconnect;
                    return value;
                }
                case 90: {
                    value = this.mConfigure.mDNSMainType;
                    return value;
                }
                case 114: {
                    value = this.mEnablePreParseHost;
                    return value;
                }
                case 105: {
                    value = AVMDLDNSParser.getIntValue((int)6);
                    return value;
                }
                case 103: {
                    value = AVMDLDNSParser.getIntValue((int)4);
                    return value;
                }
                case 115: {
                    value = this.mEnableBackupIP;
                    return value;
                }
                case 101: {
                    value = this.mConfigure.mEnableSessionReuse;
                    return value;
                }
                case 100: {
                    value = this.mConfigure.mMaxTlsVersion;
                    return value;
                }
                case 7: {
                    value = this.mConfigure.mEnableExternDNS;
                    return value;
                }
                case 1150: {
                    value = this.mConfigure.mEnableIOManager;
                    return value;
                }
                case 9016: {
                    value = this.mEnableHLSProxy;
                    return value;
                }
            }
            return value;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public long getCacheFileSize(String key) {
        return this.getCacheSize(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryQuickGetCacheFileSize(String key) {
        if (this.mState != 0) {
            return 0L;
        }
        this.mLock.lock();
        try {
            long result = 0L;
            if (this.mInnerDataLoader == null) {
                long l = result;
                return l;
            }
            result = this.mInnerDataLoader.tryQuickGetCacheSize(key);
            long l = result > 0L ? result : 0L;
            return l;
        }
        catch (Throwable e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlayLog(String traceId) {
        if (TextUtils.isEmpty((CharSequence)traceId)) {
            return null;
        }
        String result = null;
        this.mLock.lock();
        try {
            result = this.mInnerDataLoader == null ? null : this.mInnerDataLoader.getStringValueByStr(traceId, 1010);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getPreloadTraceId(String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey)) {
            return null;
        }
        String result = null;
        this.mLock.lock();
        try {
            result = this.mInnerDataLoader == null ? null : this.mInnerDataLoader.getStringValueByStr(rawKey, 1012);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
        return result;
    }

    @Nullable
    public void resetPreloadTraceId(String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey)) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null || this.mState != 0) {
                return;
            }
            this.mInnerDataLoader.resetPreloadTraceId(rawKey);
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoaderCacheInfo getCacheInfo(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null || this.mState != 0) {
                DataLoaderCacheInfo dataLoaderCacheInfo = null;
                return dataLoaderCacheInfo;
            }
            String infoStr = this.mInnerDataLoader.getStringCacheInfo(key);
            DataLoaderCacheInfo dataLoaderCacheInfo = this._processCacheInfo(infoStr);
            return dataLoaderCacheInfo;
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
            DataLoaderCacheInfo dataLoaderCacheInfo = null;
            return dataLoaderCacheInfo;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataLoaderCacheInfo getCacheInfoByTimeOut(String key, long timeOut, TimeUnit unit) {
        DataLoaderCacheInfo info;
        block11: {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            info = null;
            try {
                TTVideoEngineLog.d(TAG, "****try get cacheinfo lock timeout" + timeOut);
                if (this.mLock.tryLock(timeOut, unit)) {
                    TTVideoEngineLog.d(TAG, "####get cacheinfo lock suc");
                    try {
                        if (this.mInnerDataLoader == null || this.mState != 0) {
                            TTVideoEngineLog.d(TAG, "get cacheinfo fail mdl not start");
                            DataLoaderCacheInfo dataLoaderCacheInfo = null;
                            return dataLoaderCacheInfo;
                        }
                        String infoStr = this.mInnerDataLoader.getStringCacheInfo(key);
                        info = this._processCacheInfo(infoStr);
                        TTVideoEngineLog.d(TAG, "get cacheinfo native end");
                        break block11;
                    }
                    catch (Throwable e) {
                        TTVideoEngineLog.d(e);
                        break block11;
                    }
                    finally {
                        this.mLock.unlock();
                    }
                }
                TTVideoEngineLog.d(TAG, "####not get cacheinfo lock timeout" + timeOut);
            }
            catch (InterruptedException interrupt) {
                TTVideoEngineLog.d(TAG, "get cacheinfo interrupt exception:" + interrupt.getLocalizedMessage());
            }
        }
        TTVideoEngineLog.d(TAG, "get cacheinfo all end");
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataLoaderCacheInfo getCacheInfoByFilePath(String filePath) {
        this.mLock.lock();
        try {
            DataLoaderCacheInfo info;
            if (this.mInnerDataLoader == null) {
                DataLoaderCacheInfo dataLoaderCacheInfo = null;
                return dataLoaderCacheInfo;
            }
            String key = TTHelper.keyFromFilePath(this.mContext, filePath);
            String infoStr = this.mInnerDataLoader.getStringCacheInfo(key, filePath);
            DataLoaderCacheInfo dataLoaderCacheInfo = info = this._processCacheInfo(infoStr);
            return dataLoaderCacheInfo;
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
            DataLoaderCacheInfo dataLoaderCacheInfo = null;
            return dataLoaderCacheInfo;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheSizeByFilePath(String filePath) {
        this.mLock.lock();
        try {
            long result = 0L;
            if (this.mInnerDataLoader == null) {
                long l = result;
                return l;
            }
            String key = TTHelper.keyFromFilePath(this.mContext, filePath);
            result = this.mInnerDataLoader.getCacheSize(key, filePath);
            long l = result > 0L ? result : 0L;
            return l;
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
            long l = 0L;
            return l;
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToClearCachesByUsedTime(long time) {
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null) {
                return;
            }
            this.mInnerDataLoader.tryToClearCachesByUsedTime(time);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryToClearAndGetCachesByUsedTime(long time, boolean isNeedDeleteFile) {
        this.mLock.lock();
        long result = 0L;
        try {
            if (this.mInnerDataLoader == null) {
                long l = -1L;
                return l;
            }
            result = this.mInnerDataLoader.tryToClearAndGetCachesByUsedTime(time, isNeedDeleteFile);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
        return result;
    }

    public void clearNetinfoCache() {
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null) {
                return;
            }
            this.mInnerDataLoader.clearNetinfoCache();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
    }

    private DataLoaderCacheInfo _processCacheInfo(String infoStr) {
        if (infoStr == null) {
            return null;
        }
        String[] result = infoStr.split(",");
        if (result.length >= 4) {
            DataLoaderCacheInfo cacheInfo = new DataLoaderCacheInfo();
            cacheInfo.mLocalFilePath = result[3];
            if (!TextUtils.isEmpty((CharSequence)result[0])) {
                cacheInfo.mCacheSizeFromZero = Long.valueOf(result[0]);
            }
            if (!TextUtils.isEmpty((CharSequence)result[1])) {
                cacheInfo.mMediaSize = Long.valueOf(result[1]);
            }
            TTVideoEngineLog.d(TAG, "get cache info.");
            return cacheInfo;
        }
        return null;
    }

    public void cancelTaskByFilePath(String filePath) {
        String key = TTHelper.keyFromFilePath(this.mContext, filePath);
        this.cancelTask(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDnsInfo(JSONObject dnsInfo, long dnsTime) {
        if (dnsInfo == null) {
            TTVideoEngineLog.e(TAG, "ip direct info invalid");
            return;
        }
        if (NetUtils.netUpdateTimeMs != -1L && dnsTime * 1000L < NetUtils.netUpdateTimeMs) {
            TTVideoEngineLog.e(TAG, "network did change, dnsinfo is invalid");
            return;
        }
        this.mLock.lock();
        try {
            Iterator keys = dnsInfo.keys();
            String host = "";
            String ipList = "";
            do {
                host = (String)keys.next();
                JSONArray temIpList = dnsInfo.optJSONArray(host);
                for (int i = 0; i < temIpList.length(); ++i) {
                    ipList = ipList + temIpList.optString(i);
                    if (i >= temIpList.length() - 1) continue;
                    ipList = ipList + ",";
                }
                AVMDLDNSParser.updateDNSInfo((String)host, (String)ipList, (long)dnsTime);
                ipList = "";
            } while (keys.hasNext() && !TextUtils.isEmpty((CharSequence)host));
        }
        catch (Exception e) {
            TTVideoEngineLog.e(TAG, e.toString());
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTaskByVideoId(String vid) {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            return;
        }
        if (this.mInnerDataLoader == null || this.mState != 0) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        ArrayList<String> temKeys = new ArrayList<String>();
        this.mLock.lock();
        try {
            int i;
            ArrayList<DataLoaderTaskItem> temArray;
            DataLoaderTaskItem temItem;
            if (this.mPreloadTasks.count() > 0L) {
                temItem = null;
                temArray = this.mPreloadTasks.toArray();
                for (i = 0; i < temArray.size(); ++i) {
                    temItem = temArray.get(i);
                    if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || !vid.equals(temItem.mVideoId)) continue;
                    for (DataLoaderTaskItem.TrackItem trackItem : temItem.mTracks) {
                        if (TextUtils.isEmpty((CharSequence)trackItem.mTaskKey)) continue;
                        temKeys.add(trackItem.mTaskKey);
                    }
                }
            }
            if (this.mExecuteTasks.count() > 0L) {
                temItem = null;
                temArray = this.mExecuteTasks.toArray();
                for (i = 0; i < temArray.size(); ++i) {
                    temItem = temArray.get(i);
                    if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || !vid.equals(temItem.mVideoId)) continue;
                    for (DataLoaderTaskItem.TrackItem trackItem : temItem.mTracks) {
                        if (TextUtils.isEmpty((CharSequence)trackItem.mTaskKey)) continue;
                        temKeys.add(trackItem.mTaskKey);
                    }
                }
            }
            if (this.mAllPreloadTasks.count() > 0L) {
                temItem = null;
                temArray = this.mAllPreloadTasks.toArray();
                for (i = 0; i < temArray.size(); ++i) {
                    temItem = temArray.get(i);
                    if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || !vid.equals(temItem.mVideoId)) continue;
                    for (DataLoaderTaskItem.TrackItem trackItem : temItem.mTracks) {
                        if (TextUtils.isEmpty((CharSequence)trackItem.mTaskKey)) continue;
                        temKeys.add(trackItem.mTaskKey);
                    }
                }
            }
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
        if (temKeys.size() > 0) {
            for (int i = 0; i < temKeys.size(); ++i) {
                this.cancelTask((String)temKeys.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (this.mInnerDataLoader == null || this.mState != 0) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        this.mLock.lock();
        try {
            DataLoaderTaskItem taskItem = this.mPreloadTasks.popItem(key);
            if (taskItem != null) {
                this._notifyPreloadCancel(taskItem);
            } else {
                taskItem = this.mExecuteTasks.popItem(key);
                if (taskItem != null) {
                    if (taskItem.mFetcher != null) {
                        taskItem.mFetcher.cancel();
                    }
                    if (taskItem.mURLItem != null && taskItem.mURLItem.mAdapter != null && taskItem.mURLItem.mAdapter.isFetchSmartUrl()) {
                        taskItem.mURLItem.mAdapter.cancelFetchSmartUrlInfo();
                    }
                    this._notifyPreloadCancel(taskItem);
                } else {
                    taskItem = this.mAllPreloadTasks.popItem(key);
                    if (taskItem != null) {
                        boolean canceled = false;
                        canceled = this.mDataLoaderHelperAdapter.cancelPreload(key);
                        if (!canceled) {
                            this.mInnerDataLoader.cancel(key);
                        }
                        this._notifyPreloadCancel(taskItem);
                    }
                }
            }
            TTVideoEngineLog.i(TAG, "[preload] cancel preload task. key = " + key);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void cancelAllTasks() {
        if (this.mInnerDataLoader == null || this.mState != 0) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        if (this.mEnableStrategyCenterCancelAll == 1 && StrategyHelper.helper().isRunning()) {
            StrategyHelper.helper().getCenter().businessEvent(31205, 1);
        }
        this.mLock.lock();
        try {
            this.cancelAllTasksInternal();
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void cancelAllWaitReqs() {
        TTVideoEngineLog.d(TAG, "start do cancel all wait reqs");
        if (this.mInnerDataLoader == null || this.mState != 0) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        this.mLock.lock();
        try {
            this.mInnerDataLoader.cancelAllPreloadWaitReqs();
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(TAG, "do cancel all wait reqs exception:" + e.toString());
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void removeCacheFile(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mDataLoaderHelperAdapter.removeCacheFile(key)) {
                return;
            }
            if (this.mInnerDataLoader == null) {
                TTVideoEngineLog.e(TAG, "mInnerDataLoader == null");
                return;
            }
            TTVideoEngineLog.i(TAG, "remove mdl file. key " + key);
            this.mInnerDataLoader.removeFileCache(key);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void removeDownloadFile(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mDataLoaderHelperAdapter.removeDownloadFile(key)) {
                return;
            }
            if (this.mInnerDataLoader == null) {
                TTVideoEngineLog.e(TAG, "mInnerDataLoader == null");
                return;
            }
            TTVideoEngineLog.i(TAG, "remove mdl file, download key " + key);
            this.mInnerDataLoader.removeFileCache(key);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    void forceRemoveCacheFile(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mDataLoaderHelperAdapter.removeCacheFile(key)) {
                return;
            }
            if (this.mInnerDataLoader == null) {
                TTVideoEngineLog.e(TAG, "mInnerDataLoader == null");
                return;
            }
            TTVideoEngineLog.i(TAG, " force remove mdl file. key " + key);
            this.mInnerDataLoader.forceRemoveFileCache(key);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAllCacheSize() {
        if (this.mState != 0) {
            return 0L;
        }
        long size = 0L;
        if (this.mLock.tryLock()) {
            try {
                long playlistSize = this.mDataLoaderHelperAdapter.getAllCacheSize();
                if (playlistSize > 0L) {
                    size += playlistSize;
                }
                if (this.mInnerDataLoader == null) {
                    TTVideoEngineLog.e(TAG, "mInnerDataLoader == null");
                }
                size += this.mInnerDataLoader.getAllCacheSize();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                this.mLock.unlock();
            }
        }
        return size;
    }

    public void clearAllCaches() {
        this.clearAllCaches(false);
    }

    public void clearAllCaches(boolean force) {
        if (this.mState != 0) {
            return;
        }
        this.mLock.lock();
        try {
            this.mDataLoaderHelperAdapter.removeAllHLSCache();
            if (this.mInnerDataLoader == null) {
                TTVideoEngineLog.e(TAG, "mInnerDataLoader == null");
                return;
            }
            if (force) {
                this.mInnerDataLoader.forceClearAllCaches();
            } else {
                this.mInnerDataLoader.clearAllCaches();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.mLock.unlock();
        }
    }

    public int writeDataToFile(String fileKey, long fileSize, long off, int length, byte[] buffer) {
        if (this.mState != 0) {
            TTVideoEngineLog.e(TAG, "not start");
            return -1;
        }
        int result = 0;
        if (this.mLock.tryLock()) {
            if (this.mInnerDataLoader != null) {
                TTVideoEngineLog.d(TAG, "start write");
                result = this.mInnerDataLoader.writeDataToFile(fileKey, fileSize, off, length, buffer);
                TTVideoEngineLog.d(TAG, "end write");
            }
            this.mLock.unlock();
        }
        TTVideoEngineLog.d(TAG, "write data to file ret:" + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCacheSize(String key) {
        if (this.mState != 0) {
            return 0L;
        }
        this.mLock.lock();
        try {
            long result = 0L;
            result = this.mDataLoaderHelperAdapter.getCacheSize(key);
            if (result > 0L) {
                long l = result;
                return l;
            }
            if (this.mInnerDataLoader == null) {
                long l = result;
                return l;
            }
            result = this.mInnerDataLoader.getCacheSize(key);
            long l = result > 0L ? result : 0L;
            return l;
        }
        catch (Throwable e) {
            e.printStackTrace();
            long l = 0L;
            return l;
        }
        finally {
            this.mLock.unlock();
        }
    }

    public DataLoaderCacheFileInfo cacheFileInfo(String key) {
        DataLoaderCacheInfo info = this.getCacheInfo(key);
        if (info != null) {
            DataLoaderCacheFileInfo temInfo = new DataLoaderCacheFileInfo();
            temInfo.mMediaSize = info.mMediaSize;
            temInfo.mCacheSizeFromZero = info.mCacheSizeFromZero;
            temInfo.mLocalFilePath = info.mLocalFilePath;
            return temInfo;
        }
        return null;
    }

    public DataLoaderCacheFileInfo cacheFileInfoByTimeOut(String key, long timeOut, TimeUnit unit) {
        DataLoaderCacheInfo info = this.getCacheInfoByTimeOut(key, timeOut, unit);
        if (info != null) {
            DataLoaderCacheFileInfo temInfo = new DataLoaderCacheFileInfo();
            temInfo.mMediaSize = info.mMediaSize;
            temInfo.mCacheSizeFromZero = info.mCacheSizeFromZero;
            temInfo.mLocalFilePath = info.mLocalFilePath;
            return temInfo;
        }
        return null;
    }

    public void cancelAllTasksInternal() {
        DataLoaderTaskItem temItem;
        int i;
        DataLoaderTaskItem taskItem = null;
        ArrayList<DataLoaderTaskItem> temList = new ArrayList<DataLoaderTaskItem>();
        if (this.mExecuteTasks.count() > 0L) {
            while ((taskItem = this.mExecuteTasks.popBackItem()) != null) {
                if (taskItem.mPriorityLevel >= 10000) {
                    temList.add(taskItem);
                    continue;
                }
                if (taskItem.mFetcher != null) {
                    taskItem.mFetcher.cancel();
                }
                this._notifyPreloadCancel(taskItem);
            }
            for (i = 0; i < temList.size(); ++i) {
                temItem = (DataLoaderTaskItem)temList.get(i);
                this.mExecuteTasks.enqueueItem(temItem);
            }
            temList.clear();
        }
        if (this.mPreloadTasks.count() > 0L) {
            while ((taskItem = this.mPreloadTasks.popBackItem()) != null) {
                if (taskItem.mPriorityLevel >= 10000) {
                    temList.add(taskItem);
                    continue;
                }
                if (taskItem.mFetcher != null) {
                    taskItem.mFetcher.cancel();
                }
                this._notifyPreloadCancel(taskItem);
            }
            for (i = 0; i < temList.size(); ++i) {
                temItem = (DataLoaderTaskItem)temList.get(i);
                this.mPreloadTasks.enqueueItem(temItem);
            }
            temList.clear();
        }
        if (this.mAllPreloadTasks.count() > 0L) {
            boolean mdlCancel = false;
            while ((taskItem = this.mAllPreloadTasks.popBackItem()) != null) {
                if (taskItem.mPriorityLevel >= 10000) {
                    temList.add(taskItem);
                    continue;
                }
                mdlCancel = true;
                this._notifyPreloadCancel(taskItem);
            }
            if (mdlCancel) {
                this.mDataLoaderHelperAdapter.cancelAll();
                this.mInnerDataLoader.cancelAll();
            }
            for (int i2 = 0; i2 < temList.size(); ++i2) {
                DataLoaderTaskItem temItem2 = (DataLoaderTaskItem)temList.get(i2);
                this.mAllPreloadTasks.enqueueItem(temItem2);
            }
            temList.clear();
        }
    }

    private void _notifyPreloadCancel(DataLoaderTaskItem taskItem) {
        if (taskItem == null) {
            return;
        }
        if (taskItem.mDidCanceled) {
            return;
        }
        taskItem.mDidCanceled = true;
        if (taskItem.getCallBackListener() != null) {
            PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(5);
            taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
        }
    }

    public String generateSubUrlKey(String mainKey, String subUrl) {
        return AVMDLDataLoader.makeTsFileKey((String)mainKey, (String)subUrl);
    }

    public String proxyUrl(String key, String url) {
        return this.proxyUrl(key, key, new String[]{url}, null, null);
    }

    public String proxyUrl(String key, String rawKey, String[] urls, Resolution resolution, String decryptionKey) {
        return this._proxyUrl(key, rawKey, 0L, urls, resolution, decryptionKey, null, null, null, false, false, null, 0L);
    }

    public String getDataLoaderUrl(String key, String rawKey, String[] urls, Resolution resolution, String decryptionKey) {
        return this._proxyUrl(key, rawKey, 0L, urls, resolution, decryptionKey, null, null, null, false, false, null, 0L);
    }

    public String _getProxyUrl(String protocolUrl) {
        String resultString = null;
        try {
            if (TextUtils.isEmpty((CharSequence)protocolUrl)) {
                return null;
            }
            if (!protocolUrl.startsWith(MDL_PREFIX)) {
                return protocolUrl;
            }
            int index = protocolUrl.indexOf("?");
            if (index == -1) {
                return null;
            }
            String localHost = this.mInnerDataLoader.getLocalAddr();
            if (TextUtils.isEmpty((CharSequence)localHost)) {
                return null;
            }
            StringBuffer proxyUrlBuffer = new StringBuffer();
            proxyUrlBuffer.append("http://");
            proxyUrlBuffer.append(localHost);
            proxyUrlBuffer.append(protocolUrl.substring(index));
            resultString = proxyUrlBuffer.toString();
            TTVideoEngineLog.e(TAG, "_proxyUrl: " + resultString);
        }
        catch (Exception e) {
            resultString = protocolUrl;
            TTVideoEngineLog.e(TAG, "get proxy url failed: " + protocolUrl);
        }
        return resultString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _proxyUrl(String key, String rawKey, long limitSize, String[] originalUrls, Resolution resolution, String decryptionKey, VideoInfo info, String filePath, String extraInfo, boolean forceLs, boolean isM3u, String drmToken, long urlExpireTime) {
        DataLoaderTaskItem.TrackItem trackItem;
        if (this.mState != 0) {
            return null;
        }
        if (TextUtils.isEmpty((CharSequence)key) || originalUrls == null || originalUrls.length < 1) {
            return null;
        }
        String[] urls = (String[])originalUrls.clone();
        for (int i = 0; i < urls.length; ++i) {
            if (this._supportProxy(urls[i])) continue;
            TTVideoEngineLog.d(TAG, "not support");
            return urls[i];
        }
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "start mdl first");
            return null;
        }
        boolean _isM3u = false;
        if (this.mEnableHls == 1) {
            if (isM3u || FormatProvider.FormatProviderHolder.isM3u8(urls[0])) {
                _isM3u = true;
            }
            if (_isM3u) {
                forceLs = true;
            }
        }
        String resultString = null;
        this.mLock.lock();
        try {
            String localHost = this.mInnerDataLoader.getLocalAddr();
            if (TextUtils.isEmpty((CharSequence)localHost)) {
                TTVideoEngineLog.e(TAG, "local host error");
                String string = null;
                return string;
            }
            String query = this.proxyQuery(key, rawKey, 0L, limitSize, urls, filePath, extraInfo, _isM3u, drmToken);
            if (TextUtils.isEmpty((CharSequence)query)) {
                String string = null;
                return string;
            }
            StringBuffer proxyUrlBuffer = new StringBuffer();
            int dataSourceId = this.mMdlDataSourceId++;
            StringBuffer wholeQuery = new StringBuffer();
            TTVideoEngineLog.i(TAG, "proxy url, mInvalidMdlProcotol: " + this.mInvalidMdlProcotol);
            boolean enableMdlProtocol = this.mEnableMdlProtocol;
            if (this.mForbidNativeMDLForOriUrl && !TTHelper.isTranscodeUrlList(urls)) {
                enableMdlProtocol = false;
                TTVideoEngineLog.i(TAG, "url not transcode, not use native mdl");
            }
            if (_isM3u) {
                this.mDataLoaderHelperAdapter.convertHLSProxyUrl(proxyUrlBuffer);
            }
            if (forceLs || this.mInvalidMdlProcotol || !enableMdlProtocol) {
                proxyUrlBuffer.append("http://");
                proxyUrlBuffer.append(localHost);
                proxyUrlBuffer.append("/");
                proxyUrlBuffer.append(dataSourceId);
            } else {
                proxyUrlBuffer.append(MDL_PREFIX);
                proxyUrlBuffer.append("id");
                proxyUrlBuffer.append(dataSourceId);
                proxyUrlBuffer.append("/");
            }
            proxyUrlBuffer.append(query);
            wholeQuery.append(query);
            String auth = this.mInnerDataLoader.getAuth(query);
            if (!TextUtils.isEmpty((CharSequence)auth)) {
                proxyUrlBuffer.append("&ah=");
                proxyUrlBuffer.append(auth);
                wholeQuery.append("&ah=");
                wholeQuery.append(auth);
            }
            resultString = proxyUrlBuffer.toString();
            TTVideoEngineLog.i(TAG, "_proxyUrl: " + resultString);
        }
        finally {
            this.mLock.unlock();
        }
        DataLoaderTaskItem item = this.mAllPlayTasks.popItemForVideoId(rawKey);
        if (item == null) {
            item = new DataLoaderTaskItem();
        }
        if ((trackItem = item.addTrackItemByKey(key)) != null) {
            trackItem.mTaskKey = key;
            item.mVideoId = rawKey;
            trackItem.mProxyUrl = resultString;
            trackItem.mUsingResolution = resolution;
            trackItem.mDecryptionKey = decryptionKey;
            trackItem.mVideoInfo = info;
            trackItem.mUrls = urls;
            trackItem.mLocalFilePath = filePath;
            trackItem.mExternalInfo = extraInfo;
            this.mAllPlayTasks.enqueueItem(item);
        }
        return resultString;
    }

    private String proxyQueryProvideMode(String key, String rawKey, int priority, int isProvider) {
        if (TextUtils.isEmpty((CharSequence)key) || isProvider == 0) {
            return null;
        }
        String k = TTHelper.encodeUrl(key);
        if (TextUtils.isEmpty((CharSequence)k)) {
            return null;
        }
        String rk = TTHelper.encodeUrl(TextUtils.isEmpty((CharSequence)rawKey) ? key : rawKey);
        if (TextUtils.isEmpty((CharSequence)rk)) {
            rk = key;
        }
        StringBuffer proxyUrlBuffer = new StringBuffer();
        proxyUrlBuffer.append("?rk=");
        proxyUrlBuffer.append(rk);
        proxyUrlBuffer.append("&k=");
        proxyUrlBuffer.append(k);
        proxyUrlBuffer.append("&pv=");
        proxyUrlBuffer.append(1);
        if (priority > 0) {
            proxyUrlBuffer.append("&l=");
            proxyUrlBuffer.append(priority);
        }
        return proxyUrlBuffer.toString();
    }

    private String preloadProxyQuery(String key, String rawKey, long offset, long limitSize, String[] originalUrls, String filePath, String extraInfo, int priority, String header, boolean isM3u, String drmToken) {
        return this.preloadProxyQuery(key, rawKey, offset, limitSize, originalUrls, filePath, extraInfo, priority, header, isM3u, drmToken, 0, 0L);
    }

    private String preloadProxyQuery(String key, String rawKey, long offset, long limitSize, String[] originalUrls, String filePath, String extraInfo, int priority, String header, boolean isM3u, String drmToken, int encryptVersion, long urlExpireTime) {
        String encodeDrmToken;
        boolean _isM3u;
        String encodeHeader;
        String encodeFilePath;
        if (TextUtils.isEmpty((CharSequence)key) || originalUrls == null || originalUrls.length < 1) {
            return null;
        }
        String[] urls = (String[])originalUrls.clone();
        limitSize = limitSize > 0L ? limitSize : 0L;
        for (int i = 0; i < urls.length; ++i) {
            if (this._supportProxy(urls[i])) continue;
            return null;
        }
        urls = this._removeRepeatUrls(urls);
        String k = TTHelper.encodeUrl(key);
        if (TextUtils.isEmpty((CharSequence)k)) {
            return null;
        }
        TTVideoEngineLog.i(TAG, "preloadProxyQuery: key = " + key + ", rawKey = " + rawKey);
        String rk = TTHelper.encodeUrl(TextUtils.isEmpty((CharSequence)rawKey) ? key : rawKey);
        if (TextUtils.isEmpty((CharSequence)rk)) {
            rk = "videoId";
        }
        StringBuffer proxyUrlBuffer = new StringBuffer();
        proxyUrlBuffer.append("?rk=");
        proxyUrlBuffer.append(rk);
        proxyUrlBuffer.append("&k=");
        proxyUrlBuffer.append(k);
        if (limitSize > 0L) {
            proxyUrlBuffer.append("&s=");
            proxyUrlBuffer.append(offset + limitSize);
        }
        if (priority > 0) {
            proxyUrlBuffer.append("&l=");
            proxyUrlBuffer.append(priority);
        }
        if (!TextUtils.isEmpty((CharSequence)filePath) && !TextUtils.isEmpty((CharSequence)(encodeFilePath = TTHelper.encodeUrl(filePath)))) {
            proxyUrlBuffer.append("&p=");
            proxyUrlBuffer.append(encodeFilePath);
        }
        if (!TextUtils.isEmpty((CharSequence)header) && !TextUtils.isEmpty((CharSequence)(encodeHeader = TTHelper.encodeUrl(header)))) {
            proxyUrlBuffer.append("&h=");
            proxyUrlBuffer.append(encodeHeader);
        }
        boolean bl = _isM3u = isM3u || FormatProvider.FormatProviderHolder.isM3u8(urls[0]);
        if (_isM3u) {
            proxyUrlBuffer.append("&ft=1");
        }
        if (encryptVersion > 0) {
            proxyUrlBuffer.append("&ev=" + encryptVersion);
        }
        if (urlExpireTime > 0L) {
            proxyUrlBuffer.append("&ue=" + urlExpireTime);
        }
        if (!TextUtils.isEmpty((CharSequence)drmToken) && !TextUtils.isEmpty((CharSequence)(encodeDrmToken = TTHelper.encodeUrl(drmToken)))) {
            proxyUrlBuffer.append("&dtk=");
            proxyUrlBuffer.append(encodeDrmToken);
        }
        StringBuffer urlsBuffer = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            String tem = null;
            if (this.mConfigure.mEnableUseOriginalUrl == 1) {
                try {
                    tem = URLEncoder.encode(urls[i], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    TTVideoEngineLog.d("TTHelperEncode", "encode failed:" + urls[i]);
                }
            } else {
                tem = DataLoaderHelper.encodeUrlByQuery(urls[i]);
            }
            StringBuffer temString = new StringBuffer();
            if (!TextUtils.isEmpty((CharSequence)tem)) {
                temString.append("&u");
                temString.append(i);
                temString.append("=");
                temString.append(tem);
            }
            if (proxyUrlBuffer.length() + urlsBuffer.length() + temString.length() + 32 > 3096) break;
            urlsBuffer.append(temString);
        }
        if (urlsBuffer.length() < 1) {
            return null;
        }
        proxyUrlBuffer.append(urlsBuffer);
        if (!TextUtils.isEmpty((CharSequence)extraInfo)) {
            String tem = extraInfo;
            if (proxyUrlBuffer.length() + tem.length() + 33 <= 3096) {
                proxyUrlBuffer.append("&");
                proxyUrlBuffer.append(tem);
            }
        }
        return proxyUrlBuffer.toString();
    }

    public static final String encodeUrlByQuery(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        String encodeURL = null;
        TTVideoEngineLog.d("TTHelperEncode", "before encode:" + url);
        try {
            encodeURL = AVMDLDataLoader.queryComponentEncode((String)url);
            if (TextUtils.isEmpty((CharSequence)encodeURL)) {
                TTVideoEngineLog.d("TTHelperEncode", "call native encode fail,try java");
                encodeURL = URLEncoder.encode(url, "UTF-8");
            }
            TTVideoEngineLog.d("TTHelperEncode", "after encode:" + encodeURL);
        }
        catch (UnsupportedEncodingException e) {
            encodeURL = null;
        }
        return encodeURL;
    }

    private String proxyQuery(String key, String rawKey, long offset, long limitSize, String[] urls, String filePath, String extraInfo, boolean isM3u8, String drmToken) {
        return this.preloadProxyQuery(key, rawKey, offset, limitSize, urls, filePath, extraInfo, 0, null, isM3u8, drmToken, 0, 0L);
    }

    private String proxyQuery(String key, String rawKey, long offset, long limitSize, String[] urls, String filePath, String extraInfo, boolean isM3u8, String drmToken, int encryptVersion, long urlExpireTime) {
        return this.preloadProxyQuery(key, rawKey, offset, limitSize, urls, filePath, extraInfo, 0, null, isM3u8, drmToken, encryptVersion, urlExpireTime);
    }

    public long getPreloadTaskCount() {
        return this.mExecuteTasks.count() + this.mAllPreloadTasks.count() + this.mPreloadTasks.count();
    }

    public String downloadUrl(String key, @Nullable String rawKey, String[] urls) {
        if (TextUtils.isEmpty((CharSequence)key) || urls == null || urls.length < 1) {
            return null;
        }
        return this.proxyQuery(key, rawKey, 0L, 0L, urls, null, null, false, null);
    }

    public String downloadUrl(String key, @Nullable String rawKey, String[] urls, int encryptVersion) {
        if (TextUtils.isEmpty((CharSequence)key) || urls == null || urls.length < 1) {
            return null;
        }
        return this.proxyQuery(key, rawKey, 0L, 0L, urls, null, null, false, null, encryptVersion, 0L);
    }

    public String downloadUrl(String key, @Nullable String rawKey, String[] urls, int encryptVersion, String customDir) {
        if (TextUtils.isEmpty((CharSequence)key) || urls == null || urls.length < 1) {
            return null;
        }
        return this.proxyQuery(key, rawKey, 0L, 0L, urls, customDir, null, false, null, encryptVersion, 0L);
    }

    public boolean startDownload(String resource) {
        return this.startDownload(resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startDownload(String resource, boolean isM3u8) {
        if (!FeatureManager.hasPermission()) {
            return false;
        }
        if (this.mState != 0) {
            return false;
        }
        boolean result = false;
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null || TextUtils.isEmpty((CharSequence)resource)) {
                result = false;
            }
            boolean downloaded = false;
            if (isM3u8) {
                downloaded = this.mDataLoaderHelperAdapter.downloadHlsSource(resource);
            }
            if (!downloaded) {
                this.mInnerDataLoader.downloadResource(resource);
            }
            TTVideoEngineLog.i(TAG, "[downloader] start download resource = " + resource);
            result = true;
            return result;
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
            result = false;
            return result;
        }
        finally {
            this.mLock.unlock();
            return result;
        }
    }

    public void suspendedDownload(String key) {
        if (this.mState != 0) {
            return;
        }
        this.mLock.lock();
        try {
            boolean canceled = this.mDataLoaderHelperAdapter.cancelDownload(key);
            if (canceled) {
                return;
            }
            if (this.mInnerDataLoader == null) {
                return;
            }
            this.mInnerDataLoader.suspendDownload(key);
            TTVideoEngineLog.i(TAG, "[downloader] suspended download, key = " + key);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    public void copyCache(final CopyCacheItem parameters) {
        if (parameters == null) {
            return;
        }
        AVMDLCopyOperation copyOperation = new AVMDLCopyOperation(parameters.mFileKey, parameters.mDestPath, parameters.mForceCopyUnfinished, parameters.mWaitIfCaching, new AVMDLCopyOperationListener(){

            public void onCopyComplete(boolean isSuccess, int errorCode, String desc) {
                if (parameters.mListener != null) {
                    parameters.mListener.onCopyComplete(isSuccess, errorCode, desc);
                }
            }

            public void onFileInfo(AVMDLFileInfo info) {
                if (parameters.mListener != null) {
                    DataLoaderCacheInfo cacheInfo = new DataLoaderCacheInfo();
                    cacheInfo.mMediaSize = info.mContentLenght;
                    cacheInfo.mCacheSizeFromZero = info.mCacheSize;
                    parameters.mListener.onFileInfo(cacheInfo);
                }
            }
        });
        copyOperation.mCustomDir = parameters.mCustomDir;
        this.asyncCopyOperation(copyOperation);
    }

    private void asyncCopyOperation(AVMDLCopyOperation operation) {
        if (this.mState != 0) {
            return;
        }
        this.mLock.lock();
        try {
            if (this.mInnerDataLoader == null) {
                return;
            }
            this.mInnerDataLoader.asyncCopyOperation(operation);
        }
        catch (Throwable e) {
            TTVideoEngineLog.d(e);
        }
        finally {
            this.mLock.unlock();
        }
    }

    private boolean _supportProxy(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        String lowerCaseUrl = url.toLowerCase();
        if (lowerCaseUrl.startsWith(MDL_PREFIX)) {
            return false;
        }
        String proxyIpWithPort = null;
        if (this.mInnerDataLoader != null) {
            proxyIpWithPort = this.mInnerDataLoader.getLocalAddr();
        }
        if (!TextUtils.isEmpty(proxyIpWithPort) ? lowerCaseUrl.startsWith("http://" + proxyIpWithPort) : lowerCaseUrl.startsWith("http://127.0.0.1") || lowerCaseUrl.startsWith("http://localhost")) {
            return false;
        }
        if (lowerCaseUrl.startsWith("file://") || lowerCaseUrl.startsWith("/")) {
            return false;
        }
        if (FormatProvider.FormatProviderHolder.isMpd(url)) {
            return false;
        }
        return this.mEnableHls == 1 && this.mSupporHls || !FormatProvider.FormatProviderHolder.isM3u8(url);
    }

    private String[] _removeRepeatUrls(String[] urls) {
        if (urls == null || urls.length <= 1) {
            return urls;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(urls[0]);
        for (int i = 1; i < urls.length; ++i) {
            String objString = urls[i];
            Boolean shouldAdd = true;
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                String compareString = (String)arrayList.get(j);
                if (!compareString.equals(objString)) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd.booleanValue()) continue;
            arrayList.add(objString);
        }
        int size = arrayList.size();
        String[] resultUrls = new String[size];
        arrayList.toArray(resultUrls);
        return resultUrls;
    }

    private void _addTask(String key, String videoId, long preloadSize, PreloaderVidItem vidItem, PreloaderVideoModelItem videoModelItem, PreloaderURLItem urlItem) {
        boolean ret;
        if (!FeatureManager.hasPermission("preload")) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)key)) {
            TTVideoEngineLog.e(TAG, "[preload] key invalid.");
            return;
        }
        if (this.mInnerDataLoader == null || this.mState != 0) {
            TTVideoEngineLog.e(TAG, "[preload] need load mdl first.");
            return;
        }
        if (this.mExecuteTasks.containItem(key) || this.mPreloadTasks.containItem(key)) {
            TTVideoEngineLog.d(TAG, "[preload] add the same key task.");
            return;
        }
        if (TTVideoEngineLog.d()) {
            TTVideoEngineLog.d(TAG, "[preload] _addTask key=" + key + ", videoId=" + videoId + ", preloadSize=" + preloadSize + ", vidItem=" + vidItem + ", videoModelItem=" + videoModelItem + ", urlItem=" + urlItem);
        }
        Resolution temResolution = Resolution.Undefine;
        if (vidItem != null && vidItem.mResolution != null) {
            temResolution = vidItem.mResolution;
        } else if (videoModelItem != null && videoModelItem.mResolution != null) {
            temResolution = videoModelItem.mResolution;
        }
        String tag = null;
        String subtag = null;
        if (urlItem != null) {
            String string = tag = TextUtils.isEmpty((CharSequence)urlItem.getTag()) ? "unknown" : urlItem.getTag();
            if (!TextUtils.isEmpty((CharSequence)urlItem.getSubTag())) {
                subtag = urlItem.getSubTag();
            }
        } else if (videoModelItem != null) {
            String string = tag = TextUtils.isEmpty((CharSequence)videoModelItem.getTag()) ? "unknown" : videoModelItem.getTag();
            if (!TextUtils.isEmpty((CharSequence)videoModelItem.getSubTag())) {
                subtag = videoModelItem.getSubTag();
            }
        } else if (vidItem != null) {
            String string = tag = TextUtils.isEmpty((CharSequence)vidItem.getTag()) ? "unknown" : vidItem.getTag();
            if (!TextUtils.isEmpty((CharSequence)vidItem.getSubTag())) {
                subtag = vidItem.getSubTag();
            }
        }
        DataLoaderTaskItem task = new DataLoaderTaskItem();
        task.setUp(key, temResolution, preloadSize);
        task.mVideoId = videoId;
        task.mVidItem = vidItem;
        task.mVideoModelItem = videoModelItem;
        task.mURLItem = urlItem;
        task.mTag = tag;
        task.mSubTag = subtag;
        if (urlItem != null) {
            task.mPriorityLevel = urlItem.getPriorityLevel();
            if (urlItem.mAdapter != null && urlItem.mAdapter.isFetchSmartUrl()) {
                task.setListener(new MyTaskListener(this));
            }
        }
        if (videoModelItem != null) {
            task.mResponseData = videoModelItem.mVideoModel;
            task.mPriorityLevel = videoModelItem.getPriorityLevel();
            task.mPreloadSecond = videoModelItem.mPreloadMilliSecond / 1000.0f;
            task.mTimePreloadLowerLimitSize = videoModelItem.mTimePreloadLowerLimitSize;
            task.mTimePreloadUpperLimitSize = videoModelItem.mTimePreloadUpperLimitSize;
        }
        if (task.mVidItem != null) {
            task.setListener(new MyTaskListener(this));
            task.mPriorityLevel = task.mVidItem.getPriorityLevel();
        }
        if (ret = this.mPreloadTasks.enqueueItem(task)) {
            this._startExecuteTask();
        } else {
            task._notifyError(-1002);
        }
    }

    private void _startExecuteTask() {
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "[preload] need load mdl first.");
            return;
        }
        DataLoaderTaskItem taskItem = this.mPreloadTasks.backItem();
        if (taskItem == null) {
            return;
        }
        boolean addToExectResult = this.mExecuteTasks.enqueueItem(taskItem);
        if (!addToExectResult) {
            return;
        }
        this.mPreloadTasks.popBackItem();
        if (taskItem.mURLItem != null && taskItem.mURLItem.mAdapter != null && taskItem.mURLItem.mAdapter.isFetchSmartUrl()) {
            this._startFetchSmartUrlInfo(taskItem);
            return;
        }
        if (taskItem.mResponseData != null || taskItem.mURLItem != null) {
            this._exectTask(taskItem);
            return;
        }
        this._startFetchVideoInfo(taskItem);
    }

    private void _startFetchSmartUrlInfo(DataLoaderTaskItem taskItem) {
        if (taskItem.mURLItem == null) {
            return;
        }
        if (taskItem.mURLItem.mAdapter == null) {
            return;
        }
        taskItem.mURLItem.mAdapter.fetchSmartUrlInfo(new DataLoaderTaskItem.MySmartUrlFetcherListener(taskItem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _startFetchVideoInfo(DataLoaderTaskItem taskItem) {
        taskItem.removeVidPlaceholderTrack();
        String apiString = null;
        String authString = null;
        apiString = this._apiStringForVid(taskItem.mVidItem);
        if (TextUtils.isEmpty((CharSequence)apiString)) {
            TTVideoEngineLog.d(TAG, "apiString is null");
            return;
        }
        taskItem.mApiString = TTVideoEngineUtils.BuildHttpsApi(apiString);
        authString = taskItem.mVidItem.getAuthorization();
        apiString = TTVideoEngineUtils.BuildHttpsApi(apiString);
        VideoModelCache.VideoModelCacheInfo temCache = null;
        Class<PreloaderVidItem> clazz = PreloaderVidItem.class;
        synchronized (PreloaderVidItem.class) {
            temCache = this.mModelCache.get(taskItem.mVideoId, apiString);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (temCache != null && !temCache.isExpired) {
                taskItem.mResponseData = temCache.model;
                TTVideoEngineLog.i(TAG, String.format("[preload] get videoModel , videoId = %s", taskItem.mVideoId));
                if (this.mEnableVideoModelHitCacheCallback == 1) {
                    if (taskItem.mResponseData != null && taskItem.getCallBackListener() != null) {
                        PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(4);
                        callBackInfo.fetchVideoModel = (VideoModel)taskItem.mResponseData;
                        taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
                        if (taskItem.mVidItem != null) {
                            taskItem.mSetResolution = taskItem.mVidItem.mResolution;
                        }
                    }
                    if (taskItem != null && taskItem.mVidItem != null && taskItem.mVidItem.getFetchEndListener() != null) {
                        taskItem.mVidItem.getFetchEndListener().fetchEnd((VideoModel)taskItem.mResponseData, taskItem.mResponseError);
                        taskItem.mSetResolution = taskItem.mVidItem.mResolution;
                    }
                }
                this._exectTask(taskItem);
            } else if (taskItem.mVidItem != null) {
                VideoInfoFetcher fetcher;
                taskItem.mFetcher = fetcher = new VideoInfoFetcher(this.mContext, taskItem.mVidItem.getNetClient());
                taskItem.setFetchListener();
                taskItem.mFetcher.setResolutionMap(taskItem.mVidItem.mResolutionMap);
                taskItem.mFetcher.setVideoID(taskItem.mVidItem.mVideoId);
                taskItem.mFetcher.setUseVideoModelCache(true);
                taskItem.mFetcher.fetchInfo(apiString, taskItem.mVidItem.mApiVersion == 2 || taskItem.mVidItem.mApiVersion == 4 ? null : authString, taskItem.mVidItem.mApiVersion);
            }
            return;
        }
    }

    private void _exectTask(DataLoaderTaskItem taskItem) {
        DataLoaderTaskItem.TrackItem trackItem;
        if (taskItem == null) {
            this._startExecuteTask();
            return;
        }
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "[preload] need load mdl first.");
            return;
        }
        Map<Integer, String> params = null;
        if (taskItem.mVidItem != null && taskItem.mVidItem.mParams != null) {
            params = taskItem.mVidItem.mParams;
        }
        if (taskItem.mVideoModelItem != null && taskItem.mVideoModelItem.mParams != null) {
            params = taskItem.mVideoModelItem.mParams;
        }
        this.mExecuteTasks.popItem(taskItem);
        int temPreloadType = 0;
        long temPreAudioSize = 0L;
        long temPreVideoSize = taskItem.mPreloadSize;
        if (taskItem.mResponseData != null) {
            VideoInfo temVideoInfo;
            ArrayList<VideoInfo> infoList = new ArrayList<VideoInfo>();
            if (taskItem.mResponseData.hasFormat(IVideoModel.Format.DASH)) {
                if (taskItem.mResponseData.getDynamicType().equals("segment_base")) {
                    DataLoaderTaskItem.TrackItem trackItem2;
                    String taskKey;
                    temVideoInfo = taskItem.mResponseData.getVideoInfo(taskItem.mSetResolution, VideoRef.TYPE_VIDEO, params, true);
                    VideoInfo temAudioInfo = taskItem.mResponseData.getVideoInfo(taskItem.mSetResolution, VideoRef.TYPE_AUDIO, params, true);
                    long videoPreloadSize = taskItem.mPreloadSize;
                    long audioPreloadSize = taskItem.mPreloadSize;
                    long audioPreloadOffset = 0L;
                    long audioPreloadHeaderSize = 0L;
                    long videoPreloadOffset = 0L;
                    long videoPreloadHeaderSize = 0L;
                    if (temVideoInfo != null && temAudioInfo != null) {
                        MediaBitrateFitterInfo audioBitrateFitterInfo = temAudioInfo.getBitrateFitterInfo();
                        MediaBitrateFitterInfo videoBitrateFitterInfo = temVideoInfo.getBitrateFitterInfo();
                        long preloadMilliSecondOffset = 0L;
                        long audioHeaderExtraSize = 0L;
                        long audioPacketExtraOffset = 0L;
                        long videoHeaderExtraSize = 0L;
                        long videoPacketExtraOffset = 0L;
                        if (taskItem.mVideoModelItem != null) {
                            preloadMilliSecondOffset = taskItem.mVideoModelItem.mPreloadMilliSecondOffset;
                            audioHeaderExtraSize = taskItem.mVideoModelItem.mAudioHeaderExtraSize;
                            audioPacketExtraOffset = taskItem.mVideoModelItem.mAudioPacketExtraOffset;
                            videoHeaderExtraSize = taskItem.mVideoModelItem.mVideoHeaderExtraSize;
                            videoPacketExtraOffset = taskItem.mVideoModelItem.mVideoPacketExtraOffset;
                        }
                        if (temAudioInfo.mPacketOffset != null && temAudioInfo.mPacketOffset.get((double)preloadMilliSecondOffset / 1000.0) != null && temVideoInfo.mPacketOffset != null && temVideoInfo.mPacketOffset.get((double)preloadMilliSecondOffset / 1000.0) != null) {
                            Long audioPreloadPacketOffset = temAudioInfo.mPacketOffset.get((double)preloadMilliSecondOffset / 1000.0);
                            Long videoPreloadPacketOffset = temVideoInfo.mPacketOffset.get((double)preloadMilliSecondOffset / 1000.0);
                            if (audioPreloadPacketOffset != null) {
                                audioPreloadOffset = audioPreloadPacketOffset;
                            }
                            if (videoPreloadPacketOffset != null) {
                                videoPreloadOffset = videoPreloadPacketOffset;
                            }
                            TTVideoEngineLog.i(TAG, "[preload] preload millisecondOffset " + preloadMilliSecondOffset);
                            TTVideoEngineLog.i(TAG, "[preload] preload audioOffset " + audioPreloadOffset);
                            TTVideoEngineLog.i(TAG, "[preload] preload videoOffset " + videoPreloadOffset);
                        }
                        if (preloadMilliSecondOffset > 0L && audioBitrateFitterInfo != null) {
                            if (audioPreloadOffset == 0L) {
                                audioPreloadOffset = audioBitrateFitterInfo.calculateSizeBySecond((float)preloadMilliSecondOffset / 1000.0f);
                            }
                            if (audioHeaderExtraSize == 0L) {
                                audioHeaderExtraSize = 102400L;
                            }
                            audioPreloadHeaderSize = (long)audioBitrateFitterInfo.getHeaderSize() + audioHeaderExtraSize;
                            if (audioPreloadOffset > 0L && (audioPreloadOffset -= audioPacketExtraOffset) < 0L) {
                                audioPreloadOffset = 0L;
                            }
                            TTVideoEngineLog.i(TAG, "[preload] preload audio header size " + audioPreloadHeaderSize);
                        }
                        if (preloadMilliSecondOffset > 0L && videoBitrateFitterInfo != null) {
                            if (videoPreloadOffset == 0L) {
                                videoPreloadOffset = videoBitrateFitterInfo.calculateSizeBySecond((float)preloadMilliSecondOffset / 1000.0f);
                            }
                            videoPreloadHeaderSize = (long)videoBitrateFitterInfo.getHeaderSize() > taskItem.mPreloadSize ? (long)videoBitrateFitterInfo.getHeaderSize() : taskItem.mPreloadSize;
                            videoPreloadHeaderSize += videoHeaderExtraSize;
                            if (videoPreloadOffset > 0L && (videoPreloadOffset -= videoPacketExtraOffset) < 0L) {
                                videoPreloadOffset = 0L;
                            }
                            TTVideoEngineLog.i(TAG, "[preload] preload video header size " + videoPreloadHeaderSize);
                        }
                        if (taskItem.mPreloadSecond > 0.0f && audioBitrateFitterInfo != null && videoBitrateFitterInfo != null) {
                            videoPreloadSize = videoBitrateFitterInfo.calculateSizeBySecond(taskItem.mPreloadSecond);
                            audioPreloadSize = audioBitrateFitterInfo.calculateSizeBySecond(taskItem.mPreloadSecond);
                            temPreloadType = 1;
                            TTVideoEngineLog.i(TAG, "[preload] preload second" + taskItem.mPreloadSecond + " preload size audio = " + audioPreloadSize + " ,video = " + videoPreloadSize);
                            TTVideoEngineLog.i(TAG, "[preload] preload audioOffset " + audioPreloadOffset);
                            TTVideoEngineLog.i(TAG, "[preload] preload videoOffset " + videoPreloadOffset);
                            if (taskItem.mTimePreloadLowerLimitSize > 0L && videoPreloadSize + audioPreloadSize < taskItem.mTimePreloadLowerLimitSize) {
                                audioPreloadSize = 0L;
                                videoPreloadSize = 0L;
                                taskItem.mPreloadSize = taskItem.mTimePreloadLowerLimitSize;
                                TTVideoEngineLog.i(TAG, "[preload] preload size limit to" + taskItem.mTimePreloadLowerLimitSize);
                            }
                            if (taskItem.mTimePreloadUpperLimitSize > 0L && videoPreloadSize + audioPreloadSize > taskItem.mTimePreloadUpperLimitSize) {
                                audioPreloadSize = 0L;
                                videoPreloadSize = 0L;
                                taskItem.mPreloadSize = taskItem.mTimePreloadUpperLimitSize;
                                TTVideoEngineLog.i(TAG, "[preload] preload size limit to" + taskItem.mTimePreloadUpperLimitSize);
                            }
                        }
                        if (preloadMilliSecondOffset > 0L) {
                            videoPreloadSize = taskItem.mPreloadSize;
                            if (this.mDashAudioPreloadRatio > 0) {
                                audioPreloadSize = taskItem.mPreloadSize * (long)this.mDashAudioPreloadRatio / 100L;
                                if (this.mDashAudioPreloadMinSize > 0 && audioPreloadSize < (long)this.mDashAudioPreloadMinSize) {
                                    audioPreloadSize = this.mDashAudioPreloadMinSize;
                                }
                            } else {
                                audioPreloadSize = taskItem.mPreloadSize;
                            }
                        } else if (videoPreloadSize <= 0L || audioPreloadSize <= 0L || videoPreloadSize == taskItem.mPreloadSize && audioPreloadSize == taskItem.mPreloadSize) {
                            TTVideoEngineLog.i(TAG, "[preload] preload size  audio = " + audioPreloadSize + " ,video = " + videoPreloadSize);
                            int videoBitrate = temVideoInfo.getValueInt(3);
                            int audioBitrate = temAudioInfo.getValueInt(3);
                            if (videoBitrate > 0 && audioBitrate > 0) {
                                videoPreloadSize = (long)((float)taskItem.mPreloadSize * ((float)videoBitrate / (float)(videoBitrate + audioBitrate)));
                                audioPreloadSize = (long)((float)taskItem.mPreloadSize * ((float)audioBitrate / (float)(videoBitrate + audioBitrate)));
                            }
                            temPreloadType = 0;
                        }
                    }
                    temPreAudioSize = audioPreloadSize;
                    temPreVideoSize = videoPreloadSize;
                    TTVideoEngineLog.i(TAG, "[preload] preload size  audio = " + temPreAudioSize + " ,video = " + temPreVideoSize);
                    if (this.mAudioPreloadFirst && temAudioInfo != null && !TextUtils.isEmpty((CharSequence)(taskKey = temAudioInfo.getValueStr(15)))) {
                        infoList.add(temAudioInfo);
                        trackItem2 = taskItem.addTrackItemByKey(taskKey);
                        trackItem2.mPreSize = audioPreloadSize;
                        trackItem2.mPreloadHeaderSize = audioPreloadHeaderSize;
                        trackItem2.mPreloadOffset = audioPreloadOffset;
                        this._prepareUrlInfo(temAudioInfo, taskItem);
                        this._startMDLPreloadTask(taskItem, trackItem2);
                    }
                    if (temVideoInfo != null && !TextUtils.isEmpty((CharSequence)(taskKey = temVideoInfo.getValueStr(15)))) {
                        infoList.add(temVideoInfo);
                        trackItem2 = taskItem.addTrackItemByKey(taskKey);
                        trackItem2.mPreSize = videoPreloadSize;
                        trackItem2.mPreloadHeaderSize = videoPreloadHeaderSize;
                        trackItem2.mPreloadOffset = videoPreloadOffset;
                        this._prepareUrlInfo(temVideoInfo, taskItem);
                        this._startMDLPreloadTask(taskItem, trackItem2);
                    }
                    if (!this.mAudioPreloadFirst && temAudioInfo != null && !TextUtils.isEmpty((CharSequence)(taskKey = temAudioInfo.getValueStr(15)))) {
                        infoList.add(temAudioInfo);
                        trackItem2 = taskItem.addTrackItemByKey(taskKey);
                        trackItem2.mPreSize = audioPreloadSize;
                        trackItem2.mPreloadHeaderSize = audioPreloadHeaderSize;
                        trackItem2.mPreloadOffset = audioPreloadOffset;
                        this._prepareUrlInfo(temAudioInfo, taskItem);
                        this._startMDLPreloadTask(taskItem, trackItem2);
                    }
                }
            } else {
                String taskKey;
                temVideoInfo = taskItem.mResponseData.getVideoInfo(taskItem.mSetResolution, params, true);
                if (temVideoInfo != null && !TextUtils.isEmpty((CharSequence)(taskKey = temVideoInfo.getValueStr(15)))) {
                    infoList.add(temVideoInfo);
                    DataLoaderTaskItem.TrackItem trackItem3 = taskItem.addTrackItemByKey(taskKey);
                    MediaBitrateFitterInfo videoBitrateFitterInfo = temVideoInfo.getBitrateFitterInfo();
                    long preloadMilliSecondOffset = 0L;
                    long videoHeaderExtraSize = 0L;
                    long videoPacketExtraOffset = 0L;
                    if (taskItem.mVideoModelItem != null) {
                        preloadMilliSecondOffset = taskItem.mVideoModelItem.mPreloadMilliSecondOffset;
                        videoHeaderExtraSize = taskItem.mVideoModelItem.mVideoHeaderExtraSize;
                        videoPacketExtraOffset = taskItem.mVideoModelItem.mVideoPacketExtraOffset;
                    }
                    long preloadOffset = 0L;
                    long preloadHeaderSize = 0L;
                    if (preloadMilliSecondOffset > 0L && videoBitrateFitterInfo != null) {
                        preloadOffset = videoBitrateFitterInfo.calculateSizeBySecond((float)preloadMilliSecondOffset / 1000.0f);
                        if (videoHeaderExtraSize == 0L) {
                            videoHeaderExtraSize = 102400L;
                        }
                        preloadHeaderSize = (long)videoBitrateFitterInfo.getHeaderSize() + videoHeaderExtraSize;
                    }
                    if (preloadMilliSecondOffset > 0L) {
                        if (temVideoInfo.mPacketOffset != null) {
                            Long preloadPacketOffset = temVideoInfo.mPacketOffset.get((double)preloadMilliSecondOffset / 1000.0);
                            if (preloadPacketOffset != null) {
                                preloadOffset = preloadPacketOffset;
                                if (videoPacketExtraOffset > 0L && (preloadOffset -= videoPacketExtraOffset) < 0L) {
                                    preloadOffset = 0L;
                                }
                            }
                            TTVideoEngineLog.i(TAG, "[preload] preload millisecondOffset " + preloadMilliSecondOffset);
                            TTVideoEngineLog.i(TAG, "[preload] preload videoOffset " + preloadOffset);
                        } else {
                            TTVideoEngineLog.i(TAG, "[preload] packet offset info not avaiable preload" + preloadMilliSecondOffset);
                        }
                    }
                    long videoPreloadSize = taskItem.mPreloadSize;
                    temPreloadType = 0;
                    if (taskItem.mPreloadSecond > 0.0f && videoBitrateFitterInfo != null) {
                        int preloadSize = videoBitrateFitterInfo.calculateSizeBySecond(taskItem.mPreloadSecond);
                        if (preloadSize > 0) {
                            videoPreloadSize = preloadSize;
                            temPreloadType = 1;
                        }
                        if (taskItem.mTimePreloadLowerLimitSize > 0L && videoPreloadSize < taskItem.mTimePreloadLowerLimitSize) {
                            videoPreloadSize = taskItem.mTimePreloadLowerLimitSize;
                            temPreloadType = 0;
                        }
                        if (taskItem.mTimePreloadUpperLimitSize > 0L && videoPreloadSize > taskItem.mTimePreloadUpperLimitSize) {
                            videoPreloadSize = taskItem.mTimePreloadUpperLimitSize;
                            temPreloadType = 0;
                        }
                        TTVideoEngineLog.i(TAG, "[preload] preload second" + taskItem.mPreloadSecond + " ,video size = " + videoPreloadSize);
                    }
                    if (temVideoInfo.getMediatype() == VideoRef.TYPE_VIDEO) {
                        temPreVideoSize = videoPreloadSize;
                    } else {
                        temPreAudioSize = videoPreloadSize;
                    }
                    trackItem3.mPreSize = videoPreloadSize;
                    trackItem3.mPreloadOffset = preloadOffset;
                    trackItem3.mPreloadHeaderSize = preloadHeaderSize;
                    this._prepareUrlInfo(temVideoInfo, taskItem);
                    this._startMDLPreloadTask(taskItem, trackItem3);
                }
            }
            if (infoList.size() == 0) {
                TTVideoEngineLog.i(TAG, "invalid videoModel");
                this._startExecuteTask();
                return;
            }
            if (taskItem.mVidItem != null && taskItem.mVidItem.mListener != null) {
                taskItem.mVidItem.mListener.onUsingUrlInfos(infoList);
            }
            if (taskItem.getCallBackListener() != null) {
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(1);
                callBackInfo.usingUrlInfos = infoList;
                taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
            }
        } else if (taskItem.mURLItem != null && taskItem.mURLItem.getUrls() != null && taskItem.mURLItem.getUrls().length > 0) {
            trackItem = taskItem.mTracks.get(0);
            trackItem.mUrls = taskItem.mURLItem.getUrls();
            trackItem.mPreSize = taskItem.mPreloadSize;
            trackItem.mUsingResolution = taskItem.mSetResolution;
            trackItem.mLocalFilePath = taskItem.mURLItem.getFilePath();
            trackItem.mCustomHeader = this._headerString(taskItem.mURLItem.customHeaders());
            trackItem.mPreloadFooterSize = taskItem.mURLItem.getPreloadFooterSize();
            this._startMDLPreloadTask(taskItem, trackItem);
        } else if (taskItem.mURLItem != null && taskItem.mURLItem.getProvider() != null) {
            trackItem = taskItem.mTracks.get(0);
            trackItem.mProxyUrl = this.proxyQueryProvideMode(trackItem.mTaskKey, taskItem.mVideoId, taskItem.mPriorityLevel, 1);
            trackItem.mPreSize = taskItem.mPreloadSize;
            trackItem.mUsingResolution = taskItem.mSetResolution;
            trackItem.mUrls = taskItem.mURLItem.getUrls();
            trackItem.mLocalFilePath = taskItem.mURLItem.getFilePath();
            trackItem.mCustomHeader = this._headerString(taskItem.mURLItem.customHeaders());
            this._startMDLPreloadTask(taskItem, trackItem);
            TTVideoEngineLog.i(TAG, String.format("exect preload task by provider mode, key is %s; videoId = %s proxyurl:%s", trackItem.mTaskKey, taskItem.mVideoId, trackItem.mProxyUrl));
        }
        if (taskItem.getCallBackListener() != null) {
            PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(6);
            callBackInfo.preloadType = temPreloadType;
            callBackInfo.videoPreloadSize = temPreVideoSize;
            callBackInfo.audioPreloadSize = temPreAudioSize;
            taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
            TTVideoEngineLog.i(TAG, "[preload] notify info. type = " + temPreloadType);
        }
        this._startExecuteTask();
    }

    private void _prepareUrlInfo(VideoInfo info, DataLoaderTaskItem taskItem) {
        if (info == null || taskItem == null) {
            TTVideoEngineLog.e(TAG, "[preload] prepare url info fail. info or taskItem is null");
            return;
        }
        String taskKey = null;
        String[] originalUrls = info.getValueStrArr(16);
        taskKey = info.getValueStr(15);
        DataLoaderTaskItem.TrackItem trackItem = taskItem.addTrackItemByKey(taskKey);
        if (originalUrls == null || originalUrls.length < 1) {
            TTVideoEngineLog.e(TAG, "[preload] url info, urls info invalid");
            taskItem._notifyError(-100001);
            return;
        }
        String[] urls = (String[])originalUrls.clone();
        boolean forbidP2p = false;
        if (taskItem.mVidItem != null) {
            forbidP2p = taskItem.mVidItem.mForbidP2p;
        } else if (taskItem.mVideoModelItem != null) {
            forbidP2p = taskItem.mVideoModelItem.mForbidP2p;
        }
        urls = this._addP2pFlag(forbidP2p, urls);
        String filePath = null;
        if (taskItem.mVidItem != null && taskItem.mVidItem.getFilePathListener() != null && !TextUtils.isEmpty((CharSequence)taskKey)) {
            filePath = taskItem.mVidItem.getFilePathListener().cacheFilePath(taskItem.mVideoId, info);
            if (TextUtils.isEmpty((CharSequence)filePath) || !filePath.contains(taskKey)) {
                filePath = null;
            }
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                taskKey = TTHelper.keyFromFilePath(this.mContext, filePath);
            }
        } else if (taskItem.mVideoModelItem != null && taskItem.mVideoModelItem.getFilePathListener() != null && !TextUtils.isEmpty((CharSequence)taskKey)) {
            filePath = taskItem.mVideoModelItem.getFilePathListener().cacheFilePath(taskItem.mVideoId, info);
            if (TextUtils.isEmpty((CharSequence)filePath) || !filePath.contains(taskKey)) {
                filePath = null;
            }
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                taskKey = TTHelper.keyFromFilePath(this.mContext, filePath);
            }
        }
        if (trackItem == null) {
            trackItem = taskItem.addTrackItemByKey(taskKey);
        }
        if (trackItem == null) {
            taskItem._notifyError(-100001);
            return;
        }
        trackItem.mTaskKey = taskKey;
        trackItem.mVideoInfo = info;
        trackItem.mDecryptionKey = info.getValueStr(5);
        trackItem.mUsingResolution = info.getResolution();
        trackItem.mUrls = urls;
        trackItem.mLocalFilePath = filePath;
        trackItem.mExternalInfo = MDLExtraInfoHelper.createMDLExtraInfo(info, taskItem);
        TTVideoEngineLog.d(TAG, "[preload] prepare url info. videoId = " + taskItem.mVideoId + ", key is " + taskKey + ", resolution = " + trackItem.mUsingResolution.toString());
    }

    private String[] _addP2pFlag(boolean forbidP2p, String[] tmpUrls) {
        if (!forbidP2p) {
            return tmpUrls;
        }
        for (int i = 0; i < tmpUrls.length; ++i) {
            if (TextUtils.isEmpty((CharSequence)tmpUrls[i])) continue;
            tmpUrls[i] = TTHelper.appendQueryString(tmpUrls[i], "p2p=0");
        }
        return tmpUrls;
    }

    @Nullable
    String _headerString(HashMap<String, String> header) {
        if (header == null || header.size() < 1) {
            return null;
        }
        StringBuilder bulder = new StringBuilder();
        for (String key : header.keySet()) {
            bulder.append(key).append(":").append(" ").append(header.get(key)).append("\r\n");
        }
        return bulder.toString();
    }

    private void _tryToSetDefaultCacheDir() {
        if (this.mContext == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mConfigure.mCacheDir)) {
            return;
        }
        String temString = TTHelper.getAppFilesPath(this.mContext);
        File tem = new File(temString = temString + File.separator + "mdlcache");
        if (!tem.exists()) {
            tem.mkdir();
        }
        this.mConfigure.mCacheDir = temString;
    }

    private void reportSpeed(AVMDLDataLoaderNotifyInfo info) {
        if (this.mEnableReportSpeed == 0) {
            return;
        }
        long downloadBytes = info.code;
        long costTime = info.parameter;
        if (downloadBytes > 0L) {
            // empty if block
        }
    }

    @SuppressLint(value={"CI_DefaultLocale"})
    public void onNotify(AVMDLDataLoaderNotifyInfo info) {
        if (info == null) {
            return;
        }
        if (info.jsonLog != null) {
            try {
                if (!info.jsonLog.has("app_session_id")) {
                    info.jsonLog.put("app_session_id", (Object)VideoEventBase.appSessionId);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        switch (info.what) {
            case 700: {
                TTVideoEngineLog.d(TAG, "KeyIsSpeedTestSampledByTime  mNeedSpeedTestByTimeInternal:" + this.mNeedSpeedTestByTimeInternal + " code:" + info.code);
                if (!FeatureManager.hasPermission("net_speed")) {
                    return;
                }
                if (this.mTestSpeedListener != null) {
                    this.mTestSpeedListener.onNotify(2, info.code, info.parameter, info.logInfo, info.logType, info.logExtraJsonStr);
                }
                int notifyKey = -1;
                switch (this.mNeedSpeedTestByTimeInternal) {
                    case 1: {
                        notifyKey = 2;
                        break;
                    }
                    case 2: {
                        notifyKey = 32;
                    }
                }
                if (this.mListener == null || notifyKey == -1) break;
                TTVideoEngineLog.d(TAG, "KeyIsSpeedTestSampledByTimenotify by" + (notifyKey == 2 ? "general" : "timeinternal") + "speed info code:" + info.code + " parameter:" + info.parameter);
                this.mListener.onNotify(notifyKey, info.code, info.parameter, info.logInfo);
                break;
            }
            case 702: {
                if (!FeatureManager.hasPermission("net_speed")) {
                    return;
                }
                if (this.mTestSpeedListener == null || this.mTestSpeedListener == null) break;
                this.mTestSpeedListener.onNotify(2, info.logInfo);
                break;
            }
            case 2: {
                if (!FeatureManager.hasPermission("net_speed")) {
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.onNotify(2, info.code, info.parameter, info.logInfo);
                }
                this.reportSpeed(info);
                break;
            }
            case 703: {
                break;
            }
            case 0: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.onLogInfo(0, info.logType, info.jsonLog);
                }
                if (this.mUploader == null || !this.mReportLogEnable) break;
                this.mUploader.onUplaod(info.logType, info.jsonLog);
                break;
            }
            case 16: {
                if (this.mListener == null) break;
                this.mListener.onLogInfo(0, info.logType, info.jsonLog);
                break;
            }
            case 1: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.onLogInfo(1, info.logType, info.jsonLog);
                }
                if (this.mUploader == null || !this.mReportLogEnable) break;
                this.mUploader.onUplaod(info.logType, info.jsonLog);
                break;
            }
            case 14: {
                TTVideoEngineLog.i(TAG, "MDL Alog: " + info.logInfo);
                break;
            }
            case 70: {
                info.jsonLog = this._onHeartBeatFire(info.jsonLog);
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.onLogInfo(3, info.logType, info.jsonLog);
                }
                if (this.mUploader != null && this.mReportLogEnable) {
                    this.mUploader.onUplaod(info.logType, info.jsonLog);
                }
                TTVideoEngineLog.d(TAG, "heart beat msg: " + info.logInfo);
                break;
            }
            case 10: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener == null) break;
                this.mListener.onLogInfo(4, info.logType, info.jsonLog);
                TTVideoEngineLog.d(TAG, "live loader log msg: " + info.logInfo);
                break;
            }
            case 11: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener == null) break;
                this.mListener.onLogInfo(5, info.logType, info.jsonLog);
                TTVideoEngineLog.d(TAG, "live loader log sample msg: " + info.logInfo);
                break;
            }
            case 3: 
            case 4: {
                TTVideoEngineLog.d(TAG, "KeyIsFileCacheProgress log = " + info.logInfo + ", task type = " + info.parameter + " code = " + (int)info.code);
                if (info.logInfo == null) break;
                if (info.parameter == 3L) {
                    boolean processed = false;
                    if (info.what == 4) {
                        processed = this.mDataLoaderHelperAdapter.onDownloadCompleted(info);
                    } else if (info.what == 3) {
                        processed = this.mDataLoaderHelperAdapter.onDownloadProgress(info);
                    }
                    if (processed) break;
                    Downloader.getInstance().progress(info.logInfo);
                    break;
                }
                this._progressInfoString(info, info.parameter == 2L);
                break;
            }
            case 5: {
                if (this.mListener == null) break;
                this.mListener.onNotify(20, info.code, info.parameter, info.logInfo);
                break;
            }
            case 6: {
                try {
                    JSONObject log = DataLoaderCDNLog.process(info.jsonLog);
                    if (log == null) break;
                    if (this.mListener != null) {
                        this.mListener.onNotifyCDNLog(log);
                    }
                    TTVideoEngineLog.d("avmdlcdnlog", "receive log:" + log);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: 
            case 20: {
                if (info.logInfo != null && info.parameter == 3L) {
                    boolean processed = false;
                    processed = this.mDataLoaderHelperAdapter.onDownloadFail(info);
                    if (!processed) {
                        String key = info.logInfo;
                        long errorCode = info.code;
                        Downloader.getInstance().downloadFail(key, this._errorWithCode((int)errorCode, info.parameter, key));
                    }
                    return;
                }
                if (info.logInfo == null) break;
                TTVideoEngineLog.i(TAG, " task fail log = " + info.logInfo + ", code = " + info.code + ", task type = " + info.parameter);
                String[] temArray = info.logInfo.split(",");
                if (temArray.length < 1) {
                    return;
                }
                String fileKey = temArray[0];
                if (this.mDataLoaderHelperAdapter.onLoaderFail(info)) {
                    return;
                }
                DataLoaderTaskQueue temQueue = null;
                DataLoaderTaskItem item = this.mAllPreloadTasks.itemForKey(fileKey);
                if (item == null) {
                    return;
                }
                temQueue = this.mAllPreloadTasks;
                Error thisError = new Error("kTTVideoErrorDomainDataLoaderPreload", (int)info.code, info.logInfo);
                String rawKey = TextUtils.isEmpty((CharSequence)item.mVideoId) ? fileKey : item.mVideoId;
                DataLoaderTaskLoadProgress loadProgress = PreloadLoadProgressCenter.center().getLoadProgressByRawKey(rawKey);
                if (loadProgress == null) {
                    loadProgress = new DataLoaderTaskLoadProgress();
                }
                loadProgress.mVideoId = item.mVideoId;
                loadProgress.mTaskType = (int)info.parameter;
                loadProgress.setUp(item);
                loadProgress.onError(fileKey, thisError);
                if (this.mListener != null) {
                    this.mListener.onLoadProgress(loadProgress);
                }
                PreloadLoadProgressCenter.center().putByRawKey(rawKey, loadProgress);
                if (!loadProgress.isCacheEnd() && !loadProgress.isPreloadComplete()) break;
                temQueue.popItem(fileKey);
                TTVideoEngineLog.i(TAG, "pop all task item. videoId = " + item.mVideoId + " key = " + fileKey);
                PreloadLoadProgressCenter.center().removeLoadProgressByRawKey(rawKey);
                if (this.mListener != null) {
                    DataLoaderTaskProgressInfo progressInfo = new DataLoaderTaskProgressInfo();
                    progressInfo.mTaskType = (int)info.parameter;
                    progressInfo.mVideoId = item.mVideoId;
                    progressInfo.mKey = fileKey;
                    if (item.mURLItem != null && item.mURLItem.getFilePath() != null) {
                        progressInfo.mLocalFilePath = item.mURLItem.getFilePath();
                        progressInfo.mKey = null;
                    }
                    this.mListener.onTaskProgress(progressInfo);
                }
                if (item.getCallBackListener() == null || info.parameter != 2L) break;
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(3);
                callBackInfo.preloadError = thisError;
                callBackInfo.loadProgress = loadProgress;
                callBackInfo.preloadDataInfo = null;
                item.getCallBackListener().preloadItemInfo(callBackInfo);
                break;
            }
            case 13: {
                if (this.mListener == null || info.jsonLog == null) break;
                this.mListener.onLogInfo(0, info.logType, info.jsonLog);
                break;
            }
            case 15: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener == null || info.jsonLog == null) break;
                this.mListener.onLogInfoToMonitor(6, info.logType, info.jsonLog);
                break;
            }
            case 22: {
                if (info.logInfo == null) break;
                String key = info.logInfo;
                Downloader.getInstance().downloadDidSuspened(key);
                break;
            }
            case 21: {
                if (info.logInfo == null) break;
                boolean processed = false;
                processed = this.mDataLoaderHelperAdapter.onDownloadCompleted(info);
                if (processed) break;
                Downloader.getInstance().progress(info.logInfo);
                break;
            }
            case 50: {
                break;
            }
            case 19: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener == null) break;
                this.mListener.onLogInfo(7, info.logType, info.jsonLog);
                break;
            }
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: 
            case 1005: {
                if (this.mEngineUploader != null) {
                    this.mEngineUploader.onEvent(info.logType, info.jsonLog);
                    return;
                }
                if (this.mListener == null) break;
                this.mListener.onLogInfo(10, info.logType, info.jsonLog);
                break;
            }
            case 1004: {
                if (this.mEngineUploader == null) break;
                this.mEngineUploader.onEventV2(monitorName, info.jsonLog);
                return;
            }
            case 901: {
                TTVideoEngineLog.d("multinetwork", String.format("target network:%d current network:%d", info.parameter, info.code));
                String targetNetwork = this.getNetworkName(info.parameter);
                String currentNetwork = this.getNetworkName(info.code);
                if (TextUtils.isEmpty((CharSequence)targetNetwork) || TextUtils.isEmpty((CharSequence)currentNetwork) || this.mListener == null) break;
                TTVideoEngineLog.d("multinetwork", "do callback target: " + targetNetwork + " current: " + currentNetwork);
                this.mListener.onMultiNetworkSwitch(targetNetwork, currentNetwork);
                TTVideoEngineLog.d("multinetwork", "end do callback target: " + targetNetwork + " current: " + currentNetwork);
                break;
            }
            case 24: {
                if (this.mDataLoaderHelperAdapter.onLoaderOpen(info)) {
                    return;
                }
                if (this.mListener == null) break;
                this.mListener.onNotify(30, 0L, info.parameter, info.logInfo);
                break;
            }
            case 7: {
                if (!this.mDataLoaderHelperAdapter.onLoaderCancel(info)) break;
                return;
            }
            case 902: {
                TTVideoEngineLog.d(TAG, "KeyIsFileDeleteSizeByUsedTime size: " + info.code);
                if (this.mListener == null) break;
                this.mListener.onNotify(31, 0L, info.code, null);
                break;
            }
            default: {
                TTVideoEngineLog.d(TAG, "NOT DEAL notify info what =  " + info.what);
            }
        }
    }

    String getNetworkName(long value) {
        switch ((int)value) {
            case 1: {
                return "cellular";
            }
            case 2: {
                return "wifi";
            }
            case 0: {
                return PRELOAD_DEFAULT_SCENE;
            }
        }
        return null;
    }

    private Error _errorWithCode(int errorCode, long taskType, String key) {
        String reason = null;
        int code = errorCode;
        switch (errorCode) {
            case -1000: {
                reason = "create preload task fail.";
                break;
            }
            case -1001: {
                reason = "add the same key task.";
                break;
            }
            case -1002: {
                reason = "Waiting for too many tasks, > 20";
                break;
            }
            case -2000: {
                reason = "media data content length invalid";
                break;
            }
            case -3000: {
                code = !NetUtils.isNetAvailable(this.mContext) ? -9960 : -9945;
                reason = "url invalid. response status code >= 400";
                break;
            }
            case -3001: {
                code = -9944;
                reason = "server invalid. response status code >= 500";
                break;
            }
            case -4000: {
                reason = "request invalid.";
                break;
            }
            case -5000: {
                code = -9948;
                reason = "write file fail.";
                break;
            }
            default: {
                reason = "task fail. reply task error.";
            }
        }
        String domain = "kTTVideoErrorDomainDataLoaderPreload";
        if (taskType == 3L) {
            domain = "kTTVideoErrorDomainDownload";
        }
        return new Error(domain, code, errorCode, "key = " + key + ", reason = " + reason);
    }

    public long getInt64Value(int code, long defaultValue) {
        return 0L;
    }

    public String getCheckSumInfo(String fileKey) {
        String result = null;
        try {
            if (this.mListener != null && !TextUtils.isEmpty((CharSequence)fileKey)) {
                result = this.mListener.getCheckSumInfo(fileKey);
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
        return result;
    }

    public String getStringValue(int what, long code, String fileKey) {
        String result = null;
        TTVideoEngineLog.i(TAG, "[preload] getStringValue, key = " + fileKey);
        switch (what) {
            case 1506: {
                String newKey;
                DataLoaderTaskItem temItem = null;
                if (temItem == null && this.mAllPreloadTasks != null) {
                    temItem = this.mAllPreloadTasks.itemForKey(fileKey);
                }
                TTVideoEngineLog.i(TAG, "[preload] getStringValue, key = " + fileKey);
                if (temItem == null || temItem.mURLItem == null || temItem.mURLItem.getProvider() == null) break;
                String key = temItem.mURLItem.getProvider().getKey();
                String[] urls = temItem.mURLItem.getProvider().getUrls();
                DataLoaderTaskItem.TrackItem trackItem = temItem.getTrackItem(fileKey);
                long size = trackItem.mPreSize;
                size = temItem.mURLItem.getProvider().getPreloadSize();
                String path = temItem.mURLItem.getProvider().getCacheDir();
                String extraInfoStr = null;
                if (temItem.mTag != null) {
                    extraInfoStr = "tag=" + TTHelper.encodeUrl(temItem.mTag);
                }
                result = this.proxyQuery(key, key, trackItem.mPreloadOffset, size, urls, path, extraInfoStr, false, null);
                trackItem.mTaskKey = newKey = TextUtils.isEmpty((CharSequence)key) ? fileKey : key;
                TTVideoEngineLog.i(TAG, String.format("[preload] get proxxy url from url: %s", result));
                break;
            }
            case 1509: {
                if (this.mListener == null || TextUtils.isEmpty((CharSequence)fileKey)) break;
                HashMap<String, String> headers = this.mListener.getCustomHttpHeaders(fileKey);
                if (headers == null || headers.size() == 0) {
                    return null;
                }
                StringBuilder bulder = new StringBuilder();
                for (String key : headers.keySet()) {
                    if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)headers.get(key))) continue;
                    bulder.append(key).append(": ").append(headers.get(key)).append("\r\n");
                }
                TTVideoEngineLog.i(TAG, String.format("[customheader] get custom header:%s url: %s", fileKey, bulder.toString()));
                return bulder.toString();
            }
        }
        return result;
    }

    private void _progressInfoString(AVMDLDataLoaderNotifyInfo info, boolean isPreload) {
        if (info == null || TextUtils.isEmpty((CharSequence)info.logInfo)) {
            return;
        }
        String[] temArray = info.logInfo.split(",");
        if (temArray.length < 4) {
            return;
        }
        try {
            long cacheSize = Long.valueOf(temArray[0]);
            long mediaSize = Long.valueOf(temArray[1]);
            if (mediaSize <= 0L && info.what != 4) {
                TTVideoEngineLog.i(TAG, "[preload] mediaSize <= 0 return " + info.logInfo);
                return;
            }
            String key = temArray[2];
            String localFilePath = temArray[3];
            if (this.mDataLoaderHelperAdapter.onLoaderEnd(info)) {
                return;
            }
            DataLoaderTaskItem temItem = null;
            DataLoaderTaskQueue temQueue = null;
            if (isPreload) {
                if (temItem == null) {
                    temItem = this.mAllPreloadTasks.itemForKey(key);
                    if (temItem == null) {
                        TTVideoEngineLog.i(TAG, "[preload] preload temItem == null return " + info.logInfo);
                        if (info.what == 4) {
                            DataLoaderTaskProgressInfo progressInfo = new DataLoaderTaskProgressInfo();
                            progressInfo.mCacheSizeFromZero = cacheSize;
                            progressInfo.mMediaSize = mediaSize;
                            progressInfo.mKey = key;
                            progressInfo.mTaskType = 2;
                            progressInfo.mLocalFilePath = localFilePath;
                            if (this.mListener != null) {
                                this.mListener.onTaskProgress(progressInfo);
                                TTVideoEngineLog.i(TAG, " task progress. cache end. key = " + key);
                            }
                        }
                        return;
                    }
                    temQueue = this.mAllPreloadTasks;
                }
            } else {
                temItem = this.mAllPlayTasks.itemForKey(key);
                if (temItem == null) {
                    TTVideoEngineLog.i(TAG, "[preload] play temItem == null return " + info.logInfo);
                    return;
                }
                temQueue = this.mAllPlayTasks;
            }
            if (temItem != null) {
                DataLoaderTaskItem.TrackItem trackItem = temItem.getTrackItem(key);
                if (trackItem != null) {
                    trackItem.mMediaSize = mediaSize;
                    trackItem.mCacheSize = cacheSize;
                    trackItem.mLocalFilePath = localFilePath;
                }
                if (trackItem != null && isPreload && trackItem.mPreloadFooterSize > 0L && !trackItem.mIsFooterPreloaded) {
                    TTVideoEngineLog.i(TAG, "[preload] preload footer" + trackItem.mPreloadFooterSize);
                    if (trackItem.mMediaSize != trackItem.mCacheSize) {
                        long footerOffset;
                        long l = footerOffset = trackItem.mMediaSize <= trackItem.mPreloadFooterSize ? 0L : trackItem.mMediaSize - trackItem.mPreloadFooterSize;
                        if (footerOffset < trackItem.mCacheSize) {
                            footerOffset = trackItem.mCacheSize;
                        }
                        trackItem.mIsFooterPreloaded = true;
                        trackItem.mPreloadOffset = footerOffset;
                        trackItem.mPreSize = trackItem.mPreloadFooterSize;
                        this._startMDLPreloadTask(temItem, trackItem);
                        return;
                    }
                }
                String rawKey = TextUtils.isEmpty((CharSequence)temItem.mVideoId) ? key : temItem.mVideoId;
                DataLoaderTaskLoadProgress loadProgress = PreloadLoadProgressCenter.center().getLoadProgressByRawKey(rawKey);
                if (loadProgress == null) {
                    loadProgress = new DataLoaderTaskLoadProgress();
                }
                loadProgress.mVideoId = temItem.mVideoId;
                loadProgress.mTaskType = isPreload ? 2 : 1;
                loadProgress.setUp(temItem);
                if (mediaSize == cacheSize && trackItem != null && trackItem.mVideoInfo != null) {
                    TTVideoEngineLog.i(TAG, "[preload] " + (trackItem.mVideoInfo.getMediatype() == VideoRef.TYPE_AUDIO ? "Audio" : "Video") + " cache complete key: " + key);
                }
                if (this.mListener != null) {
                    this.mListener.onLoadProgress(loadProgress);
                }
                PreloadLoadProgressCenter.center().putByRawKey(rawKey, loadProgress);
                if (loadProgress.isCacheEnd() || isPreload && loadProgress.isPreloadComplete() || info.what == 4) {
                    temQueue.popItem(key);
                    PreloadLoadProgressCenter.center().removeLoadProgressByRawKey(rawKey);
                    if (!isPreload) {
                        TTVideoEngineLog.i(TAG, "[preload] notify vid cache end key: " + rawKey);
                        this._cacheEndNotifyEngine(temItem);
                    }
                    DataLoaderTaskProgressInfo progressInfo = new DataLoaderTaskProgressInfo();
                    progressInfo.mCacheSizeFromZero = cacheSize;
                    progressInfo.mMediaSize = mediaSize;
                    progressInfo.mKey = key;
                    progressInfo.mLocalFilePath = localFilePath;
                    progressInfo.mResolution = trackItem.mUsingResolution;
                    progressInfo.mDecryptionKey = trackItem.mDecryptionKey;
                    progressInfo.mUsingVideoInfo = trackItem.mVideoInfo;
                    progressInfo.mVideoId = temItem.mVideoId;
                    progressInfo.mTaskType = loadProgress.mTaskType;
                    if (temItem.getCallBackListener() != null && isPreload) {
                        PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(2);
                        callBackInfo.preloadDataInfo = progressInfo;
                        callBackInfo.loadProgress = loadProgress;
                        temItem.getCallBackListener().preloadItemInfo(callBackInfo);
                        TTVideoEngineLog.i(TAG, "[preload] notify end cache size = " + loadProgress.getTotalCacheSize());
                    }
                    if (this.mListener != null && progressInfo != null) {
                        this.mListener.onTaskProgress(progressInfo);
                        TTVideoEngineLog.i(TAG, " task progress. cache end. key = " + key + ", rawKey = " + rawKey);
                    }
                }
            }
        }
        catch (Exception e) {
            TTVideoEngineLog.d(e);
        }
    }

    private String _apiStringForVid(PreloaderVidItem vidItem) {
        if (vidItem == null) {
            return null;
        }
        FetcherApiHelper apiHelper = new FetcherApiHelper(vidItem.getAuthorization(), vidItem.mApiVersion, vidItem.mDashEnable, vidItem.mHlsEnable, vidItem.mEncryptEnable, vidItem.mCodecType);
        return apiHelper.getAPIString();
    }

    private void _cacheEndNotifyEngine(DataLoaderTaskItem item) {
        ArrayList<DataLoaderTaskItem> tasks = this.mAllPlayTasks.toArray();
        DataLoaderTaskItem temItem = null;
        boolean allEnd = true;
        for (int i = 0; i < tasks.size(); ++i) {
            temItem = tasks.get(i);
            if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || TextUtils.isEmpty((CharSequence)item.mVideoId) || !temItem.mVideoId.equals(item.mVideoId)) continue;
            allEnd = false;
            break;
        }
        if (allEnd) {
            this.mLock.lock();
            this.mPreloadUtil.notifyCacheEnd(item.mVideoId);
            this.mLock.unlock();
            ArrayList<WeakReference<TTVideoEngine>> engines = this._getEnginesByRawKey(item.mVideoId);
            if (engines == null || engines.size() == 0) {
                return;
            }
            for (int i = 0; i < engines.size(); ++i) {
                WeakReference<TTVideoEngine> ref = engines.get(i);
                if (ref.get() == null) continue;
                ((TTVideoEngine)ref.get()).notifyCacheEnd();
            }
        }
    }

    public void _removePlayTask(String taskKey) {
        this.mAllPlayTasks.popItem(taskKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addEngine(TTVideoEngine engine, String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey) || engine == null) {
            return;
        }
        try {
            ValueWeakReference<TTVideoEngine> ref;
            this.mEngineLock.lock();
            ArrayList<WeakReference<TTVideoEngine>> engines = this.mAllUsingEngies.get(rawKey);
            if (engines == null) {
                engines = new ArrayList();
                this.mAllUsingEngies.put(rawKey, engines);
            }
            if (!engines.contains(ref = new ValueWeakReference<TTVideoEngine>(engine))) {
                engines.add(ref);
                TTVideoEngineLog.i(TAG, "add engine ref,rawKey = " + rawKey + " engine ref count: " + engines.size());
            }
        }
        finally {
            this.mEngineLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _removeEngine(TTVideoEngine engine, String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey) || engine == null) {
            return;
        }
        try {
            this.mEngineLock.lock();
            ArrayList<WeakReference<TTVideoEngine>> engines = this.mAllUsingEngies.get(rawKey);
            if (engines != null) {
                engines.remove(new ValueWeakReference<TTVideoEngine>(engine));
                TTVideoEngineLog.i(TAG, "remove engine ref,rawKey = " + rawKey + " engine ref count: " + engines.size());
                if (engines.size() == 0) {
                    this.mAllUsingEngies.remove(rawKey);
                    if (this.mPreloadUtil.mPlayBufferLowerBound > 0L && this.mPreloadUtil.mPlayBufferUpperBound > 0L) {
                        this.mPreloadUtil.removePlayInfo(rawKey);
                    }
                }
            }
        }
        finally {
            this.mEngineLock.unlock();
        }
    }

    public void doParseHosts(String[] hosts) {
        if (hosts == null || hosts.length == 0) {
            return;
        }
        this.mEnablePreParseHost = 1;
        this.mInnerDataLoader.doParseHosts(hosts);
    }

    public void setBackUpIP(String hostname, String ipList) {
        AVMDLDNSParser.getInstance().setBackUpIP(hostname, ipList);
        if (!TextUtils.isEmpty((CharSequence)hostname) && !TextUtils.isEmpty((CharSequence)ipList)) {
            this.mEnableBackupIP = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ArrayList<WeakReference<TTVideoEngine>> _getEnginesByRawKey(String rawKey) {
        if (TextUtils.isEmpty((CharSequence)rawKey)) {
            return null;
        }
        try {
            this.mEngineLock.lock();
            ArrayList<WeakReference<TTVideoEngine>> engines = this.mAllUsingEngies.get(rawKey);
            if (engines != null) {
                ArrayList<WeakReference<TTVideoEngine>> tem = new ArrayList<WeakReference<TTVideoEngine>>();
                tem.addAll(engines);
                TTVideoEngineLog.i(TAG, "get engine ref,rawKey = " + rawKey + " engine ref count: " + tem.size());
                ArrayList<WeakReference<TTVideoEngine>> arrayList = tem;
                return arrayList;
            }
        }
        finally {
            this.mEngineLock.unlock();
        }
        return null;
    }

    public void setProbeType(int probeType) {
    }

    public int getProbeType() {
        return 0;
    }

    public void setProbeIntervalMS(int intervalMS) {
    }

    public int getProbeIntervalMS() {
        return -1;
    }

    public void setPlayTaskProgress(float progress) {
    }

    public float playTaskProgress() {
        return -1.0f;
    }

    public void setPreloadLogLevel(int level) {
        if (level == 1) {
            level = 1;
        }
        if (level >= 4) {
            level = 5;
        }
        StrategyHelper.helper().setLogLevel(level);
    }

    private void _startMDLPreloadTask(DataLoaderTaskItem item, DataLoaderTaskItem.TrackItem trackItem) {
        if (item == null || trackItem == null) {
            TTVideoEngineLog.e(TAG, "[preload] start mdl preload task fail. track is null");
            return;
        }
        DataLoaderTaskQueue temQueue = this.mAllPreloadTasks;
        TTVideoEngineLog.i(TAG, "[preload] start mdl preload task.  key = " + trackItem.mTaskKey);
        String header = trackItem.mCustomHeader;
        String taskKey = trackItem.mTaskKey;
        if (item.mURLItem != null && item.mURLItem.getProvider() != null) {
            trackItem.mProxyUrl = this.proxyQueryProvideMode(taskKey, item.mVideoId, item.mPriorityLevel, 1);
            if (!TextUtils.isEmpty((CharSequence)trackItem.mProxyUrl)) {
                this.mAllPreloadTasks.popItem(taskKey);
                this.mAllPreloadTasks.enqueueItem(item);
                if (trackItem.mPreloadOffset > 0L && trackItem.mPreloadOffset < trackItem.mPreloadHeaderSize + 102400L) {
                    trackItem.mPreSize += trackItem.mPreloadOffset;
                    trackItem.mPreloadOffset = 0L;
                }
                TTVideoEngineLog.i(TAG, "[preload] preload offset " + trackItem.mPreloadOffset + " header size = " + trackItem.mPreloadHeaderSize + " preload size = " + trackItem.mPreSize);
                if (trackItem.mPreloadOffset > 0L) {
                    if (trackItem.mPreloadHeaderSize > 0L) {
                        this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreloadHeaderSize);
                    }
                    this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreloadOffset, (int)trackItem.mPreSize);
                } else {
                    this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreSize);
                }
            } else {
                item._notifyError(-100001);
            }
            TTVideoEngineLog.i(TAG, String.format("[preload] exect preload task by provider mode, key is %s; videoId = %s proxyurl:%s", taskKey, item.mVideoId, trackItem.mProxyUrl));
        } else if (trackItem.mUrls != null) {
            String[] temUrls = trackItem.mUrls;
            boolean isM3u8 = false;
            if (item.mResponseData != null) {
                isM3u8 = item.mResponseData.hasFormat(IVideoModel.Format.HLS);
            }
            if (temUrls.length > 0 && !TextUtils.isEmpty((CharSequence)temUrls[0]) && FormatProvider.FormatProviderHolder.isM3u8(temUrls[0])) {
                isM3u8 = true;
            }
            MDLExtraInfoHelper.addPCDNFlag(item, trackItem);
            MDLExtraInfoHelper.addTags(item, trackItem);
            trackItem.mProxyUrl = this.preloadProxyQuery(taskKey, item.mVideoId, trackItem.mPreloadOffset, 0L, temUrls, trackItem.mLocalFilePath, trackItem.mExternalInfo, item.mPriorityLevel, header, isM3u8, null);
            if (!TextUtils.isEmpty((CharSequence)trackItem.mProxyUrl)) {
                this.mAllPreloadTasks.popItem(taskKey);
                this.mAllPreloadTasks.enqueueItem(item);
                if (trackItem.mPreloadOffset > 0L && trackItem.mPreloadOffset < trackItem.mPreloadHeaderSize + 102400L) {
                    trackItem.mPreSize += trackItem.mPreloadOffset;
                    trackItem.mPreloadOffset = 0L;
                }
                TTVideoEngineLog.i(TAG, "[preload] preload offset " + trackItem.mPreloadOffset + " header size = " + trackItem.mPreloadHeaderSize + " preload size = " + trackItem.mPreSize);
                boolean preloaded = false;
                if (isM3u8) {
                    preloaded = this.mDataLoaderHelperAdapter.preloadHLSSource(trackItem.mProxyUrl, (int)trackItem.mPreSize);
                }
                if (!preloaded) {
                    if (trackItem.mPreloadOffset > 0L) {
                        if (trackItem.mPreloadHeaderSize > 0L) {
                            this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreloadHeaderSize);
                        }
                        this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreloadOffset, (int)trackItem.mPreSize);
                    } else {
                        this.mInnerDataLoader.preloadResource(trackItem.mProxyUrl, (int)trackItem.mPreSize);
                    }
                }
                TTVideoEngineLog.i(TAG, String.format("[preload] exect preload task ,key is %s; videoId = %s", trackItem.mTaskKey, item.mVideoId));
            } else {
                item._notifyError(-100001);
            }
        } else {
            item._notifyError(-100001);
        }
    }

    public void setTaskConfigs(List<PreloadTaskConfig> taskConfigs) {
    }

    public void createScene(PreloadScene scene) {
        if (this.mMdlPreloadStrategy == 200) {
            StrategyHelper.helper().getCenter().createScene(scene.toJsonString());
        }
    }

    public void destroyScene(String sceneId) {
        if (this.mMdlPreloadStrategy == 200) {
            StrategyHelper.helper().getCenter().destroyScene(sceneId);
        }
    }

    public void moveToScene(String sceneId) {
        if (this.mMdlPreloadStrategy == 200) {
            StrategyHelper.helper().getCenter().switchToScene(sceneId);
        }
    }

    public void focusMedia(String mediaId, int forceType) {
        if (this.mediaOperateThread != null) {
            ArrayList<Object> temList = new ArrayList<Object>();
            temList.add(this);
            temList.add(mediaId);
            temList.add(forceType);
            this.mediaOperateThread.postMessage(temList, 114);
        } else {
            StrategyHelper.helper().getCenter().focusMedia(mediaId, forceType);
        }
    }

    public void removeMedia(String mediaId, String sceneId) {
        this._ml_removeMedia(mediaId, sceneId);
    }

    private void _ml_addMedia(PreloadModelMedia model, String sceneId) {
        if (model != null) {
            if (this.mediaOperateThread != null) {
                ArrayList<Object> temList = new ArrayList<Object>();
                temList.add(this);
                temList.add(model);
                temList.add(sceneId);
                this.mediaOperateThread.postMessage(temList, 111);
            } else {
                this._doMl_addMedia(model, sceneId);
            }
        }
    }

    private void _doMl_addMedia(PreloadModelMedia model, String sceneId) {
        if (model != null) {
            List<VideoInfo> videoInfos;
            String mediaJson;
            MySelectBitrateListener selectListener = null;
            if (model.getSelectCallback() != null) {
                selectListener = new MySelectBitrateListener(model.getSelectCallback());
            }
            String info = model.mVideoModel.toMediaInfoJsonString();
            if (model.isNeedConvertStrategyInfo() && !TextUtils.isEmpty((CharSequence)(mediaJson = model.toStrategyInfo()))) {
                info = mediaJson;
            }
            if (this.mEnableCheckPreloadUrls == 1 && model.mVideoModel != null && (videoInfos = model.mVideoModel.getVideoInfoList()) != null && !videoInfos.isEmpty()) {
                for (VideoInfo videoInfo : videoInfos) {
                    String[] urls;
                    for (String url : urls = videoInfo.getValueStrArr(16)) {
                        if (this._supportProxy(url)) continue;
                        return;
                    }
                }
            }
            StrategyHelper.helper().getCenter().addMedia(info, selectListener, sceneId, model.isLast);
        }
    }

    private void _doMl_addPriorityTask(PreloadModelMedia model) {
        MySelectBitrateListener selectListener = null;
        if (model.getSelectCallback() != null) {
            selectListener = new MySelectBitrateListener(model.getSelectCallback());
        }
        MyPreloadTaskCallbackListener callbackListener = null;
        if (model.getCallBackListener() != null) {
            callbackListener = new MyPreloadTaskCallbackListener(model.getCallBackListener());
        }
        StrategyHelper.helper().getCenter().addPriorityTask(model.toStrategyInfo(), selectListener, callbackListener);
    }

    private void _doMl_removePriorityTask(String key) {
        StrategyHelper.helper().getCenter().removePriorityTask(key);
    }

    private void _ml_removeAllMedias(String sceneId, int moveFlag) {
        if (this.mediaOperateThread != null) {
            ArrayList<Object> temList = new ArrayList<Object>();
            temList.add(this);
            temList.add(sceneId);
            temList.add(moveFlag);
            this.mediaOperateThread.postMessage(temList, 113);
        } else {
            this._doMl_removeAllMedias(sceneId, moveFlag);
        }
    }

    private void _doMl_removeAllMedias(String sceneId, int moveFlag) {
        StrategyHelper.helper().getCenter().removeAllMedia(sceneId, moveFlag);
    }

    private void _ml_removeMedia(String mediaId, String sceneId) {
        if (this.mediaOperateThread != null) {
            ArrayList<Object> temList = new ArrayList<Object>();
            temList.add(this);
            temList.add(mediaId);
            temList.add(sceneId);
            this.mediaOperateThread.postMessage(temList, 112);
        } else {
            this._doMl_removeMedia(mediaId, sceneId);
        }
    }

    private void _doMl_removeMedia(String mediaId, String sceneId) {
        StrategyHelper.helper().getCenter().removeMedia(mediaId, sceneId);
    }

    public void tryStartStrategyCenter() {
        if (this.mConfigure.mEnableIOManager != 0) {
            long iomanagerHandle = this.mInnerDataLoader.getLongValue(7390);
            long iomanagerVersion = this.mInnerDataLoader.getLongValue(7402);
            if (iomanagerHandle == 0L || iomanagerHandle == -1L || iomanagerHandle == -998L || iomanagerVersion < 0L) {
                TTVideoEngineLog.d(TAG, "tryStartStrategyCenter iomanagerHandle or iomanagerVersion is not validiomanagerHandle=" + iomanagerHandle + " iomanagerVersion=" + iomanagerVersion);
                return;
            }
            this.mediaOperateThread = new PreloadMediaThread();
            StrategyHelper.helper().setIOManager(iomanagerHandle, iomanagerVersion);
            StrategyHelper.helper().setContext(this.mContext);
            boolean isLoadedByProxy = false;
            if (this.mProxy != null) {
                isLoadedByProxy = StrategyHelper.helper().loadPluginLibrary(this.mProxy);
            }
            StrategyHelper.helper().start(!isLoadedByProxy);
            StrategyHelper.helper().configAppInfo(AppInfo.toJsonString(), null);
            StrategyHelper.helper().getCenter().businessEvent(31211, VideoEventBase.appSessionId);
            StrategyHelper.helper().getCenter().businessEvent(31209, this.mConfigure.mCacheDir);
            if (!TextUtils.isEmpty((CharSequence)Inspector.share().getHost())) {
                StrategyHelper.helper().getCenter().businessEvent(31207, Inspector.share().getHost());
            }
            if (this.mInnerDataLoader.isRunning()) {
                if (!StrategyHelper.helper().isRunning()) {
                    TTVideoEngineLog.d(TAG, "strategy center start failed, set mdl preload strategy back " + this.mMdlOldPreloadStrategy);
                    this.mInnerDataLoader.setIntValue(1030, this.mMdlOldPreloadStrategy);
                } else {
                    this.mInnerDataLoader.setIntValue(1030, this.mMdlPreloadStrategy);
                }
            }
        }
    }

    public void setTaskEventListener(AVMDLTaskEventListener listener) {
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        this.mLock.lock();
        this.mInnerDataLoader.setTaskEventListener(listener);
        this.mLock.unlock();
    }

    public void suspendPreconnect() {
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        this.mLock.lock();
        this.mInnerDataLoader.suspendPreconnect();
        this.mLock.unlock();
    }

    public void resumePreconnect() {
        if (this.mInnerDataLoader == null) {
            TTVideoEngineLog.e(TAG, "need start mdl first");
            return;
        }
        this.mLock.lock();
        this.mInnerDataLoader.resumePreConnect();
        this.mLock.unlock();
    }

    private JSONObject _onHeartBeatFire(JSONObject fromMdl) {
        try {
            long playConsumed;
            long playWast = VideoInfoCollector.getInstance().getPlayWastDataSize();
            if (playWast > 0L) {
                fromMdl.put("_play_waste_data", playWast);
            }
            if ((playConsumed = VideoInfoCollector.getInstance().getPlayConsumedSize()) > 0L) {
                fromMdl.put("_play_consumed_data", playConsumed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fromMdl;
    }

    class MyPreloadTaskCallbackListener
    implements IPreloadTaskCallbackListener {
        private IPreLoaderItemCallBackListener mCallBackListener = null;

        MyPreloadTaskCallbackListener(IPreLoaderItemCallBackListener listener) {
            this.mCallBackListener = listener;
        }

        @Override
        public void preloadItemInfo(int type, String info, String extraInfo) {
            if (this.mCallBackListener != null) {
                String[] temArray;
                int preloadCallbackType = 2;
                if (type == 4) {
                    preloadCallbackType = 3;
                } else if (type == 5) {
                    preloadCallbackType = 5;
                } else if (type == 2) {
                    preloadCallbackType = 8;
                } else if (type == 1) {
                    preloadCallbackType = 7;
                } else if (type == 6) {
                    preloadCallbackType = 9;
                }
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(preloadCallbackType);
                if (!TextUtils.isEmpty((CharSequence)info) && info.contains(",") && (temArray = info.split(",")).length >= 3) {
                    long cacheSize = Long.valueOf(temArray[0]);
                    long mediaSize = Long.valueOf(temArray[1]);
                    String key = temArray[2];
                    String localFilePath = "";
                    if (temArray.length >= 4) {
                        localFilePath = temArray[3];
                    }
                    callBackInfo.preloadDataInfo = new DataLoaderTaskProgressInfo();
                    callBackInfo.preloadDataInfo.mKey = key;
                    callBackInfo.preloadDataInfo.mCacheSizeFromZero = cacheSize;
                    callBackInfo.preloadDataInfo.mMediaSize = mediaSize;
                    callBackInfo.preloadDataInfo.mLocalFilePath = localFilePath;
                }
                callBackInfo.businessContext = extraInfo;
                this.mCallBackListener.preloadItemInfo(callBackInfo);
            }
        }
    }

    class MySelectBitrateListener
    implements ISelectBitrateListener {
        private ISelectBitrateCallback mCallback = null;

        MySelectBitrateListener(ISelectBitrateCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public String selectBitrateJsonString(String videoId, int type) {
            Map<String, Integer> map;
            if (this.mCallback != null && (map = this.mCallback.selectBitrate(type)) != null) {
                return new JSONObject(map).toString();
            }
            return null;
        }
    }

    private static class PreloadMediaThread {
        private HandlerThread mHandlerThread;
        private Handler mHandler;

        public PreloadMediaThread() {
            try {
                this.mHandlerThread = new HandlerThread("vclould.engine.preload.media");
                this.mHandlerThread.start();
                this.mHandler = new Handler(this.mHandlerThread.getLooper()){

                    public void handleMessage(Message msg) {
                        try {
                            if (msg == null) {
                                return;
                            }
                            if (!(msg.obj instanceof ArrayList)) {
                                TTVideoEngineLog.d(DataLoaderHelper.TAG, "[preload] obj should instance of ArrayList");
                                return;
                            }
                            ArrayList arrayList = (ArrayList)msg.obj;
                            if (arrayList == null) {
                                TTVideoEngineLog.d(DataLoaderHelper.TAG, "[preload] obj should instance of ArrayList");
                                return;
                            }
                            DataLoaderHelper dataLoaderHelper = (DataLoaderHelper)arrayList.get(0);
                            switch (msg.what) {
                                case 111: {
                                    if (arrayList.size() != 3) break;
                                    PreloadModelMedia model = (PreloadModelMedia)arrayList.get(1);
                                    String sceneId = (String)arrayList.get(2);
                                    if (dataLoaderHelper != null) {
                                        dataLoaderHelper._doMl_addMedia(model, sceneId);
                                    }
                                    break;
                                }
                                case 112: {
                                    if (arrayList.size() != 3) break;
                                    String mediaId = (String)arrayList.get(1);
                                    String sceneId = (String)arrayList.get(2);
                                    if (dataLoaderHelper != null) {
                                        dataLoaderHelper._doMl_removeMedia(mediaId, sceneId);
                                    }
                                    break;
                                }
                                case 113: {
                                    if (arrayList.size() != 3) break;
                                    String sceneId = (String)arrayList.get(1);
                                    int moveFlag = (Integer)arrayList.get(2);
                                    if (dataLoaderHelper != null) {
                                        dataLoaderHelper._doMl_removeAllMedias(sceneId, moveFlag);
                                    }
                                    break;
                                }
                                case 114: {
                                    if (arrayList.size() != 3) break;
                                    String mediaId = (String)arrayList.get(1);
                                    int forceType = (Integer)arrayList.get(2);
                                    if (dataLoaderHelper != null) {
                                        StrategyHelper.helper().getCenter().focusMedia(mediaId, forceType);
                                    }
                                    break;
                                }
                                case 115: {
                                    if (arrayList.size() != 2) break;
                                    PreloadModelMedia model = (PreloadModelMedia)arrayList.get(1);
                                    if (dataLoaderHelper != null) {
                                        dataLoaderHelper._doMl_addPriorityTask(model);
                                    }
                                    break;
                                }
                                case 116: {
                                    if (arrayList.size() != 2) break;
                                    String key = (String)arrayList.get(1);
                                    if (dataLoaderHelper != null) {
                                        dataLoaderHelper._doMl_removePriorityTask(key);
                                    }
                                    break;
                                }
                            }
                        }
                        catch (Throwable e) {
                            TTVideoEngineLog.d(e);
                        }
                    }
                };
            }
            catch (Throwable e) {
                TTVideoEngineLog.d(e);
                this.mHandlerThread = null;
                this.mHandler = null;
            }
        }

        public void postMessage(ArrayList<Object> obj, int code) {
            if (this.mHandler != null && this.mHandlerThread != null) {
                Message message = Message.obtain();
                message.what = code;
                message.obj = obj;
                this.mHandler.sendMessage(message);
            }
        }
    }

    private class DataLoaderHeartBeat {
        private Timer mHbTimer = null;
        private MyHeartBeatTask mHbTask = null;

        private DataLoaderHeartBeat() {
        }

        public void start(AVMDLDataLoader loader, int interval) {
            if (this.mHbTask != null || this.mHbTimer != null || interval <= 0) {
                return;
            }
            this.mHbTask = new MyHeartBeatTask(loader);
            this.mHbTimer = new Timer();
            this.mHbTimer.schedule((TimerTask)this.mHbTask, interval, (long)interval);
        }

        public void stop() {
            if (this.mHbTimer != null) {
                this.mHbTimer.cancel();
            }
        }

        private class MyHeartBeatTask
        extends TimerTask {
            private AVMDLDataLoader mDataLoader = null;

            @Override
            public void run() {
                try {
                    if (this.mDataLoader != null) {
                        this.mDataLoader.onLogInfo(70, 0, this.mDataLoader.getStringValue(1011));
                    }
                }
                catch (Exception ex) {
                    TTVideoEngineLog.d(ex);
                }
            }

            public MyHeartBeatTask(AVMDLDataLoader loader) {
                this.mDataLoader = loader;
            }
        }
    }

    private class DataLoaderTaskQueue {
        private final ReentrantLock mLock = new ReentrantLock();
        private final ArrayList<DataLoaderTaskItem> mTaskItems = new ArrayList();
        private long mMaxCount = 0L;

        private DataLoaderTaskQueue() {
        }

        public void setMaxCount(long maxCount) {
            this.mMaxCount = maxCount;
        }

        public long count() {
            this.mLock.lock();
            long temCount = this.mTaskItems.size();
            this.mLock.unlock();
            return temCount;
        }

        public DataLoaderTaskItem frontItem() {
            this.mLock.lock();
            if (this.mTaskItems.size() == 0) {
                this.mLock.unlock();
                return null;
            }
            DataLoaderTaskItem item = this.mTaskItems.get(0);
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem popFrontItem() {
            this.mLock.lock();
            if (this.mTaskItems.size() == 0) {
                this.mLock.unlock();
                return null;
            }
            DataLoaderTaskItem item = this.mTaskItems.get(0);
            this.mTaskItems.remove(item);
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem backItem() {
            this.mLock.lock();
            if (this.mTaskItems.size() == 0) {
                this.mLock.unlock();
                return null;
            }
            DataLoaderTaskItem item = this.mTaskItems.get(this.mTaskItems.size() - 1);
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem popBackItem() {
            this.mLock.lock();
            if (this.mTaskItems.size() == 0) {
                this.mLock.unlock();
                return null;
            }
            DataLoaderTaskItem item = this.mTaskItems.get(this.mTaskItems.size() - 1);
            this.mTaskItems.remove(item);
            this.mLock.unlock();
            return item;
        }

        boolean enqueueItem(DataLoaderTaskItem item) {
            if (item == null) {
                return false;
            }
            if (item.mTracks.size() == 0) {
                return false;
            }
            Boolean result = false;
            this.mLock.lock();
            if (this._enoughItems().booleanValue()) {
                result = false;
            } else {
                this.mTaskItems.add(item);
                result = true;
            }
            this.mLock.unlock();
            return result;
        }

        public boolean containItem(String key) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return false;
            }
            Boolean result = false;
            this.mLock.lock();
            for (int idx = 0; idx < this.mTaskItems.size(); ++idx) {
                DataLoaderTaskItem item = this.mTaskItems.get(idx);
                if (item.getTrackItem(key) == null) continue;
                result = true;
                break;
            }
            this.mLock.unlock();
            return result;
        }

        public DataLoaderTaskItem itemForKey(String key) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            DataLoaderTaskItem item = null;
            this.mLock.lock();
            for (int idx = 0; idx < this.mTaskItems.size(); ++idx) {
                DataLoaderTaskItem temItem = this.mTaskItems.get(idx);
                if (temItem.getTrackItem(key) == null) continue;
                item = temItem;
                break;
            }
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem itemForVideoId(String videoId) {
            if (TextUtils.isEmpty((CharSequence)videoId)) {
                return null;
            }
            DataLoaderTaskItem item = null;
            this.mLock.lock();
            for (int idx = 0; idx < this.mTaskItems.size(); ++idx) {
                DataLoaderTaskItem temItem = this.mTaskItems.get(idx);
                if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || !temItem.mVideoId.equals(videoId)) continue;
                item = temItem;
                break;
            }
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem popItemForVideoId(String videoId) {
            if (TextUtils.isEmpty((CharSequence)videoId)) {
                return null;
            }
            DataLoaderTaskItem item = null;
            this.mLock.lock();
            for (int idx = 0; idx < this.mTaskItems.size(); ++idx) {
                DataLoaderTaskItem temItem = this.mTaskItems.get(idx);
                if (TextUtils.isEmpty((CharSequence)temItem.mVideoId) || !temItem.mVideoId.equals(videoId)) continue;
                item = temItem;
                break;
            }
            if (item != null) {
                this.mTaskItems.remove(item);
            }
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem popItem(String key) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            DataLoaderTaskItem item = null;
            this.mLock.lock();
            for (int idx = 0; idx < this.mTaskItems.size(); ++idx) {
                DataLoaderTaskItem temItem = this.mTaskItems.get(idx);
                if (temItem.getTrackItem(key) == null) continue;
                item = temItem;
                break;
            }
            if (item != null) {
                this.mTaskItems.remove(item);
            }
            this.mLock.unlock();
            return item;
        }

        public DataLoaderTaskItem popItem(DataLoaderTaskItem item) {
            DataLoaderTaskItem retItem = null;
            if (!TextUtils.isEmpty((CharSequence)item.mVideoId) && (retItem = this.popItemForVideoId(item.mVideoId)) != null) {
                return retItem;
            }
            for (DataLoaderTaskItem.TrackItem trackItem : item.mTracks) {
                retItem = this.popItem(trackItem.mTaskKey);
                if (retItem == null) continue;
                break;
            }
            return retItem;
        }

        public ArrayList<DataLoaderTaskItem> toArray() {
            try {
                this.mLock.lock();
                ArrayList<DataLoaderTaskItem> tem = new ArrayList<DataLoaderTaskItem>();
                tem.addAll(this.mTaskItems);
                ArrayList<DataLoaderTaskItem> arrayList = tem;
                return arrayList;
            }
            finally {
                this.mLock.unlock();
            }
        }

        public void removeAll() {
            try {
                this.mLock.lock();
                this.mTaskItems.clear();
            }
            finally {
                this.mLock.unlock();
            }
        }

        private Boolean _enoughItems() {
            if (this.mMaxCount >= 1L) {
                return (long)this.mTaskItems.size() >= this.mMaxCount;
            }
            return false;
        }
    }

    private static interface TaskListener {
        public void taskFinished(DataLoaderTaskItem var1);
    }

    public class DataLoaderCacheFileInfo {
        public String mLocalFilePath = null;
        public long mMediaSize = 0L;
        public long mCacheSizeFromZero = 0L;
    }

    public class DataLoaderTaskLoadProgress {
        public String mVideoId = null;
        public int mTaskType = 0;
        public List<CacheInfo> mCacheInfos = null;
        protected boolean mSeparateAudioVideo = false;

        public void setUp(DataLoaderTaskItem taskItem) {
            this.mVideoId = taskItem.mVideoId;
            if (this.mCacheInfos == null) {
                this.mCacheInfos = new ArrayList<CacheInfo>();
            }
            int videoCount = 0;
            int audioCount = 0;
            for (DataLoaderTaskItem.TrackItem trackItem : taskItem.mTracks) {
                boolean exist = true;
                CacheInfo cacheInfo = this.getCacheInfo(trackItem.mTaskKey);
                if (cacheInfo == null) {
                    cacheInfo = new CacheInfo();
                    exist = false;
                }
                cacheInfo.mKey = trackItem.mTaskKey;
                cacheInfo.mMediaSize = trackItem.mMediaSize;
                cacheInfo.mResolution = trackItem.mUsingResolution;
                cacheInfo.setCacheSize(trackItem.mCacheSize);
                cacheInfo.mLocalFilePath = trackItem.mLocalFilePath;
                cacheInfo.mPreloadSize = trackItem.mPreSize;
                if (trackItem.mVideoInfo != null) {
                    if (trackItem.mVideoInfo.getMediatype() == VideoRef.TYPE_VIDEO) {
                        ++videoCount;
                    } else if (trackItem.mVideoInfo.getMediatype() == VideoRef.TYPE_AUDIO) {
                        ++audioCount;
                    }
                }
                if (exist) continue;
                this.mCacheInfos.add(cacheInfo);
            }
            if (audioCount > 0 && videoCount > 0) {
                this.mSeparateAudioVideo = true;
            }
        }

        public void onError(String key, Error error) {
            CacheInfo cacheInfo = this.getCacheInfo(key);
            if (cacheInfo != null) {
                cacheInfo.mError = error;
            }
        }

        private CacheInfo getCacheInfo(String key) {
            CacheInfo cacheInfo = null;
            if (!TextUtils.isEmpty((CharSequence)key) && this.mCacheInfos != null) {
                for (CacheInfo tem : this.mCacheInfos) {
                    if (!tem.mKey.equals(key)) continue;
                    cacheInfo = tem;
                    break;
                }
            }
            return cacheInfo;
        }

        public long getTotalCacheSize() {
            CacheInfo cacheInfo = null;
            long cacheSize = 0L;
            if (this.mCacheInfos != null) {
                for (int i = 0; i < this.mCacheInfos.size(); ++i) {
                    cacheInfo = this.mCacheInfos.get(i);
                    cacheSize += cacheInfo.getCacheSize();
                }
            }
            return cacheSize;
        }

        public boolean isPreloadComplete() {
            if (this.mTaskType != 2) {
                TTVideoEngineLog.d(DataLoaderHelper.TAG, "task is not a preload task");
                return false;
            }
            boolean ret = true;
            CacheInfo cacheInfo = null;
            if (this.mCacheInfos != null) {
                for (int i = 0; i < this.mCacheInfos.size(); ++i) {
                    cacheInfo = this.mCacheInfos.get(i);
                    if (cacheInfo == null || cacheInfo.finished()) continue;
                    ret = false;
                    break;
                }
            }
            return ret;
        }

        public boolean isCacheEnd() {
            boolean ret = true;
            int endCount = 0;
            CacheInfo cacheInfo = null;
            if (this.mCacheInfos != null) {
                for (int i = 0; i < this.mCacheInfos.size(); ++i) {
                    cacheInfo = this.mCacheInfos.get(i);
                    if (cacheInfo != null && !cacheInfo.finished()) {
                        ret = false;
                        continue;
                    }
                    ++endCount;
                }
            }
            if (!this.mSeparateAudioVideo) {
                return ret || endCount >= 1 && this.mTaskType == 1;
            }
            return ret || endCount >= 2 && this.mTaskType == 1;
        }

        public class CacheInfo {
            public String mKey = null;
            public long mMediaSize = 0L;
            public long mPreloadSize = 0L;
            public Resolution mResolution = Resolution.Undefine;
            public List<CacheRange> mCacheRanges = null;
            public String mLocalFilePath = null;
            public Error mError = null;

            void setCacheSize(long cacheSize) {
                if (this.mCacheRanges == null) {
                    this.mCacheRanges = new ArrayList<CacheRange>();
                }
                if (this.mCacheRanges.size() == 0) {
                    this.mCacheRanges.add(new CacheRange());
                }
                this.mCacheRanges.get((int)0).mOffset = 0L;
                this.mCacheRanges.get((int)0).mSize = cacheSize;
            }

            public long getCacheSize() {
                if (this.mCacheRanges != null && this.mCacheRanges.size() > 0) {
                    return this.mCacheRanges.get((int)(this.mCacheRanges.size() - 1)).mSize;
                }
                return 0L;
            }

            public boolean finished() {
                boolean ret = true;
                long cacheEndSize = this.mPreloadSize > 0L ? Math.min(this.mPreloadSize, this.mMediaSize) : this.mMediaSize;
                CacheRange cacheRange = null;
                if (this.mCacheRanges != null) {
                    cacheRange = this.mCacheRanges.get(this.mCacheRanges.size() - 1);
                }
                if (this.mError == null && (cacheRange == null || this.mMediaSize <= 0L || cacheRange.mOffset + cacheRange.mSize < cacheEndSize)) {
                    ret = false;
                }
                return ret;
            }

            public class CacheRange {
                public long mOffset = 0L;
                public long mSize = 0L;
            }
        }
    }

    public class DataLoaderTaskProgressInfo {
        public String mKey = null;
        public String mVideoId = null;
        public String mLocalFilePath = null;
        public long mMediaSize = 0L;
        public long mCacheSizeFromZero = 0L;
        public Resolution mResolution = Resolution.Undefine;
        public String mDecryptionKey = null;
        public VideoInfo mUsingVideoInfo = null;
        public int mTaskType = 0;
    }

    public class DataLoaderCacheInfo {
        public long mMediaSize = 0L;
        public long mCacheSizeFromZero = 0L;
        public String mLocalFilePath = null;
    }

    public static class DataLoaderTaskItem {
        public String mVideoId = null;
        public IVideoModel mResponseData = null;
        public Error mResponseError = null;
        public long mPreloadSize = 0L;
        public long mPreloadMilliSecondOffset = 0L;
        public float mPreloadSecond = 0.0f;
        public long mTimePreloadLowerLimitSize = 0L;
        public long mTimePreloadUpperLimitSize = 0L;
        public int mPriorityLevel = 0;
        public Resolution mSetResolution = Resolution.Undefine;
        public VideoInfoFetcher mFetcher = null;
        public TaskListener mListener = null;
        public PreloaderVidItem mVidItem = null;
        public String mApiString = null;
        public PreloaderVideoModelItem mVideoModelItem = null;
        public PreloaderURLItem mURLItem = null;
        public boolean mDidCanceled = false;
        public PreloadMedia mPreloadMedia = null;
        public String mTag = null;
        public String mSubTag = null;
        public List<TrackItem> mTracks = new CopyOnWriteArrayList<TrackItem>();

        public TrackItem getTrackItem(String key) {
            TrackItem retItem = null;
            if (this.mTracks.size() > 0) {
                for (int i = 0; i < this.mTracks.size(); ++i) {
                    TrackItem tem = this.mTracks.get(i);
                    if (!tem.mTaskKey.equals(key)) continue;
                    retItem = tem;
                    break;
                }
            }
            return retItem;
        }

        public TrackItem addTrackItemByKey(String key) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            TrackItem item = this.getTrackItem(key);
            if (item == null) {
                item = new TrackItem();
                item.mTaskKey = key;
                this.mTracks.add(item);
            }
            return item;
        }

        public void removeVidPlaceholderTrack() {
            if (this.mVidItem == null) {
                return;
            }
            if (this.mTracks.size() == 1) {
                this.mTracks.remove(0);
            }
        }

        public void setListener(TaskListener listener) {
            this.mListener = listener;
        }

        public void setUp(String key, Resolution resolution, long preloadSize) {
            if (this.mTracks.size() == 0) {
                TrackItem trackItem = new TrackItem();
                trackItem.mTaskKey = key;
                trackItem.mUsingResolution = resolution;
                trackItem.mPreSize = preloadSize;
                this.mTracks.add(trackItem);
            } else {
                TTVideoEngineLog.e(DataLoaderHelper.TAG, "[preload] DataLoaderTaskItem setup fail");
            }
            this.mSetResolution = resolution;
            this.mPreloadSize = preloadSize;
        }

        public void setFetchListener() {
            if (this.mFetcher != null) {
                this.mFetcher.setListener(new MyFetcherListener(this));
            }
        }

        public IPreLoaderItemCallBackListener getCallBackListener() {
            if (this.mURLItem != null && this.mURLItem.getCallBackListener() != null) {
                return this.mURLItem.getCallBackListener();
            }
            if (this.mVidItem != null) {
                return this.mVidItem.getCallBackListener();
            }
            if (this.mVideoModelItem != null) {
                return this.mVideoModelItem.getCallBackListener();
            }
            if (this.mPreloadMedia != null) {
                return this.mPreloadMedia.getCallBackListener();
            }
            return null;
        }

        public void _notifyError(int errorCode) {
            if (this.getCallBackListener() != null) {
                PreLoaderItemCallBackInfo callBackInfo = new PreLoaderItemCallBackInfo(3);
                callBackInfo.preloadError = new Error("kTTVideoErrorDomainDataLoaderPreload", errorCode);
                this.getCallBackListener().preloadItemInfo(callBackInfo);
            }
        }

        private class MyFetcherListener
        implements VideoInfoFetcher.FetcherListener {
            private final WeakReference<DataLoaderTaskItem> mTaskItemRef;

            public MyFetcherListener(DataLoaderTaskItem taskItem) {
                this.mTaskItemRef = new WeakReference<DataLoaderTaskItem>(taskItem);
            }

            @Override
            public void onRetry(Error error) {
            }

            @Override
            public void onCompletion(VideoModel model, Error error) {
                DataLoaderTaskItem taskItem = (DataLoaderTaskItem)this.mTaskItemRef.get();
                if (taskItem == null) {
                    return;
                }
                taskItem.mResponseData = model;
                taskItem.mResponseError = error;
                if (taskItem.mListener != null) {
                    taskItem.mListener.taskFinished(taskItem);
                }
            }

            @Override
            public void onStatusException(int status, String message) {
                DataLoaderTaskItem taskItem = (DataLoaderTaskItem)this.mTaskItemRef.get();
                if (taskItem == null) {
                    return;
                }
                if (status != 0 && status != 10) {
                    taskItem.mResponseError = new Error("kTTVideoErrorDomainFetchingInfo", -7996);
                }
                if (taskItem.mListener != null) {
                    taskItem.mListener.taskFinished(taskItem);
                }
            }

            @Override
            public void onLog(String message) {
            }
        }

        private static class MySmartUrlFetcherListener
        implements SmartUrlFetcher.Callback {
            private final WeakReference<DataLoaderTaskItem> mTaskItemRef;

            public MySmartUrlFetcherListener(DataLoaderTaskItem taskItem) {
                this.mTaskItemRef = new WeakReference<DataLoaderTaskItem>(taskItem);
            }

            @Override
            public void onComplete(@NonNull SmartUrlFetcher.RequestParams params, int cacheType, @NonNull SmartUrlFetcher.Result result) {
                DataLoaderTaskItem taskItem = (DataLoaderTaskItem)this.mTaskItemRef.get();
                if (taskItem == null) {
                    return;
                }
                TTVideoEngineLog.d(DataLoaderHelper.TAG, "fetchSmartUrlInfo success " + result);
                taskItem.mResponseData = result.videoModel;
                if (taskItem.mListener != null) {
                    taskItem.mListener.taskFinished(taskItem);
                }
            }

            @Override
            public void onError(@NonNull SmartUrlFetcher.RequestParams params, @NonNull Error error) {
                DataLoaderTaskItem taskItem = (DataLoaderTaskItem)this.mTaskItemRef.get();
                if (taskItem == null) {
                    return;
                }
                if (taskItem.mURLItem == null) {
                    return;
                }
                if (taskItem.mURLItem.mAdapter == null) {
                    return;
                }
                taskItem.mResponseError = error;
                taskItem.mURLItem.mAdapter.fallbackToDirectUrl();
                if (taskItem.mListener != null) {
                    taskItem.mListener.taskFinished(taskItem);
                }
            }
        }

        public class TrackItem {
            public String mTaskKey = null;
            public String mProxyUrl = null;
            public Resolution mUsingResolution = Resolution.Undefine;
            public String mDecryptionKey = null;
            public VideoInfo mVideoInfo = null;
            public String[] mUrls = null;
            public String mExternalInfo = null;
            public long mPreloadHeaderSize = 0L;
            public long mPreloadOffset = 0L;
            public long mPreSize = 0L;
            public long mMediaSize = 0L;
            public long mCacheSize = 0L;
            public String mLocalFilePath = null;
            public String mCustomHeader = null;
            public long mPreloadFooterSize = 0L;
            public boolean mIsFooterPreloaded = false;
        }
    }

    private class MyTaskListener
    implements TaskListener {
        private final WeakReference<DataLoaderHelper> mDataLoader;

        public MyTaskListener(DataLoaderHelper dataLoader) {
            this.mDataLoader = new WeakReference<DataLoaderHelper>(dataLoader);
        }

        @Override
        public void taskFinished(DataLoaderTaskItem taskItem) {
            PreLoaderItemCallBackInfo callBackInfo;
            DataLoaderHelper dataLoader = (DataLoaderHelper)this.mDataLoader.get();
            if (dataLoader == null) {
                return;
            }
            if (taskItem == null) {
                return;
            }
            if (taskItem.mResponseData != null && taskItem.getCallBackListener() != null) {
                callBackInfo = new PreLoaderItemCallBackInfo(4);
                callBackInfo.fetchVideoModel = (VideoModel)taskItem.mResponseData;
                taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
                if (taskItem.mVidItem != null) {
                    taskItem.mSetResolution = taskItem.mVidItem.mResolution;
                }
            }
            if (taskItem != null && taskItem.mVidItem != null && taskItem.mVidItem.getFetchEndListener() != null) {
                taskItem.mVidItem.getFetchEndListener().fetchEnd((VideoModel)taskItem.mResponseData, taskItem.mResponseError);
                taskItem.mSetResolution = taskItem.mVidItem.mResolution;
            }
            if (taskItem.mURLItem != null && taskItem.mURLItem.mAdapter != null && taskItem.mURLItem.mAdapter.isFetchSmartUrl()) {
                taskItem.mSetResolution = CodecStrategy.SmartUrlVod.findTargetResolution(taskItem.mResponseData);
                dataLoader._exectTask(taskItem);
            }
            if (taskItem.mVidItem != null) {
                taskItem.mSetResolution = BestResolution.findDefaultResolution(taskItem.mResponseData, taskItem.mVidItem.mResolution);
            }
            if (taskItem.mVidItem != null && !taskItem.mVidItem.getOnlyFetchVideoModel()) {
                dataLoader._exectTask(taskItem);
            }
            if (taskItem.mResponseError != null) {
                if (dataLoader.mListener != null) {
                    dataLoader.mListener.dataLoaderError(taskItem.mVideoId, 1, taskItem.mResponseError);
                }
                if (taskItem.getCallBackListener() != null) {
                    callBackInfo = new PreLoaderItemCallBackInfo(3);
                    callBackInfo.preloadError = taskItem.mResponseError;
                    taskItem.getCallBackListener().preloadItemInfo(callBackInfo);
                }
            }
        }
    }

    private static class Holder {
        private static DataLoaderHelper instance = new DataLoaderHelper();

        private Holder() {
        }
    }
}

